/*
 * Decompiled with CFR 0.152.
 */
package com.sas.grid.representations;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sas.grid.representations.EnvironmentVariable;
import com.sas.grid.representations.ResourceLimit;
import com.sas.grid.representations.ResourceRequirement;
import com.sas.grid.representations.json.DateDeserializer;
import com.sas.grid.representations.json.DateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Job {
    public static final String MEDIA_TYPE_BASE_VALUE = "application/vnd.sas.sasgrid.job";
    public static final String MEDIA_TYPE_VERSION_VALUE = "application/vnd.sas.sasgrid.job;version=1";
    public static final String MEDIA_TYPE_CHARSET_VALUE = "application/vnd.sas.sasgrid.job;version=1;charset=utf-8";
    public static final String MEDIA_TYPES = "application/vnd.sas.sasgrid.job;version=1;charset=utf-8";
    public static final Long VERSION = 1L;
    private Long version;
    private Integer id;
    private Request request;
    private ProcessingInfo processingInfo;

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        if (version < 0L || version > VERSION) {
            this.version = VERSION;
        }
        this.version = version;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public ProcessingInfo getProcessingInfo() {
        return this.processingInfo;
    }

    public void setProcessingInfo(ProcessingInfo processingInfo) {
        this.processingInfo = processingInfo;
    }

    public String toString() {
        return "Job{version=" + this.version + ", id=" + this.id + ", request=" + this.request + ", processingInfo=" + this.processingInfo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.version != null ? !this.version.equals(job.version) : job.version != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(job.id) : job.id != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(job.request) : job.request != null) {
            return false;
        }
        return this.processingInfo != null ? this.processingInfo.equals(job.processingInfo) : job.processingInfo == null;
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.request != null ? this.request.hashCode() : 0);
        result = 31 * result + (this.processingInfo != null ? this.processingInfo.hashCode() : 0);
        return result;
    }

    public static class ProcessingInfo {
        private String state;
        private String queue;
        private String userGroup;
        private Integer suspendFlags;
        private Integer queuePriority;
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date submitTime;
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date startTime;
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date endTime;
        private Integer launchStatus;
        private Integer processId;
        private String executionHost;
        private Integer exitCode;
        private Integer totalTimePending;
        private Integer totalTimeRunning;
        private Integer totalTimeSuspAdmin;
        private Integer totalTimeSuspThresh;
        private Integer totalTimeSuspPreempt;
        private List<String> hosts = new ArrayList<String>();
        private List<String> requiredTags = new ArrayList<String>();
        private List<ResourceRequirement> consumedResources = new ArrayList<ResourceRequirement>();
        private List<ResourceRequirement> requiredResources = new ArrayList<ResourceRequirement>();
        private List<ResourceLimit> limits = new ArrayList<ResourceLimit>();
        private List<ResourceLimit> limitValues = new ArrayList<ResourceLimit>();
        private List<String> stdOutput = new ArrayList<String>();

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getQueue() {
            return this.queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getUserGroup() {
            return this.userGroup;
        }

        public void setUserGroup(String userGroup) {
            this.userGroup = userGroup;
        }

        public Integer getSuspendFlags() {
            return this.suspendFlags;
        }

        public void setSuspendFlags(Integer suspendFlags) {
            this.suspendFlags = suspendFlags;
        }

        public Integer getQueuePriority() {
            return this.queuePriority;
        }

        public void setQueuePriority(Integer queuePriority) {
            this.queuePriority = queuePriority;
        }

        public Date getSubmitTime() {
            return this.submitTime;
        }

        public void setSubmitTime(Date submitTime) {
            this.submitTime = submitTime;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public Integer getLaunchStatus() {
            return this.launchStatus;
        }

        public void setLaunchStatus(Integer launchStatus) {
            this.launchStatus = launchStatus;
        }

        public Integer getProcessId() {
            return this.processId;
        }

        public void setProcessId(Integer processId) {
            this.processId = processId;
        }

        public String getExecutionHost() {
            return this.executionHost;
        }

        public void setExecutionHost(String executionHost) {
            this.executionHost = executionHost;
        }

        public Integer getExitCode() {
            return this.exitCode;
        }

        public void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public Integer getTotalTimePending() {
            return this.totalTimePending;
        }

        public void setTotalTimePending(Integer totalTimePending) {
            this.totalTimePending = totalTimePending;
        }

        public Integer getTotalTimeRunning() {
            return this.totalTimeRunning;
        }

        public void setTotalTimeRunning(Integer totalTimeRunning) {
            this.totalTimeRunning = totalTimeRunning;
        }

        public Integer getTotalTimeSuspAdmin() {
            return this.totalTimeSuspAdmin;
        }

        public void setTotalTimeSuspAdmin(Integer totalTimeSuspAdmin) {
            this.totalTimeSuspAdmin = totalTimeSuspAdmin;
        }

        public Integer getTotalTimeSuspThresh() {
            return this.totalTimeSuspThresh;
        }

        public void setTotalTimeSuspThresh(Integer totalTimeSuspThresh) {
            this.totalTimeSuspThresh = totalTimeSuspThresh;
        }

        public Integer getTotalTimeSuspPreempt() {
            return this.totalTimeSuspPreempt;
        }

        public void setTotalTimeSuspPreempt(Integer totalTimeSuspPreempt) {
            this.totalTimeSuspPreempt = totalTimeSuspPreempt;
        }

        public List<String> getHosts() {
            return this.hosts == null ? new ArrayList() : this.hosts;
        }

        public void setHosts(List<String> hosts) {
            this.hosts = hosts == null ? new ArrayList() : hosts;
        }

        public List<String> getRequiredTags() {
            return this.requiredTags == null ? new ArrayList() : this.requiredTags;
        }

        public void setRequiredTags(List<String> requiredTags) {
            this.requiredTags = requiredTags == null ? new ArrayList() : requiredTags;
        }

        public List<ResourceRequirement> getConsumedResources() {
            return this.consumedResources == null ? new ArrayList() : this.consumedResources;
        }

        public void setConsumedResources(List<ResourceRequirement> consumedResources) {
            this.consumedResources = consumedResources == null ? new ArrayList() : consumedResources;
        }

        public List<ResourceRequirement> getRequiredResources() {
            return this.requiredResources == null ? new ArrayList() : this.requiredResources;
        }

        public void setRequiredResources(List<ResourceRequirement> requiredResources) {
            this.requiredResources = requiredResources == null ? new ArrayList() : requiredResources;
        }

        public List<ResourceLimit> getLimits() {
            return this.limits == null ? new ArrayList() : this.limits;
        }

        public void setLimits(List<ResourceLimit> limits) {
            this.limits = limits == null ? new ArrayList() : limits;
        }

        public List<ResourceLimit> getLimitValues() {
            return this.limitValues == null ? new ArrayList() : this.limitValues;
        }

        public void setLimitValues(List<ResourceLimit> limitValues) {
            this.limitValues = limitValues == null ? new ArrayList() : limitValues;
        }

        public List<String> getStdOutput() {
            return this.stdOutput == null ? new ArrayList() : this.stdOutput;
        }

        public void setStdOutput(List<String> stdOutput) {
            this.stdOutput = stdOutput == null ? new ArrayList() : stdOutput;
        }

        public String toString() {
            return "ProcessingInfo{state='" + this.state + '\'' + ", queue='" + this.queue + '\'' + ", userGroup='" + this.userGroup + '\'' + ", suspendFlags=" + this.suspendFlags + ", queuePriority=" + this.queuePriority + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", launchStatus=" + this.launchStatus + ", processId=" + this.processId + ", executionHost='" + this.executionHost + '\'' + ", exitCode=" + this.exitCode + ", totalTimePending=" + this.totalTimePending + ", totalTimeRunning=" + this.totalTimeRunning + ", totalTimeSuspAdmin=" + this.totalTimeSuspAdmin + ", totalTimeSuspThresh=" + this.totalTimeSuspThresh + ", totalTimeSuspPreempt=" + this.totalTimeSuspPreempt + ", hosts=" + this.hosts + ", requiredTags=" + this.requiredTags + ", consumedResources=" + this.consumedResources + ", requiredResources=" + this.requiredResources + ", limits=" + this.limits + ", limitValues=" + this.limitValues + ", stdOutput=" + this.stdOutput + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessingInfo that = (ProcessingInfo)o;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
                return false;
            }
            if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) {
                return false;
            }
            if (this.userGroup != null ? !this.userGroup.equals(that.userGroup) : that.userGroup != null) {
                return false;
            }
            if (this.suspendFlags != null ? !this.suspendFlags.equals(that.suspendFlags) : that.suspendFlags != null) {
                return false;
            }
            if (this.queuePriority != null ? !this.queuePriority.equals(that.queuePriority) : that.queuePriority != null) {
                return false;
            }
            if (this.submitTime != null ? !this.submitTime.equals(that.submitTime) : that.submitTime != null) {
                return false;
            }
            if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
                return false;
            }
            if (this.endTime != null ? !this.endTime.equals(that.endTime) : that.endTime != null) {
                return false;
            }
            if (this.launchStatus != null ? !this.launchStatus.equals(that.launchStatus) : that.launchStatus != null) {
                return false;
            }
            if (this.processId != null ? !this.processId.equals(that.processId) : that.processId != null) {
                return false;
            }
            if (this.executionHost != null ? !this.executionHost.equals(that.executionHost) : that.executionHost != null) {
                return false;
            }
            if (this.exitCode != null ? !this.exitCode.equals(that.exitCode) : that.exitCode != null) {
                return false;
            }
            if (this.totalTimePending != null ? !this.totalTimePending.equals(that.totalTimePending) : that.totalTimePending != null) {
                return false;
            }
            if (this.totalTimeRunning != null ? !this.totalTimeRunning.equals(that.totalTimeRunning) : that.totalTimeRunning != null) {
                return false;
            }
            if (this.totalTimeSuspAdmin != null ? !this.totalTimeSuspAdmin.equals(that.totalTimeSuspAdmin) : that.totalTimeSuspAdmin != null) {
                return false;
            }
            if (this.totalTimeSuspThresh != null ? !this.totalTimeSuspThresh.equals(that.totalTimeSuspThresh) : that.totalTimeSuspThresh != null) {
                return false;
            }
            if (this.totalTimeSuspPreempt != null ? !this.totalTimeSuspPreempt.equals(that.totalTimeSuspPreempt) : that.totalTimeSuspPreempt != null) {
                return false;
            }
            if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
                return false;
            }
            if (this.requiredTags != null ? !this.requiredTags.equals(that.requiredTags) : that.requiredTags != null) {
                return false;
            }
            if (this.consumedResources != null ? !this.consumedResources.equals(that.consumedResources) : that.consumedResources != null) {
                return false;
            }
            if (this.requiredResources != null ? !this.requiredResources.equals(that.requiredResources) : that.requiredResources != null) {
                return false;
            }
            if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) {
                return false;
            }
            if (this.limitValues != null ? !this.limitValues.equals(that.limitValues) : that.limitValues != null) {
                return false;
            }
            return this.stdOutput != null ? this.stdOutput.equals(that.stdOutput) : that.stdOutput == null;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
            result = 31 * result + (this.userGroup != null ? this.userGroup.hashCode() : 0);
            result = 31 * result + (this.suspendFlags != null ? this.suspendFlags.hashCode() : 0);
            result = 31 * result + (this.queuePriority != null ? this.queuePriority.hashCode() : 0);
            result = 31 * result + (this.submitTime != null ? this.submitTime.hashCode() : 0);
            result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
            result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
            result = 31 * result + (this.launchStatus != null ? this.launchStatus.hashCode() : 0);
            result = 31 * result + (this.processId != null ? this.processId.hashCode() : 0);
            result = 31 * result + (this.executionHost != null ? this.executionHost.hashCode() : 0);
            result = 31 * result + (this.exitCode != null ? this.exitCode.hashCode() : 0);
            result = 31 * result + (this.totalTimePending != null ? this.totalTimePending.hashCode() : 0);
            result = 31 * result + (this.totalTimeRunning != null ? this.totalTimeRunning.hashCode() : 0);
            result = 31 * result + (this.totalTimeSuspAdmin != null ? this.totalTimeSuspAdmin.hashCode() : 0);
            result = 31 * result + (this.totalTimeSuspThresh != null ? this.totalTimeSuspThresh.hashCode() : 0);
            result = 31 * result + (this.totalTimeSuspPreempt != null ? this.totalTimeSuspPreempt.hashCode() : 0);
            result = 31 * result + (this.hosts != null ? this.hosts.hashCode() : 0);
            result = 31 * result + (this.requiredTags != null ? this.requiredTags.hashCode() : 0);
            result = 31 * result + (this.consumedResources != null ? this.consumedResources.hashCode() : 0);
            result = 31 * result + (this.requiredResources != null ? this.requiredResources.hashCode() : 0);
            result = 31 * result + (this.limits != null ? this.limits.hashCode() : 0);
            result = 31 * result + (this.limitValues != null ? this.limitValues.hashCode() : 0);
            result = 31 * result + (this.stdOutput != null ? this.stdOutput.hashCode() : 0);
            return result;
        }
    }

    public static class Request {
        private String name;
        private String queue;
        private String project;
        private String user;
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date startAfter;
        private Boolean restartable;
        private String cmd;
        private List<String> args = new ArrayList<String>();
        private List<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
        private List<String> hosts = new ArrayList<String>();
        private List<String> requiredTags = new ArrayList<String>();
        private List<ResourceRequirement> consumedResources = new ArrayList<ResourceRequirement>();
        private List<ResourceRequirement> requiredResources = new ArrayList<ResourceRequirement>();
        private List<ResourceLimit> limits = new ArrayList<ResourceLimit>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getQueue() {
            return this.queue;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public Date getStartAfter() {
            return this.startAfter;
        }

        public void setStartAfter(Date startAfter) {
            this.startAfter = startAfter;
        }

        public Boolean getRestartable() {
            return this.restartable;
        }

        public void setRestartable(Boolean restartable) {
            this.restartable = restartable;
        }

        public String getCmd() {
            return this.cmd;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public List<String> getArgs() {
            return this.args == null ? new ArrayList() : this.args;
        }

        public void setArgs(List<String> args) {
            this.args = args == null ? new ArrayList() : args;
        }

        public List<EnvironmentVariable> getEnvVars() {
            return this.envVars == null ? new ArrayList() : this.envVars;
        }

        public void setEnvVars(List<EnvironmentVariable> envVars) {
            this.envVars = envVars == null ? new ArrayList() : envVars;
        }

        public List<String> getHosts() {
            return this.hosts == null ? new ArrayList() : this.hosts;
        }

        public void setHosts(List<String> hosts) {
            this.hosts = hosts == null ? new ArrayList() : hosts;
        }

        public List<String> getRequiredTags() {
            return this.requiredTags == null ? new ArrayList() : this.requiredTags;
        }

        public void setRequiredTags(List<String> requiredTags) {
            this.requiredTags = requiredTags == null ? new ArrayList() : requiredTags;
        }

        public List<ResourceRequirement> getConsumedResources() {
            return this.consumedResources == null ? new ArrayList() : this.consumedResources;
        }

        public void setConsumedResources(List<ResourceRequirement> consumedResources) {
            this.consumedResources = consumedResources == null ? new ArrayList() : consumedResources;
        }

        public List<ResourceRequirement> getRequiredResources() {
            return this.requiredResources == null ? new ArrayList() : this.requiredResources;
        }

        public void setRequiredResources(List<ResourceRequirement> requiredResources) {
            this.requiredResources = requiredResources == null ? new ArrayList() : requiredResources;
        }

        public List<ResourceLimit> getLimits() {
            return this.limits == null ? new ArrayList() : this.limits;
        }

        public void setLimits(List<ResourceLimit> limits) {
            this.limits = limits == null ? new ArrayList() : limits;
        }

        public String toString() {
            return "Request{name='" + this.name + '\'' + ", queue='" + this.queue + '\'' + ", project='" + this.project + '\'' + ", user='" + this.user + '\'' + ", startAfter=" + this.startAfter + ", restartable=" + this.restartable + ", cmd='" + this.cmd + '\'' + ", args=" + this.args + ", envVars=" + this.envVars + ", hosts=" + this.hosts + ", requiredTags=" + this.requiredTags + ", consumedResources=" + this.consumedResources + ", requiredResources=" + this.requiredResources + ", limits=" + this.limits + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            if (this.name != null ? !this.name.equals(request.name) : request.name != null) {
                return false;
            }
            if (this.queue != null ? !this.queue.equals(request.queue) : request.queue != null) {
                return false;
            }
            if (this.project != null ? !this.project.equals(request.project) : request.project != null) {
                return false;
            }
            if (this.user != null ? !this.user.equals(request.user) : request.user != null) {
                return false;
            }
            if (this.startAfter != null ? !this.startAfter.equals(request.startAfter) : request.startAfter != null) {
                return false;
            }
            if (this.restartable != null ? !this.restartable.equals(request.restartable) : request.restartable != null) {
                return false;
            }
            if (this.cmd != null ? !this.cmd.equals(request.cmd) : request.cmd != null) {
                return false;
            }
            if (this.args != null ? !this.args.equals(request.args) : request.args != null) {
                return false;
            }
            if (this.envVars != null ? !this.envVars.equals(request.envVars) : request.envVars != null) {
                return false;
            }
            if (this.hosts != null ? !this.hosts.equals(request.hosts) : request.hosts != null) {
                return false;
            }
            if (this.requiredTags != null ? !this.requiredTags.equals(request.requiredTags) : request.requiredTags != null) {
                return false;
            }
            if (this.consumedResources != null ? !this.consumedResources.equals(request.consumedResources) : request.consumedResources != null) {
                return false;
            }
            if (this.requiredResources != null ? !this.requiredResources.equals(request.requiredResources) : request.requiredResources != null) {
                return false;
            }
            return this.limits != null ? this.limits.equals(request.limits) : request.limits == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
            result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.startAfter != null ? this.startAfter.hashCode() : 0);
            result = 31 * result + (this.restartable != null ? this.restartable.hashCode() : 0);
            result = 31 * result + (this.cmd != null ? this.cmd.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.envVars != null ? this.envVars.hashCode() : 0);
            result = 31 * result + (this.hosts != null ? this.hosts.hashCode() : 0);
            result = 31 * result + (this.requiredTags != null ? this.requiredTags.hashCode() : 0);
            result = 31 * result + (this.consumedResources != null ? this.consumedResources.hashCode() : 0);
            result = 31 * result + (this.requiredResources != null ? this.requiredResources.hashCode() : 0);
            result = 31 * result + (this.limits != null ? this.limits.hashCode() : 0);
            return result;
        }
    }
}

