/*
 * Decompiled with CFR 0.152.
 */
package com.sas.grid.representations;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sas.grid.representations.Threshold;
import com.sas.grid.representations.json.DateDeserializer;
import com.sas.grid.representations.json.DateSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Host {
    public static final String MEDIA_TYPE_BASE_VALUE = "application/vnd.sas.sasgrid.host";
    public static final String MEDIA_TYPE_VERSION_VALUE = "application/vnd.sas.sasgrid.host;version=1";
    public static final String MEDIA_TYPE_CHARSET_VALUE = "application/vnd.sas.sasgrid.host;version=1;charset=utf-8";
    public static final String MEDIA_TYPES = "application/vnd.sas.sasgrid.host;version=1;charset=utf-8";
    public static final Long VERSION = 1L;
    private Long version;
    private String name;
    private List<String> aliases = new ArrayList<String>();
    private List<String> ipAddresses = new ArrayList<String>();
    private ConfigInfo configInfo;
    private StaticInfo staticInfo;
    private DynamicInfo dynamicInfo;

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        if (version < 0L || version > VERSION) {
            this.version = VERSION;
        }
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAliases() {
        return this.aliases == null ? new ArrayList() : this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases == null ? new ArrayList() : aliases;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses == null ? new ArrayList() : this.ipAddresses;
    }

    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses == null ? new ArrayList() : ipAddresses;
    }

    public ConfigInfo getConfigInfo() {
        return this.configInfo;
    }

    public void setConfigInfo(ConfigInfo configInfo) {
        this.configInfo = configInfo;
    }

    public StaticInfo getStaticInfo() {
        return this.staticInfo;
    }

    public void setStaticInfo(StaticInfo staticInfo) {
        this.staticInfo = staticInfo;
    }

    public DynamicInfo getDynamicInfo() {
        return this.dynamicInfo;
    }

    public void setDynamicInfo(DynamicInfo dynamicInfo) {
        this.dynamicInfo = dynamicInfo;
    }

    public String toString() {
        return "Host{version=" + this.version + ", name=" + this.name + ", aliases=" + this.aliases + ", ipAddresses=" + this.ipAddresses + ", configInfo=" + this.configInfo + ", staticInfo=" + this.staticInfo + ", dynamicInfo=" + this.dynamicInfo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        if (this.version != null ? !this.version.equals(host.version) : host.version != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(host.name) : host.name != null) {
            return false;
        }
        if (this.aliases != null ? !this.aliases.equals(host.aliases) : host.aliases != null) {
            return false;
        }
        if (this.ipAddresses != null ? !this.ipAddresses.equals(host.ipAddresses) : host.ipAddresses != null) {
            return false;
        }
        if (this.configInfo != null ? !this.configInfo.equals(host.configInfo) : host.configInfo != null) {
            return false;
        }
        if (this.staticInfo != null ? !this.staticInfo.equals(host.staticInfo) : host.staticInfo != null) {
            return false;
        }
        return this.dynamicInfo != null ? this.dynamicInfo.equals(host.dynamicInfo) : host.dynamicInfo == null;
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
        result = 31 * result + (this.ipAddresses != null ? this.ipAddresses.hashCode() : 0);
        result = 31 * result + (this.configInfo != null ? this.configInfo.hashCode() : 0);
        result = 31 * result + (this.staticInfo != null ? this.staticInfo.hashCode() : 0);
        result = 31 * result + (this.dynamicInfo != null ? this.dynamicInfo.hashCode() : 0);
        return result;
    }

    public static class DynamicInfo {
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date lastUpdateTime;
        private String state;
        private Boolean hostClosed;
        private Boolean licenseValid;
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date licenseExpireDate;
        private Integer jobsRunning;
        private Integer jobsSuspended;
        private Double utilization;
        private Double runQueue15s;
        private Double runQueue1m;
        private Double runQueue15m;
        private Double diskIORate;
        private Double netIORate;
        private Double ioRate;
        private Double pgRate;
        private Double usedMemory;
        private Double usedSwap;
        private Double usedTemp;

        public Date getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(Date lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public Boolean getHostClosed() {
            return this.hostClosed;
        }

        public void setHostClosed(Boolean hostClosed) {
            this.hostClosed = hostClosed;
        }

        public Boolean getLicenseValid() {
            return this.licenseValid;
        }

        public void setLicenseValid(Boolean licenseValid) {
            this.licenseValid = licenseValid;
        }

        public Date getLicenseExpireDate() {
            return this.licenseExpireDate;
        }

        public void setLicenseExpireDate(Date licenseExpireDate) {
            this.licenseExpireDate = licenseExpireDate;
        }

        public Integer getJobsRunning() {
            return this.jobsRunning;
        }

        public void setJobsRunning(Integer jobsRunning) {
            this.jobsRunning = jobsRunning;
        }

        public Integer getJobsSuspended() {
            return this.jobsSuspended;
        }

        public void setJobsSuspended(Integer jobsSuspended) {
            this.jobsSuspended = jobsSuspended;
        }

        public Double getUtilization() {
            return this.utilization;
        }

        public void setUtilization(Double utilization) {
            this.utilization = utilization;
        }

        public Double getRunQueue15s() {
            return this.runQueue15s;
        }

        public void setRunQueue15s(Double runQueue15s) {
            this.runQueue15s = runQueue15s;
        }

        public Double getRunQueue1m() {
            return this.runQueue1m;
        }

        public void setRunQueue1m(Double runQueue1m) {
            this.runQueue1m = runQueue1m;
        }

        public Double getRunQueue15m() {
            return this.runQueue15m;
        }

        public void setRunQueue15m(Double runQueue15m) {
            this.runQueue15m = runQueue15m;
        }

        public Double getDiskIORate() {
            return this.diskIORate;
        }

        public void setDiskIORate(Double diskIORate) {
            this.diskIORate = diskIORate;
        }

        public Double getNetIORate() {
            return this.netIORate;
        }

        public void setNetIORate(Double netIORate) {
            this.netIORate = netIORate;
        }

        public Double getIoRate() {
            return this.ioRate;
        }

        public void setIoRate(Double ioRate) {
            this.ioRate = ioRate;
        }

        public Double getPgRate() {
            return this.pgRate;
        }

        public void setPgRate(Double pgRate) {
            this.pgRate = pgRate;
        }

        public Double getUsedMemory() {
            return this.usedMemory;
        }

        public void setUsedMemory(Double usedMemory) {
            this.usedMemory = usedMemory;
        }

        public Double getUsedSwap() {
            return this.usedSwap;
        }

        public void setUsedSwap(Double usedSwap) {
            this.usedSwap = usedSwap;
        }

        public Double getUsedTemp() {
            return this.usedTemp;
        }

        public void setUsedTemp(Double usedTemp) {
            this.usedTemp = usedTemp;
        }

        public String toString() {
            return "DynamicInfo{lastUpdateTime=" + this.lastUpdateTime + ", state='" + this.state + '\'' + ", hostClosed=" + this.hostClosed + ", licenseValid=" + this.licenseValid + ", licenseExpireDate=" + this.licenseExpireDate + ", jobsRunning=" + this.jobsRunning + ", jobsSuspended=" + this.jobsSuspended + ", utilization=" + this.utilization + ", runQueue15s=" + this.runQueue15s + ", runQueue1m=" + this.runQueue1m + ", runQueue15m=" + this.runQueue15m + ", diskIORate=" + this.diskIORate + ", netIORate=" + this.netIORate + ", ioRate=" + this.ioRate + ", pgRate=" + this.pgRate + ", usedMemory=" + this.usedMemory + ", usedSwap=" + this.usedSwap + ", usedTemp=" + this.usedTemp + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicInfo that = (DynamicInfo)o;
            if (this.lastUpdateTime != null ? !this.lastUpdateTime.equals(that.lastUpdateTime) : that.lastUpdateTime != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) {
                return false;
            }
            if (this.hostClosed != null ? !this.hostClosed.equals(that.hostClosed) : that.hostClosed != null) {
                return false;
            }
            if (this.licenseValid != null ? !this.licenseValid.equals(that.licenseValid) : that.licenseValid != null) {
                return false;
            }
            if (this.licenseExpireDate != null ? !this.licenseExpireDate.equals(that.licenseExpireDate) : that.licenseExpireDate != null) {
                return false;
            }
            if (this.jobsRunning != null ? !this.jobsRunning.equals(that.jobsRunning) : that.jobsRunning != null) {
                return false;
            }
            if (this.jobsSuspended != null ? !this.jobsSuspended.equals(that.jobsSuspended) : that.jobsSuspended != null) {
                return false;
            }
            if (this.utilization != null ? !this.utilization.equals(that.utilization) : that.utilization != null) {
                return false;
            }
            if (this.runQueue15s != null ? !this.runQueue15s.equals(that.runQueue15s) : that.runQueue15s != null) {
                return false;
            }
            if (this.runQueue1m != null ? !this.runQueue1m.equals(that.runQueue1m) : that.runQueue1m != null) {
                return false;
            }
            if (this.runQueue15m != null ? !this.runQueue15m.equals(that.runQueue15m) : that.runQueue15m != null) {
                return false;
            }
            if (this.diskIORate != null ? !this.diskIORate.equals(that.diskIORate) : that.diskIORate != null) {
                return false;
            }
            if (this.netIORate != null ? !this.netIORate.equals(that.netIORate) : that.netIORate != null) {
                return false;
            }
            if (this.ioRate != null ? !this.ioRate.equals(that.ioRate) : that.ioRate != null) {
                return false;
            }
            if (this.pgRate != null ? !this.pgRate.equals(that.pgRate) : that.pgRate != null) {
                return false;
            }
            if (this.usedMemory != null ? !this.usedMemory.equals(that.usedMemory) : that.usedMemory != null) {
                return false;
            }
            if (this.usedSwap != null ? !this.usedSwap.equals(that.usedSwap) : that.usedSwap != null) {
                return false;
            }
            return this.usedTemp != null ? this.usedTemp.equals(that.usedTemp) : that.usedTemp == null;
        }

        public int hashCode() {
            int result = this.lastUpdateTime != null ? this.lastUpdateTime.hashCode() : 0;
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.hostClosed != null ? this.hostClosed.hashCode() : 0);
            result = 31 * result + (this.licenseValid != null ? this.licenseValid.hashCode() : 0);
            result = 31 * result + (this.licenseExpireDate != null ? this.licenseExpireDate.hashCode() : 0);
            result = 31 * result + (this.jobsRunning != null ? this.jobsRunning.hashCode() : 0);
            result = 31 * result + (this.jobsSuspended != null ? this.jobsSuspended.hashCode() : 0);
            result = 31 * result + (this.utilization != null ? this.utilization.hashCode() : 0);
            result = 31 * result + (this.runQueue15s != null ? this.runQueue15s.hashCode() : 0);
            result = 31 * result + (this.runQueue1m != null ? this.runQueue1m.hashCode() : 0);
            result = 31 * result + (this.runQueue15m != null ? this.runQueue15m.hashCode() : 0);
            result = 31 * result + (this.diskIORate != null ? this.diskIORate.hashCode() : 0);
            result = 31 * result + (this.netIORate != null ? this.netIORate.hashCode() : 0);
            result = 31 * result + (this.ioRate != null ? this.ioRate.hashCode() : 0);
            result = 31 * result + (this.pgRate != null ? this.pgRate.hashCode() : 0);
            result = 31 * result + (this.usedMemory != null ? this.usedMemory.hashCode() : 0);
            result = 31 * result + (this.usedSwap != null ? this.usedSwap.hashCode() : 0);
            result = 31 * result + (this.usedTemp != null ? this.usedTemp.hashCode() : 0);
            return result;
        }
    }

    public static class StaticInfo {
        @JsonSerialize(using=DateSerializer.class)
        @JsonDeserialize(using=DateDeserializer.class)
        private Date buildDate;
        private String osName;
        private String osDesc;
        private String cpuVendor;
        private String cpuArch;
        private Double cpuRating;
        private Double cpuRatingAllocated;
        private Double cores;
        private Double coresAllocated;
        private Double memory;
        private Double memoryAllocated;
        private Double swap;
        private Double swapAllocated;
        private Double temp;
        private Double tempAllocated;

        public Date getBuildDate() {
            return this.buildDate;
        }

        public void setBuildDate(Date buildDate) {
            this.buildDate = buildDate;
        }

        public String getOsName() {
            return this.osName;
        }

        public void setOsName(String osName) {
            this.osName = osName;
        }

        public String getOsDesc() {
            return this.osDesc;
        }

        public void setOsDesc(String osDesc) {
            this.osDesc = osDesc;
        }

        public String getCpuVendor() {
            return this.cpuVendor;
        }

        public void setCpuVendor(String cpuVendor) {
            this.cpuVendor = cpuVendor;
        }

        public String getCpuArch() {
            return this.cpuArch;
        }

        public void setCpuArch(String cpuArch) {
            this.cpuArch = cpuArch;
        }

        public Double getCpuRating() {
            return this.cpuRating;
        }

        public void setCpuRating(Double cpuRating) {
            this.cpuRating = cpuRating;
        }

        public Double getCpuRatingAllocated() {
            return this.cpuRatingAllocated;
        }

        public void setCpuRatingAllocated(Double cpuRatingAllocated) {
            this.cpuRatingAllocated = cpuRatingAllocated;
        }

        public Double getCores() {
            return this.cores;
        }

        public void setCores(Double cores) {
            this.cores = cores;
        }

        public Double getCoresAllocated() {
            return this.coresAllocated;
        }

        public void setCoresAllocated(Double coresAllocated) {
            this.coresAllocated = coresAllocated;
        }

        public Double getMemory() {
            return this.memory;
        }

        public void setMemory(Double memory) {
            this.memory = memory;
        }

        public Double getMemoryAllocated() {
            return this.memoryAllocated;
        }

        public void setMemoryAllocated(Double memoryAllocated) {
            this.memoryAllocated = memoryAllocated;
        }

        public Double getSwap() {
            return this.swap;
        }

        public void setSwap(Double swap) {
            this.swap = swap;
        }

        public Double getSwapAllocated() {
            return this.swapAllocated;
        }

        public void setSwapAllocated(Double swapAllocated) {
            this.swapAllocated = swapAllocated;
        }

        public Double getTemp() {
            return this.temp;
        }

        public void setTemp(Double temp) {
            this.temp = temp;
        }

        public Double getTempAllocated() {
            return this.tempAllocated;
        }

        public void setTempAllocated(Double tempAllocated) {
            this.tempAllocated = tempAllocated;
        }

        public String toString() {
            return "StaticInfo{buildDate=" + this.buildDate + ", osName='" + this.osName + '\'' + ", osDesc='" + this.osDesc + '\'' + ", cpuVendor='" + this.cpuVendor + '\'' + ", cpuArch='" + this.cpuArch + '\'' + ", cpuRating=" + this.cpuRating + ", cpuRatingAllocated=" + this.cpuRatingAllocated + ", cores=" + this.cores + ", coresAllocated=" + this.coresAllocated + ", memory=" + this.memory + ", memoryAllocated=" + this.memoryAllocated + ", swap=" + this.swap + ", swapAllocated=" + this.swapAllocated + ", temp=" + this.temp + ", tempAllocated=" + this.tempAllocated + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StaticInfo that = (StaticInfo)o;
            if (this.buildDate != null ? !this.buildDate.equals(that.buildDate) : that.buildDate != null) {
                return false;
            }
            if (this.osName != null ? !this.osName.equals(that.osName) : that.osName != null) {
                return false;
            }
            if (this.osDesc != null ? !this.osDesc.equals(that.osDesc) : that.osDesc != null) {
                return false;
            }
            if (this.cpuVendor != null ? !this.cpuVendor.equals(that.cpuVendor) : that.cpuVendor != null) {
                return false;
            }
            if (this.cpuArch != null ? !this.cpuArch.equals(that.cpuArch) : that.cpuArch != null) {
                return false;
            }
            if (this.cpuRating != null ? !this.cpuRating.equals(that.cpuRating) : that.cpuRating != null) {
                return false;
            }
            if (this.cpuRatingAllocated != null ? !this.cpuRatingAllocated.equals(that.cpuRatingAllocated) : that.cpuRatingAllocated != null) {
                return false;
            }
            if (this.cores != null ? !this.cores.equals(that.cores) : that.cores != null) {
                return false;
            }
            if (this.coresAllocated != null ? !this.coresAllocated.equals(that.coresAllocated) : that.coresAllocated != null) {
                return false;
            }
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) {
                return false;
            }
            if (this.memoryAllocated != null ? !this.memoryAllocated.equals(that.memoryAllocated) : that.memoryAllocated != null) {
                return false;
            }
            if (this.swap != null ? !this.swap.equals(that.swap) : that.swap != null) {
                return false;
            }
            if (this.swapAllocated != null ? !this.swapAllocated.equals(that.swapAllocated) : that.swapAllocated != null) {
                return false;
            }
            if (this.temp != null ? !this.temp.equals(that.temp) : that.temp != null) {
                return false;
            }
            return this.tempAllocated != null ? this.tempAllocated.equals(that.tempAllocated) : that.tempAllocated == null;
        }

        public int hashCode() {
            int result = this.buildDate != null ? this.buildDate.hashCode() : 0;
            result = 31 * result + (this.osName != null ? this.osName.hashCode() : 0);
            result = 31 * result + (this.osDesc != null ? this.osDesc.hashCode() : 0);
            result = 31 * result + (this.cpuVendor != null ? this.cpuVendor.hashCode() : 0);
            result = 31 * result + (this.cpuArch != null ? this.cpuArch.hashCode() : 0);
            result = 31 * result + (this.cpuRating != null ? this.cpuRating.hashCode() : 0);
            result = 31 * result + (this.cpuRatingAllocated != null ? this.cpuRatingAllocated.hashCode() : 0);
            result = 31 * result + (this.cores != null ? this.cores.hashCode() : 0);
            result = 31 * result + (this.coresAllocated != null ? this.coresAllocated.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.memoryAllocated != null ? this.memoryAllocated.hashCode() : 0);
            result = 31 * result + (this.swap != null ? this.swap.hashCode() : 0);
            result = 31 * result + (this.swapAllocated != null ? this.swapAllocated.hashCode() : 0);
            result = 31 * result + (this.temp != null ? this.temp.hashCode() : 0);
            result = 31 * result + (this.tempAllocated != null ? this.tempAllocated.hashCode() : 0);
            return result;
        }
    }

    public static class ConfigInfo {
        private String hostType;
        private Integer maxJobsAllowed;
        private List<Threshold> scheduleThresholds = new ArrayList<Threshold>();
        private List<Threshold> suspendThresholds = new ArrayList<Threshold>();
        private List<String> tags = new ArrayList<String>();

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public Integer getMaxJobsAllowed() {
            return this.maxJobsAllowed;
        }

        public void setMaxJobsAllowed(Integer maxJobsAllowed) {
            this.maxJobsAllowed = maxJobsAllowed;
        }

        public List<Threshold> getScheduleThresholds() {
            return this.scheduleThresholds == null ? new ArrayList() : this.scheduleThresholds;
        }

        public void setScheduleThresholds(List<Threshold> scheduleThresholds) {
            this.scheduleThresholds = scheduleThresholds == null ? new ArrayList() : scheduleThresholds;
        }

        public List<Threshold> getSuspendThresholds() {
            return this.suspendThresholds == null ? new ArrayList() : this.suspendThresholds;
        }

        public void setSuspendThresholds(List<Threshold> suspendThresholds) {
            this.suspendThresholds = suspendThresholds == null ? new ArrayList() : suspendThresholds;
        }

        public List<String> getTags() {
            return this.tags == null ? new ArrayList() : this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags == null ? new ArrayList() : tags;
        }

        public String toString() {
            return "ConfigInfo{hostType='" + this.hostType + '\'' + ", maxJobsAllowed=" + this.maxJobsAllowed + ", scheduleThresholds=" + this.scheduleThresholds + ", suspendThresholds=" + this.suspendThresholds + ", tags=" + this.tags + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigInfo that = (ConfigInfo)o;
            if (this.hostType != null ? !this.hostType.equals(that.hostType) : that.hostType != null) {
                return false;
            }
            if (this.maxJobsAllowed != null ? !this.maxJobsAllowed.equals(that.maxJobsAllowed) : that.maxJobsAllowed != null) {
                return false;
            }
            if (this.scheduleThresholds != null ? !this.scheduleThresholds.equals(that.scheduleThresholds) : that.scheduleThresholds != null) {
                return false;
            }
            if (this.suspendThresholds != null ? !this.suspendThresholds.equals(that.suspendThresholds) : that.suspendThresholds != null) {
                return false;
            }
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        public int hashCode() {
            int result = this.hostType != null ? this.hostType.hashCode() : 0;
            result = 31 * result + (this.maxJobsAllowed != null ? this.maxJobsAllowed.hashCode() : 0);
            result = 31 * result + (this.scheduleThresholds != null ? this.scheduleThresholds.hashCode() : 0);
            result = 31 * result + (this.suspendThresholds != null ? this.suspendThresholds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}

