/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.sqlfilter;

import MITI.bridges.sqlfilter.SqlFilterParser;
import MITI.messages.MIRModelBridge.BLIB;
import java.util.ArrayList;
import java.util.List;

public class SqlFilterPrinter {
    protected boolean isCaseSensitive = true;
    List<SqlFilterParser.FilterItem> filters = null;
    String targetName = null;
    String columnPattern = null;
    String template = null;

    public SqlFilterPrinter(SqlFilterParser sqlFilterParser, TargetType targetType) {
        this(sqlFilterParser, targetType, true);
    }

    public SqlFilterPrinter(SqlFilterParser sqlFilterParser, TargetType targetType, boolean bl) {
        this.filters = sqlFilterParser.getFilterNodes();
        switch (targetType) {
            case Database: {
                return;
            }
            case Schema: {
                this.targetName = "schema";
                this.columnPattern = "@@SCHEMA";
                break;
            }
            case Table: {
                this.targetName = "table";
                this.columnPattern = "@@TABLE";
                break;
            }
            case Procedure: {
                this.targetName = "procedure";
                this.columnPattern = "@@PROCEDURE";
                break;
            }
            case Package: {
                this.targetName = "package";
                this.columnPattern = "@@PACKAGE";
                break;
            }
        }
        this.isCaseSensitive = bl;
        this.template = this.print(this.targetName, this.columnPattern);
    }

    private String print(String string, String string2) {
        String string3;
        String string4;
        Object object;
        String string42 = "";
        ArrayList<SqlFilterParser.FilterItem> arrayList = new ArrayList<SqlFilterParser.FilterItem>();
        ArrayList<SqlFilterParser.FilterItem> arrayList2 = new ArrayList<SqlFilterParser.FilterItem>();
        ArrayList<SqlFilterParser.FilterItem> arrayList3 = new ArrayList<SqlFilterParser.FilterItem>();
        ArrayList<SqlFilterParser.FilterItem> arrayList4 = new ArrayList<SqlFilterParser.FilterItem>();
        for (SqlFilterParser.FilterItem object22 : this.filters) {
            object = object22.getOperator();
            switch (object) {
                case IN: {
                    arrayList.add(object22);
                    break;
                }
                case NOT_IN: {
                    arrayList2.add(object22);
                    break;
                }
                case LIKE: 
                case REGEXP: {
                    arrayList3.add(object22);
                    break;
                }
                case NOT_LIKE: 
                case NOT_REGEXP: {
                    arrayList4.add(object22);
                }
            }
        }
        String string5 = this.contactenateConditions(string2, arrayList3);
        string42 = this.printSQLFilter(string2, string5, string4 = this.contactenateConditions(string2, arrayList4), (String)(object = this.contactenateInConditions(string2, arrayList)), string3 = this.contactenateInConditions(string2, arrayList2));
        if (!string42.isEmpty()) {
            BLIB.DBG_DEBUG.log("Parsed filter text " + string + " to '" + string42.replace(this.columnPattern, this.targetName) + "'");
            if (!this.isCaseSensitive) {
                string42 = string42.toUpperCase();
            }
        }
        return string42;
    }

    protected String printSQLFilter(String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        if (!(string2.isEmpty() && string3.isEmpty() && string4.isEmpty() && string5.isEmpty())) {
            int n = (string2.isEmpty() ? 0 : 1) + (string3.isEmpty() ? 0 : 1) + (string4.isEmpty() ? 0 : 1) + (string5.isEmpty() ? 0 : 1);
            boolean bl = string2.isEmpty() && string4.isEmpty();
            boolean bl2 = string3.isEmpty() && string5.isEmpty();
            string6 = " AND " + (n == 1 ? "" : "(") + (!string2.isEmpty() || !string4.isEmpty() ? "(" : "") + string2 + (string2.isEmpty() || string4.isEmpty() ? "" : " OR ") + string4 + (!string2.isEmpty() || !string4.isEmpty() ? ")" : "") + (bl || bl2 ? "" : " AND") + (bl2 ? "" : " NOT (") + string3 + (string3.isEmpty() || string5.isEmpty() ? "" : " OR ") + string5 + (bl2 ? "" : ")") + (n == 1 ? "" : ")");
        }
        return string6;
    }

    protected String contactenateConditions(String string, List<SqlFilterParser.FilterItem> list) {
        String string2 = "";
        if (list.size() > 0) {
            for (SqlFilterParser.FilterItem filterItem : list) {
                String string3 = filterItem.getCondition();
                if (filterItem.getOperator() == SqlFilterParser.FilterOperatorType.LIKE || filterItem.getOperator() == SqlFilterParser.FilterOperatorType.NOT_LIKE) {
                    string2 = string2 + string + " " + this.buildLikeOperator(string, string3) + " OR ";
                    continue;
                }
                string2 = string2 + this.buildRegExpOperator(string, string3) + " OR ";
            }
            string2 = string2.replaceAll(" OR $", "");
        }
        return string2;
    }

    private String buildRegExpOperator(String string, String string2) {
        return "";
    }

    protected String contactenateInConditions(String string, List<SqlFilterParser.FilterItem> list) {
        String string2 = "";
        if (list.size() > 0) {
            string2 = string2 + string + " IN(";
            for (SqlFilterParser.FilterItem filterItem : list) {
                String string3 = filterItem.getCondition();
                string2 = string2 + "'" + string3 + "',";
            }
            string2 = string2.replaceAll(",$", ")");
        }
        return string2;
    }

    protected String buildLikeOperator(String string, String string2) {
        String string3 = string2;
        string3 = string2.contains("\\_") ? "LIKE '" + string2 + "' ESCAPE '\\'" : "LIKE '" + string2 + "'";
        return string3;
    }

    public String getSQLFilter(String string) {
        if (string == null) {
            return this.template;
        }
        return this.template.replaceAll(this.columnPattern, string);
    }

    public static enum TargetType {
        Database,
        Schema,
        Table,
        Procedure,
        Package;

    }
}

