/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.sqlfilter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlFilter {
    private String regexp_operator;
    private Pattern pattern;
    private Map<FilterOperatorType, List<FilterItem>> positiveItems;
    private Map<FilterOperatorType, List<FilterItem>> negativeItems;

    public SqlFilter() {
        this("");
    }

    public SqlFilter(String string) {
        this.regexp_operator = string;
        this.pattern = Pattern.compile("(?:(NOT)\\s+)?(?:(" + (string != null ? string : "") + ")\\s+)?(?:([^\\s,;']+|'([^']|'')*'))", 2);
        this.positiveItems = new TreeMap<FilterOperatorType, List<FilterItem>>();
        this.negativeItems = new TreeMap<FilterOperatorType, List<FilterItem>>();
    }

    public boolean isEmpty() {
        return this.positiveItems.isEmpty() && this.negativeItems.isEmpty();
    }

    public boolean parse(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = this.pattern.matcher(string);
        while (matcher.find()) {
            FilterItem filterItem;
            Map<FilterOperatorType, List<FilterItem>> map;
            List<FilterItem> list;
            boolean bl;
            boolean bl2 = "NOT".equalsIgnoreCase(matcher.group(1));
            boolean bl3 = this.regexp_operator != null ? this.regexp_operator.equalsIgnoreCase(matcher.group(2)) : false;
            String string2 = matcher.group(3);
            if (!string2.contains("'")) {
                string2 = "'" + string2 + "'";
            }
            if ((bl = string2.contains("%")) && this.regexp_operator != null) {
                bl3 = true;
                string2 = "'^" + string2.substring(1, string2.length() - 1).replace("%", ".*") + "$'";
            }
            if ((list = (map = bl2 ? this.negativeItems : this.positiveItems).get((Object)(filterItem = new FilterItem(bl3 ? FilterOperatorType.REGEXP_LIKE : (bl ? FilterOperatorType.LIKE : FilterOperatorType.IN), string2)).getOperator())) == null) {
                list = new ArrayList<FilterItem>();
                map.put(filterItem.getOperator(), list);
            }
            list.add(filterItem);
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().trim().isEmpty();
    }

    public String print(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.positiveItems.isEmpty() || !this.negativeItems.isEmpty()) {
            stringBuffer.append("(");
            if (!this.positiveItems.isEmpty() && !this.negativeItems.isEmpty()) {
                stringBuffer.append("(");
            }
            this.printFilterItems(stringBuffer, string, this.positiveItems);
            if (!this.positiveItems.isEmpty() && !this.negativeItems.isEmpty()) {
                stringBuffer.append(") AND NOT (");
            }
            if (this.positiveItems.isEmpty() && !this.negativeItems.isEmpty()) {
                stringBuffer.append("NOT (");
            }
            this.printFilterItems(stringBuffer, string, this.negativeItems);
            if (this.positiveItems.isEmpty() && !this.negativeItems.isEmpty()) {
                stringBuffer.append(")");
            }
            if (!this.positiveItems.isEmpty() && !this.negativeItems.isEmpty()) {
                stringBuffer.append(")");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private StringBuffer printFilterItems(StringBuffer stringBuffer, String string, Map<FilterOperatorType, List<FilterItem>> map) {
        boolean bl = false;
        for (Map.Entry<FilterOperatorType, List<FilterItem>> entry : map.entrySet()) {
            FilterOperatorType filterOperatorType = entry.getKey();
            List<FilterItem> list = entry.getValue();
            if (filterOperatorType == FilterOperatorType.IN) {
                stringBuffer.append(string).append(" ").append((Object)filterOperatorType).append(" (");
                for (int i = 0; i < list.size(); ++i) {
                    if (i != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(list.get(i).getCondition());
                }
                stringBuffer.append(")");
                bl = true;
                continue;
            }
            if (filterOperatorType == FilterOperatorType.LIKE) {
                for (FilterItem filterItem : list) {
                    if (bl) {
                        stringBuffer.append(" OR ");
                    }
                    stringBuffer.append(string).append(" ").append((Object)filterOperatorType).append(" ").append(filterItem.getCondition());
                    if (filterItem.getCondition().contains("\\_")) {
                        stringBuffer.append(" ESCAPE '\\'");
                    }
                    bl = true;
                }
                continue;
            }
            if (filterOperatorType != FilterOperatorType.REGEXP_LIKE) continue;
            for (FilterItem filterItem : list) {
                if (bl) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append((Object)filterOperatorType).append("(").append(string).append(",").append(filterItem.getCondition()).append(")");
                bl = true;
            }
        }
        return stringBuffer;
    }

    public class FilterItem {
        private FilterOperatorType operator;
        private String condition;

        public FilterItem(FilterOperatorType filterOperatorType, String string) {
            this.operator = filterOperatorType;
            this.condition = string;
        }

        public String getCondition() {
            return this.condition;
        }

        public FilterOperatorType getOperator() {
            return this.operator;
        }
    }

    public static enum FilterOperatorType {
        IN,
        LIKE,
        REGEXP_LIKE;

    }
}

