/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.sqlfilter;

import MITI.bridges.sqlfilter.SqlFilterParser;
import MITI.bridges.sqlfilter.SqlFilterPrinter;
import java.util.ArrayList;
import java.util.List;

public class JdbcSqlFilterPrinter
extends SqlFilterPrinter {
    protected List<String> fullNames = new ArrayList<String>();
    protected List<String> fullNamesNot = new ArrayList<String>();
    protected List<SqlFilterParser.FilterItem> likeNames = new ArrayList<SqlFilterParser.FilterItem>();
    protected List<SqlFilterParser.FilterItem> likeNamesNot = new ArrayList<SqlFilterParser.FilterItem>();

    public JdbcSqlFilterPrinter(SqlFilterParser sqlFilterParser, SqlFilterPrinter.TargetType targetType) {
        this(sqlFilterParser, targetType, true);
    }

    public JdbcSqlFilterPrinter(SqlFilterParser sqlFilterParser, SqlFilterPrinter.TargetType targetType, boolean bl) {
        super(sqlFilterParser, targetType, bl);
        this.filters = sqlFilterParser.getFilterNodes();
        this.init();
    }

    private void init() {
        for (SqlFilterParser.FilterItem filterItem : this.filters) {
            SqlFilterParser.FilterOperatorType filterOperatorType = filterItem.getOperator();
            if (filterOperatorType == SqlFilterParser.FilterOperatorType.IN) {
                this.fullNames.add(filterItem.getCondition());
                continue;
            }
            if (filterOperatorType == SqlFilterParser.FilterOperatorType.NOT_IN) {
                this.fullNamesNot.add(filterItem.getCondition());
                continue;
            }
            if (filterOperatorType == SqlFilterParser.FilterOperatorType.LIKE || filterOperatorType == SqlFilterParser.FilterOperatorType.REGEXP) {
                this.likeNames.add(filterItem);
                continue;
            }
            if (filterOperatorType != SqlFilterParser.FilterOperatorType.NOT_LIKE && filterOperatorType != SqlFilterParser.FilterOperatorType.NOT_REGEXP) continue;
            this.likeNamesNot.add(filterItem);
        }
    }

    public List<String> getFullNamesNodes() {
        return this.fullNames;
    }

    public boolean isPrinted(String string) {
        return this.test(string, this.fullNames, this.fullNamesNot, this.likeNames, this.likeNamesNot);
    }

    protected boolean test(String string, List<String> list, List<String> list2, List<SqlFilterParser.FilterItem> list3, List<SqlFilterParser.FilterItem> list4) {
        boolean bl = this.doesListContainName(list2, string);
        if (bl) {
            return false;
        }
        String string2 = null;
        for (SqlFilterParser.FilterItem object : list4) {
            String string3 = object.getCondition();
            string2 = this.convertPatternToRegexp(string3, object.getOperator() == SqlFilterParser.FilterOperatorType.NOT_REGEXP);
            if (!string.matches(string2)) continue;
            return false;
        }
        boolean bl2 = this.doesListContainName(list, string);
        if (!bl2 && list3.size() > 0) {
            for (SqlFilterParser.FilterItem filterItem : list3) {
                String string4 = filterItem.getCondition();
                string2 = this.convertPatternToRegexp(string4, filterItem.getOperator() == SqlFilterParser.FilterOperatorType.REGEXP);
                if (string2 == null || !string.matches(string2)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        if (list.size() > 0 && list2.isEmpty()) {
            return bl2;
        }
        return true;
    }

    private String convertPatternToRegexp(String string, boolean bl) {
        String string2 = null;
        if (string.startsWith("%")) {
            if (string.endsWith("%")) {
                String string3 = string.replaceAll("^%|%$", "");
                string2 = "^.*" + string3 + ".*$";
            } else {
                String string4 = string.replaceAll("^%", "");
                string2 = "^.*" + string4 + "$";
            }
        } else if (string.endsWith("%")) {
            String string5 = string.replaceAll("%$", "");
            string2 = "^" + string5 + ".*$";
        } else if (string.contains("%")) {
            String[] stringArray = string.split("%");
            string2 = stringArray.length == 2 ? "^" + stringArray[0] + ".*" + stringArray[1] + "$" : string;
        } else if (bl) {
            string2 = string;
        }
        string2 = this.addCaseSensitive(string2);
        return string2;
    }

    private String addCaseSensitive(String string) {
        return this.isCaseSensitive ? string : "(?i)" + string;
    }

    protected boolean doesListContainName(List<String> list, String string) {
        if (this.isCaseSensitive) {
            return list.contains(string);
        }
        for (String string2 : list) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

