/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.mimb;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.mimb.BridgeLibrary;
import MITI.messages.MIR.MIRSDK;
import MITI.messages.MIRBridgeConstants.MBLST;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.util.MachineInfo;
import MITI.util.VersionInfo;
import MITI.util.XmlUtil;
import MITI.util.file.FileCache;
import MITI.util.log.MIRLogger;
import MITI.util.text.BridgeSpecificationLiteral;
import MITI.util.text.TextLiteralCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MIRModelBridges {
    private static final String DEV_XML = "_Custom/MITI/conf/ModelBridgeList.xml";
    private static FileCache<MIRModelBridges> cache = new FileCache();
    private TreeMap<String, BridgeLibrary> importBridges = new TreeMap();
    private TreeMap<String, BridgeLibrary> exportBridges = new TreeMap();

    public static MIRModelBridges load(File file) throws MIRException {
        MIRModelBridges mIRModelBridges;
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new MIRException(MBCM.ERR_WRONG_MIMB_HOME_DIR.getMessage(new Object[0]));
        }
        boolean bl = false;
        File file2 = new File(file, "conf/ModelBridgeList.xml");
        if (!file2.isFile()) {
            bl = true;
            file2 = new File(file, DEV_XML);
        }
        if ((mIRModelBridges = cache.get(file2)) == null) {
            mIRModelBridges = new MIRModelBridges(file2, bl);
            cache.add(file2, mIRModelBridges);
        }
        return mIRModelBridges;
    }

    private MIRModelBridges(File file, boolean bl) throws MIRException {
        boolean bl2 = file.isFile();
        if (bl2) {
            try {
                Document document = MIRBridgeLib.parseXmlFile(file, MIRLogger.getLogger());
                if (document != null) {
                    Element object = document.getDocumentElement();
                    boolean bl3 = this.loadBridges(object, false);
                    if (!(bl3 &= this.loadBridges(object, true))) {
                        MBCM.MODEL_BRIDGE_CONFIGURATION_FILE_INVALID.log(new Object[0]);
                    }
                }
            }
            catch (IOException iOException) {
                throw new MIRException(MBCM.ERR_CANNOT_READ_CONFIG_FILE.getMessage(file.getAbsolutePath(), iOException.getMessage()), iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new MIRException(MIRSDK.XML_PARSER_INIT.getMessage(parserConfigurationException.getMessage()), parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new MIRException(MBCM.ERR_CANNOT_PARSE_CONFIG_FILE.getMessage(file.getAbsolutePath(), sAXException.getMessage()), sAXException);
            }
        }
        if (!bl2 || bl) {
            for (BridgeSpecificationLiteral bridgeSpecificationLiteral : MBLST.listAllSpecifications()) {
                if (bl2 && !bridgeSpecificationLiteral.getVendor_Name().isEmpty()) continue;
                this.addBridge(bridgeSpecificationLiteral);
            }
        }
    }

    private void addBridge(BridgeSpecificationLiteral bridgeSpecificationLiteral) {
        if (MachineInfo.isWindows() || !bridgeSpecificationLiteral.isBridge_IsWindowsOnly()) {
            BridgeLibrary bridgeLibrary = new BridgeLibrary(bridgeSpecificationLiteral.getBridge_Id(), bridgeSpecificationLiteral.getBridge_Id(), true, bridgeSpecificationLiteral.isBridge_IsWindowsOnly());
            if (bridgeSpecificationLiteral.getBridge_Direction().equals("Import")) {
                this.importBridges.put(bridgeLibrary.getBridgeId(), bridgeLibrary);
            } else {
                this.exportBridges.put(bridgeLibrary.getBridgeId(), bridgeLibrary);
            }
            for (BridgeSpecificationLiteral bridgeSpecificationLiteral2 : bridgeSpecificationLiteral.getBridgeAliases().values()) {
                this.addBridge(bridgeSpecificationLiteral2);
            }
        }
    }

    private boolean loadBridges(Element element, boolean bl) {
        ArrayList<Element> arrayList;
        boolean bl2 = true;
        String string = bl ? "Export" : "Import";
        Element element2 = XmlUtil.getFirstElement(element, string);
        if (element2 != null && (arrayList = XmlUtil.getChildElements(element2, "Bridge")) != null) {
            for (Element element3 : arrayList) {
                ArrayList<Element> arrayList2;
                String string2 = element3.getAttribute("id");
                if (string2.isEmpty()) {
                    bl2 = false;
                    continue;
                }
                BridgeSpecificationLiteral bridgeSpecificationLiteral = MBLST.getBridgeSpecification(string2, bl);
                if (bridgeSpecificationLiteral == null) {
                    bl2 = false;
                    continue;
                }
                boolean bl3 = !element3.getAttribute("enabled").equalsIgnoreCase("false");
                boolean bl4 = bridgeSpecificationLiteral.isBridge_IsWindowsOnly();
                if (bl4 && !MachineInfo.isWindows() || (arrayList2 = XmlUtil.getChildElements(element3, "DisplayName")) == null) continue;
                for (Element element4 : arrayList2) {
                    String string3 = element4.getAttribute("id");
                    if (string3.isEmpty()) {
                        string3 = string2;
                    } else if (bridgeSpecificationLiteral.getBridgeAliases().get(string3) == null) {
                        bl2 = false;
                        continue;
                    }
                    boolean bl5 = !element4.getAttribute("enabled").equalsIgnoreCase("false");
                    String string4 = XmlUtil.getElementValue(element4);
                    BridgeLibrary bridgeLibrary = new BridgeLibrary(string3, string4, bl3 && bl5, bl4);
                    if (bl) {
                        this.exportBridges.put(string3, bridgeLibrary);
                        continue;
                    }
                    this.importBridges.put(string3, bridgeLibrary);
                }
            }
        }
        return bl2;
    }

    public BridgeLibrary loadBridgeLibrary(String string, boolean bl) {
        BridgeLibrary bridgeLibrary = null;
        bridgeLibrary = bl ? this.exportBridges.get(string) : this.importBridges.get(string);
        return bridgeLibrary;
    }

    public Collection<BridgeLibrary> getBridges(boolean bl) {
        if (bl) {
            return this.exportBridges.values();
        }
        return this.importBridges.values();
    }

    public static BridgeSpecificationLiteral getBridgeSpecificationLiteral(String string, boolean bl) {
        return MBLST.getBridgeSpecification(string, bl);
    }

    public static BridgeSpecification buildSpecification(String string, boolean bl, BridgeSpecificationLiteral bridgeSpecificationLiteral, String string2, Class<? extends BridgeInterface> clazz) throws MIRException {
        String string3;
        TextLiteralCollection.TextLiteral textLiteral;
        BridgeSpecificationLiteral bridgeSpecificationLiteral2 = MIRModelBridges.getBridgeSpecificationLiteral(string, bl);
        if (bridgeSpecificationLiteral2 == null) {
            bridgeSpecificationLiteral2 = bridgeSpecificationLiteral;
        }
        String string4 = (textLiteral = TextLiteralCollection.getLiteral(string2, string3 = bridgeSpecificationLiteral2.getInternalCode_DescriptionLiteralId())) != null ? textLiteral.getText() : "*** " + string3;
        VersionInfo versionInfo = VersionInfo.loadMitiJar(clazz);
        String string5 = versionInfo != null ? versionInfo.getVersionString() + " - " + versionInfo.getDate() : "";
        BridgeSpecification bridgeSpecification = new BridgeSpecification(bridgeSpecificationLiteral2.getTool_Web(), bridgeSpecificationLiteral2.getVendor_Name(), bridgeSpecificationLiteral2.getTool_Name(), bridgeSpecificationLiteral2.getTool_Versions(), bridgeSpecificationLiteral2.getMethodology_ToolCategory(), bridgeSpecificationLiteral2.getMethodology_MetadataCoverage_Summary(), bridgeSpecificationLiteral2.getToolInterface_Summary(), bridgeSpecificationLiteral2.getMethodology_Summary(), bridgeSpecificationLiteral2.getId(), string5, string4, bridgeSpecificationLiteral2.isBridge_IsRepositoryMultiModel(), bridgeSpecificationLiteral2.isBridge_IsDriverLiveDownloadEnabled());
        return bridgeSpecification;
    }
}

