/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.mimb;

import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.util.Exec;
import MITI.util.MachineInfo;
import MITI.util.StringUtil;
import MITI.util.XmlUtil;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;

public class MIRModelBridgeInterface {
    private static boolean useCppDebugStop = false;
    private static boolean useCppDebugDirectory = false;
    private static boolean useJavaDebugStop = false;
    private static boolean keepMimbTempFiles = false;

    public static void setUseCppDebugStop(boolean bl) {
        useCppDebugStop = bl;
    }

    public static boolean getUseCppDebugStop() {
        return useCppDebugStop;
    }

    public static void setUseJavaDebugStop(boolean bl) {
        useJavaDebugStop = bl;
    }

    public static boolean getUseJavaDebugStop() {
        return useJavaDebugStop;
    }

    public static boolean isKeepMimbTempFiles() {
        return keepMimbTempFiles;
    }

    public static void setKeepMimbTempFiles(boolean bl) {
        keepMimbTempFiles = bl;
    }

    public static File getMimbCppHomeDir(File file) {
        File file2;
        if (file != null && useCppDebugDirectory && (file2 = new File(file, "../_Debug")).isDirectory()) {
            return file2;
        }
        return file;
    }

    public static String execute(String string, String string2, PrintStream printStream, MIRSetup mIRSetup, String string3) throws IOException {
        Object object2;
        File file = mIRSetup.getHomeDirectory();
        File file2 = MIRModelBridgeInterface.getMimbCppHomeDir(file);
        String string4 = new File(file2, "bin").getPath();
        String string5 = new File(file2, "lib").getPath();
        if (string2 == null || string2.length() == 0) {
            string2 = "en";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PATH", string4 + File.pathSeparator + System.getenv("PATH"));
        hashMap.put("MIR_I18N_LANG", string2);
        hashMap.put("MITI_OEM_CALLER_ID", string3);
        hashMap.put("MIR_LOG_LEVEL", Integer.toString(MIRLogger.getLogger().getLevel()));
        if (printStream != null) {
            hashMap.put("MIMB_LOG_IN_RESPONSE", "false");
        }
        hashMap.put("LD_LIBRARY_PATH", string5 + File.pathSeparator + System.getenv("LD_LIBRARY_PATH"));
        if (useCppDebugStop) {
            hashMap.put("MITI_DEBUG_MIMB", "ON");
        }
        if (keepMimbTempFiles) {
            hashMap.put("MITI_KEEP_MIMB_TEMP_FILES", "ON");
        }
        if (useJavaDebugStop) {
            hashMap.put("MITI_DEBUG_MIMB_JAVA", "ON");
        }
        File file3 = File.createTempFile("mimbResponse", ".xml", mIRSetup.getTempDirectory());
        file3.deleteOnExit();
        String[] stringArray = new String[]{string4 + File.separator + "MIMB" + (MachineInfo.isWindows() ? ".exe" : ""), "-r", "STDIN", "-y", file3.getAbsolutePath()};
        if (MIRLogger.getGlobalLevel() >= 6) {
            for (Object object2 : hashMap.keySet()) {
                String string6 = (String)hashMap.get(object2);
                MBCM.ENVIRONMENT_VARIABLE.log(object2, string6);
            }
            MBCM.MIMB_COMMAND.log("\"" + StringUtil.join(stringArray, "\" \"") + "\"");
        }
        Object object3 = printStream;
        object2 = null;
        if (printStream == null) {
            object2 = new ByteArrayOutputStream();
            object3 = new PrintStream((OutputStream)object2);
        }
        int n = Exec.exec(stringArray, hashMap, new File(string4), string, (PrintStream)object3, (PrintStream)object3, FileUtil.UTF8);
        String string7 = FileUtil.readContent(file3, FileUtil.UTF8);
        StringBuffer stringBuffer = new StringBuffer(string7);
        file3.delete();
        if (stringBuffer.length() == 0) {
            stringBuffer = new StringBuffer();
            String string8 = null;
            if (object2 != null) {
                string8 = ((ByteArrayOutputStream)object2).toString("utf-8").trim();
            }
            if (string8 != null && string8.length() != 0) {
                int n2;
                for (n2 = 0; n2 < string8.length() && Character.isWhitespace(string8.charAt(n2)); ++n2) {
                }
                if (string8.charAt(n2) == '<') {
                    stringBuffer.append(string8);
                } else {
                    stringBuffer.append(MIRModelBridgeInterface.generateMimbErrorResponse(MBCM.EMPTY_MIMB_RESPONSE_WITH_STDOUT.getMessage(string8)));
                }
            } else {
                stringBuffer.append(MIRModelBridgeInterface.generateMimbErrorResponse(MBCM.EMPTY_MIMB_RESPONSE.getMessage(new Object[0])));
            }
        } else {
            int n3;
            for (n3 = 0; n3 < stringBuffer.length() && Character.isWhitespace(stringBuffer.charAt(n3)); ++n3) {
            }
            if (stringBuffer.charAt(n3) != '<') {
                String string9 = stringBuffer.toString();
                stringBuffer = new StringBuffer();
                stringBuffer.append(MIRModelBridgeInterface.generateMimbErrorResponse(string9));
            }
        }
        if ((n < -6 || n > 12) && object3 != null) {
            ((PrintStream)object3).println(MBCM.ERR_MIMB_EXE.getMessage(n));
            ((PrintStream)object3).flush();
        }
        return stringBuffer.toString();
    }

    private static String generateMimbErrorResponse(String string) {
        return "<MimbErrorResponse><Log><Message type='NONE'>" + XmlUtil.escapeXml(string) + "</Message></Log></MimbErrorResponse>";
    }

    public static boolean getUseCppDebugDirectory() {
        return useCppDebugDirectory;
    }

    public static void setUseCppDebugDirectory(boolean bl) {
        useCppDebugDirectory = bl;
    }
}

