/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.maven;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.maven.Artifact;
import MITI.bridges.maven.ArtifactId;
import MITI.bridges.maven.ArtifactRef;
import MITI.bridges.maven.MavenArtifacts;
import MITI.bridges.maven.MavenRepository;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.util.Exec;
import MITI.util.MiscParams;
import MITI.util.Pair;
import MITI.util.log.MIRLogger;
import MITI.util.rest.RestUtil;
import MITI.util.text.BridgeOptionLiteral;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class MavenLibrary {
    private MavenRepository repo;
    private boolean secure;
    private File dir;
    private Proxy proxy;
    private MavenArtifacts artifacts;
    private Boolean isRepositoryAccessible;

    public static MavenLibrary get(MIRSetup mIRSetup) {
        return MavenLibrary.get(MavenRepository.DEFAULT, mIRSetup, null);
    }

    public static MavenLibrary get(MIRSetup mIRSetup, Proxy proxy) {
        return MavenLibrary.get(MavenRepository.DEFAULT, mIRSetup, proxy);
    }

    public static MavenLibrary get(MavenRepository mavenRepository, MIRSetup mIRSetup, Proxy proxy) {
        File file = mIRSetup.getDownloadDirectory();
        file.mkdirs();
        if (proxy == null) {
            proxy = MavenLibrary.getProxySettings(mIRSetup.getJavaOptions());
        }
        MavenLibrary mavenLibrary = new MavenLibrary(mavenRepository, file, proxy);
        return mavenLibrary;
    }

    public static Proxy getProxySettings(MimbOptions mimbOptions, BridgeOptionLiteral bridgeOptionLiteral) throws MIRException {
        String string = mimbOptions.getOptionValue(bridgeOptionLiteral.getParameterId(), false);
        MiscParams miscParams = MiscParams.parse(string);
        String string2 = miscParams.getValue("-java.parameters");
        return MavenLibrary.getProxySettings(string2);
    }

    private static Proxy getProxySettings(String string) {
        Map<String, String> map;
        String string2;
        if (string != null && !string.isEmpty() && (string2 = (map = Exec.getEnvVars(string)).get("-Dhttp.proxyHost")) != null && !string2.isEmpty()) {
            int n = 80;
            try {
                n = Integer.parseInt(map.get("-Dhttp.proxyPort"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            final String string3 = map.get("-Dhttp.proxyUser");
            final String string4 = map.get("-Dhttp.proxyPassword");
            if (string3 != null && string4 != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (Authenticator.RequestorType.PROXY == this.getRequestorType() && string2.equalsIgnoreCase(this.getRequestingHost())) {
                            return new PasswordAuthentication(string3, string4.toCharArray());
                        }
                        return null;
                    }
                });
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string2, n));
        }
        return null;
    }

    private MavenLibrary(MavenRepository mavenRepository, File file, Proxy proxy) {
        this.repo = mavenRepository;
        this.dir = file;
        this.proxy = proxy;
        this.artifacts = MavenArtifacts.get(file);
        this.processDir(file);
    }

    private String getMavenRepoUrl() {
        return this.repo.getStringUrl(this.secure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRepositoryAccessible() {
        if (this.isRepositoryAccessible == null) {
            this.isRepositoryAccessible = false;
            boolean[] blArray = new boolean[]{true, false};
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                this.secure = bl = blArray[i];
                HttpURLConnection httpURLConnection = null;
                try {
                    httpURLConnection = RestUtil.openConnection(new URL(this.getMavenRepoUrl()), this.proxy);
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() != 200) continue;
                    this.isRepositoryAccessible = true;
                    break;
                }
                catch (IOException | GeneralSecurityException exception) {
                    continue;
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
            if (!this.isRepositoryAccessible.booleanValue()) {
                MBCM.MSG_MAVEN_REPOSITORY_ACCESS_ERROR.log(this.repo.getStringUrl(false) + " and " + this.repo.getStringUrl(true));
            }
        }
        return this.isRepositoryAccessible;
    }

    private void processDir(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                this.processDir(file2);
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(".pom")) continue;
            this.resolveArtifact(file2, false);
        }
    }

    public Collection<File> download(boolean bl, ArtifactId ... artifactIdArray) {
        return this.getFiles(true, bl, artifactIdArray);
    }

    public Collection<File> load(boolean bl, ArtifactId ... artifactIdArray) {
        return this.getFiles(false, bl, artifactIdArray);
    }

    private Collection<File> getFiles(boolean bl, boolean bl2, ArtifactId ... artifactIdArray) {
        TreeMap<ArtifactId, Pair<Artifact, Integer>> treeMap = new TreeMap<ArtifactId, Pair<Artifact, Integer>>(ArtifactId.NO_VERSION);
        for (ArtifactId artifactId : artifactIdArray) {
            this.buildDependencyGraph(treeMap, new Stack<ArtifactRef>(), new ArtifactRef(artifactId, ""), bl2, bl);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (ArtifactId artifactId : artifactIdArray) {
            this.buildClasspath(treeMap, linkedHashMap, artifactId);
        }
        return linkedHashMap.values();
    }

    private void buildDependencyGraph(TreeMap<ArtifactId, Pair<Artifact, Integer>> treeMap, Stack<ArtifactRef> stack, ArtifactRef artifactRef, boolean bl, boolean bl2) {
        Artifact artifact;
        Pair<Artifact, Integer> pair = treeMap.get(artifactRef.getId());
        if ((pair == null || (Integer)pair.obj2 > stack.size()) && (artifact = this.getResolvedArtifact(artifactRef.getId(), bl2)) != null) {
            Artifact artifact2 = new Artifact(artifact);
            treeMap.put(artifactRef.getId(), new Pair<Artifact, Integer>(artifact2, stack.size()));
            if (bl) {
                stack.push(artifactRef);
                for (ArtifactRef artifactRef2 : this.artifacts.getDependencies(artifact)) {
                    for (ArtifactRef artifactRef3 : stack) {
                        if (!this.isExcluded(artifactRef3, artifactRef2.getId())) continue;
                        artifactRef2 = null;
                        break;
                    }
                    if (artifactRef2 != null && (artifactRef2.getId().getVersion().isEmpty() || artifactRef2.getScope().isEmpty())) {
                        ArtifactRef artifactRef4;
                        Artifact artifact3;
                        Object object2 = null;
                        Iterator iterator = stack.iterator();
                        while (iterator.hasNext() && (object2 = this.artifacts.getManagedDependency(artifactRef2, artifact3 = this.getResolvedArtifact((artifactRef4 = (ArtifactRef)iterator.next()).getId(), bl2))) == null) {
                        }
                        if (object2 != null) {
                            if ((artifactRef2 = new ArtifactRef(artifactRef2)).getId().getVersion().isEmpty()) {
                                artifactRef2.getId().setVersion(((ArtifactRef)object2).getId().getVersion());
                            }
                            if (artifactRef2.getScope().isEmpty()) {
                                artifactRef2.setScope(((ArtifactRef)object2).getScope());
                            }
                        } else if (artifactRef2.getId().getVersion().isEmpty()) {
                            artifactRef2 = null;
                        }
                    }
                    if (artifactRef2 == null || !artifactRef2.isIncluded()) continue;
                    artifact2.getDependencies().add(artifactRef2);
                    this.buildDependencyGraph(treeMap, stack, artifactRef2, true, bl2);
                }
                stack.pop();
            }
        }
    }

    private boolean isExcluded(ArtifactRef artifactRef, ArtifactId artifactId) {
        if (artifactRef.isExcluded(artifactId)) {
            return true;
        }
        Artifact artifact = this.artifacts.get(artifactRef.getId());
        ArtifactRef artifactRef2 = this.artifacts.getManagedDependency(artifactRef, artifact);
        return artifactRef2 != null && artifactRef2.isExcluded(artifactId);
    }

    private void buildClasspath(TreeMap<ArtifactId, Pair<Artifact, Integer>> treeMap, LinkedHashMap<String, File> linkedHashMap, ArtifactId artifactId) {
        File file;
        Pair<Artifact, Integer> pair = treeMap.get(artifactId);
        if (pair != null && artifactId.compareTo((ArtifactId)pair.obj1) == 0 && linkedHashMap.putIfAbsent((file = artifactId.getJarFile(this.dir)).getPath(), file) == null) {
            this.download(artifactId.getJarUrl(), file);
            for (ArtifactRef artifactRef : ((Artifact)pair.obj1).getDependencies()) {
                this.buildClasspath(treeMap, linkedHashMap, artifactRef.getId());
            }
        }
    }

    private void download(String string, File file) {
        if (!file.exists()) {
            URL uRL = this.getMavenUrl(this.repo, string);
            file.getParentFile().mkdirs();
            File file2 = new File(file.getPath() + "_download");
            if (this.isRepositoryAccessible()) {
                MIRBridgeLib.downloadWebPageToFile(uRL, file2, "", this.proxy, MIRLogger.getNullLogger());
            }
            if (!file2.exists() && this.repo != MavenRepository.DEFAULT) {
                uRL = this.getMavenUrl(MavenRepository.DEFAULT, string);
                MIRBridgeLib.downloadWebPageToFile(uRL, file2, "", this.proxy, MIRLogger.getNullLogger());
            }
            if (!file2.exists()) {
                MBCM.MSG_MAVEN_DOWNLOADING_FILE_ERROR.log(uRL.toString());
            } else {
                MBCM.MSG_MAVEN_DOWNLOADING_FILE.log(uRL.toString());
                file2.renameTo(file);
            }
        }
    }

    private URL getMavenUrl(MavenRepository mavenRepository, String string) {
        try {
            return new URL(mavenRepository.getStringUrl(this.secure) + string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private Artifact getResolvedArtifact(ArtifactId artifactId, boolean bl) {
        Artifact artifact = this.artifacts.get(artifactId);
        if (artifact == null) {
            if (bl && "release".equals(artifactId.getVersion())) {
                File file = artifactId.getMetadataFile(this.dir);
                this.download(artifactId.getMetadataUrl(), file);
                artifactId = ArtifactId.fromMetadata(file);
            }
            artifact = this.resolveArtifact(this.getPomFile(artifactId, bl), bl);
        }
        return artifact;
    }

    private Artifact resolveArtifact(File file, boolean bl) {
        Artifact artifact = null;
        try {
            artifact = Artifact.fromPom(new FileInputStream(file));
            if (artifact != null && artifact.getParentId() != null && this.getResolvedArtifact(artifact.getParentId(), bl) == null && !bl) {
                artifact = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (artifact != null) {
            this.artifacts.put(artifact);
            this.importDependentPoms(artifact, bl);
        }
        return artifact;
    }

    private void importDependentPoms(Artifact artifact, boolean bl) {
        for (ArtifactRef artifactRef : artifact.getManagementDependencies()) {
            this.artifacts.resolve(artifactRef, artifact);
            if (!artifactRef.isImport()) continue;
            this.getResolvedArtifact(artifactRef.getId(), bl);
        }
        for (ArtifactRef artifactRef : artifact.getDependencies()) {
            this.artifacts.resolve(artifactRef, artifact);
        }
    }

    private File getPomFile(ArtifactId artifactId, boolean bl) {
        File file = artifactId.getPomFile(this.dir);
        if (bl) {
            this.download(artifactId.getPomUrl(), file);
        }
        return file;
    }
}

