/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.maven;

import MITI.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ArtifactId
implements Comparable<ArtifactId> {
    public static final String LATEST = "latest";
    public static final String RELEASE = "release";
    private String group;
    private String name;
    private String version;
    private Type packaging;
    public static Comparator<ArtifactId> NO_VERSION = new Comparator<ArtifactId>(){

        @Override
        public int compare(ArtifactId artifactId, ArtifactId artifactId2) {
            int n = artifactId.group.compareTo(artifactId2.group);
            if (n == 0) {
                n = artifactId.name.compareTo(artifactId2.name);
            }
            return n;
        }
    };

    public ArtifactId(String string, String string2, String string3) {
        this(string, string2, string3, Type.JAR);
    }

    public ArtifactId(ArtifactId artifactId) {
        this(artifactId.group, artifactId.name, artifactId.version, artifactId.packaging);
    }

    public ArtifactId(String string, String string2, String string3, Type type) {
        this.group = string != null ? string : "";
        this.name = string2;
        this.version = string3 != null ? string3 : "";
        this.packaging = type != null ? type : Type.JAR;
    }

    public String getGroup() {
        return this.group;
    }

    protected void setGroup(String string) {
        if (string != null && !string.isEmpty()) {
            this.group = string;
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        if (string != null && !string.isEmpty()) {
            this.name = string;
        }
    }

    public String getVersion() {
        return this.version;
    }

    protected void setVersion(String string) {
        if (string != null && !string.isEmpty()) {
            this.version = string;
        }
    }

    public Type getPackaging() {
        return this.packaging;
    }

    private String getPath(boolean bl, boolean bl2) {
        return (bl2 ? this.getGroup().replace(".", "/") : this.getGroup()) + "/" + this.name + "/" + (bl ? this.getVersion() + "/" : "");
    }

    public String getMetadataUrl() {
        return this.getPath(false, true) + "maven-metadata.xml";
    }

    public String getPomUrl() {
        return this.getPath(true, true) + this.name + "-" + this.getVersion() + ".pom";
    }

    public String getJarUrl() {
        return this.getPath(true, true) + this.name + "-" + this.getVersion() + "." + this.packaging.name().toLowerCase();
    }

    public File getMetadataFile(File file) {
        return new File(file, this.getPath(false, false) + "maven-metadata.xml");
    }

    public File getPomFile(File file) {
        return new File(file, this.getPath(true, false) + this.name + "-" + this.getVersion() + ".pom");
    }

    public File getJarFile(File file) {
        return new File(file, this.getPath(true, false) + this.name + "-" + this.getVersion() + "." + this.packaging.name().toLowerCase());
    }

    @Override
    public int compareTo(ArtifactId artifactId) {
        int n = this.group.compareTo(artifactId.group);
        if (n == 0 && (n = this.name.compareTo(artifactId.name)) == 0) {
            n = this.version.compareTo(artifactId.version);
        }
        return n;
    }

    public static ArtifactId fromMetadata(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            String string = XmlUtil.getElementValue(XmlUtil.getFirstElement(element, "groupId"));
            String string2 = XmlUtil.getElementValue(XmlUtil.getFirstElement(element, "artifactId"));
            Element element2 = XmlUtil.getFirstElement(element, "versioning");
            String string3 = XmlUtil.getElementValue(XmlUtil.getFirstElement(element2, RELEASE));
            return new ArtifactId(string, string2, string3);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return null;
        }
    }

    public String toString() {
        return this.group + ":" + this.name + ":" + this.version;
    }

    public static enum Type {
        POM,
        JAR,
        WAR,
        ZIP;


        public static Type get(String string) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(string)) continue;
                return type;
            }
            return null;
        }
    }
}

