/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.maven;

import MITI.bridges.maven.ArtifactId;
import MITI.bridges.maven.ArtifactRef;
import MITI.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Artifact
extends ArtifactId {
    private String projectName;
    private String projectDescription;
    private String projectUrl;
    private ArrayList<String> licenseNames = new ArrayList();
    private ArrayList<String> licenseUrls = new ArrayList();
    private HashMap<String, String> artifactProperties = new HashMap();
    private ArtifactId parentId;
    private ArrayList<ArtifactRef> dependencies = new ArrayList();
    private ArrayList<ArtifactRef> managementDependencies = new ArrayList();

    public Artifact(ArtifactId artifactId) {
        super(artifactId);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public Collection<String> getLicenseNames() {
        return this.licenseNames;
    }

    public Collection<String> getLicenseUrls() {
        return this.licenseUrls;
    }

    public ArtifactId getParentId() {
        return this.parentId;
    }

    public Collection<ArtifactRef> getDependencies() {
        return this.dependencies;
    }

    public Collection<ArtifactRef> getManagementDependencies() {
        return this.managementDependencies;
    }

    public static Artifact fromPom(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Element element;
            Element element2;
            Element element3;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element4 = document.getDocumentElement();
            ArtifactId artifactId = Artifact.fromElement(element4);
            ArtifactId artifactId2 = Artifact.fromElement(XmlUtil.getFirstElement(element4, "parent"));
            if (artifactId2 != null) {
                artifactId = new ArtifactId(artifactId.getGroup().isEmpty() ? artifactId2.getGroup() : artifactId.getGroup(), artifactId.getName(), artifactId.getVersion().isEmpty() ? artifactId2.getVersion() : artifactId.getVersion(), artifactId.getPackaging());
            }
            Artifact artifact = new Artifact(artifactId);
            if (artifactId2 != null) {
                artifact.parentId = artifactId2;
            }
            artifact.projectName = XmlUtil.getElementValue(XmlUtil.getFirstElement(element4, "name"));
            artifact.projectDescription = XmlUtil.getElementValue(XmlUtil.getFirstElement(element4, "description"));
            artifact.projectUrl = XmlUtil.getElementValue(XmlUtil.getFirstElement(element4, "url"));
            Element element5 = XmlUtil.getFirstElement(element4, "properties");
            if (element5 != null) {
                Artifact.processProperties(element5, artifact);
            }
            if ((element3 = XmlUtil.getFirstElement(element4, "licenses")) != null) {
                Artifact.processLicenses(element3, artifact);
            }
            if ((element2 = XmlUtil.getFirstElement(element = XmlUtil.getFirstElement(element4, "dependencyManagement"), "dependencies")) != null) {
                artifact.managementDependencies.addAll(Artifact.processDependencies(element2));
            }
            if ((element2 = XmlUtil.getFirstElement(element4, "dependencies")) != null) {
                artifact.dependencies.addAll(Artifact.processDependencies(element2));
            }
            return artifact;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return null;
        }
    }

    private static void processProperties(Element element, Artifact artifact) {
        for (Element element2 : XmlUtil.getChildElements(element)) {
            artifact.artifactProperties.put(element2.getTagName(), XmlUtil.getElementValue(element2));
        }
    }

    private static void processLicenses(Element element, Artifact artifact) {
        for (Element element2 : XmlUtil.getChildElements(element, "license")) {
            artifact.licenseNames.add(XmlUtil.getElementValue(XmlUtil.getFirstElement(element2, "name")));
            artifact.licenseUrls.add(XmlUtil.getElementValue(XmlUtil.getFirstElement(element2, "url")));
        }
    }

    private static ArrayList<ArtifactRef> processDependencies(Element element) {
        ArrayList<ArtifactRef> arrayList = new ArrayList<ArtifactRef>();
        for (Element element2 : XmlUtil.getChildElements(element, "dependency")) {
            ArtifactRef artifactRef;
            String string = XmlUtil.getElementValue(XmlUtil.getFirstElement(element2, "scope"));
            String string2 = XmlUtil.getElementValue(XmlUtil.getFirstElement(element2, "optional"));
            boolean bl = "true".equals(string2);
            if (bl || !(artifactRef = new ArtifactRef(Artifact.fromElement(element2), string)).isIncluded()) continue;
            Element element3 = XmlUtil.getFirstElement(element2, "exclusions");
            if (element3 != null) {
                for (Element element4 : XmlUtil.getChildElements(element3, "exclusion")) {
                    artifactRef.addExclusion(Artifact.fromElement(element4));
                }
            }
            arrayList.add(artifactRef);
        }
        return arrayList;
    }

    private static ArtifactId fromElement(Element element) {
        if (element != null) {
            String[] stringArray;
            String string = XmlUtil.getElementValue(XmlUtil.getFirstElement(element, "groupId"));
            String string2 = XmlUtil.getElementValue(XmlUtil.getFirstElement(element, "artifactId"));
            String string3 = XmlUtil.getElementValue(XmlUtil.getFirstElement(element, "version"));
            if (string3 != null && string3.contains(",")) {
                stringArray = string3.replaceAll("[\\[\\]\\(\\)]", "").split(",");
                for (int i = stringArray.length; i > 0 && (string3 = stringArray[i - 1].trim()).isEmpty(); --i) {
                }
            }
            stringArray = ArtifactId.Type.get(XmlUtil.getElementValue(XmlUtil.getFirstElement(element, "packaging")));
            return new ArtifactId(string, string2, string3, (ArtifactId.Type)stringArray);
        }
        return null;
    }

    public Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }
}

