/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.util.text.BridgeEnumerationLiteral;
import MITI.util.text.BridgeOptionLiteral;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Parameter {
    private static final String HIDDEN_PARAMETER_PREFIX = "__";
    private String name;
    private String displayName;
    private String description;
    private String defaultValue;
    private boolean mandatory = false;
    private String[] fileExtensions;
    private OpenMode mode;
    private boolean transferable;
    private Type type;
    private Map<String, String> possibleValues = new LinkedHashMap<String, String>();
    private String savedValue;
    private List<String> historicalValues = new ArrayList<String>();
    private boolean isHidden = false;

    protected Parameter(BridgeOptionLiteral bridgeOptionLiteral, boolean bl, String[] stringArray, OpenMode openMode, boolean bl2) {
        this.name = bridgeOptionLiteral.getParameterId();
        this.displayName = bridgeOptionLiteral.getText();
        this.description = bridgeOptionLiteral.getDescription();
        this.type = Type.valueOf(bridgeOptionLiteral.getType().name());
        this.defaultValue = bridgeOptionLiteral.getDefaultValue();
        if (this.type != Type.ENUMERATED && this.type != Type.BOOLEAN) {
            this.mandatory = bl;
        }
        this.fileExtensions = stringArray;
        this.mode = openMode;
        this.transferable = bl2;
        if (bridgeOptionLiteral.getEnumeration() != null) {
            for (BridgeEnumerationLiteral bridgeEnumerationLiteral : bridgeOptionLiteral.getEnumeration().getValues()) {
                this.possibleValues.put(bridgeEnumerationLiteral.getId(), bridgeEnumerationLiteral.getText());
            }
        }
    }

    public Parameter(String string, String string2, String string3, String string4, Type type, boolean bl, String[] stringArray, OpenMode openMode, boolean bl2, Map<String, String> map, String string5, List<String> list) {
        this.name = string;
        this.displayName = string2;
        this.description = string3;
        this.defaultValue = string4;
        this.type = type;
        this.mandatory = bl;
        this.fileExtensions = stringArray;
        this.mode = openMode;
        this.transferable = bl2;
        this.possibleValues = map;
        this.savedValue = string5;
        this.historicalValues = list;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isTransferable() {
        return this.transferable;
    }

    public OpenMode getOpenMode() {
        return this.mode;
    }

    public List<String> getFileExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.fileExtensions != null) {
            for (String string : this.fileExtensions) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public Map<String, String> getPossibleValues() {
        return this.possibleValues;
    }

    public String getDisplayPossibleValue(String string) {
        String string2;
        Map<String, String> map = this.getPossibleValues();
        if (map != null && (string2 = map.get(string)) != null) {
            return string2;
        }
        return string;
    }

    public boolean isPossibleValue(String string) {
        if (this.type == Type.ENUMERATED || this.type == Type.BOOLEAN) {
            Map<String, String> map = this.getPossibleValues();
            return map.keySet().contains(string);
        }
        if (this.type == Type.FILE) {
            if (string.isEmpty()) {
                return !this.mandatory;
            }
            List<String> list = this.getFileExtensions();
            if (!list.isEmpty()) {
                for (String string2 : list) {
                    String string3 = "." + string2;
                    if (!string.toLowerCase().endsWith(string3.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        if (this.type == Type.DIRECTORY) {
            if (string.isEmpty()) {
                return !this.mandatory;
            }
            return true;
        }
        return true;
    }

    public String getSavedValue() {
        return this.savedValue;
    }

    public void setSavedValue(String string) {
        this.savedValue = string;
    }

    public boolean isHidden() {
        return this.isHidden || this.name.startsWith(HIDDEN_PARAMETER_PREFIX);
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void addHistoricalValue(String string) {
        this.historicalValues.add(string);
    }

    public List<String> getHistoricalValues() {
        return this.historicalValues;
    }

    public static enum OpenMode {
        DEFAULT,
        READ,
        WRITE,
        READWRITE;

    }

    public static enum Type {
        STRING,
        ENUMERATED,
        NUMERIC,
        BOOLEAN,
        PASSWORD,
        FILE,
        DIRECTORY,
        REPOSITORY_MODEL,
        REPOSITORY_SUBSET,
        DATE;

    }
}

