/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.cache.MIMBCache;
import MITI.bridges.javabridge.JavaBridge;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.BridgeSpecification;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.javabridgeinterface.Parameter;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.bridges.mimb.MimbMessageLogOutputStream;
import MITI.bridges.mimb.MimbUtf8PrintStream;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.JBDG;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.Encryption;
import MITI.util.Exec;
import MITI.util.MiscParams;
import MITI.util.ProcessBuilder;
import MITI.util.XmlUtil;
import MITI.util.config.MitiLocale;
import MITI.util.file.FileUtil;
import MITI.util.file.PropertyFile;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class JavaBridgeExec
extends Exec {
    public static final String JAVA_VERSION_7 = "1.7";
    public static final String JAVA_VERSION_8 = "1.8";
    private String bridgeClass;
    private Class<?> mainClass;
    private MIRLogger logger;
    private String javaExe;
    private String javaVersion;
    private ClassPath userClassPath;
    private String javaUserOptions = "";
    private List<String> javaProperties;
    private Map<String, String> userEnvironment;
    private static final String IMPORT_COMMAND = "Import";
    private static final String EXPORT_COMMAND = "Export";
    private static final String BROWSE_COMMAND = "Browse";
    private static final String TEST_COMMAND = "Test";
    private static final String DATAQUALITY_COMMAND = "DataQuality";
    private BridgeEnvironment bridgeEnvironment;
    private String preScript = null;
    private String postScript = null;
    private static final String[] MIR_JARS = new String[]{"MIRUtil.jar", "MIR.jar", "MIRBridgeConstants.jar", "MIRExpressionLib.jar", "MIRModelBridge.jar", "MIRModelConverter.jar", "MIREtlBridgeLib.jar", "Mimb.jar", "MIRProfiler.jar", "MIRStatisticsUtil.jar", "Yaml/snakeyaml-2.0.jar"};
    private static final String[] MIR_OPTIONAL_JARS = new String[]{"Licensing.jar"};

    public JavaBridgeExec(MIRLogger mIRLogger, String string, ClassPath classPath, BridgeEnvironment bridgeEnvironment, String string2) throws MIRException {
        this.logger = mIRLogger;
        this.userClassPath = classPath;
        this.javaVersion = string2;
        this.bridgeClass = string;
        this.mainClass = JavaBridge.class;
        this.javaProperties = new ArrayList<String>();
        this.bridgeEnvironment = bridgeEnvironment;
    }

    public JavaBridgeExec(MIRLogger mIRLogger, String string, ClassPath classPath, BridgeEnvironment bridgeEnvironment) throws MIRException {
        this(mIRLogger, string, classPath, bridgeEnvironment, JAVA_VERSION_7);
    }

    public void javaImport(File file, MimbOptions mimbOptions, BridgeSpecification bridgeSpecification) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        MIRMetadataOrigin mIRMetadataOrigin = this.generateMetadataOrigin(bridgeSpecification);
        this.execScript(this.preScript);
        this.exec(IMPORT_COMMAND, file, mimbOptions, this.bridgeEnvironment.getValidationLevel(), "", mIRMetadataOrigin, null);
        this.execScript(this.postScript);
    }

    public void javaExport(File file, MimbOptions mimbOptions) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        this.execScript(this.preScript);
        this.exec(EXPORT_COMMAND, file, mimbOptions, MIRValidationLevel.NONE, "", null, null);
        this.execScript(this.postScript);
    }

    public void javaBrowse(File file, MimbOptions mimbOptions, BridgeSpecification bridgeSpecification, String string) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        MIRMetadataOrigin mIRMetadataOrigin = this.generateMetadataOrigin(bridgeSpecification);
        this.exec(BROWSE_COMMAND, file, mimbOptions, MIRValidationLevel.BROWSE, string, mIRMetadataOrigin, null);
    }

    public void javaTest(MimbOptions mimbOptions) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        this.exec(TEST_COMMAND, null, mimbOptions, MIRValidationLevel.NONE, "", null, null);
    }

    public void javaDataQuality(MimbOptions mimbOptions, DataQualityOptions dataQualityOptions) throws MIRException {
        this.configureMiscellaneousOptions(mimbOptions);
        this.exec(DATAQUALITY_COMMAND, null, mimbOptions, MIRValidationLevel.NONE, "", null, dataQualityOptions);
    }

    public void setJavaExe(String string) {
        this.javaExe = string;
    }

    public void setJavaUserOptions(String string) {
        this.javaUserOptions = string;
    }

    private void configureMiscellaneousOptions(MimbOptions mimbOptions) throws MIRException {
        String string = mimbOptions.getOptionValue("Miscellaneous", false);
        if (string != null) {
            this.configureMiscellaneousOptions(string);
        }
    }

    private void configureMiscellaneousOptions(String string) throws MIRException {
        Object object;
        Object object2;
        Map<String, String> map;
        String string2;
        Object object3;
        MiscParams miscParams = MiscParams.parse(string);
        String string3 = miscParams.getValue("-java.executable");
        if (string3 != null && !string3.isEmpty()) {
            if (string3.startsWith("\"")) {
                string3 = string3.replace("\"", "");
            }
            if (((File)(object3 = new File(string3))).exists()) {
                this.javaExe = string3;
            }
        }
        if ((object3 = miscParams.getValue("-java.memory")) != null && !((String)object3).isEmpty()) {
            this.javaUserOptions = this.javaUserOptions + " -Xmx" + (String)object3;
        }
        if ((string2 = miscParams.getValue("-java.parameters")) != null && !string2.isEmpty()) {
            this.javaUserOptions = this.javaUserOptions + " " + string2;
        }
        if ((map = miscParams.getMappedValues("-environment.variable")) != null) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                this.setEnvironmentProperty((String)object.getKey(), (String)object.getValue());
            }
        }
        if ((object2 = miscParams.getValue("-prescript")) != null && !((String)object2).isEmpty()) {
            this.preScript = object2;
        }
        if ((object = miscParams.getValue("-postscript")) != null && !((String)object).isEmpty()) {
            this.postScript = object;
        }
    }

    public void setEnvironmentProperty(String string, String string2) {
        if (this.userEnvironment == null) {
            this.userEnvironment = new HashMap<String, String>();
        }
        this.userEnvironment.put(string, string2);
    }

    public void addJavaProperty(String string, String string2) {
        this.addJavaProperty("-D" + string + "=" + string2);
    }

    private void addJavaProperty(String string) {
        this.javaProperties.add(string);
    }

    protected List<String> buildCommandLine(File file, MimbOptions mimbOptions, Map<String, String> map, boolean bl) throws MIRException {
        String string5;
        Object object;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = Exec.splitCommandLine(this.javaUserOptions + " " + this.bridgeEnvironment.getSetup().getJavaOptions());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = iterator.next();
            if (string4.startsWith("-Xms")) {
                if (string3 != null) continue;
                string3 = string4;
                continue;
            }
            if (string4.startsWith("-Xmx")) {
                if (string2 != null) continue;
                string2 = string4;
                continue;
            }
            if (string4.startsWith("-D")) {
                this.addJavaProperty(string4);
                continue;
            }
            if (string4.equals("--add-opens")) {
                Object object2 = object = iterator.hasNext() ? iterator.next() : "";
                if (!bl) continue;
                arrayList.add(string4);
                arrayList.add((String)object);
                continue;
            }
            arrayList.add(string4);
        }
        if (string3 == null) {
            string3 = "-Xms256m";
        }
        arrayList.add(string3);
        boolean bl2 = Exec.is64bits(new File(this.javaExe));
        JBDG.DETECTED_JVM_ARCHITECTURE.log(this.javaExe, bl2 ? "64" : "32");
        if (string2 == null) {
            string2 = bl2 ? "-Xmx2048m" : "-Xmx512m";
        }
        arrayList.add(string2);
        if (this.getDebugJava(map)) {
            arrayList.add("-Xdebug");
            arrayList.add("-Xrunjdwp:transport=dt_socket,address=19988,server=y,suspend=y");
        }
        arrayList.add("-Dmimb.home=" + this.bridgeEnvironment.getHomeDirectory().getPath());
        arrayList.add("-Dmimb.data=" + this.bridgeEnvironment.getSetup().getDataDirectory().getPath());
        for (String string5 : this.javaProperties) {
            if (string5.equals("-Dnashorn.args=--no-deprecation-warning") && !bl) continue;
            arrayList.add(string5);
        }
        arrayList.add("-classpath");
        object = new ClassPath(this.bridgeEnvironment, this.logger, mimbOptions);
        ((ClassPath)object).addRelativePaths(this.bridgeEnvironment.getJavaDirectory(), MIR_JARS);
        if (!((ClassPath)object).isComplete()) {
            BLIB.SOME_JARS_NOT_FOUND.log(this.logger, new Object[0]);
        }
        ((ClassPath)object).addOptionalRelativePaths(this.bridgeEnvironment.getJavaDirectory(), MIR_OPTIONAL_JARS);
        ((ClassPath)object).appendClassPath(this.userClassPath);
        string5 = ((ClassPath)object).build();
        BLIB.DBG_DEBUG.log("Classpath: " + string5);
        arrayList.add(string5);
        arrayList.add(this.mainClass.getName());
        arrayList.add("-r");
        arrayList.add(file.getPath());
        return arrayList;
    }

    protected boolean getDebugJava(Map<String, String> map) {
        String string = map.get("MITI_DEBUG_MIMB_JAVA");
        return "ON".equals(string) || MIRModelBridgeInterface.getUseJavaDebugStop();
    }

    protected void setDebugJava(Map<String, String> map) {
        map.put("MITI_DEBUG_MIMB_JAVA", "ON");
    }

    protected boolean getDebugCpp(Map<String, String> map) {
        String string = map.get("MITI_DEBUG_MIMB");
        return "ON".equals(string) || MIRModelBridgeInterface.getUseCppDebugStop();
    }

    protected void setDebugCpp(Map<String, String> map) {
        map.put("MITI_DEBUG_MIMB", "ON");
    }

    protected boolean getDebugCppDir(Map<String, String> map) {
        String string = map.get("MITI_DEBUG_MIMB_DIR");
        return "ON".equals(string) || MIRModelBridgeInterface.getUseCppDebugDirectory();
    }

    protected void setDebugCppDir(Map<String, String> map) {
        map.put("MITI_DEBUG_MIMB_DIR", "ON");
    }

    protected File createXmlRequestFile(String string, File file, MimbOptions mimbOptions, MIRValidationLevel.Enum enum_, String string2, MIRMetadataOrigin mIRMetadataOrigin, DataQualityOptions dataQualityOptions) throws MIRException {
        Object object;
        Object object22;
        Element element = XmlUtil.parseString("<" + string + "/>");
        element.setAttribute("bridge", this.bridgeClass);
        if (mIRMetadataOrigin != null) {
            element.setAttribute("vendorName", mIRMetadataOrigin.getVendorName());
            element.setAttribute("toolName", mIRMetadataOrigin.getToolName());
            element.setAttribute("toolVersion", mIRMetadataOrigin.getToolVersion());
            element.setAttribute("formatVersion", mIRMetadataOrigin.getFormatVersion());
            element.setAttribute("bridgeName", mIRMetadataOrigin.getBridgeName());
            element.setAttribute("bridgeVersion", mIRMetadataOrigin.getBridgeVersion());
        }
        element.setAttribute("aliasId", this.bridgeClass);
        if (file != null) {
            element.setAttribute("file", file.getPath());
        }
        element.setAttribute("validationLevel", enum_.getName());
        if (string2 != null && !string2.isEmpty()) {
            element.setAttribute("browseParameter", string2);
        }
        String string3 = "0";
        if (MIMBCache.isResetXmiCache()) {
            string3 = MIMBCache.isResetNativeCache() ? "2" : "1";
        }
        element.setAttribute("resetCache", string3);
        element.setAttribute("javaVersion", this.javaVersion);
        for (Object object22 : mimbOptions) {
            Element element2 = XmlUtil.appendNewElement(element, "BridgeParameter");
            element2.setAttribute("name", ((MimbOption)object22).getName());
            if (((MimbOption)object22).getParameter().getType() == Parameter.Type.PASSWORD) {
                element2.setAttribute("encoded", "true");
                XmlUtil.setElementValue(element2, Encryption.encrypt(((MimbOption)object22).getValue()));
                continue;
            }
            XmlUtil.setElementValue(element2, ((MimbOption)object22).getValue());
        }
        if (dataQualityOptions != null) {
            object = XmlUtil.appendNewElement(element, "DataQualityOptions");
            dataQualityOptions.serialize((Element)object);
        }
        object = this.bridgeEnvironment.getSetup().getTempDirectory();
        object22 = MIRBridgeLib.makeTempFile((File)object, "MJBC", ".xml");
        FileUtil.writeContent((File)object22, XmlUtil.getString(element), FileUtil.UTF8);
        return object22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec(String string, File file, MimbOptions mimbOptions, MIRValidationLevel.Enum enum_, String string2, MIRMetadataOrigin mIRMetadataOrigin, DataQualityOptions dataQualityOptions) throws MIRException {
        File file2 = this.createXmlRequestFile(string, file, mimbOptions, enum_, string2, mIRMetadataOrigin, dataQualityOptions);
        try {
            Object object;
            Object object2;
            File file3;
            MimbUtf8PrintStream mimbUtf8PrintStream = new MimbUtf8PrintStream(new MimbMessageLogOutputStream(this.logger));
            if (this.javaExe == null) {
                this.javaExe = this.bridgeEnvironment.getSetup().getJavaExecutable();
            }
            if (!(file3 = new File(this.javaExe)).exists()) {
                JBDG.WRN_FILE_NOT_FOUND.log(this.javaExe);
            }
            boolean bl = false;
            File file4 = new File(file3.getParentFile(), "../release");
            if (file4.exists()) {
                object2 = new PropertyFile(file4);
                object = ((PropertyFile)object2).getStringProperty("JAVA_VERSION");
                JBDG.DETECTED_JVM_VERSION.log(this.javaExe, object);
                object = ((String)object).replace("\"", "");
                bl = ((String)object).equals("11") || ((String)object).startsWith("11.");
            }
            object2 = System.getenv();
            object = new ArrayList<String>();
            object.add(this.javaExe);
            object.addAll(this.buildCommandLine(file2, mimbOptions, (Map<String, String>)object2, bl));
            File file5 = MIRBridgeLib.makeTempFile(this.bridgeEnvironment.getSetup().getTempDirectory(), "shutdown", ".pid");
            object.add("-s");
            object.add(file5.getPath());
            JBDG.JB_STARTING_JVM_PROCESS.log(this.logger, new Object[0]);
            String[] stringArray = new String[object.size()];
            object.toArray(stringArray);
            File file6 = this.bridgeEnvironment.getSetup().getBinDirectory();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (bl) {
                hashMap.put("JDK_JAVA_OPTIONS", null);
            }
            hashMap.put("MIR_LOG_LEVEL", Integer.toString(this.logger.getLevel()));
            hashMap.put("MITI_OEM_CALLER_ID", this.bridgeEnvironment.getOemToken());
            hashMap.put("MIR_I18N_LANG", MitiLocale.getLang());
            if (this.getDebugCpp((Map<String, String>)object2)) {
                this.setDebugCpp(hashMap);
            }
            if (this.getDebugCppDir((Map<String, String>)object2)) {
                this.setDebugCppDir(hashMap);
            }
            if (this.getDebugJava((Map<String, String>)object2)) {
                this.setDebugJava(hashMap);
            }
            if (this.userEnvironment != null) {
                hashMap.putAll(this.userEnvironment);
            }
            int n = 0;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder().setArguments(stringArray).setEnvironmentVariables(hashMap).setBaseDirector(file6).setOutputStream(mimbUtf8PrintStream).redirectErrToOut(true).setCharset(FileUtil.UTF8).setShutdownFile(file5);
                n = processBuilder.exec();
            }
            catch (IOException iOException) {
                JBDG.JB_PLATFORM_ERROR.log(this.logger, iOException, "", iOException.getMessage());
                throw new MIRException(JBDG.JB_UNABLE_TO_START_JVM.getMessage(new Object[0]), iOException);
            }
            if (n == 143) {
                MBCM.ERR_MIMB_SIGTERM.log(this.logger, new Object[0]);
            } else if (n == 137) {
                MBCM.ERR_MIMB_OOM.log(this.logger, new Object[0]);
            } else if (n < -6 || n > 12) {
                MBCM.ERR_MIMB_EXE.log(this.logger, n);
            }
            if (n != 0) {
                throw new MIRException(JBDG.JB_IMPORT_BRIDGE_FAILED.getMessage(new Object[0]));
            }
        }
        finally {
            file2.delete();
        }
    }

    private File checkValidScript(File file, String string) {
        if (!FileUtil.isSubPath(file, string)) {
            MBCM.UNSUPPORTED_SCRIPT_PATH.log(this.logger, new Object[0]);
            return null;
        }
        File file2 = new File(file, string);
        if (!file2.exists()) {
            MBCM.SCRIPT_NOT_FOUND.log(this.logger, file2.getPath());
            return null;
        }
        if (string.toLowerCase().endsWith(".bat") || string.endsWith(".sh")) {
            return file2;
        }
        MBCM.UNSUPPORTED_SCRIPT_EXTENSION.log(this.logger, string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execScript(String string) throws MIRException {
        if (string != null && !string.isEmpty()) {
            boolean bl;
            block15: {
                String string2;
                int n;
                File file = this.bridgeEnvironment.getSetup().getScriptDir();
                bl = true;
                File file2 = null;
                ProcessBuilder processBuilder = new ProcessBuilder();
                List<String> list = Exec.splitCommandLine(string);
                for (n = 0; n < list.size(); ++n) {
                    string2 = list.get(n);
                    if (n == 0) {
                        file2 = this.checkValidScript(file, string2);
                        if (file2 == null) {
                            bl = false;
                            break;
                        }
                        processBuilder.addArgument(file2.getPath());
                        continue;
                    }
                    processBuilder.addArgument(string2);
                }
                if (bl) {
                    MBCM.STARTING_SCRIPT.log(this.logger, file2.getPath());
                    try {
                        String[] stringArray;
                        n = processBuilder.exec();
                        string2 = processBuilder.getStdOut();
                        if (string2 != null) {
                            stringArray = string2.split("(\\\r)?\\\n");
                            int n2 = stringArray.length;
                            for (int i = 0; i < n2; ++i) {
                                String string3 = stringArray[i];
                                MBCM.SCRIPT_MESSAGE.log(this.logger, string3);
                            }
                        }
                        if ((stringArray = processBuilder.getStdErr()) != null && !stringArray.isEmpty()) {
                            for (String string4 : stringArray.split("(\\\r)?\\\n")) {
                                MBCM.SCRIPT_ERROR.log(this.logger, string4);
                            }
                        }
                        if (n == 0) {
                            bl = true;
                            break block15;
                        }
                        MBCM.SCRIPT_EXIT_CODE.log(this.logger, string, Integer.toString(n));
                        bl = false;
                    }
                    catch (IOException iOException) {
                        MBCM.SCRIPT_ERROR.log(this.logger, iOException, iOException.getMessage());
                        bl = false;
                    }
                }
            }
            if (!bl) {
                throw new MIRException(MBCM.SCRIPT_FAILED.getMessage(new Object[0]));
            }
        }
    }

    private MIRMetadataOrigin generateMetadataOrigin(BridgeSpecification bridgeSpecification) {
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRMetadataOrigin.setVendorName(bridgeSpecification.getProductCompany());
        mIRMetadataOrigin.setToolName(bridgeSpecification.getProductName());
        mIRMetadataOrigin.setToolVersion(bridgeSpecification.getProductVersion());
        mIRMetadataOrigin.setFormatVersion(bridgeSpecification.getProductVersion());
        mIRMetadataOrigin.setBridgeName(bridgeSpecification.getBridgeId());
        mIRMetadataOrigin.setBridgeVersion(bridgeSpecification.getBridgeVersion());
        return mIRMetadataOrigin;
    }
}

