/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.bridges.javabridgeinterface.DataQualityObjectId;
import MITI.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class DataQualityOptions {
    private File outputDirectory;
    private boolean isDataSamplingEnabled;
    private long samplingRowLimit;
    private boolean isDataProfilingEnabled;
    private long profilingRowLimit;
    private boolean isOperationalMetadataEnabled;
    private List<DataQualityObjectId> objectIds = new ArrayList<DataQualityObjectId>();

    public void parse(Element element) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Element element2 = XmlUtil.getFirstElement(element, "OutputDirectory");
        if (element2 != null) {
            object4 = XmlUtil.getElementValue(element2);
            this.outputDirectory = new File((String)object4);
        }
        if ((object4 = XmlUtil.getFirstElement(element, "DataSampling")) != null) {
            object3 = object4.getAttribute("enabled");
            if (((String)object3).equals("true")) {
                this.isDataSamplingEnabled = true;
            }
            if (!((String)(object2 = object4.getAttribute("rowLimit"))).isEmpty()) {
                try {
                    this.samplingRowLimit = Long.parseLong((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((object3 = XmlUtil.getFirstElement(element, "DataProfiling")) != null) {
            object2 = object3.getAttribute("enabled");
            if (((String)object2).equals("true")) {
                this.isDataProfilingEnabled = true;
            }
            if (!((String)(object = object3.getAttribute("rowLimit"))).isEmpty()) {
                try {
                    this.profilingRowLimit = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((object2 = XmlUtil.getFirstElement(element, "OperationalMetadata")) != null && ((String)(object = object2.getAttribute("enabled"))).equals("true")) {
            this.isOperationalMetadataEnabled = true;
        }
        object = XmlUtil.getChildElements(element, "Object");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            DataQualityObjectId dataQualityObjectId = new DataQualityObjectId();
            dataQualityObjectId.parse(element3);
            this.objectIds.add(dataQualityObjectId);
        }
    }

    public void serialize(Element element) {
        Element element2 = XmlUtil.appendNewElement(element, "OutputDirectory");
        if (this.outputDirectory != null) {
            XmlUtil.setElementValue(element2, this.outputDirectory.toString());
        }
        Element element3 = XmlUtil.appendNewElement(element, "DataSampling");
        element3.setAttribute("enabled", this.isDataSamplingEnabled ? "true" : "false");
        element3.setAttribute("rowLimit", Long.toString(this.samplingRowLimit));
        Element element4 = XmlUtil.appendNewElement(element, "DataProfiling");
        element4.setAttribute("enabled", this.isDataProfilingEnabled ? "true" : "false");
        element4.setAttribute("rowLimit", Long.toString(this.profilingRowLimit));
        Element element5 = XmlUtil.appendNewElement(element, "OperationalMetadata");
        element5.setAttribute("enabled", this.isOperationalMetadataEnabled ? "true" : "false");
        for (DataQualityObjectId dataQualityObjectId : this.objectIds) {
            Element element6 = XmlUtil.appendNewElement(element, "Object");
            dataQualityObjectId.serialize(element6);
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    public boolean isDataProfilingEnabled() {
        return this.isDataProfilingEnabled;
    }

    public void setDataProfilingEnabled(boolean bl) {
        this.isDataProfilingEnabled = bl;
    }

    public long getProfilingRowLimit() {
        return this.profilingRowLimit;
    }

    public void setProfilingRowLimit(long l) {
        this.profilingRowLimit = l;
    }

    public boolean isDataSamplingEnabled() {
        return this.isDataSamplingEnabled;
    }

    public void setDataSamplingEnabled(boolean bl) {
        this.isDataSamplingEnabled = bl;
    }

    public long getSamplingRowLimit() {
        return this.samplingRowLimit;
    }

    public void setSamplingRowLimit(long l) {
        this.samplingRowLimit = l;
    }

    public boolean isOperationalMetadataEnabled() {
        return this.isOperationalMetadataEnabled;
    }

    public void setOperationalMetadataEnabled(boolean bl) {
        this.isOperationalMetadataEnabled = bl;
    }

    public List<DataQualityObjectId> getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(List<DataQualityObjectId> list) {
        this.objectIds = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Operational metadata enabled: ").append(this.isOperationalMetadataEnabled).append('\n');
        stringBuilder.append("Data Sampling enabled: ").append(this.isDataSamplingEnabled).append('\n');
        if (this.isDataSamplingEnabled) {
            stringBuilder.append("Data Sampling rows: ").append(this.samplingRowLimit).append('\n');
        }
        stringBuilder.append("Data Profiling enabled: ").append(this.isDataProfilingEnabled).append('\n');
        if (this.isDataProfilingEnabled) {
            stringBuilder.append("Data Profiling rows: ").append(this.profilingRowLimit).append('\n');
        }
        stringBuilder.append("Data Profiling Objects (" + this.objectIds.size() + "): ").append('\n');
        for (DataQualityObjectId dataQualityObjectId : this.objectIds) {
            stringBuilder.append("     ").append(dataQualityObjectId.toString()).append('\n');
        }
        return stringBuilder.toString();
    }
}

