/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.MimbOption;
import MITI.bridges.javabridgeinterface.MimbOptions;
import MITI.bridges.maven.ArtifactId;
import MITI.bridges.maven.MavenLibrary;
import MITI.bridges.maven.MavenRepository;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.util.Exec;
import MITI.util.MiscParams;
import MITI.util.StringUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassPath {
    private MIRSetup setup;
    private MIRLogger log;
    private MimbOptions options;
    private boolean complete;
    private boolean skipDownload;
    private HashMap<MavenRepository, MavenLibrary> repos;
    private LinkedHashMap<String, File> classpath;

    public ClassPath(BridgeEnvironment bridgeEnvironment, MIRLogger mIRLogger, MimbOptions mimbOptions) {
        this(bridgeEnvironment.getSetup(), mIRLogger, mimbOptions);
    }

    public ClassPath(MIRSetup mIRSetup, MIRLogger mIRLogger) {
        this(mIRSetup, mIRLogger, null);
    }

    private ClassPath(MIRSetup mIRSetup, MIRLogger mIRLogger, MimbOptions mimbOptions) {
        this.setup = mIRSetup;
        this.log = mIRLogger;
        this.options = mimbOptions;
        this.complete = true;
        this.repos = new HashMap();
        this.classpath = new LinkedHashMap();
    }

    private MavenLibrary getMavenLibrary(MavenRepository mavenRepository) {
        MavenLibrary mavenLibrary = this.repos.get((Object)mavenRepository);
        if (mavenLibrary == null) {
            MimbOption mimbOption;
            Proxy proxy = null;
            if (this.options != null && (mimbOption = this.options.getOption("Miscellaneous")) != null) {
                MiscParams miscParams = MiscParams.parse(mimbOption.getValue());
                proxy = this.getProxySettings(miscParams.getValue("-java.parameters"));
                boolean bl = this.skipDownload = miscParams.contains("-skip.download") || miscParams.contains("-cache.reuse");
            }
            if (proxy == null) {
                proxy = this.getProxySettings(this.setup.getJavaOptions());
            }
            mavenLibrary = MavenLibrary.get(mavenRepository, this.setup, proxy);
            this.repos.put(mavenRepository, mavenLibrary);
        }
        return mavenLibrary;
    }

    private Proxy getProxySettings(String string) {
        Map<String, String> map;
        String string2;
        if (string != null && !string.isEmpty() && (string2 = (map = Exec.getEnvVars(string)).get("-Dhttp.proxyHost")) != null && !string2.isEmpty()) {
            int n = 80;
            try {
                n = Integer.parseInt(map.get("-Dhttp.proxyPort"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            final String string3 = map.get("-Dhttp.proxyUser");
            final String string4 = map.get("-Dhttp.proxyPassword");
            if (string3 != null && string4 != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (Authenticator.RequestorType.PROXY == this.getRequestorType() && string2.equalsIgnoreCase(this.getRequestingHost())) {
                            return new PasswordAuthentication(string3, string4.toCharArray());
                        }
                        return null;
                    }
                });
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string2, n));
        }
        return null;
    }

    private void addFile(boolean bl, File file) {
        if (file.isFile()) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.classpath.putIfAbsent(file.getName(), file) != null) {
                BLIB.DBG_DUPLICATE_JAR.log(this.log, file.getPath());
            }
        } else if (file.isDirectory()) {
            this.classpath.put(file.getAbsolutePath(), file);
        } else if (!bl) {
            BLIB.WRN_FILE_NOT_FOUND.log(this.log, file.getPath());
            this.complete = false;
        } else {
            BLIB.DBG_OPTIONAL_JAR_NOT_FOUND.log(this.log, file.getPath());
        }
    }

    public void addFiles(File ... fileArray) {
        this.addFiles(false, fileArray);
    }

    public void addOptionalFiles(File ... fileArray) {
        this.addFiles(true, fileArray);
    }

    private void addFiles(boolean bl, File ... fileArray) {
        for (File file : fileArray) {
            this.addFile(bl, file);
        }
    }

    public void addRelativePaths(File file, String ... stringArray) {
        this.addRelativePaths(false, file, stringArray);
    }

    public void addOptionalRelativePaths(File file, String ... stringArray) {
        this.addRelativePaths(true, file, stringArray);
    }

    private void addRelativePaths(boolean bl, File file, String ... stringArray) {
        if (file.isDirectory()) {
            for (String string : stringArray) {
                this.addFile(bl, new File(file, string));
            }
        } else if (!bl) {
            BLIB.WRN_FILE_NOT_FOUND.log(this.log, file.getPath());
            this.complete = false;
        } else {
            BLIB.DBG_OPTIONAL_JAR_NOT_FOUND.log(this.log, file.getPath());
        }
    }

    public void addArtifacts(ArtifactId ... artifactIdArray) {
        this.addArtifacts(false, MavenRepository.DEFAULT, artifactIdArray);
    }

    public void addArtifacts(MavenRepository mavenRepository, ArtifactId ... artifactIdArray) {
        this.addArtifacts(false, mavenRepository, artifactIdArray);
    }

    public void addOptionalArtifacts(ArtifactId ... artifactIdArray) {
        this.addArtifacts(true, MavenRepository.DEFAULT, artifactIdArray);
    }

    public void addOptionalArtifacts(MavenRepository mavenRepository, ArtifactId ... artifactIdArray) {
        this.addArtifacts(true, MavenRepository.DEFAULT, artifactIdArray);
    }

    public void addSingleArtifact(ArtifactId artifactId) {
        MavenLibrary mavenLibrary = this.getMavenLibrary(MavenRepository.DEFAULT);
        for (File file : this.skipDownload ? mavenLibrary.load(false, artifactId) : mavenLibrary.download(false, artifactId)) {
            this.addFile(false, file);
        }
    }

    private void addArtifacts(boolean bl, MavenRepository mavenRepository, ArtifactId ... artifactIdArray) {
        MavenLibrary mavenLibrary = this.getMavenLibrary(mavenRepository);
        for (File file : this.skipDownload ? mavenLibrary.load(true, artifactIdArray) : mavenLibrary.download(true, artifactIdArray)) {
            this.addFile(bl, file);
        }
    }

    public void addDirectory(File file) {
        int n = 0;
        if (file.isDirectory()) {
            BLIB.STS_LOADING_JARS.log(this.log, file.getPath());
            for (File file2 : file.listFiles()) {
                String string = file2.getName().toLowerCase();
                if (!string.endsWith(".zip") && !string.endsWith(".jar")) continue;
                this.addFile(true, file2);
                ++n;
            }
        }
        this.complete &= n > 0;
    }

    protected void appendClassPath(ClassPath classPath) {
        this.classpath.putAll(classPath.classpath);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String build() {
        return StringUtil.join(this.classpath.values(), File.pathSeparator);
    }
}

