/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridgeinterface;

import MITI.MIRException;
import MITI.bridges.javabridgeinterface.BridgeInterface;
import MITI.messages.MIRModelBridge.BLIB;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class BridgeLoader {
    private static final String SERVICE = "META-INF/mimb/BridgeInterface";
    private HashMap<String, BridgeInfo> bridgeInfos = new HashMap();

    public BridgeLoader(File file) {
        for (File file2 : file.listFiles()) {
            if (!file2.getName().endsWith(".jar")) continue;
            try (JarFile jarFile = new JarFile(file2);){
                JarEntry jarEntry = jarFile.getJarEntry(SERVICE);
                if (jarEntry == null) continue;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));){
                    String string = null;
                    do {
                        if ((string = bufferedReader.readLine()) == null || string.isEmpty()) continue;
                        String[] stringArray = string.split(":");
                        if (stringArray.length > 1) {
                            BridgeInfo bridgeInfo = new BridgeInfo();
                            bridgeInfo.bridgeId = stringArray[0];
                            bridgeInfo.bridgeInterface = stringArray[1];
                            if (stringArray.length > 2) {
                                BridgeInfo.access$302(bridgeInfo, stringArray[2].split("[;,]"));
                            }
                            bridgeInfo.jarFile = file2;
                            this.bridgeInfos.put(bridgeInfo.bridgeId, bridgeInfo);
                            continue;
                        }
                        BLIB.DBG_DEBUG.log("Incorrect manifest for " + file2.getPath());
                    } while (string != null);
                }
                catch (IOException iOException) {
                    BLIB.DBG_DEBUG.log(iOException, "Error parsing manifest of " + file2.getPath());
                }
            }
            catch (IOException iOException) {
                BLIB.DBG_DEBUG.log(iOException, "Error opening jar file " + file2.getPath());
            }
        }
    }

    private BridgeInfo getBridge(String string, boolean bl) {
        String string2 = BridgeLoader.getBridgeId(string) + (bl ? "Export" : "Import");
        return this.bridgeInfos.get(string2);
    }

    public static String getBridgeId(String string) {
        String string2 = new String(string);
        int n = string2.indexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.endsWith("Export") || string2.endsWith("Import")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        return string2;
    }

    public BridgeInterface loadBridge(String string, boolean bl) throws MIRException {
        return this.loadBridge(string, bl, BridgeLoader.class.getClassLoader());
    }

    public BridgeInterface loadBridge(String string, boolean bl, ClassLoader classLoader) {
        BridgeInfo bridgeInfo = this.getBridge(string, bl);
        if (bridgeInfo != null) {
            try {
                Class<BridgeInterface> clazz;
                Object object;
                ArrayList<URL> arrayList = new ArrayList<URL>();
                arrayList.add(bridgeInfo.jarFile.toURI().toURL());
                if (bridgeInfo.dependencies != null) {
                    object = bridgeInfo.dependencies;
                    int n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = object[i];
                        arrayList.add(new File(bridgeInfo.jarFile.getParent(), string2).toURI().toURL());
                    }
                }
                if ((clazz = ((ClassLoader)(object = new CustomClassLoader(arrayList.toArray(new URL[arrayList.size()]), classLoader))).loadClass(bridgeInfo.bridgeInterface).asSubclass(BridgeInterface.class)) != null) {
                    return clazz.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | MalformedURLException exception) {
                BLIB.DBG_DEBUG.log(exception, "Error loading bridge " + string);
            }
        }
        return null;
    }

    public void unloadBridge(BridgeInterface bridgeInterface) {
        ClassLoader classLoader;
        if (bridgeInterface != null && (classLoader = bridgeInterface.getClass().getClassLoader()) instanceof CustomClassLoader) {
            try {
                ((CustomClassLoader)classLoader).close();
                System.gc();
            }
            catch (IOException iOException) {
                BLIB.DBG_DEBUG.log(iOException, "Error unloading bridge " + bridgeInterface.getClass().getName());
            }
        }
    }

    private class CustomClassLoader
    extends URLClassLoader {
        public CustomClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }
    }

    private static class BridgeInfo {
        private String bridgeId;
        private String bridgeInterface;
        private String[] dependencies;
        private File jarFile;

        private BridgeInfo() {
        }

        static /* synthetic */ String[] access$302(BridgeInfo bridgeInfo, String[] stringArray) {
            bridgeInfo.dependencies = stringArray;
            return stringArray;
        }
    }
}

