/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.javabridge;

import MITI.MIRException;
import MITI.bridges.cache.MIMBCache;
import MITI.bridges.javabridge.BridgeOptions;
import MITI.bridges.javabridge.Browse;
import MITI.bridges.javabridge.DataProfiler;
import MITI.bridges.javabridge.DualModelImport;
import MITI.bridges.javabridge.ModelExport;
import MITI.bridges.javabridge.ModelImport;
import MITI.bridges.javabridge.ModelStatistics;
import MITI.bridges.javabridge.ModelTest;
import MITI.bridges.javabridge.MultiModelExport;
import MITI.bridges.javabridge.MultiModelImport;
import MITI.bridges.javabridgeinterface.DataQualityOptions;
import MITI.bridges.mimb.MIRModelBridgeInterface;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelBridge.MBCM;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.statistics.ProfileStatistics;
import MITI.util.Encryption;
import MITI.util.MachineInfo;
import MITI.util.MiscParams;
import MITI.util.Shutdown;
import MITI.util.VersionInfo;
import MITI.util.VersionNumber;
import MITI.util.XmlUtil;
import MITI.util.cmd.CommandLineOption;
import MITI.util.cmd.CommandLineParser;
import MITI.util.cmd.HelpOption;
import MITI.util.cmd.HiddenOption;
import MITI.util.cmd.Option;
import MITI.util.cmd.RepeatableOption;
import MITI.util.cmd.TypedOption;
import MITI.util.config.MimbConfiguration;
import MITI.util.file.FileUtil;
import MITI.util.log.LogEventHandler;
import MITI.util.log.MIRLogger;
import MITI.util.log.XmlLogEventHandler;
import MITI.util.text.BridgeOptionLiteral;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class JavaBridge {
    private static HelpOption helpOption = new HelpOption();
    private static Option mimbXmlOption = new Option(new String[]{"-r", "--runXml"}, MBCM.PARAM_DESCR_R.getText(), TypedOption.Type.FILE);
    private static Option mirXmlOption = new Option(new String[]{"-f", "--mirFile"}, MBCM.PARAM_DESCR_F.getText());
    private static Option bridgeClassOption = new Option(new String[]{"-c", "--bridgeClass"}, MBCM.PARAM_DESCR_C.getText());
    private static Option bridgeCommandOption = new Option(new String[]{"-x", "--executeCommand"}, MBCM.PARAM_DESCR_X.getText());
    private static Option bridgeBrowsingParameterIdOption = new Option(new String[]{"-b", "--browseParameter"}, MBCM.PARAM_DESCR_B.getText());
    private static RepeatableOption bridgeParameterOption = new RepeatableOption(new String[]{"-o", "--bridgeOption"}, MBCM.PARAM_DESCR_O.getText());
    private static Option validationLevelOption = new Option(new String[]{"-v", "--validation"}, MBCM.PARAM_DESCR_V.getText());
    private static Option resetCacheOption = new Option(new String[]{"-rc", "--resetCache"}, MBCM.PARAM_DESCR_RC.getText(), TypedOption.Type.INT);
    private static HiddenOption shutdownOption = new HiddenOption(new String[]{"-s", "--shutdown"});
    private static MIRMetadataOrigin cppOrigin = new MIRMetadataOrigin();
    private static CommandLineOption[] options = new CommandLineOption[]{helpOption, mimbXmlOption, mirXmlOption, bridgeClassOption, bridgeCommandOption, bridgeBrowsingParameterIdOption, bridgeParameterOption, validationLevelOption, resetCacheOption, shutdownOption};

    private boolean runTest(BridgeOptions bridgeOptions) throws MIRException {
        if (this instanceof ModelTest) {
            return ((ModelTest)((Object)this)).test(bridgeOptions);
        }
        return true;
    }

    private boolean isMultiModelImport(BridgeOptions bridgeOptions) throws MIRException {
        if (this instanceof DualModelImport) {
            return ((DualModelImport)((Object)this)).isMultiModel(bridgeOptions);
        }
        return this instanceof MultiModelImport;
    }

    private void runImport(String string, BridgeOptions bridgeOptions) throws MIRException {
        File file = new File(string);
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        MIRModel mIRModel = null;
        if (this.isMultiModelImport(bridgeOptions)) {
            mIRModel = ((MultiModelImport)((Object)this)).run(bridgeOptions, mIRMixManager);
        } else if (this instanceof ModelImport) {
            mIRModel = ((ModelImport)((Object)this)).run(bridgeOptions);
        } else {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "import"));
        }
        if (mIRModel == null) {
            throw new MIRException(MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.getMessage("Input model is null"));
        }
        String string2 = this.getMiscellaneousOption(bridgeOptions, "-model.name");
        if (string2 != null) {
            if (string2.startsWith("\"") && string2.endsWith("\"") && string2.length() > 2) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            mIRModel.setName(string2);
        }
        mIRMixManager.writeFile(file, mIRModel);
        MIRMixCache mIRMixCache = new MIRMixCache(mIRMixManager);
        ProfileStatistics profileStatistics = new ProfileStatistics(mIRModel, mIRMixCache);
        profileStatistics.compute();
        if (this instanceof ModelStatistics) {
            ((ModelStatistics)((Object)this)).printStatistics(profileStatistics);
        } else {
            profileStatistics.print(MIRLogger.getLogger());
        }
    }

    private void runExport(String string, BridgeOptions bridgeOptions) throws MIRException {
        File file = new File(string);
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        MIRModel mIRModel = mIRMixManager.readFile(file);
        if (mIRModel == null) {
            throw new MIRException(MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.getMessage("Input model is null"));
        }
        if (mIRModel instanceof MIRStoreModel && this instanceof ModelExport) {
            ((ModelExport)((Object)this)).run((MIRStoreModel)mIRModel, bridgeOptions, mIRMixManager);
        } else if (mIRModel instanceof MIRDirectoryStructureModel && this instanceof MultiModelExport) {
            ((MultiModelExport)((Object)this)).run((MIRDirectoryStructureModel)mIRModel, bridgeOptions, mIRMixManager);
        } else {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "export"));
        }
    }

    private void runBrowse(String string, BridgeOptions bridgeOptions, String string2) throws MIRException {
        if (!(this instanceof Browse)) {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "browse"));
        }
        File file = new File(string);
        MIRMixManager mIRMixManager = new MIRMixManager(file, 2);
        MIRDirectoryStructureModel mIRDirectoryStructureModel = ((Browse)((Object)this)).browse(string2, bridgeOptions);
        if (mIRDirectoryStructureModel == null) {
            throw new MIRException(MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.getMessage("Input model is null"));
        }
        mIRMixManager.writeFile(file, mIRDirectoryStructureModel);
    }

    private void runDataQuality(BridgeOptions bridgeOptions, DataQualityOptions dataQualityOptions) throws MIRException {
        if (!(this instanceof DataProfiler)) {
            throw new MIRException(MBCM.UNSUPPORTED_BRIDGE_OPERATION.getMessage(this.getClass().getSimpleName(), "dataprofiling"));
        }
        ((DataProfiler)((Object)this)).profile(bridgeOptions, dataQualityOptions);
    }

    public static MIRMetadataOrigin generateMetadataOrigin(Class<? extends JavaBridge> clazz) {
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRMetadataOrigin.setFrom(cppOrigin);
        VersionInfo versionInfo = VersionInfo.loadMitiJar(clazz);
        if (versionInfo != null) {
            mIRMetadataOrigin.setBridgeName(cppOrigin.getBridgeName() + "; JAR " + versionInfo.getComponent());
            mIRMetadataOrigin.setBridgeVersion(cppOrigin.getBridgeVersion() + "; JAR " + versionInfo.getVersionString() + " build " + versionInfo.getDate());
        }
        return mIRMetadataOrigin;
    }

    public MIRMetadataOrigin generateMetadataOrigin() {
        return JavaBridge.generateMetadataOrigin(this.getClass());
    }

    private static void printUsage() {
        System.out.println(MBCM.TITLE1.getText());
        System.out.println(MBCM.TITLE2.getText());
        CommandLineParser.printUsage(options, System.out);
    }

    private static void printJavaInfo(VersionNumber versionNumber) {
        MBCM.MSG_STARTING_JVM.log(MachineInfo.getJavaVersion(), MachineInfo.getJavaHome(), MachineInfo.getJavaMemory(), MachineInfo.getJavaOptions());
        VersionNumber versionNumber2 = VersionNumber.parse(System.getProperty("java.version"));
        if (versionNumber2.compareTo(versionNumber) < 0) {
            MBCM.MINIMUM_JAVA_VERSION_ERROR.log(versionNumber2.toString(), versionNumber.toString());
            System.exit(1);
        }
    }

    public static void printVersionInfos(MIRLogger mIRLogger) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        File file = new File(MimbConfiguration.getMimbHome(), "java");
        for (String string : System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            if (!string.endsWith(".jar") || !FileUtil.isSubPath(file, string)) continue;
            try (JarFile jarFile = new JarFile(string);){
                String string2;
                VersionInfo versionInfo = VersionInfo.loadManifest(jarFile.getManifest());
                if (versionInfo == null || versionInfo.getComponent() == null) continue;
                String string3 = versionInfo.getComponent() + ".jar";
                String string4 = "";
                if (versionInfo.getVersionString() != null) {
                    string4 = string4 + versionInfo.getVersionString();
                    if (versionInfo.getDate() != null) {
                        string4 = string4 + " - " + versionInfo.getDate().substring(0, versionInfo.getDate().length() - 9);
                    }
                }
                string2 = (string2 = (String)treeMap.get(string4)) == null ? string3 : string2 + ", " + string3;
                treeMap.put(string4, string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String string : treeMap.keySet()) {
            String string5 = (String)treeMap.get(string);
            if (string.isEmpty()) {
                BLIB.MITI_COMPONENT_EMPTY_BUILD_VERSION.log(mIRLogger, string5);
                continue;
            }
            BLIB.MITI_COMPONENT_BUILD_VERSION.log(mIRLogger, string, string5);
        }
    }

    protected String getMiscellaneousOption(BridgeOptions bridgeOptions, String string) {
        BridgeOptionLiteral bridgeOptionLiteral = new BridgeOptionLiteral("Miscellaneous", BridgeOptionLiteral.BridgeOptionType.STRING, null, null, null);
        if (bridgeOptions.hasOption(bridgeOptionLiteral)) {
            String string2 = bridgeOptions.getValue(bridgeOptionLiteral);
            MiscParams miscParams = MiscParams.parse(string2);
            String string3 = miscParams.getValue(string);
            return string3;
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        MIRLogger.init(new LogEventHandler[]{new XmlLogEventHandler(System.err)});
        var1_1 = null;
        var2_2 = "Import";
        var3_3 = null;
        var4_4 = new HashMap<Object, String>();
        var5_5 = null;
        var6_6 = VersionNumber.parse("1.5");
        var7_7 = null;
        var8_8 = System.getenv();
        var9_9 = var8_8.get("MITI_DEBUG_MIMB");
        if ("ON".equals(var9_9)) {
            MIRModelBridgeInterface.setUseCppDebugStop(true);
        }
        if ("ON".equals(var10_10 = var8_8.get("MITI_DEBUG_MIMB_DIR"))) {
            MIRModelBridgeInterface.setUseCppDebugDirectory(true);
        }
        try {
            CommandLineParser.process(var0, 0, JavaBridge.options);
        }
        catch (IllegalArgumentException var11_11) {
            System.err.println(var11_11.getMessage());
            JavaBridge.printJavaInfo(var6_6);
            JavaBridge.printUsage();
            System.exit(1);
        }
        if (JavaBridge.helpOption.isSet()) {
            JavaBridge.printUsage();
            System.exit(0);
        }
        if (JavaBridge.shutdownOption.isSet()) {
            Shutdown.listen(JavaBridge.shutdownOption.getFileValue());
        }
        if (JavaBridge.mimbXmlOption.isSet()) {
            try {
                var11_12 = DocumentBuilderFactory.newInstance();
                var12_17 = var11_12.newDocumentBuilder();
                var13_20 = var12_17.parse(JavaBridge.mimbXmlOption.getFileValue());
                var14_22 = var13_20.getDocumentElement();
                var2_2 = var14_22.getNodeName();
                var1_1 = var14_22.getAttribute("bridge").replace("/", ".");
                var5_5 = new File(var14_22.getAttribute("file"));
                var15_23 = var14_22.getAttribute("validationLevel");
                if (var15_23 != null && var15_23.length() > 0) {
                    var16_24 = MIRValidationLevel.getByName((String)var15_23);
                    MIRValidationLevel.setDefaultLevel((MIRValidationLevel.Enum)var16_24);
                }
                var3_3 = var14_22.getAttribute("browseParameter");
                if (var14_22.hasAttribute("javaVersion")) {
                    var6_6 = VersionNumber.parse(var14_22.getAttribute("javaVersion"));
                }
                if ((var16_24 = var14_22.getAttribute("resetCache")) != null && var16_24.length() > 0) {
                    var17_25 = Integer.parseInt((String)var16_24);
                    if ((var17_25 & 1) == 1) {
                        MIMBCache.setResetXmiCache(true);
                    }
                    if ((var17_25 & 2) == 2) {
                        MIMBCache.setResetNativeCache(true);
                    }
                }
                JavaBridge.cppOrigin.setVendorName(var14_22.getAttribute("vendorName"));
                JavaBridge.cppOrigin.setToolName(var14_22.getAttribute("toolName"));
                JavaBridge.cppOrigin.setToolVersion(var14_22.getAttribute("toolVersion"));
                JavaBridge.cppOrigin.setFormatVersion(var14_22.getAttribute("formatVersion"));
                JavaBridge.cppOrigin.setBridgeName(var14_22.getAttribute("bridgeName"));
                JavaBridge.cppOrigin.setBridgeVersion(var14_22.getAttribute("bridgeVersion"));
                var17_26 = var14_22.getElementsByTagName("BridgeParameter");
                for (var18_27 = 0; var18_27 < var17_26.getLength(); ++var18_27) {
                    block46: {
                        var19_29 = (Element)var17_26.item(var18_27);
                        var20_30 = var19_29.getAttribute("name");
                        var21_31 = null;
                        try {
                            var21_31 = var19_29.getTextContent();
                        }
                        catch (AbstractMethodError var22_32) {
                            var23_33 = var19_29.getFirstChild();
                            if (var23_33 == null) break block46;
                            var21_31 = var23_33.getNodeValue();
                        }
                    }
                    if ("true".equals(var19_29.getAttribute("encoded"))) {
                        var21_31 = Encryption.decrypt(var21_31);
                    }
                    var4_4.put(var20_30, var21_31);
                }
                var18_28 = XmlUtil.getFirstElement(var14_22, "DataQualityOptions");
                if (var18_28 == null) ** GOTO lbl105
                var7_7 = new DataQualityOptions();
                var7_7.parse(var18_28);
            }
            catch (IOException | ParserConfigurationException | SAXException var11_13) {
                throw new IllegalArgumentException(var11_13);
            }
        } else {
            var1_1 = JavaBridge.bridgeClassOption.getStringValue();
            var2_2 = JavaBridge.bridgeCommandOption.getStringValue();
            var3_3 = JavaBridge.bridgeBrowsingParameterIdOption.getStringValue();
            if (JavaBridge.mirXmlOption.isSet()) {
                var5_5 = JavaBridge.mirXmlOption.getFileValue();
            }
            for (Object var12_17 : JavaBridge.bridgeParameterOption.getValues()) {
                var13_21 = var12_17.indexOf("=");
                if (var13_21 < 1) {
                    throw new IllegalArgumentException(MBCM.INVALID_PARAM_FORMAT.getMessage(new Object[]{var12_17}));
                }
                var14_22 = var12_17.substring(0, var13_21).trim();
                var15_23 = var12_17.substring(var13_21 + 1).trim();
                var4_4.put(var14_22, (String)var15_23);
            }
            if (JavaBridge.validationLevelOption.isSet()) {
                var11_14 /* !! */  = MIRValidationLevel.getByName(JavaBridge.validationLevelOption.getStringValue());
                MIRValidationLevel.setDefaultLevel(var11_14 /* !! */ );
            }
            if (JavaBridge.resetCacheOption.isSet()) {
                var11_15 = JavaBridge.resetCacheOption.getIntValue();
                if ((var11_15 & 1) == 1) {
                    MIMBCache.setResetXmiCache(true);
                }
                if ((var11_15 & 2) == 2) {
                    MIMBCache.setResetNativeCache(true);
                }
            }
        }
lbl105:
        // 7 sources

        if (var1_1 == null) {
            MBCM.ERR_MISSING_REQUIRED_PARAMETER.log(new Object[]{"bridgeClass"});
            System.exit(-1);
            return;
        }
        if (var2_2 == null) {
            MBCM.ERR_MISSING_REQUIRED_PARAMETER.log(new Object[]{"command"});
            System.exit(-1);
            return;
        }
        JavaBridge.printJavaInfo(var6_6);
        var11_16 = null;
        try {
            MBCM.DBG_LOADING_JAVA_BRIDGE_CLASS.log(new Object[]{var1_1});
            var11_16 = Class.forName(var1_1);
            try {
                JavaBridge.printVersionInfos(MIRLogger.getLogger());
                var12_17 = (JavaBridge)var11_16.newInstance();
                var13_20 = new BridgeOptions();
                for (Object var15_23 : var4_4.entrySet()) {
                    var13_20.addOption((String)var15_23.getKey(), (String)var15_23.getValue());
                }
                if (var2_2.equalsIgnoreCase("Import")) {
                    if (var5_5 == null) {
                        MBCM.ERR_MISSING_REQUIRED_PARAMETER.log(new Object[]{"file"});
                        System.exit(-1);
                        return;
                    }
                    super.runImport(var5_5.getAbsolutePath(), (BridgeOptions)var13_20);
                } else if (var2_2.equalsIgnoreCase("Export")) {
                    if (var5_5 == null) {
                        MBCM.ERR_MISSING_REQUIRED_PARAMETER.log(new Object[]{"file"});
                        System.exit(-1);
                        return;
                    }
                    super.runExport(var5_5.getAbsolutePath(), (BridgeOptions)var13_20);
                } else if (var2_2.equalsIgnoreCase("Test")) {
                    if (!super.runTest((BridgeOptions)var13_20)) {
                        System.exit(1);
                        return;
                    }
                } else if (var2_2.equalsIgnoreCase("Browse")) {
                    if (var5_5 == null) {
                        MBCM.ERR_MISSING_REQUIRED_PARAMETER.log(new Object[]{"file"});
                        System.exit(-1);
                        return;
                    }
                    super.runBrowse(var5_5.getAbsolutePath(), (BridgeOptions)var13_20, var3_3);
                } else if (var2_2.equalsIgnoreCase("DataQuality")) {
                    super.runDataQuality((BridgeOptions)var13_20, var7_7);
                }
            }
            catch (Error | Exception var12_18) {
                MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(var12_18, new Object[]{var12_18.toString()});
                System.exit(1);
            }
        }
        catch (ClassNotFoundException | LinkageError var12_19) {
            MBCM.COULD_NOT_LOAD_JAVA_CLASS.log(new Object[]{var1_1});
            MBCM.MIR_EXCEPTION_IN_JAVA_BRIDGE.log(var12_19, new Object[]{var12_19.toString()});
            System.exit(1);
        }
        System.exit(0);
    }
}

