/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.glossary;

import MITI.MIRException;
import MITI.bridges.glossary.IGlossaryConverter;
import MITI.bridges.profiles.ProfileIds;
import MITI.sdk.MIRCategory;
import MITI.sdk.MIRConceptualDomain;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRGlossaryModel;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRTerm;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.util.VersionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SapEccGlossaryConverter
implements IGlossaryConverter {
    private MIRModel model = null;
    private MIRGlossaryModel glossary = null;
    private HashMap<MIRElement, MIRElement> object2GlossaryMap = new HashMap();
    private ArrayList<MIRDesignPackage> designPackages = new ArrayList();
    private HashSet<MIRDerivedType> dataElements = new HashSet();
    private HashSet<MIRDerivedType> domains = new HashSet();

    @Override
    public MIRGlossaryModel convert(MIRModel mIRModel) throws MIRException {
        this.model = mIRModel;
        if (this.model.isInstanceOf((short)266)) {
            return (MIRGlossaryModel)this.model;
        }
        ObjectCollector objectCollector = new ObjectCollector();
        this.model.depthTraversal(objectCollector);
        this.glossary = new MIRGlossaryModel();
        this.glossary.setName(this.model.getName());
        this.glossary.setDescription(this.model.getDescription());
        this.glossary.setDesignLevel((byte)1);
        this.glossary.setStoreType((byte)3);
        this.glossary.addMetadataOrigin(this.generateMetadataOrigin(ProfileIds.META_INTEGRATION__GLOSSARY));
        this.glossary.setSystemType(mIRModel.getSystemType());
        for (MIRDesignPackage mIRNamespaceElement : this.designPackages) {
            this.convertDesignPackage(mIRNamespaceElement);
        }
        for (MIRDerivedType mIRDerivedType : this.domains) {
            this.convertDomain(mIRDerivedType);
        }
        for (MIRDerivedType mIRDerivedType : this.dataElements) {
            this.convertDataElement(mIRDerivedType);
        }
        for (MIRDerivedType mIRDerivedType : this.domains) {
            MIRConceptualDomain mIRConceptualDomain;
            MIRConcreteType mIRConcreteType;
            MIRConceptualDomain mIRConceptualDomain2 = (MIRConceptualDomain)this.object2GlossaryMap.get(mIRDerivedType);
            if (mIRConceptualDomain2 == null || !(mIRConcreteType = mIRDerivedType.getDerivedFromConcreteType()).isInstanceOf((short)5) || !((MIRDerivedType)mIRConcreteType).getUserDefined() || (mIRConceptualDomain = (MIRConceptualDomain)this.object2GlossaryMap.get(mIRConcreteType)) == null) continue;
            mIRConceptualDomain2.addSupertypeConceptualDomain(mIRConceptualDomain);
        }
        this.cleanupGlossary(this.glossary);
        return this.glossary;
    }

    private void setCommon(MIRModelObject mIRModelObject, MIRElement mIRElement) {
        mIRElement.setName(mIRModelObject.getName());
        if (mIRElement.getName().isEmpty() && mIRModelObject instanceof MIRTypeValue) {
            mIRElement.setName(((MIRTypeValue)mIRModelObject).getValue());
        }
        mIRElement.setDescription(mIRModelObject.getDescription());
        this.object2GlossaryMap.put(mIRModelObject, mIRElement);
    }

    private void convertDesignPackage(MIRDesignPackage mIRDesignPackage) {
        MIRCategory mIRCategory = new MIRCategory();
        this.setCommon(mIRDesignPackage, mIRCategory);
        if (mIRDesignPackage.getParent() == this.model) {
            this.glossary.addCategory(mIRCategory);
        } else if (mIRDesignPackage.getNamespace() instanceof MIRDesignPackage) {
            MIRCategory mIRCategory2 = (MIRCategory)this.object2GlossaryMap.get(mIRDesignPackage.getParent());
            mIRCategory2.addNamespaceElement(mIRCategory);
        }
    }

    private void convertDataElement(MIRDerivedType mIRDerivedType) {
        MIRNamespace mIRNamespace = mIRDerivedType.getNamespace();
        MIRCategory mIRCategory = (MIRCategory)this.object2GlossaryMap.get(mIRNamespace);
        MIRTerm mIRTerm = new MIRTerm();
        this.setCommon(mIRDerivedType, mIRTerm);
        mIRTerm.setName(mIRDerivedType.getPhysicalName());
        mIRTerm.setAbbreviation(mIRDerivedType.getPhysicalName());
        mIRTerm.setType((byte)1);
        mIRTerm.setDocumentation(mIRDerivedType.getComment());
        mIRCategory.addNamespaceElementUniqueName(mIRTerm);
        Iterator<MIRPackage> iterator = mIRDerivedType.getImportedByPackageIterator();
        while (iterator.hasNext()) {
            MIRDesignPackage mIRDesignPackage;
            MIRCategory mIRCategory2;
            MIRPackage mIRPackage = iterator.next();
            if (!(mIRPackage instanceof MIRDesignPackage) || (mIRCategory2 = (MIRCategory)this.object2GlossaryMap.get(mIRDesignPackage = (MIRDesignPackage)mIRPackage)) == null) continue;
            mIRCategory2.addImportedNamespaceElement(mIRTerm);
        }
    }

    private void convertDomain(MIRDerivedType mIRDerivedType) {
        if (mIRDerivedType.getTypeValueCount() == 0) {
            return;
        }
        MIRNamespace mIRNamespace = mIRDerivedType.getNamespace();
        MIRCategory mIRCategory = (MIRCategory)this.object2GlossaryMap.get(mIRNamespace);
        MIRConceptualDomain mIRConceptualDomain = new MIRConceptualDomain();
        this.setCommon(mIRDerivedType, mIRConceptualDomain);
        MIRDerivedType mIRDerivedType2 = new MIRDerivedType();
        mIRDerivedType2.setName(mIRDerivedType.getName());
        mIRDerivedType2.setDataType(mIRDerivedType.getDataType());
        mIRDerivedType2.setUserDefined(false);
        mIRDerivedType2.setLength(mIRDerivedType.getLength());
        mIRDerivedType2.setScale(mIRDerivedType.getScale());
        mIRConceptualDomain.addDerivedType(mIRDerivedType2);
        Iterator<MIRTypeValue> iterator = mIRDerivedType.getTypeValueIterator();
        while (iterator.hasNext()) {
            MIRTypeValue mIRTypeValue = iterator.next();
            if (mIRTypeValue.getValue().length() == 0) continue;
            MIRTerm mIRTerm = new MIRTerm();
            this.setCommon(mIRTypeValue, mIRTerm);
            mIRConceptualDomain.addNamespaceElement(mIRTerm);
            MIRTypeValue mIRTypeValue2 = new MIRTypeValue(mIRTypeValue);
            mIRDerivedType2.addTypeValue(mIRTypeValue2);
            mIRTerm.addTypeValue(mIRTypeValue2);
        }
        mIRCategory.addNamespaceElementUniqueName(mIRConceptualDomain);
    }

    private void cleanupGlossary(MIRGlossaryModel mIRGlossaryModel) {
        Iterator<MIRCategory> iterator = mIRGlossaryModel.getCategoryIterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            MIRCategory mIRCategory = iterator.next();
            if (!this.cleanupCategory(mIRCategory)) continue;
            arrayList.add(mIRCategory);
        }
        for (MIRNamespaceElement mIRNamespaceElement : arrayList) {
            mIRNamespaceElement.delete();
        }
    }

    private boolean cleanupCategory(MIRCategory mIRCategory) {
        Iterator<MIRNamespaceElement> iterator = mIRCategory.getNamespaceElementIterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            MIRNamespaceElement mIRNamespaceElement = iterator.next();
            if (!(mIRNamespaceElement instanceof MIRCategory) || !this.cleanupCategory((MIRCategory)mIRNamespaceElement)) continue;
            arrayList.add(mIRNamespaceElement);
        }
        for (MIRNamespaceElement mIRNamespaceElement : arrayList) {
            mIRNamespaceElement.delete();
        }
        return mIRCategory.getNamespaceElementCount() == 0;
    }

    private MIRMetadataOrigin generateMetadataOrigin(int n) {
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        VersionInfo versionInfo = VersionInfo.loadMitiJar(this.getClass());
        mIRMetadataOrigin.setBridgeName("Metadata Manager");
        mIRMetadataOrigin.setToolName("Metadata Manager");
        if (versionInfo != null) {
            mIRMetadataOrigin.setBridgeVersion(versionInfo.getVersionString());
            mIRMetadataOrigin.setToolVersion(versionInfo.getVersionString());
        }
        mIRMetadataOrigin.setProfileId(n);
        return mIRMetadataOrigin;
    }

    private class ObjectCollector
    implements MIR_Object.MIRTraversalOperation {
        private ObjectCollector() {
        }

        @Override
        public boolean traverse(MIRObject mIRObject) {
            return mIRObject.getElementType() == 2 || mIRObject.getElementType() == 9;
        }

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) {
            if (mIRObject instanceof MIRDesignPackage) {
                SapEccGlossaryConverter.this.designPackages.add((MIRDesignPackage)mIRObject);
            } else if (mIRObject instanceof MIRDerivedType) {
                if (((MIRDerivedType)mIRObject).getNativeType().equals("DataElement")) {
                    SapEccGlossaryConverter.this.dataElements.add((MIRDerivedType)mIRObject);
                } else if (((MIRDerivedType)mIRObject).getNativeType().equals("Domain")) {
                    SapEccGlossaryConverter.this.domains.add((MIRDerivedType)mIRObject);
                }
            }
        }

        @Override
        public void post_process(MIRObject mIRObject) {
        }
    }
}

