/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.glossary;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.glossary.ICounter;
import MITI.bridges.glossary.IGlossaryConverter;
import MITI.bridges.profiles.ProfileIds;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRCategory;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConceptualDomain;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiagram;
import MITI.sdk.MIRDimension;
import MITI.sdk.MIRDimensionAttribute;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRGeneralizationRole;
import MITI.sdk.MIRGlossaryModel;
import MITI.sdk.MIRMeasure;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSynonym;
import MITI.sdk.MIRSynonymGroup;
import MITI.sdk.MIRTerm;
import MITI.sdk.MIRTermRelationship;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.util.VersionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class GlossaryConverterDefault
implements IGlossaryConverter {
    private static final String DOMAIN_CATEGORY = "Domains";
    private static final String USER_TYPES_CATEGORY = "User Data Types";
    private static final String BUSINESS_RULE_CATEGORY = "Business Rules";
    private MIRModel model = null;
    private MIRGlossaryModel glossary = null;
    private MIRCategory domainCategory = null;
    private MIRCategory userDataTypesCategory = null;
    private MIRCategory businessRulesCategory = null;
    private Map<MIRElement, MIRElement> object2GlossaryMap = new TreeMap<MIRElement, MIRElement>();
    private Map<MIRCategory, Set<String>> duplicatesInCategory = new TreeMap<MIRCategory, Set<String>>();
    private Set<MIRElement> renamedElements = new TreeSet<MIRElement>();
    private List<MIRDesignPackage> designPackages = new ArrayList<MIRDesignPackage>();
    private List<MIRDataPackage> dataPackages = new ArrayList<MIRDataPackage>();
    private List<MIRDerivedType> domains = new ArrayList<MIRDerivedType>();
    private List<MIRBusinessRule> businessRules = new ArrayList<MIRBusinessRule>();
    private List<MIRClassifier> classifiers = new ArrayList<MIRClassifier>();
    private List<MIRFeature> features = new ArrayList<MIRFeature>();
    private List<MIRDiagram> diagrams = new ArrayList<MIRDiagram>();
    private List<MIRSynonym> synonyms = new ArrayList<MIRSynonym>();
    private List<MIRGeneralization> generalizations = new ArrayList<MIRGeneralization>();
    private List<MIRAssociation> associations = new ArrayList<MIRAssociation>();
    private ICounter counter = null;

    public void setCounter(ICounter iCounter) {
        this.counter = iCounter;
    }

    public Map<MIRElement, MIRElement> getObject2GlossaryMap() {
        return Collections.unmodifiableMap(this.object2GlossaryMap);
    }

    public static Byte getModelStoreType(MIRModel mIRModel) {
        if (mIRModel == null) {
            return null;
        }
        if (mIRModel instanceof MIRStoreModel) {
            return ((MIRStoreModel)mIRModel).getStoreType();
        }
        return (byte)3;
    }

    private MIRMetadataOrigin generateMetadataOrigin(int n) {
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        VersionInfo versionInfo = VersionInfo.loadMitiJar(this.getClass());
        mIRMetadataOrigin.setBridgeName("Metadata Manager");
        mIRMetadataOrigin.setToolName("Metadata Manager");
        if (versionInfo != null) {
            mIRMetadataOrigin.setBridgeVersion(versionInfo.getVersionString());
            mIRMetadataOrigin.setToolVersion(versionInfo.getVersionString());
        }
        mIRMetadataOrigin.setProfileId(n);
        return mIRMetadataOrigin;
    }

    @Override
    public MIRGlossaryModel convert(MIRModel mIRModel) throws MIRException {
        this.model = mIRModel;
        if (this.model.isInstanceOf((short)266)) {
            return (MIRGlossaryModel)this.model;
        }
        ObjectCollector objectCollector = new ObjectCollector();
        this.model.depthTraversal(objectCollector);
        this.glossary = new MIRGlossaryModel();
        this.glossary.setName(this.model.getName());
        this.glossary.setDescription(this.model.getDescription());
        this.glossary.setDesignLevel((byte)1);
        this.glossary.setStoreType((byte)3);
        this.glossary.addMetadataOrigin(this.generateMetadataOrigin(ProfileIds.META_INTEGRATION__GLOSSARY));
        for (MIRDesignPackage mIRModelObject : this.designPackages) {
            this.convertDesignPackage(mIRModelObject);
        }
        for (MIRDataPackage mIRDataPackage : this.dataPackages) {
            this.convertDataPackage(mIRDataPackage);
        }
        this.domainCategory = this.glossary.getCategory(DOMAIN_CATEGORY);
        if (this.domainCategory == null) {
            this.domainCategory = new MIRCategory();
            this.domainCategory.setName(DOMAIN_CATEGORY);
            this.addCategory(this.domainCategory);
        }
        this.userDataTypesCategory = this.glossary.getCategory(USER_TYPES_CATEGORY);
        if (this.userDataTypesCategory == null) {
            this.userDataTypesCategory = new MIRCategory();
            this.userDataTypesCategory.setName(USER_TYPES_CATEGORY);
            this.addCategory(this.userDataTypesCategory);
        }
        for (MIRDerivedType mIRDerivedType : this.domains) {
            this.convertDomain(mIRDerivedType);
        }
        if (this.businessRules.size() > 0) {
            this.businessRulesCategory = this.glossary.getCategory(BUSINESS_RULE_CATEGORY);
            if (this.businessRulesCategory == null) {
                this.businessRulesCategory = new MIRCategory();
                this.businessRulesCategory.setName(BUSINESS_RULE_CATEGORY);
                this.addCategory(this.businessRulesCategory);
            }
            for (MIRBusinessRule mIRBusinessRule : this.businessRules) {
                this.convertBusinessRule(mIRBusinessRule);
            }
        }
        for (MIRDerivedType mIRDerivedType : this.domains) {
            MIRConceptualDomain mIRConceptualDomain;
            MIRConcreteType mIRConcreteType;
            MIRConceptualDomain mIRConceptualDomain2 = (MIRConceptualDomain)this.object2GlossaryMap.get(mIRDerivedType);
            if (mIRConceptualDomain2 == null || !(mIRConcreteType = mIRDerivedType.getDerivedFromConcreteType()).isInstanceOf((short)5) || !((MIRDerivedType)mIRConcreteType).getUserDefined() || (mIRConceptualDomain = (MIRConceptualDomain)this.object2GlossaryMap.get(mIRConcreteType)) == null) continue;
            mIRConceptualDomain2.addSupertypeConceptualDomain(mIRConceptualDomain);
        }
        for (MIRClassifier mIRClassifier : this.classifiers) {
            this.convertClassifier(mIRClassifier);
        }
        for (MIRGeneralization mIRGeneralization : this.generalizations) {
            this.convertGeneralization(mIRGeneralization);
        }
        for (MIRAssociation mIRAssociation : this.associations) {
            this.convertAssociation(mIRAssociation);
        }
        for (MIRDiagram mIRDiagram : this.diagrams) {
            this.convertDiagram(mIRDiagram);
        }
        for (MIRFeature mIRFeature : this.features) {
            this.convertFeature(mIRFeature);
        }
        for (MIRSynonym mIRSynonym : this.synonyms) {
            this.convertSynonym(mIRSynonym);
        }
        return this.glossary;
    }

    private void convertBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule.getType() == 2) {
            return;
        }
        MIRConceptualDomain mIRConceptualDomain = new MIRConceptualDomain();
        this.setCommon(mIRBusinessRule, mIRConceptualDomain);
        MIRDerivedType mIRDerivedType = new MIRDerivedType();
        mIRDerivedType.setName(mIRBusinessRule.getName());
        mIRDerivedType.setUserDefined(false);
        if (mIRBusinessRule.getType() == 0) {
            mIRDerivedType.setDataType("SQL_INTEGER");
            mIRDerivedType.setUpperBound(mIRBusinessRule.getUpperBound());
            mIRDerivedType.setLowerBound(mIRBusinessRule.getLowerBound());
        } else {
            mIRDerivedType.setDataType("SQL_VARCHAR");
        }
        mIRDerivedType.setInitialValue(mIRBusinessRule.getValue());
        mIRConceptualDomain.addDerivedType(mIRDerivedType);
        if (mIRBusinessRule.getType() == 1) {
            Iterator<MIRTypeValue> iterator = mIRBusinessRule.getTypeValueIterator();
            this.importDomainPossibleValues(iterator, mIRConceptualDomain, mIRDerivedType);
        }
        this.addNamespaceElement(this.businessRulesCategory, mIRConceptualDomain, false);
    }

    private void importDomainPossibleValues(Iterator<MIRTypeValue> iterator, MIRConceptualDomain mIRConceptualDomain, MIRDerivedType mIRDerivedType) {
        while (iterator.hasNext()) {
            MIRTypeValue mIRTypeValue = iterator.next();
            MIRTerm mIRTerm = new MIRTerm();
            this.setCommon(mIRTypeValue, mIRTerm);
            if (mIRConceptualDomain.getNamespaceElement(mIRTerm.getName()) != null) continue;
            this.addNamespaceElement(mIRConceptualDomain, mIRTerm, false);
            MIRTypeValue mIRTypeValue2 = new MIRTypeValue(mIRTypeValue);
            mIRDerivedType.addTypeValue(mIRTypeValue2);
            mIRTerm.addTypeValue(mIRTypeValue2);
        }
    }

    private void convertAssociation(MIRAssociation mIRAssociation) {
        if (mIRAssociation.getAssociationRoleCount() != 2) {
            return;
        }
        MIRAssociationRole mIRAssociationRole = null;
        MIRAssociationRole mIRAssociationRole2 = null;
        Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
        while (iterator.hasNext()) {
            if (mIRAssociationRole == null) {
                mIRAssociationRole = iterator.next();
                continue;
            }
            mIRAssociationRole2 = iterator.next();
        }
        if (mIRAssociationRole == null || mIRAssociationRole2 == null) {
            return;
        }
        MIRClass mIRClass = mIRAssociationRole.getAssociatedClass();
        MIRClass mIRClass2 = mIRAssociationRole2.getAssociatedClass();
        MIRTerm mIRTerm = (MIRTerm)this.object2GlossaryMap.get(mIRClass);
        MIRTerm mIRTerm2 = (MIRTerm)this.object2GlossaryMap.get(mIRClass2);
        if (mIRTerm == null || mIRTerm2 == null) {
            return;
        }
        MIRTermRelationship mIRTermRelationship = this.createTermRelationship(mIRTerm, mIRTerm2, (byte)2);
        mIRTermRelationship.setDestinationMultiplicity(mIRAssociationRole2.getMultiplicity());
        mIRTermRelationship.setSourceMultiplicity(mIRAssociationRole.getMultiplicity());
        mIRTermRelationship.setDestinationRoleName(mIRAssociationRole2.getName());
        mIRTermRelationship.setSourceRoleName(mIRAssociationRole.getName());
    }

    private void convertGeneralization(MIRGeneralization mIRGeneralization) {
        MIRGeneralizationRole mIRGeneralizationRole = null;
        Iterator<MIRGeneralizationRole> iterator = mIRGeneralization.getSupertypeGeneralizationRoleIterator();
        if (iterator.hasNext()) {
            mIRGeneralizationRole = iterator.next();
        }
        if (mIRGeneralizationRole == null) {
            return;
        }
        MIRClass mIRClass = mIRGeneralizationRole.getAssociatedClass();
        MIRTerm mIRTerm = (MIRTerm)this.object2GlossaryMap.get(mIRClass);
        if (mIRTerm == null) {
            return;
        }
        Iterator<MIRGeneralizationRole> iterator2 = mIRGeneralization.getSubtypeGeneralizationRoleIterator();
        while (iterator2.hasNext()) {
            MIRGeneralizationRole mIRGeneralizationRole2 = iterator2.next();
            MIRClass mIRClass2 = mIRGeneralizationRole2.getAssociatedClass();
            MIRTerm mIRTerm2 = (MIRTerm)this.object2GlossaryMap.get(mIRClass2);
            if (mIRTerm2 == null) continue;
            MIRTermRelationship mIRTermRelationship = this.createTermRelationship(mIRTerm, mIRTerm2, (byte)1);
            mIRTermRelationship.setSourceMultiplicity("1");
            mIRTermRelationship.setDestinationMultiplicity("0..1");
        }
    }

    private void setCommon(MIRElement mIRElement, MIRElement mIRElement2) {
        mIRElement2.setName(mIRElement.getName());
        if (mIRElement2.getName().isEmpty() && mIRElement instanceof MIRTypeValue) {
            mIRElement2.setName(((MIRTypeValue)mIRElement).getValue());
        }
        mIRElement2.setDescription(mIRElement.getDescription());
        this.object2GlossaryMap.put(mIRElement, mIRElement2);
    }

    private void convertDesignPackage(MIRDesignPackage mIRDesignPackage) {
        MIRCategory mIRCategory = new MIRCategory();
        this.setCommon(mIRDesignPackage, mIRCategory);
        if (mIRDesignPackage.getParent() == this.model) {
            this.addCategory(mIRCategory);
        } else if (mIRDesignPackage.getNamespace() instanceof MIRDesignPackage) {
            MIRCategory mIRCategory2 = (MIRCategory)this.object2GlossaryMap.get(mIRDesignPackage.getParent());
            this.addNamespaceElement(mIRCategory2, mIRCategory, false);
        }
    }

    private void convertDataPackage(MIRDataPackage mIRDataPackage) {
        if (mIRDataPackage.getNamespaceElementCount() == 0) {
            return;
        }
        MIRCategory mIRCategory = new MIRCategory();
        this.setCommon(mIRDataPackage, mIRCategory);
        if (mIRDataPackage.getParent() == this.model) {
            this.addCategory(mIRCategory);
        } else if (mIRDataPackage.getNamespace() instanceof MIRDataPackage) {
            MIRCategory mIRCategory2 = (MIRCategory)this.object2GlossaryMap.get(mIRDataPackage.getParent());
            this.addNamespaceElement(mIRCategory2, mIRCategory, false);
        }
    }

    private void convertDiagram(MIRDiagram mIRDiagram) {
        MIRCategory mIRCategory = new MIRCategory();
        this.setCommon(mIRDiagram, mIRCategory);
        MIRDesignPackage mIRDesignPackage = mIRDiagram.getDesignPackage();
        MIRCategory mIRCategory2 = (MIRCategory)this.object2GlossaryMap.get(mIRDesignPackage);
        if (GlossaryConverterDefault.getElementByName(mIRCategory2, mIRDiagram.getName()) != null) {
            mIRCategory.setName(mIRDiagram.getName() + MIRElementType.toString(mIRDiagram.getElementType()));
        }
        this.addNamespaceElement(mIRCategory2, mIRCategory, false);
        Iterator<MIRModelElement> iterator = mIRDiagram.getModelElementIterator();
        while (iterator.hasNext()) {
            MIRModelElement mIRModelElement = iterator.next();
            MIRTerm mIRTerm = (MIRTerm)this.object2GlossaryMap.get(mIRModelElement);
            if (mIRTerm == null) continue;
            mIRCategory.addImportedNamespaceElement(mIRTerm);
        }
    }

    private void convertDomain(MIRDerivedType mIRDerivedType) {
        MIRConceptualDomain mIRConceptualDomain = new MIRConceptualDomain();
        this.setCommon(mIRDerivedType, mIRConceptualDomain);
        MIRDerivedType mIRDerivedType2 = new MIRDerivedType();
        mIRDerivedType2.setName(mIRDerivedType.getName());
        mIRDerivedType2.setDataType(mIRDerivedType.getDataType());
        mIRDerivedType2.setNativeLogicalDataType(this.convertDataType(mIRDerivedType));
        mIRDerivedType2.setUserDefined(false);
        mIRDerivedType2.setLength(mIRDerivedType.getLength());
        mIRConceptualDomain.addDerivedType(mIRDerivedType2);
        Iterator<MIRTypeValue> iterator = mIRDerivedType.getTypeValueIterator();
        this.importDomainPossibleValues(iterator, mIRConceptualDomain, mIRDerivedType2);
        if (mIRDerivedType.getUserDataType()) {
            this.addNamespaceElement(this.userDataTypesCategory, mIRConceptualDomain, true);
        } else {
            this.addNamespaceElement(this.domainCategory, mIRConceptualDomain, true);
        }
        SortedSet<MIRBusinessRule> sortedSet = mIRDerivedType.getAssociatedBusinessRules();
        for (MIRBusinessRule mIRBusinessRule : sortedSet) {
            Iterator<MIRTypeValue> iterator2 = mIRBusinessRule.getTypeValueIterator();
            this.importDomainPossibleValues(iterator2, mIRConceptualDomain, mIRDerivedType2);
        }
    }

    private boolean isStandaloneBusinessRule(MIRBusinessRule mIRBusinessRule) {
        if (mIRBusinessRule.getModelObjectCount() == 0) {
            return true;
        }
        for (MIRModelObject mIRModelObject : mIRBusinessRule.getModelObjects()) {
            if (mIRModelObject.isInstanceOf((short)5)) continue;
            return true;
        }
        return false;
    }

    private void convertClassifier(MIRClassifier mIRClassifier) {
        MIRNamespace mIRNamespace = mIRClassifier.getNamespace();
        MIRCategory mIRCategory = (MIRCategory)this.object2GlossaryMap.get(mIRNamespace);
        MIRTerm mIRTerm = new MIRTerm();
        this.setCommon(mIRClassifier, mIRTerm);
        mIRTerm.setAbbreviation(mIRClassifier.getPhysicalName());
        mIRTerm.setType((byte)1);
        this.addNamespaceElement(mIRCategory, mIRTerm, false);
        Iterator<MIRPackage> iterator = mIRClassifier.getImportedByPackageIterator();
        while (iterator.hasNext()) {
            MIRDesignPackage mIRDesignPackage;
            MIRCategory mIRCategory2;
            MIRPackage mIRPackage = iterator.next();
            if (!(mIRPackage instanceof MIRDesignPackage) || (mIRCategory2 = (MIRCategory)this.object2GlossaryMap.get(mIRDesignPackage = (MIRDesignPackage)mIRPackage)) == null) continue;
            mIRCategory2.addImportedNamespaceElement(mIRTerm);
        }
    }

    private void convertFeature(MIRFeature mIRFeature) {
        Iterator<MIRBusinessRule> iterator;
        Object object;
        MIRElement mIRElement2;
        Object object2;
        TreeSet<String> treeSet;
        MIRClassifier mIRClassifier = mIRFeature.getClassifier();
        MIRTerm mIRTerm = (MIRTerm)this.object2GlossaryMap.get(mIRClassifier);
        if (mIRTerm == null) {
            return;
        }
        MIRCategory mIRCategory = (MIRCategory)mIRTerm.getNamespace();
        if (mIRFeature instanceof MIRAttribute) {
            boolean bl = false;
            treeSet = ((MIRAttribute)mIRFeature).getKeyIterator();
            while (treeSet.hasNext()) {
                object2 = treeSet.next();
                if (!(object2 instanceof MIRForeignKey)) continue;
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        MIRTerm mIRTerm2 = new MIRTerm();
        this.setCommon(mIRFeature, mIRTerm2);
        treeSet = this.duplicatesInCategory.get(mIRCategory);
        if (treeSet != null && treeSet.contains(mIRFeature.getName())) {
            object2 = this.getTermUniqueueName(mIRCategory, mIRClassifier.getName(), mIRFeature.getName());
            mIRTerm2.setName((String)object2);
            this.renamedElements.add(mIRTerm2);
        } else {
            object2 = GlossaryConverterDefault.getElementByName(mIRCategory, mIRFeature.getName());
            if (object2 != null) {
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    this.duplicatesInCategory.put(mIRCategory, treeSet);
                }
                treeSet.add(mIRFeature.getName());
                if (object2 instanceof MIRTerm) {
                    for (MIRElement mIRElement2 : ((MIRTerm)object2).getDestinationOfTermRelationships()) {
                        if (mIRElement2.getType() != 0) continue;
                        if (this.renamedElements.contains(object2)) break;
                        object = this.getTermUniqueueName(mIRCategory, mIRElement2.getSourceTerm().getName(), ((MIRObject)object2).getName());
                        ((MIRObject)object2).setName((String)object);
                        this.renamedElements.add((MIRElement)object2);
                        break;
                    }
                }
                iterator = this.getTermUniqueueName(mIRCategory, mIRClassifier.getName(), mIRFeature.getName());
                mIRTerm2.setName((String)((Object)iterator));
                this.renamedElements.add(mIRTerm2);
            }
        }
        mIRTerm2.setAbbreviation(mIRFeature.getPhysicalName());
        mIRTerm2.setType((byte)2);
        this.addNamespaceElement(mIRCategory, mIRTerm2, false);
        object2 = this.createTermRelationship(mIRTerm, mIRTerm2, (byte)0);
        ((MIRTermRelationship)object2).setSourceMultiplicity("1");
        ((MIRTermRelationship)object2).setDestinationMultiplicity("0..1");
        iterator = mIRFeature.getAssociatedBusinessRuleIterator();
        while (iterator.hasNext()) {
            mIRElement2 = iterator.next();
            object = (MIRConceptualDomain)this.object2GlossaryMap.get(mIRElement2);
            if (object == null) continue;
            mIRTerm2.addRepresentedByConceptualDomain((MIRConceptualDomain)object);
        }
        if (mIRTerm2.getRepresentedByConceptualDomain() == null && (mIRElement2 = MIRBridgeLib.getDomain(mIRFeature)) != null && (object = (MIRConceptualDomain)this.object2GlossaryMap.get(mIRElement2)) != null) {
            mIRTerm2.addRepresentedByConceptualDomain((MIRConceptualDomain)object);
        }
    }

    private String getTermUniqueueName(MIRCategory mIRCategory, String string, String string2) {
        String string3 = string + " " + string2;
        int n = 1;
        while (mIRCategory.getNamespaceElement(string3) != null) {
            string3 = string + " " + string2 + "_" + String.valueOf(n);
            ++n;
        }
        return string3;
    }

    private void addNamespaceElement(MIRPackage mIRPackage, MIRNamespaceElement mIRNamespaceElement, boolean bl) {
        if (bl) {
            mIRPackage.addNamespaceElementUniqueName(mIRNamespaceElement);
        } else {
            mIRPackage.addNamespaceElement(mIRNamespaceElement);
        }
        if (this.counter != null) {
            this.counter.count(mIRNamespaceElement);
        }
    }

    private void addCategory(MIRCategory mIRCategory) {
        this.glossary.addCategory(mIRCategory);
        if (this.counter != null) {
            this.counter.count(mIRCategory);
        }
    }

    private void convertSynonym(MIRSynonym mIRSynonym) {
        MIRNamespaceElement mIRNamespaceElement;
        MIRModelObject mIRModelObject = mIRSynonym.getModelObject();
        MIRTerm mIRTerm = (MIRTerm)this.object2GlossaryMap.get(mIRModelObject);
        if (mIRTerm == null) {
            return;
        }
        MIRCategory mIRCategory = (MIRCategory)mIRTerm.getNamespace();
        MIRSynonymGroup mIRSynonymGroup = mIRTerm.getPreferredBySynonymGroup();
        if (mIRSynonymGroup == null) {
            mIRSynonymGroup = new MIRSynonymGroup();
            mIRSynonymGroup.addGlossaryModel(this.glossary);
            mIRSynonymGroup.addPreferredTerm(mIRTerm);
        }
        if ((mIRNamespaceElement = GlossaryConverterDefault.getElementByName(mIRCategory, mIRSynonym.getName())) == null) {
            MIRTerm mIRTerm2 = new MIRTerm();
            this.setCommon(mIRSynonym, mIRTerm2);
            mIRTerm2.setAbbreviation(mIRSynonym.getPhysicalName());
            mIRTerm2.setType(mIRTerm.getType());
            mIRSynonymGroup.addTerm(mIRTerm2);
            this.addNamespaceElement(mIRCategory, mIRTerm2, false);
        }
    }

    private static MIRNamespaceElement getElementByName(MIRCategory mIRCategory, String string) {
        MIRNamespaceElement mIRNamespaceElement;
        MIRNamespaceElement mIRNamespaceElement2 = null;
        Iterator<MIRNamespaceElement> iterator = mIRCategory.getNamespaceElementIterator();
        while (iterator.hasNext()) {
            mIRNamespaceElement = iterator.next();
            if (mIRNamespaceElement.getName().compareToIgnoreCase(string) != 0) continue;
            mIRNamespaceElement2 = mIRNamespaceElement;
            break;
        }
        iterator = mIRCategory.getImportedNamespaceElementIterator();
        while (iterator.hasNext()) {
            mIRNamespaceElement = iterator.next();
            if (mIRNamespaceElement.getName().compareToIgnoreCase(string) != 0) continue;
            mIRNamespaceElement2 = mIRNamespaceElement;
            break;
        }
        return mIRNamespaceElement2;
    }

    private MIRTermRelationship createTermRelationship(MIRTerm mIRTerm, MIRTerm mIRTerm2, byte by) {
        MIRTermRelationship mIRTermRelationship = new MIRTermRelationship();
        mIRTermRelationship.addDestinationTerm(mIRTerm2);
        mIRTermRelationship.addSourceTerm(mIRTerm);
        mIRTermRelationship.setType(by);
        this.glossary.addTermRelationship(mIRTermRelationship);
        if (this.counter != null) {
            this.counter.count(mIRTermRelationship);
        }
        return mIRTermRelationship;
    }

    private String convertDataType(MIRDerivedType mIRDerivedType) {
        String string = "";
        String string2 = mIRDerivedType.getDataType();
        if ("SQL_BOOLEAN".equals(string2)) {
            string = "Boolean";
        }
        if (MIRBaseTypeList.isMIRNumeric(string2)) {
            string = "Number";
        } else if (MIRBaseTypeList.isMIRString(string2)) {
            string = "String";
        } else if (MIRBaseTypeList.isMIRDate(string2)) {
            string = "Date";
        } else if (MIRBaseTypeList.isMIRBinary(string2)) {
            string = "Binary";
        }
        return string;
    }

    private class ObjectCollector
    implements MIR_Object.MIRTraversalOperation {
        private ObjectCollector() {
        }

        @Override
        public boolean traverse(MIRObject mIRObject) {
            return mIRObject.getElementType() != 216;
        }

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) {
            if (!bl) {
                return;
            }
            if (mIRObject instanceof MIRDesignPackage) {
                GlossaryConverterDefault.this.designPackages.add((MIRDesignPackage)mIRObject);
            }
            if (mIRObject instanceof MIRDataPackage) {
                GlossaryConverterDefault.this.dataPackages.add((MIRDataPackage)mIRObject);
            } else if (mIRObject instanceof MIRDerivedType) {
                if (((MIRDerivedType)mIRObject).getUserDefined()) {
                    GlossaryConverterDefault.this.domains.add((MIRDerivedType)mIRObject);
                }
            } else if (mIRObject instanceof MIRBusinessRule) {
                if (GlossaryConverterDefault.this.isStandaloneBusinessRule((MIRBusinessRule)mIRObject)) {
                    GlossaryConverterDefault.this.businessRules.add((MIRBusinessRule)mIRObject);
                }
            } else if (mIRObject instanceof MIRClass || mIRObject instanceof MIRDimension || mIRObject instanceof MIRSQLViewEntity || mIRObject instanceof MIRFlatTextFile) {
                GlossaryConverterDefault.this.classifiers.add((MIRClassifier)mIRObject);
            } else if (mIRObject instanceof MIRAttribute || mIRObject instanceof MIRDimensionAttribute || mIRObject instanceof MIRMeasure || mIRObject instanceof MIRSQLViewAttribute) {
                GlossaryConverterDefault.this.features.add((MIRFeature)mIRObject);
            } else if (mIRObject instanceof MIRDiagram) {
                GlossaryConverterDefault.this.diagrams.add((MIRDiagram)mIRObject);
            } else if (mIRObject instanceof MIRSynonym) {
                GlossaryConverterDefault.this.synonyms.add((MIRSynonym)mIRObject);
            } else if (mIRObject instanceof MIRGeneralization) {
                GlossaryConverterDefault.this.generalizations.add((MIRGeneralization)mIRObject);
            } else if (mIRObject instanceof MIRAssociation) {
                GlossaryConverterDefault.this.associations.add((MIRAssociation)mIRObject);
            }
        }

        @Override
        public void post_process(MIRObject mIRObject) {
        }
    }
}

