/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class MIRDOMElement {
    private MIRDOMElement parent = null;
    private String tagName = "";
    private String value = "";
    private TreeMap<String, String> attributes = new TreeMap();
    private TreeMap<String, ArrayList<MIRDOMElement>> elements = new TreeMap();
    private ArrayList<MIRDOMElement> elementsArray = new ArrayList();

    protected MIRDOMElement(String string, MIRDOMElement mIRDOMElement) {
        this.parent = mIRDOMElement;
        this.tagName = string;
        if (this.parent != null) {
            this.parent.appendChild(this);
        }
    }

    private void appendChild(MIRDOMElement mIRDOMElement) {
        ArrayList<MIRDOMElement> arrayList = this.elements.get(mIRDOMElement.tagName);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.elements.put(mIRDOMElement.tagName, arrayList);
        }
        arrayList.add(mIRDOMElement);
        this.elementsArray.add(mIRDOMElement);
    }

    public String getTagName() {
        return this.tagName;
    }

    public MIRDOMElement getParent() {
        return this.parent;
    }

    public String getAttribute(String string) {
        if (this.attributes.size() == 0) {
            return "";
        }
        String string2 = this.attributes.get(string);
        return string2 == null ? "" : string2;
    }

    public void setAttribute(String string, String string2) {
        String string3 = this.attributes.get(string);
        if (string3 == null) {
            this.attributes.put(string, string2);
        }
    }

    public int getElementCount() {
        return this.getAllElements().size();
    }

    public ArrayList<MIRDOMElement> getAllElements() {
        return this.elementsArray;
    }

    public MIRDOMElement getElement(int n) {
        ArrayList<MIRDOMElement> arrayList = this.getAllElements();
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.get(n);
    }

    public int getElementCount(String string) {
        List<MIRDOMElement> list = this.getElements(string);
        return list.size();
    }

    public MIRDOMElement getElement(String string, int n) {
        List<MIRDOMElement> list = this.getElements(string);
        if (list.size() == 0) {
            return null;
        }
        return list.get(n);
    }

    public String getFirstElementValue(String string) {
        List<MIRDOMElement> list = this.getElements(string);
        if (list.size() == 0) {
            return "";
        }
        MIRDOMElement mIRDOMElement = list.get(0);
        return mIRDOMElement.getValue();
    }

    public MIRDOMElement getFirstElement(String string) {
        List<MIRDOMElement> list = this.getElements(string);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public List<MIRDOMElement> getElements(String string) {
        ArrayList arrayList = this.elements.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tagName);
        for (String string : this.attributes.keySet()) {
            String string2 = this.attributes.get(string);
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(" ").append(string).append("=\"").append(string2).append("\"");
        }
        return stringBuffer.toString();
    }
}

