/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.MIRException;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRSystemTypeHandler;
import MITI.messages.MIRModelBridge.DTLIB;
import MITI.sdk.MIRSystemPackage;
import java.util.ArrayList;

public class MIRDataTypeLib {
    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static MIRDataStoreVersion getDataStore(MIRSystemPackage mIRSystemPackage) {
        if (mIRSystemPackage != null) {
            MIRDataStoreVersion mIRDataStoreVersion = new MIRDataStoreVersion(mIRSystemPackage.getSystemType(), mIRSystemPackage.getSystemMajorVersion(), mIRSystemPackage.getSystemMinorVersion(), mIRSystemPackage.getSystemReleaseVersion());
            if (mIRDataStoreVersion.isValid()) {
                return mIRDataStoreVersion;
            }
            MIRDataStoreVersion mIRDataStoreVersion2 = MIRDataTypeLib.getMappedDataStoreVersion(mIRSystemPackage.getSystemTypeOld());
            if (mIRDataStoreVersion2.isValid()) {
                return mIRDataStoreVersion2;
            }
        }
        return new MIRDataStoreVersion();
    }

    public static boolean setDataStore(MIRSystemPackage mIRSystemPackage, MIRDataStoreVersion mIRDataStoreVersion) {
        if (mIRSystemPackage == null || mIRDataStoreVersion == null || !mIRDataStoreVersion.isValid()) {
            return false;
        }
        mIRSystemPackage.setSystemType(mIRDataStoreVersion.getDataStoreType());
        mIRSystemPackage.setSystemMajorVersion(mIRDataStoreVersion.getMajorVersion());
        mIRSystemPackage.setSystemMinorVersion(mIRDataStoreVersion.getMinorVersion());
        mIRSystemPackage.setSystemReleaseVersion(mIRDataStoreVersion.getReleaseVersion());
        return true;
    }

    public static MIRDataStoreVersion getMappedDataStoreVersion(String string) {
        MIRDataStoreVersion mIRDataStoreVersion = MIRSystemTypeHandler.versionMap.get(string);
        if (mIRDataStoreVersion == null) {
            mIRDataStoreVersion = new MIRDataStoreVersion();
        }
        return mIRDataStoreVersion;
    }

    private static String checkDigits(String string) {
        String string2 = "";
        if (string == null || string.isEmpty()) {
            return string2;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                string2 = string2 + c;
                continue;
            }
            if (!string2.isEmpty()) break;
        }
        return string2;
    }

    public static String extractDataType(String string) {
        if (MIRDataTypeLib.isEmpty(string)) {
            return string;
        }
        MIRParsedType mIRParsedType = MIRParsedType.parseSqlType(string);
        return mIRParsedType.getTypeName();
    }

    public static String formatOracleInterval(String string, String string2, int n, int n2) {
        String string3 = "";
        int n3 = string.toLowerCase().indexOf(string2);
        if (n != 0 && n3 != -1) {
            int n4 = n3 + string2.length();
            string3 = string.substring(0, n4) + "(" + n + ")" + string.substring(n4, string.length());
        }
        if (n2 != 0) {
            string3 = string3 + "(" + Integer.toString(n2) + ")";
        }
        return string3;
    }

    static int findClosestVersionIndex(ArrayList<MIRDataStoreVersion> arrayList, MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        if (mIRDataStoreVersion == null || !mIRDataStoreVersion.isValid()) {
            return -1;
        }
        int n = arrayList.size();
        if (n == 0) {
            return -1;
        }
        int n2 = 0;
        MIRDataStoreVersion mIRDataStoreVersion2 = arrayList.get(n2);
        int n3 = mIRDataStoreVersion2.compareTo(mIRDataStoreVersion);
        if (n3 >= 0) {
            return n2;
        }
        n2 = n - 1;
        MIRDataStoreVersion mIRDataStoreVersion3 = arrayList.get(n2);
        n3 = mIRDataStoreVersion3.compareTo(mIRDataStoreVersion);
        if (n3 <= 0) {
            return n2;
        }
        int n4 = 0;
        int n5 = 1;
        while (n5 < n) {
            mIRDataStoreVersion3 = arrayList.get(n5);
            n3 = mIRDataStoreVersion3.compareTo(mIRDataStoreVersion);
            if (n3 == 0) {
                return n5;
            }
            if (n3 >= 0) {
                MIRDataStoreVersion mIRDataStoreVersion4 = arrayList.get(n4);
                if (mIRDataStoreVersion4.getMajorVersion() < mIRDataStoreVersion3.getMajorVersion() && mIRDataStoreVersion.getMajorVersion() == mIRDataStoreVersion3.getMajorVersion()) {
                    return n5;
                }
                if (mIRDataStoreVersion4.compareTo(mIRDataStoreVersion) >= 0) break;
                return n4;
            }
            n4 = n5++;
        }
        throw new MIRException(DTLIB.NO_DATASTORE_VERSION.getMessage(mIRDataStoreVersion.toString()));
    }

    public static class MIRParsedType {
        private String name = "";
        private String length = "";
        private String scale = "";
        private String nativeDataType = "";
        private boolean isCollection = false;
        private String collectionElement = "";
        private MIRParsedType collectionElementType = null;
        private static String[] ORACLE_COLLECTION = new String[]{"VARRAY", "VARYING ARRAY", "TABLE"};
        private static String[] INFORMIX_COLLECTION = new String[]{"LIST", "MULTISET", "SET"};
        private static String[] POSTGRESQL_COLLECTION = new String[]{"ARRAY", "["};
        private static String[] HIVE_COLLECTION = new String[]{"ARRAY"};

        private MIRParsedType() {
        }

        private void setTypeName(String string) {
            this.name = string != null ? string.trim() : "";
        }

        public String getTypeName() {
            return this.name;
        }

        public void setLength(String string) {
            this.length = string != null ? string.trim() : "";
        }

        public String getLength() {
            return this.length;
        }

        public void setScale(String string) {
            this.scale = string != null ? string.trim() : "";
        }

        public String getScale() {
            return this.scale;
        }

        public void setNativeDataType(String string) {
            this.nativeDataType = string != null ? string.trim() : "";
        }

        public String getNativeDataType() {
            return this.nativeDataType;
        }

        public void setCollection(boolean bl) {
            this.isCollection = bl;
        }

        public boolean getCollection() {
            return this.isCollection;
        }

        public void setCollectionElement(String string) {
            this.collectionElement = string != null ? string.trim() : "";
        }

        public String getCollectionElement() {
            return this.collectionElement;
        }

        public void setCollectionElementType(MIRParsedType mIRParsedType) {
            this.collectionElementType = mIRParsedType;
        }

        public MIRParsedType getCollectionElementType() {
            return this.collectionElementType;
        }

        public int getIntLength() {
            int n;
            if (this.length.equals("")) {
                return 0;
            }
            try {
                n = Integer.parseInt(MIRDataTypeLib.checkDigits(this.length));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            return n;
        }

        public String getLengthUnit() {
            if (this.length.equals("")) {
                return this.length;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.length.length(); ++i) {
                char c = this.length.charAt(i);
                if (Character.isDigit(c)) continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString().trim();
        }

        public int getIntScale() {
            int n;
            if (this.scale.equals("")) {
                return 0;
            }
            try {
                n = Integer.parseInt(MIRDataTypeLib.checkDigits(this.scale));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            return n;
        }

        public static MIRParsedType parseSqlType(String string, String string2) {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            if (!string2.equalsIgnoreCase("ORACLE")) break block6;
                            String string3 = " OF ";
                            for (String string4 : ORACLE_COLLECTION) {
                                int n;
                                if (!string.toUpperCase().startsWith(string4) || string.length() <= string4.length() || (n = string.toUpperCase().indexOf(string3)) == -1) continue;
                                String string5 = string.substring(string4.length(), n);
                                int n2 = string5.indexOf(40);
                                int n3 = string5.indexOf(41);
                                string5 = n2 != -1 && n3 != -1 ? string5.substring(n2 + 1, n3) : "";
                                String string6 = string.substring(n + string3.length(), string.length());
                                MIRParsedType mIRParsedType = new MIRParsedType();
                                mIRParsedType.setTypeName(ORACLE_COLLECTION[0]);
                                mIRParsedType.setLength(string5);
                                mIRParsedType.setNativeDataType(string);
                                mIRParsedType.setCollection(true);
                                mIRParsedType.setCollectionElement(string6);
                                mIRParsedType.setCollectionElementType(MIRParsedType.parseSqlType(string6));
                                return mIRParsedType;
                            }
                            break block7;
                        }
                        if (!string2.equalsIgnoreCase("INFORMIX")) break block8;
                        for (String string7 : INFORMIX_COLLECTION) {
                            if (!string.toUpperCase().startsWith(string7) || string.length() <= string7.length()) continue;
                            char c = string.charAt(string7.length());
                            int n = string.lastIndexOf(")");
                            if (c != '(' || n == -1) continue;
                            String string8 = string.substring(string7.length() + 1, n);
                            MIRParsedType mIRParsedType = new MIRParsedType();
                            mIRParsedType.setTypeName(string7);
                            mIRParsedType.setNativeDataType(string);
                            mIRParsedType.setCollection(true);
                            mIRParsedType.setCollectionElement(string8);
                            mIRParsedType.setCollectionElementType(MIRParsedType.parseSqlType(string8, string2));
                            return mIRParsedType;
                        }
                        break block7;
                    }
                    if (!string2.equalsIgnoreCase("POSTGRESQL")) break block9;
                    for (String string9 : POSTGRESQL_COLLECTION) {
                        String string10 = "";
                        String string11 = "";
                        String string12 = "";
                        int n = string.toUpperCase().indexOf(string9);
                        if (n != -1) {
                            string10 = POSTGRESQL_COLLECTION[0];
                            string11 = string.substring(0, n).trim();
                            int n4 = string.indexOf("[");
                            int n5 = string.indexOf("]");
                            if (n4 != -1 && n5 != -1) {
                                string12 = string.substring(n4 + 1, n5);
                            }
                        }
                        if (string10.isEmpty()) continue;
                        MIRParsedType mIRParsedType = new MIRParsedType();
                        mIRParsedType.setTypeName(string10);
                        mIRParsedType.setLength(string12);
                        mIRParsedType.setNativeDataType(string);
                        mIRParsedType.setCollection(true);
                        mIRParsedType.setCollectionElement(string11);
                        mIRParsedType.setCollectionElementType(MIRParsedType.parseSqlType(string11));
                        return mIRParsedType;
                    }
                    break block7;
                }
                if (!string2.equalsIgnoreCase("HIVE")) break block7;
                for (String string13 : HIVE_COLLECTION) {
                    if (!string.toUpperCase().startsWith(string13) || string.length() <= string13.length()) continue;
                    int n = string.indexOf("<");
                    int n6 = string.lastIndexOf(">");
                    if (n == -1 || n6 == -1 || n > n6) continue;
                    String string14 = string.substring(n + 1, n6);
                    MIRParsedType mIRParsedType = new MIRParsedType();
                    mIRParsedType.setTypeName(HIVE_COLLECTION[0]);
                    mIRParsedType.setNativeDataType(string);
                    mIRParsedType.setCollection(true);
                    mIRParsedType.setCollectionElement(string14);
                    mIRParsedType.setCollectionElementType(MIRParsedType.parseSqlType(string14));
                    return mIRParsedType;
                }
            }
            return MIRParsedType.parseSqlType(string);
        }

        public static MIRParsedType parseSqlType(String string) {
            MIRParsedType mIRParsedType = new MIRParsedType();
            String string2 = null;
            int n = string.indexOf(40);
            if (n != -1) {
                String string3 = string.substring(0, n).trim();
                String string4 = "";
                String string5 = "";
                string2 = string.substring(n + 1, string.length());
                int n2 = string2.indexOf(41);
                int n3 = string2.indexOf(44);
                if (n3 != -1 && n2 != -1) {
                    if (n3 < n2) {
                        string4 = string2.substring(0, n3);
                        string5 = string2.substring(n3 + 1, n2);
                        string3 = string3 + string2.substring(n2 + 1);
                    } else {
                        string4 = string2.substring(0, n2);
                        string5 = "";
                        string3 = string3 + string2.substring(n3 + 1);
                    }
                } else if (n3 != -1 && n2 == -1) {
                    string4 = string2.substring(0, n3);
                    string5 = string2.substring(n3 + 1);
                } else if (n3 == -1 && n2 != -1) {
                    string4 = string2.substring(0, n2);
                    if ((string2 = string2.substring(n2 + 1)) != null) {
                        n = string2.indexOf(40);
                        if (n != -1) {
                            string3 = string3 + string2.substring(0, n);
                            n2 = string2.indexOf(41, n);
                            if (n2 != -1) {
                                string5 = string2.substring(n + 1, n2);
                                string3 = string3 + string2.substring(n2 + 1);
                            } else {
                                string5 = string2.substring(n + 1);
                            }
                        } else {
                            string3 = string3 + string2;
                        }
                    }
                } else if (n3 == -1 && n2 == -1) {
                    string4 = string2;
                }
                mIRParsedType.setTypeName(string3);
                mIRParsedType.setNativeDataType(string);
                mIRParsedType.setLength(string4);
                mIRParsedType.setScale(string5);
            } else {
                mIRParsedType.setTypeName(string);
                mIRParsedType.setNativeDataType(string);
                mIRParsedType.setLength("");
                mIRParsedType.setScale("");
            }
            return mIRParsedType;
        }
    }
}

