/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.MIRException;
import MITI.bridges.datatypelib.ExportDataTypeInfo;
import MITI.bridges.datatypelib.MIRDTTool;
import MITI.bridges.datatypelib.MIRDTTools;
import MITI.bridges.datatypelib.MIRDataStore;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.messages.MIRModelBridge.DTLIB;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRType;
import java.util.HashSet;

public class MIRDataTypeConverter {
    private String toolID = null;
    boolean useNativeType = false;
    private MIRDTTool targetTool = null;
    private MIRDataStore targetStore = null;
    private int targetVersionIndex = -1;
    private static HashSet<String> versions = new HashSet();

    private boolean isValid() {
        return this.targetStore != null && this.targetTool != null && this.targetVersionIndex >= 0;
    }

    private void ensureValid(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        if (!this.isValid()) {
            String string = DTLIB.ERROR_CREATE_DT_CONVERTER.getMessage(this.toolID, mIRDataStoreVersion.toString());
            throw new MIRException(string);
        }
        this.targetTool.validate();
    }

    private void doConstruct(MIRDataStoreVersion mIRDataStoreVersion, String string) throws MIRException {
        MIRDTTools mIRDTTools = MIRDTTools.getTools();
        if (string.isEmpty()) {
            for (MIRDTTool mIRDTTool : mIRDTTools.getToolsCollection()) {
                this.targetStore = mIRDTTool.findDataStore(mIRDataStoreVersion.getDataStoreType());
                if (this.targetStore == null) continue;
                this.targetVersionIndex = this.targetStore.findMatchingVersionIndex(mIRDataStoreVersion);
                this.targetTool = mIRDTTool;
                break;
            }
        } else {
            this.toolID = string;
            this.targetTool = mIRDTTools.findTool(string);
            if (this.targetTool != null) {
                this.targetStore = this.targetTool.findDataStore(mIRDataStoreVersion.getDataStoreType());
                if (this.targetStore != null) {
                    this.targetVersionIndex = this.targetStore.findMatchingVersionIndex(mIRDataStoreVersion);
                }
            }
        }
    }

    public MIRDataTypeConverter(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        this(mIRDataStoreVersion, "MIRGENERIC");
    }

    public MIRDataTypeConverter(MIRDataStoreVersion mIRDataStoreVersion, String string) throws MIRException {
        if (mIRDataStoreVersion.isValid()) {
            this.doConstruct(mIRDataStoreVersion, string);
        }
        this.ensureValid(mIRDataStoreVersion);
        this.logUsedMappingsInfo();
    }

    public MIRDataTypeConverter(MIRDataStoreVersion mIRDataStoreVersion, MIRDataStoreVersion mIRDataStoreVersion2) throws MIRException {
        this(mIRDataStoreVersion, mIRDataStoreVersion2, "MIRGENERIC");
    }

    public MIRDataTypeConverter(MIRDataStoreVersion mIRDataStoreVersion, MIRDataStoreVersion mIRDataStoreVersion2, String string) throws MIRException {
        this(mIRDataStoreVersion2, string);
        this.useNativeType = mIRDataStoreVersion.getDataStoreType().compareToIgnoreCase(mIRDataStoreVersion2.getDataStoreType()) == 0;
    }

    public MIRDerivedType getImportType(String string, int n, int n2, String string2) {
        MIRDerivedType mIRDerivedType = this.targetStore.getImportType(this.targetVersionIndex, string, n, n2, string2);
        return mIRDerivedType;
    }

    public String getImportTypeName(String string) {
        if (MIRDataTypeLib.isEmpty(string)) {
            return "undefined";
        }
        return this.targetStore.getImportTypeName(this.targetVersionIndex, string);
    }

    public static boolean isUndefined(MIRType mIRType) {
        return mIRType == null ? true : MIRBaseTypeList.isMIRUndefined(mIRType.getDataType());
    }

    public static boolean isUndefined(String string) {
        return MIRDataTypeLib.isEmpty(string) ? true : MIRBaseTypeList.isMIRUndefined(string);
    }

    public ExportDataTypeInfo getExportType(MIRType mIRType) throws MIRException {
        boolean bl = this.useNativeType;
        String string = mIRType.getNativeDataType();
        if (string != null && "xml".compareToIgnoreCase(string) == 0) {
            bl = true;
        }
        ExportDataTypeInfo exportDataTypeInfo = this.targetStore.getExportType(this.targetVersionIndex, mIRType, bl);
        return exportDataTypeInfo;
    }

    public String getExportTypeName(String string) throws MIRException {
        return this.targetStore.getExportTypeName(this.targetVersionIndex, string);
    }

    public boolean canUseNativeDatatype(ExportDataTypeInfo exportDataTypeInfo, MIRType mIRType) {
        return this.useNativeType && MIRDataTypeLib.isEmpty(exportDataTypeInfo.getNativeType()) && !MIRDataTypeLib.isEmpty(mIRType.getNativeDataType());
    }

    public MIRDataStoreVersion getTargetDataStore() {
        if (!this.isValid()) {
            return null;
        }
        MIRDataStoreVersion mIRDataStoreVersion = this.targetStore.getDataStoreVersion(this.targetVersionIndex);
        if (mIRDataStoreVersion != null && mIRDataStoreVersion.isValid()) {
            return mIRDataStoreVersion;
        }
        return null;
    }

    public static MIRDataStoreVersion findClosestImportVersion(MIRDataStoreVersion mIRDataStoreVersion, String string) throws MIRException {
        String string2 = MIRDataTypeLib.isEmpty(string) ? "MIRGENERIC" : string;
        MIRDTTools mIRDTTools = MIRDTTools.getTools();
        MIRDTTool mIRDTTool = mIRDTTools.findTool(string2);
        if (mIRDTTool == null) {
            return null;
        }
        MIRDataStore mIRDataStore = mIRDTTool.findDataStore(mIRDataStoreVersion.getDataStoreType());
        if (mIRDataStore == null) {
            return null;
        }
        int n = mIRDataStore.findMatchingImportVersionIndex(mIRDataStoreVersion);
        MIRDataStoreVersion mIRDataStoreVersion2 = mIRDataStore.getDataStoreVersion(n);
        return mIRDataStoreVersion2;
    }

    public static MIRDataStoreVersion findClosestExportVersion(MIRDataStoreVersion mIRDataStoreVersion, String string) throws MIRException {
        String string2 = MIRDataTypeLib.isEmpty(string) ? "MIRGENERIC" : string;
        MIRDTTools mIRDTTools = MIRDTTools.getTools();
        MIRDTTool mIRDTTool = mIRDTTools.findTool(string2);
        if (mIRDTTool == null) {
            return null;
        }
        MIRDataStore mIRDataStore = mIRDTTool.findDataStore(mIRDataStoreVersion.getDataStoreType());
        if (mIRDataStore == null) {
            return null;
        }
        int n = mIRDataStore.findMatchingExportVersionIndex(mIRDataStoreVersion);
        MIRDataStoreVersion mIRDataStoreVersion2 = mIRDataStore.getDataStoreVersion(n);
        return mIRDataStoreVersion2;
    }

    private void logUsedMappingsInfo() {
        MIRDataStoreVersion mIRDataStoreVersion = this.getTargetDataStore();
        if (mIRDataStoreVersion != null) {
            String string = mIRDataStoreVersion.toString();
            if (versions.add(string)) {
                DTLIB.USING_DATATYPE_MAPPINGS.log(string);
            }
        } else {
            DTLIB.ERROR_NO_DATASTORE.log(new Object[0]);
        }
    }
}

