/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.bridges.datatypelib.MIRToolVersion;
import MITI.sdk.MIRSystemPackage;
import java.util.regex.Pattern;

public class MIRDataStoreVersion
implements Comparable<MIRDataStoreVersion> {
    protected String dataStoreType;
    protected String dataStoreDisplayName;
    protected String displayName;
    protected int major;
    protected int minor;
    protected int release;
    private static final Pattern dotPattern = Pattern.compile("[.]");

    private void copyFrom(MIRDataStoreVersion mIRDataStoreVersion) {
        this.dataStoreType = mIRDataStoreVersion.dataStoreType;
        this.major = mIRDataStoreVersion.major;
        this.minor = mIRDataStoreVersion.minor;
        this.release = mIRDataStoreVersion.release;
    }

    public MIRDataStoreVersion() {
        this.invalidate();
    }

    public MIRDataStoreVersion(MIRDataStoreVersion mIRDataStoreVersion) {
        this.copyFrom(mIRDataStoreVersion);
    }

    public MIRDataStoreVersion(String string, int n, int n2, int n3) {
        this.dataStoreType = string;
        this.major = n;
        this.minor = n2;
        this.release = n3;
    }

    public MIRDataStoreVersion(MIRSystemPackage mIRSystemPackage) {
        MIRDataStoreVersion mIRDataStoreVersion = MIRDataTypeLib.getDataStore(mIRSystemPackage);
        if (mIRDataStoreVersion.isValid()) {
            this.copyFrom(mIRDataStoreVersion);
        } else {
            this.invalidate();
        }
    }

    public String getDataStoreType() {
        return this.dataStoreType;
    }

    public String getDataStoreDisplayName() {
        return this.dataStoreDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getReleaseVersion() {
        return this.release;
    }

    public boolean isValid() {
        return this.dataStoreType != null && this.major >= 0 && this.minor >= 0 && this.release >= 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.dataStoreType);
        stringBuilder.append(' ').append(this.major).append('.').append(this.minor).append('.').append(this.release);
        return stringBuilder.toString();
    }

    public String serialize() {
        return this.toString();
    }

    private static boolean isDigits(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public boolean deserialize(String string) {
        char c;
        if (string == null) {
            this.invalidate();
            return false;
        }
        int n = 1 + string.lastIndexOf(46);
        if (n <= 0) {
            this.invalidate();
            return false;
        }
        int n2 = 1 + string.lastIndexOf(46, n - 2);
        if (n2 <= 0) {
            this.invalidate();
            return false;
        }
        int n3 = -1;
        int n4 = n2 - 2;
        while (n4 >= 0 && Character.isDigit(c = string.charAt(n4))) {
            n3 = n4--;
        }
        if (n3 <= 0) {
            this.invalidate();
            return false;
        }
        this.dataStoreType = string.substring(0, n3).trim();
        if (this.dataStoreType.length() == 0) {
            this.invalidate();
            return false;
        }
        String string2 = string.substring(n3).trim();
        String[] stringArray = dotPattern.split(string2);
        if (stringArray == null || stringArray.length < 3) {
            this.invalidate();
            return false;
        }
        if (!(MIRDataStoreVersion.isDigits(stringArray[0]) && MIRDataStoreVersion.isDigits(stringArray[1]) && MIRDataStoreVersion.isDigits(stringArray[2]))) {
            this.invalidate();
            return false;
        }
        try {
            this.major = Integer.parseInt(stringArray[0].trim());
            this.minor = Integer.parseInt(stringArray[1].trim());
            this.release = Integer.parseInt(stringArray[2].trim());
            return true;
        }
        catch (RuntimeException runtimeException) {
            this.invalidate();
            throw runtimeException;
        }
    }

    @Override
    public int compareTo(MIRDataStoreVersion mIRDataStoreVersion) {
        int n = 0;
        n = this.dataStoreType.compareToIgnoreCase(mIRDataStoreVersion.dataStoreType);
        if (n != 0) {
            return n;
        }
        n = this.major - mIRDataStoreVersion.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - mIRDataStoreVersion.minor;
        if (n != 0) {
            return n;
        }
        n = this.release - mIRDataStoreVersion.release;
        if (n != 0) {
            return n;
        }
        return n;
    }

    public boolean isSupportedByToolVersion(MIRToolVersion mIRToolVersion) {
        return true;
    }

    private void invalidate() {
        this.dataStoreType = null;
        this.major = -1;
        this.minor = 0;
        this.release = 0;
    }
}

