/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.MIRException;
import MITI.bridges.datatypelib.MIRDataStore;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.messages.MIRModelBridge.DTLIB;
import java.util.TreeMap;
import java.util.TreeSet;

class MIRDTTool {
    private boolean wasValidated = false;
    private String toolID;
    private TreeMap<String, MIRDataStore> dataStores;

    MIRDTTool(String string) {
        this.toolID = string;
        this.dataStores = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    String getToolID() {
        return this.toolID;
    }

    void addDataStore(MIRDataStore mIRDataStore) {
        this.dataStores.put(mIRDataStore.getType(), mIRDataStore);
    }

    private boolean isStore(MIRDataStore mIRDataStore, String string) {
        if (string.equalsIgnoreCase(mIRDataStore.getType())) {
            return true;
        }
        TreeSet<String> treeSet = mIRDataStore.getAliases();
        return treeSet != null && treeSet.contains(string);
    }

    private MIRDataStore findWithAliases(String string) {
        for (MIRDataStore mIRDataStore : this.dataStores.values()) {
            if (!this.isStore(mIRDataStore, string)) continue;
            return mIRDataStore;
        }
        return null;
    }

    MIRDataStore findDataStore(String string) {
        if (MIRDataTypeLib.isEmpty(string)) {
            return null;
        }
        if (this.isMirGeneric()) {
            return this.dataStores.get(string);
        }
        return this.findWithAliases(string);
    }

    void validate() throws MIRException {
        if (this.wasValidated) {
            return;
        }
        DTLIB.MSG_VALIDATING_DATASTORES.log(this.toolID);
        for (MIRDataStore mIRDataStore : this.dataStores.values()) {
            mIRDataStore.validate();
        }
        this.wasValidated = true;
    }

    boolean isMirGeneric() {
        return "MIRGENERIC".equalsIgnoreCase(this.toolID);
    }
}

