/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.datatypelib;

import MITI.MIRException;
import MITI.bridges.datatypelib.DataTypeImportMapping;
import MITI.bridges.datatypelib.ExportDataTypeInfo;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.messages.MIRModelBridge.DTLIB;
import MITI.sdk.MIRBaseTypeList;
import java.util.HashMap;
import java.util.TreeMap;

class DataStoreVersionInternal
extends MIRDataStoreVersion {
    private HashMap<String, DataTypeImportMapping> importMap = null;
    private TreeMap<String, ExportDataTypeInfo> exportMap = null;

    DataStoreVersionInternal(String string, int n, int n2, int n3) {
        super(string, n, n2, n3);
    }

    void addImportMapping(DataTypeImportMapping dataTypeImportMapping) {
        if (this.importMap == null) {
            this.importMap = new HashMap();
        }
        String string = dataTypeImportMapping.getStoreDatatype().toUpperCase();
        this.importMap.put(string, dataTypeImportMapping);
    }

    void addExportMapping(ExportDataTypeInfo exportDataTypeInfo) {
        if (this.exportMap == null) {
            this.exportMap = new TreeMap();
        }
        String string = exportDataTypeInfo.getMirDatatype().toUpperCase();
        this.exportMap.put(string, exportDataTypeInfo);
    }

    DataTypeImportMapping findImportMapping(String string) {
        return this.importMap == null ? null : this.importMap.get(string.toUpperCase());
    }

    ExportDataTypeInfo findExportMapping(String string) {
        return this.exportMap == null ? null : this.exportMap.get(string.toUpperCase());
    }

    private void validateImportMirTypes() throws MIRException {
        if (this.importMap == null || this.importMap.isEmpty()) {
            return;
        }
        for (DataTypeImportMapping dataTypeImportMapping : this.importMap.values()) {
            String string = dataTypeImportMapping.getMirDatatype();
            String string2 = MIRBaseTypeList.isMIRUndefined(string) ? string : string.toUpperCase();
            if (MIRBaseTypeList.isMIRType(string2)) continue;
            throw new MIRException(DTLIB.E_IMPORT_INVALID_MIR_TYPE.getMessage(dataTypeImportMapping.getMirDatatype(), this.toString()));
        }
    }

    private void validateExportTypes() throws MIRException {
        if (this.exportMap == null || this.exportMap.isEmpty()) {
            return;
        }
        for (ExportDataTypeInfo exportDataTypeInfo : this.exportMap.values()) {
            String string;
            String string2 = exportDataTypeInfo.getMirDatatype();
            String string3 = string = MIRBaseTypeList.isMIRUndefined(string2) ? string2 : string2.toUpperCase();
            if (!MIRBaseTypeList.isMIRType(string)) {
                throw new MIRException(DTLIB.E_EXPORT_INVALID_MIR_TYPE.getMessage(exportDataTypeInfo.getMirDatatype(), this.toString()));
            }
            string2 = exportDataTypeInfo.getStoreDatatype();
            if (!MIRDataTypeLib.isEmpty(string2)) continue;
            throw new MIRException(DTLIB.E_MISSING_EXPORT_MAPPING.getMessage(exportDataTypeInfo.getMirDatatype(), this.toString()));
        }
    }

    void validate() throws MIRException {
        if (this.importMap != null) {
            this.validateImportMirTypes();
        }
        if (this.exportMap != null) {
            this.validateExportTypes();
        }
    }

    int getExportMappingCount() {
        return this.exportMap == null ? 0 : this.exportMap.size();
    }

    boolean hasImport() {
        return this.importMap != null && !this.importMap.isEmpty();
    }

    boolean hasExport() {
        return this.exportMap != null && !this.exportMap.isEmpty();
    }
}

