/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.dataquality;

import MITI.MIRException;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.bridges.javabridgeinterface.ClassPath;
import MITI.bridges.mimb.MIRSetup;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.Exec;
import MITI.util.Pair;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DataQualityUtil {
    private DataQualityUtil() {
    }

    public static void resolveExternalDependencies(BridgeEnvironment bridgeEnvironment, ClassPath classPath, MIRLogger mIRLogger) {
        DataQualityUtil.resolveExternalDependencies(bridgeEnvironment.getJavaDirectory(), classPath, mIRLogger);
    }

    public static int detectSemanticTypes(String string, String string2, PrintStream printStream, PrintStream printStream2) throws IOException, MIRException {
        ClassPath classPath = new ClassPath(MIRSetup.getDefault(), MIRLogger.getNullLogger());
        File file = MIRSetup.getDefault().getJavaDirectory();
        classPath.addRelativePaths(file, "DataQuality.jar", "MIR.jar", "MIRUtil.jar", "MIRModelBridge.jar");
        File file2 = new File(file, "DataQuality");
        if (!file2.exists() || !file2.isDirectory()) {
            BLIB.DBG_DEBUG.log("directory path " + file2.getAbsolutePath() + " doesn't exists");
        }
        classPath.addRelativePaths(file2, "lucene-analyzers-common-7.7.2.jar", "lucene-core-7.7.2.jar", "lucene-queries-7.7.2.jar", "jackson-annotations-2.13.4.jar", "jackson-core-2.13.4.jar", "jackson-databind-2.13.4.2.jar", "libphonenumber-8.10.5.jar", "carrier-1.124.jar", "geocoder-2.134.jar", "prefixmapper-2.134.jar", "re2j-1.2.jar");
        String[] stringArray = new String[]{MIRSetup.getDefault().getJavaExecutable(), "-Dmimb.home=" + MIRSetup.getDefault().getHomeDirectory().getPath(), "-Dmimb.data=" + MIRSetup.getDefault().getDataDirectory().getPath(), "-cp", classPath.build(), "MITI.dataquality.semantic.Classifier", "-i", string, "-o", string2};
        return Exec.exec(stringArray, null, null, printStream, printStream2, FileUtil.UTF8);
    }

    public static Map<String[], List<String>> readClassificationRequest(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Map<String[], List<String>> map = new LinkedHashMap<String[], List<String>>();
        if (!file.exists() || !file.isFile()) {
            return map;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            SAXRequestClassificationHandler sAXRequestClassificationHandler = new SAXRequestClassificationHandler();
            sAXParser.parse(new InputSource(inputStreamReader), (DefaultHandler)sAXRequestClassificationHandler);
            map = sAXRequestClassificationHandler.results;
        }
        return map;
    }

    public static Map<ObjectIdentifier, List<Pair<String, int[]>>> readClassificationResponse(File file) throws UnsupportedEncodingException, FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Map<ObjectIdentifier, List<Pair<String, int[]>>> map = new HashMap<ObjectIdentifier, List<Pair<String, int[]>>>();
        if (file == null || !file.isFile()) {
            return map;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            SAXResponseClassificationHandler sAXResponseClassificationHandler = new SAXResponseClassificationHandler();
            sAXParser.parse(new InputSource(inputStreamReader), (DefaultHandler)sAXResponseClassificationHandler);
            map = sAXResponseClassificationHandler.results;
        }
        return map;
    }

    public static int exportSemanticTypes(String string, PrintStream printStream, PrintStream printStream2) throws IOException, MIRException {
        ClassPath classPath = new ClassPath(MIRSetup.getDefault(), MIRLogger.getNullLogger());
        File file = MIRSetup.getDefault().getJavaDirectory();
        classPath.addRelativePaths(file, "DataQuality.jar", "MIR.jar", "MIRUtil.jar", "MIRModelBridge.jar");
        File file2 = new File(file, "DataQuality");
        if (!file2.exists() || !file2.isDirectory()) {
            BLIB.DBG_DEBUG.log("directory path " + file2.getAbsolutePath() + " doesn't exists");
        }
        classPath.addRelativePaths(file2, "lucene-analyzers-common-4.10.4.jar", "lucene-core-4.10.4.jar", "lucene-queries-4.10.4.jar", "jackson-annotations-2.13.4.jar", "jackson-core-2.13.4.jar", "jackson-databind-2.13.4.2.jar");
        String[] stringArray = new String[]{MIRSetup.getDefault().getJavaExecutable(), "-Dmimb.home=" + MIRSetup.getDefault().getHomeDirectory().getPath(), "-Dmimb.data=" + MIRSetup.getDefault().getDataDirectory().getPath(), "-cp", classPath.build(), "MITI.semantictypes.SemanticTypesExport", "-s", string};
        return Exec.exec(stringArray, null, null, printStream, printStream2, FileUtil.UTF8);
    }

    private static void resolveExternalDependencies(File file, ClassPath classPath, MIRLogger mIRLogger) {
        classPath.addRelativePaths(new File(file, "DataQuality"), "commons-collections-3.2.2.jar", "commons-io-2.11.0.jar", "commons-lang-2.6.jar", "commons-lang3-3.3.2.jar", "commons-math3-3.3.jar", "daikon-1.12.0.jar", "dataprep-backend-common-2.5.2.jar", "dataquality-common-6.3.7.jar", "dataquality-record-linkage-6.3.7.jar", "dataquality-standardization-6.3.7.jar", "dataquality-semantic-6.3.7.jar", "dataquality-semantic-model-6.3.7.jar", "dataquality-statistics-6.3.7.jar", "jackson-annotations-2.13.4.jar", "jackson-core-2.13.4.jar", "jackson-databind-2.13.4.2.jar", "multitenant-core-0.23.0.jar", "slf4j-api-1.7.32.jar", "slf4j-nop-1.7.32.jar", "stream-2.9.0.jar", "re2j-1.2.jar");
    }

    private static class SAXRequestClassificationHandler
    extends DefaultHandler {
        Map<String[], List<String>> results = new LinkedHashMap<String[], List<String>>();
        StringBuilder currentStrValues;
        List<String> currentValues;

        private SAXRequestClassificationHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("feature".equals(string3)) {
                String string4 = attributes.getValue("id");
                String string5 = attributes.getValue("name");
                this.currentValues = new LinkedList<String>();
                this.results.put(new String[]{string4, string5}, this.currentValues);
            } else if ("values".equals(string3)) {
                this.currentStrValues = new StringBuilder();
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("values".equals(string3) && this.currentStrValues != null && this.currentValues != null) {
                String[] stringArray = this.currentStrValues.toString().split("\u2028");
                this.currentValues.addAll(Arrays.asList(stringArray));
                this.currentStrValues = null;
                this.currentValues = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentStrValues != null) {
                this.currentStrValues.append(cArray, n, n2);
            }
        }
    }

    private static class SAXResponseClassificationHandler
    extends DefaultHandler {
        Map<ObjectIdentifier, List<Pair<String, int[]>>> results = new HashMap<ObjectIdentifier, List<Pair<String, int[]>>>();
        List<Pair<String, int[]>> currentCategories;

        private SAXResponseClassificationHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("feature".equals(string3)) {
                String string4 = attributes.getValue("id");
                ObjectIdentifier objectIdentifier = ObjectIdentifier.deserialize(string4);
                this.currentCategories = new LinkedList<Pair<String, int[]>>();
                this.results.put(objectIdentifier, this.currentCategories);
            } else if ("category".equals(string3) && this.currentCategories != null) {
                String string5 = attributes.getValue("name");
                String string6 = attributes.getValue("count");
                String string7 = attributes.getValue("score");
                int n = !string6.isEmpty() ? Integer.valueOf(string6) : 0;
                float f = !string7.isEmpty() ? Float.valueOf(string7).floatValue() : 0.0f;
                this.currentCategories.add(new Pair<String, int[]>(string5, new int[]{n, (int)(f * 100.0f)}));
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("feature".equals(string3)) {
                this.currentCategories = null;
            }
        }
    }
}

