/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.cache;

import MITI.MIRException;
import MITI.bridges.mimb.MIRSetup;
import MITI.sdk.MIRDate;
import MITI.server.services.common.LogEvent;
import MITI.util.file.FileUtil;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.IOException;

class MIMBCacheUtil {
    static final int BRIDGE_CACHE_MAJOR_VERSION = 2;
    static final int IO_BUF_SIZE = 4096;
    static final String UTF8 = "UTF-8";
    static final String ID_FILE_NAME = "id.txt";
    static final String NATIVE_FILE_NAME = "model.";
    static final String XMI_FILE_NAME = "model.xml";
    static final int MAX_SEQ = 10000;
    private static String invalidFileNameChars = "\\/:*?\"<>|";

    MIMBCacheUtil() {
    }

    static File getMimbCacheDir() throws MIRException {
        File file = MIRSetup.getDefault().getDataDirectory();
        return new File(file, "MIMB" + File.separatorChar + "cache");
    }

    static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static String getStringHashCode(String string) {
        long l = string.length() << 24;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            l = 31L * l + (long)c;
        }
        if (l < 0L) {
            l = -l;
        }
        return String.valueOf(l);
    }

    static boolean isValidFileName(File file, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (invalidFileNameChars.indexOf(string.charAt(i)) < 0) continue;
            return false;
        }
        File file2 = new File(file, string + "__");
        if (file2.exists()) {
            return false;
        }
        if (file2.mkdirs()) {
            return file2.delete();
        }
        return false;
    }

    static String readFile(File file) {
        return FileUtil.readContent(file, FileUtil.UTF8);
    }

    static void writeFile(File file, String string) {
        FileUtil.writeContent(file, string, FileUtil.UTF8);
    }

    static boolean createForWriting(File file) throws MIRException {
        try {
            return file.createNewFile() && file.canWrite();
        }
        catch (IOException iOException) {
            throw new MIRException(iOException.getMessage(), iOException);
        }
    }

    static String mid(String string, int n, int n2) {
        if (string == null) {
            return "";
        }
        int n3 = string.length();
        if (n > n3 || n2 == 0) {
            return "";
        }
        int n4 = n + n2;
        return n4 > n3 ? string.substring(n) : string.substring(n, n4);
    }

    static String left(String string, int n) {
        if (string == null || n <= 0) {
            return "";
        }
        return n > string.length() ? string : string.substring(0, n);
    }

    static void log(int n, String string, Throwable throwable) {
        LogEvent logEvent = new LogEvent();
        logEvent.setLevel(n);
        logEvent.setText(string);
        if (throwable != null) {
            logEvent.setStackTrace(throwable);
        }
        MIRLogger mIRLogger = MIRLogger.getLogger();
        mIRLogger.log(logEvent);
    }

    static final void logInfo(String string, Throwable throwable) {
        MIMBCacheUtil.log(5, string, throwable);
    }

    static final void logDebug(String string, Throwable throwable) {
        MIMBCacheUtil.log(6, string, throwable);
    }

    static final void logWarning(String string, Throwable throwable) {
        MIMBCacheUtil.log(3, string, throwable);
    }

    static final void logError(String string, Throwable throwable) {
        MIMBCacheUtil.log(2, string, throwable);
    }

    static long getTimeInMillis(MIRDate mIRDate) {
        return mIRDate.get().getTimeInMillis();
    }
}

