/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.cache;

import MITI.MIRException;
import MITI.bridges.cache.MIMBCacheUtil;
import MITI.messages.MIRModelBridge.MBCCH;
import MITI.sdk.MIRDate;
import MITI.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;

public class MIMBCacheResourceFile {
    private File readyFile;
    private File flagFile;
    private File newFile;
    private boolean written;
    private static final String READY_FILE_FORMAT = "%s.%s.%d.r.%s";
    private static final String NEW_FILE_FORMAT = "%s.%s.%d.w%d.%s";
    private static final String FLAG_FILE_FORMAT = "%s.%s.%d.f%d.%s";

    public MIMBCacheResourceFile(File file, String string, MIRDate mIRDate, String string2) throws MIRException {
        int n;
        String string3 = string = string.toLowerCase();
        String string4 = "";
        long l = MIMBCacheUtil.getTimeInMillis(mIRDate);
        String string5 = String.format(READY_FILE_FORMAT, string3, string4, l, string2);
        if (!MIMBCacheUtil.isValidFileName(file, string5)) {
            string3 = MIMBCacheUtil.getStringHashCode(string);
            for (n = 0; n <= 10000; ++n) {
                string4 = String.valueOf(n);
                String string6 = String.format(READY_FILE_FORMAT, string3, string4, l, "id.txt");
                File file2 = new File(file, string6);
                if (file2.isFile()) {
                    if (string.equals(MIMBCacheUtil.readFile(file2))) {
                        break;
                    }
                } else if (MIMBCacheUtil.createForWriting(file2)) {
                    MIMBCacheUtil.writeFile(file2, string);
                    break;
                }
                if (n < 10000) continue;
                throw new MIRException(MBCCH.ERR_GENERATE_FILE_NAME.getMessage(string, FileUtil.getCanonicalPath(file)));
            }
            string5 = String.format(READY_FILE_FORMAT, string3, string4, l, string2);
        }
        this.readyFile = new File(file, string5);
        if (this.readyFile.isFile()) {
            this.written = true;
        } else {
            this.written = false;
            for (n = 0; n <= 10000; ++n) {
                this.flagFile = new File(file, String.format(FLAG_FILE_FORMAT, string3, string4, l, n, string2));
                if (MIMBCacheUtil.createForWriting(this.flagFile)) {
                    this.newFile = new File(file, String.format(NEW_FILE_FORMAT, string3, string4, l, n, string2));
                    break;
                }
                if (n < 10000) continue;
                throw new MIRException(MBCCH.ERR_GENERATE_FILE_NAME.getMessage(this.flagFile.getName(), FileUtil.getCanonicalPath(file)));
            }
        }
    }

    public boolean isWritten() {
        return this.written;
    }

    public File setWritten() throws IOException {
        if (!this.written) {
            if (!this.readyFile.isFile()) {
                for (int i = 0; i <= 5; ++i) {
                    try {
                        Files.move(this.newFile.toPath(), this.readyFile.toPath(), new CopyOption[0]);
                        break;
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        break;
                    }
                    catch (IOException iOException) {
                        if (i == 5) {
                            throw new IOException(MBCCH.ERR_FILE_RENAME.getMessage(this.newFile.getAbsolutePath(), iOException.getMessage()), iOException);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
            Files.deleteIfExists(this.newFile.toPath());
            Files.deleteIfExists(this.flagFile.toPath());
        }
        this.written = true;
        return this.readyFile;
    }

    public File getFile() {
        return this.written ? this.readyFile : this.newFile;
    }
}

