/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.parsers.ParserBase;
import MITI.bridges.bridgelib.parsers.RelationalParser;
import MITI.bridges.datatypelib.ExportDataTypeInfo;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeConverter;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.expression.datatypes.MIRExpressionDataType;
import MITI.expression.util.Util;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIR_Object;
import MITI.sdk.util.ObjectCollector;
import MITI.util.StringUtil;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;

public class SQLViewParser
extends RelationalParser {
    private final MIRSQLViewEntity view;
    private final boolean createSrc;
    private final boolean createDst;
    private final boolean applyDataTypes;
    private final boolean supportDoubleQuoteStrings;
    private boolean redo;

    private SQLViewParser(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, MIRSQLViewEntity mIRSQLViewEntity, MIRSystemPackage mIRSystemPackage, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2) {
        super(mIRLogger, mIRStoreModel, mIRSQLViewEntity, n, n2, string);
        if (mIRSystemPackage != null) {
            this.defaultCatalog = mIRSystemPackage;
        }
        this.createSrc = bl3;
        this.createDst = bl4;
        this.view = mIRSQLViewEntity;
        this.applyDataTypes = bl;
        this.supportDoubleQuoteStrings = bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        MIRElementNode mIRElementNode = lookupOptions.getNode();
        if (mIRElementNode.getDestinationElementType() == 75) {
            void var10_22;
            void var10_19;
            Object object;
            MIRElement mIRElement;
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
            List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
            String string = mIRElementNamePart.getName();
            boolean bl = mIRElementNamePart.getQuoted();
            MIRDataPackage mIRDataPackage = this.getDataPackage(mIRElementNode, false);
            if (mIRDataPackage == null) {
                StringBuilder comparable = new StringBuilder();
                if (list.size() > 1) {
                    if (list.size() > 2) {
                        comparable.append(list.get(list.size() - 3).getName() + ".");
                    }
                    comparable.append(list.get(list.size() - 2).getName());
                }
                if (this.createSrc) {
                    mIRDataPackage = this.getDataPackage(mIRElementNode, true);
                }
                if (mIRDataPackage != null) {
                    BLIB.MSG_NEW_SCHEMA_CREATED_FROM_SQL.log(this.getLog(), comparable.toString(), SQLViewParser.buildQualifiedName(this.view, new String[0]));
                } else {
                    BLIB.WRN_CANNOT_DETECT_SCHEMA_FOR_VIEW.log(this.getLog(), comparable.toString(), SQLViewParser.buildQualifiedName(this.view, new String[0]));
                    return;
                }
            }
            if ((mIRElement = this.getClassifier(string, bl, mIRDataPackage)) == null) {
                object = this.getAlternativeDataPackages(mIRElementNode);
                int n = ((MIRDataPackage[])object).length;
                for (int i = 0; i < n; ++i) {
                    MIRDataPackage mIRDataPackage2;
                    mIRDataPackage = mIRDataPackage2 = object[i];
                    MIRElement mIRElement2 = this.getClassifier(string, bl, mIRDataPackage2);
                }
            }
            if (var10_19 == null && mIRElementNode.getElementNamePartCount() == 1 && this.defaultSchemaName != null && !this.defaultSchemaName.isEmpty()) {
                mIRDataPackage = this.getDataPackage("", this.defaultSchemaName, true, true);
                MIRElement mIRElement3 = this.getClassifier(string, bl, mIRDataPackage);
            }
            if (var10_22 != null) {
                collection2.add((MIRElement)var10_22);
            } else if (mIRDataPackage.getElementType() == 215) {
                object = this.view.getNamespace();
                MIRClass mIRClass = new MIRClass();
                mIRClass.setName(string);
                if (((MIR_Object)object).isInstanceOf((short)9)) {
                    BLIB.MSG_NEW_CLASSIFIER_CREATED_FROM_SQL.log(SQLViewParser.buildQualifiedName((MIRObject)object, string), SQLViewParser.buildQualifiedName(this.view, new String[0]));
                    ((MIRNamespace)object).addNamespaceElementUniqueName(mIRClass);
                    mIRDataPackage.addImportedNamespaceElement(mIRClass);
                    if (!string.equals(mIRClass.getName())) {
                        BLIB.WRN_NEW_CLASSIFIER_CREATED_FROM_SQL_RENAMED.log(this.getLog(), SQLViewParser.buildQualifiedName((MIRObject)object, string), mIRClass.getName());
                    } else {
                        this.setCollationLineageOption(mIRClass, bl);
                    }
                } else {
                    BLIB.MSG_NEW_CLASSIFIER_CREATED_FROM_SQL.log(SQLViewParser.buildQualifiedName(mIRDataPackage, string), SQLViewParser.buildQualifiedName(this.view, new String[0]));
                    mIRDataPackage.addNamespaceElementUniqueName(mIRClass);
                    if (!string.equals(mIRClass.getName())) {
                        BLIB.WRN_NEW_CLASSIFIER_CREATED_FROM_SQL_RENAMED.log(this.getLog(), SQLViewParser.buildQualifiedName(mIRDataPackage, string), mIRClass.getName());
                    } else {
                        this.setCollationLineageOption(mIRClass, bl);
                    }
                }
                collection2.add(mIRClass);
            } else {
                BLIB.WRN_VIEW_CANNOT_FIND_SOURCE.log(string, mIRDataPackage.getName(), SQLViewParser.buildQualifiedName(this.view, new String[0]));
            }
        } else if (mIRElementNode.getDestinationElementType() == 77) {
            List<MIRObject> list;
            int n;
            MIRElementNamePart mIRElementNamePart;
            MIRElementNamePart mIRElementNamePart2 = mIRElementNamePart = this.getDatabaseType() == 20 ? MIRDecorUtil.getFirstNotQualifiedPart(mIRElementNode) : null;
            if (mIRElementNamePart == null) {
                mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            if (this.getOptions().supportHierarchies()) {
                n = 0;
                list = mIRElementNode.getElementNamePartByPosition();
                for (int i = 0; i < list.size(); i += 1) {
                    if (list.get(i).getReferencedElementCount() <= 0) continue;
                    n = i;
                }
                while (n < list.size()) {
                    MIRElementNamePart mIRElementNamePart3 = list.get(n);
                    if (mIRElementNamePart3.getSourceElementType() == 77 || !linkedList.isEmpty() || mIRElementNamePart3 == mIRElementNamePart) {
                        MIRElement mIRElement;
                        linkedList.add(mIRElementNamePart3.getReferencedElementCount() == 1 && (mIRElement = mIRElementNamePart3.getReferencedElementIterator().next()) instanceof MIRFeature ? mIRElement.getName() : mIRElementNamePart3.getName());
                    }
                    n += 1;
                }
            } else {
                linkedList.add(mIRElementNamePart.getName());
            }
            n = mIRElementNamePart.getQuoted();
            List<MIRObject> list2 = list = !lookupOptions.isPositionBased() ? this.getFeatures(linkedList.toArray(new String[linkedList.size()]), n != 0, collection) : this.getFeaturesByPosition(lookupOptions.getPosition(), collection);
            if (list.isEmpty()) {
                for (MIRClassifier mIRClassifier : collection) {
                    MIRDataPackage mIRDataPackage = mIRClassifier.getDataPackage();
                    if (mIRDataPackage.getElementType() != 215) continue;
                    MIRAttribute mIRAttribute = null;
                    if (mIRClassifier.getElementType() == 13) {
                        mIRAttribute = new MIRAttribute();
                    } else if (mIRClassifier.getElementType() == 25) assert (false);
                    if (mIRAttribute == null) continue;
                    if (!lookupOptions.isPositionBased()) {
                        mIRAttribute.setName(StringUtil.join(linkedList, "."));
                    } else {
                        mIRAttribute.setPosition((short)lookupOptions.getPosition());
                        mIRAttribute.setLineageOption(512);
                        mIRAttribute.setName(":" + String.valueOf(lookupOptions.getPosition()));
                    }
                    if (collection.size() > 1) {
                        mIRAttribute.setLineageOption(1);
                    }
                    mIRAttribute.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                    mIRClassifier.addFeature(mIRAttribute);
                    if (!lookupOptions.isPositionBased()) {
                        this.setCollationLineageOption(mIRAttribute, n != 0);
                    }
                    list.add(mIRAttribute);
                }
            }
            collection2.addAll(list);
        }
    }

    @Override
    public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        MIRFeature mIRFeature = null;
        if (mIRClassifier != null) {
            Object object;
            String string = lookupOptions.getName();
            int n = lookupOptions.getPosition();
            List<MIRFeature> list = mIRClassifier.getFeatureByPosition();
            if (list.size() >= n && ((MIRFeature)(object = list.get(n - 1))).getElementType() != 84) {
                mIRFeature = object;
            }
            if (mIRFeature == null) {
                if (!this.createDst) {
                    BLIB.WRN_CANNOT_FIND_VIEWFEATURE_BY_POSITION.log(String.valueOf(n), SQLViewParser.buildQualifiedName(mIRClassifier, new String[0]));
                    return null;
                }
                this.redo = true;
                mIRFeature = new MIRSQLViewAttribute();
                mIRFeature.setPosition((short)n);
                mIRFeature.setName(!string.isEmpty() ? string : "noname");
                if (this.getApplyDataTypes() && !lookupOptions.getDataType().isEmpty()) {
                    try {
                        object = MIRExpressionDataType.deserialize(lookupOptions.getDataType());
                        MIRBaseType mIRBaseType = MIRTypeLib.getBaseType(this.model, ((MIRExpressionDataType)object).getInfo().getName());
                        MIRDataStoreVersion mIRDataStoreVersion = MIRDataTypeLib.getDataStore(this.model);
                        MIRDataTypeConverter mIRDataTypeConverter = new MIRDataTypeConverter(mIRDataStoreVersion);
                        ExportDataTypeInfo exportDataTypeInfo = mIRDataTypeConverter.getExportType(mIRBaseType);
                        MIRDerivedType mIRDerivedType = mIRDataTypeConverter.getImportType(exportDataTypeInfo.getStoreDatatype(), ((MIRExpressionDataType)object).getLength(), ((MIRExpressionDataType)object).getScale(), exportDataTypeInfo.getStoreDatatype());
                        MIRDerivedType mIRDerivedType2 = (MIRDerivedType)MIRTypeLib.getType(this.model, mIRDerivedType.getName(), mIRDerivedType.getElementType());
                        if (mIRDerivedType2 == null) {
                            mIRDerivedType.addDerivedFromConcreteType(MIRTypeLib.getBaseType(this.model, MIRBaseTypeList.getLogicalName(mIRDerivedType.getDataType())));
                            this.model.addType(mIRDerivedType);
                            mIRDerivedType2 = mIRDerivedType;
                        }
                        mIRFeature.addType(mIRDerivedType2);
                    }
                    catch (MIRException mIRException) {
                        BLIB.WRN_FAILED_TO_APPLY_DATATYPE.log(lookupOptions.getDataType(), SQLViewParser.buildQualifiedName(mIRClassifier, new String[0]), mIRFeature.getName());
                    }
                }
                boolean bl = this.view.addFeatureUniqueName(mIRFeature, '_');
                if (!string.isEmpty() && !lookupOptions.isPositionBased()) {
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                }
                if (bl) {
                    BLIB.WRN_RENAMED_VIEW_ATTRIBUTE.log(string, n, SQLViewParser.buildQualifiedName(this.view, new String[0]));
                }
            }
        }
        return mIRFeature;
    }

    @Override
    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        MIRFeature mIRFeature = mIRClassifier.getFeature("SQL CONDITION");
        if (mIRFeature == null || !mIRFeature.isInstanceOf((short)84)) {
            MIRCondition mIRCondition = new MIRCondition();
            mIRCondition.setName("SQL CONDITION");
            mIRClassifier.addFeatureUniqueName(mIRCondition, '_');
            mIRCondition.setPosition((short)Short.MAX_VALUE);
            mIRFeature = mIRCondition;
        }
        return mIRFeature;
    }

    @Override
    public boolean isStarCandidate(MIRFeature mIRFeature, boolean bl) {
        return mIRFeature.getElementType() != 84;
    }

    @Override
    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        if (mIRClassifier.getNamespace().getElementType() == 215) {
            return false;
        }
        return !this.createSrc || mIRClassifier.getElementType() != 25 || mIRClassifier.getFeatureCount() > 0;
    }

    @Override
    public boolean getApplyDataTypes() {
        return this.applyDataTypes;
    }

    @Override
    public boolean supportDoubleQuoteStrings() {
        return this.supportDoubleQuoteStrings;
    }

    public static void processSqlViewAssociations(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, final boolean bl, final boolean bl2, final boolean bl3, int n, int n2) throws MIRException {
        SQLViewParserParams sQLViewParserParams = new SQLViewParserParams(){

            @Override
            public boolean createSrc(MIRSQLViewEntity mIRSQLViewEntity) {
                return bl;
            }

            @Override
            public boolean createDst(MIRSQLViewEntity mIRSQLViewEntity) {
                return true;
            }

            @Override
            public boolean rebuildAssociations(MIRSQLViewEntity mIRSQLViewEntity) {
                return bl2;
            }

            @Override
            public boolean captureComments(MIRSQLViewEntity mIRSQLViewEntity) {
                return bl3;
            }
        };
        SQLViewParser.processSqlViewAssociations(mIRLogger, mIRStoreModel, n, n2, sQLViewParserParams);
    }

    public static void processSqlViewAssociations(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, int n, int n2, SQLViewParserParams sQLViewParserParams) throws MIRException {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{25});
        mIRStoreModel.depthTraversal(objectCollector);
        SQLViewParser.processSqlViewAssociations(mIRLogger, mIRStoreModel, new LinkedList<MIRSQLViewEntity>(objectCollector.getObjects()), n, n2, sQLViewParserParams);
    }

    public static void processSqlViewAssociations(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, List<MIRSQLViewEntity> list, int n, int n2, SQLViewParserParams sQLViewParserParams) throws MIRException {
        Object object;
        Object object2;
        Object object3;
        if (list.size() > 0) {
            BLIB.STS_PARSING_VIEWS.log(new Object[0]);
        }
        ArrayList<MIRSQLViewEntity> arrayList = new ArrayList<MIRSQLViewEntity>();
        boolean bl = false;
        Comparator<MIRSQLViewEntity> comparator = new Comparator<MIRSQLViewEntity>(){

            @Override
            public int compare(MIRSQLViewEntity mIRSQLViewEntity, MIRSQLViewEntity mIRSQLViewEntity2) {
                MIRDataPackage mIRDataPackage;
                MIRDataPackage mIRDataPackage2;
                if (mIRSQLViewEntity == mIRSQLViewEntity2) {
                    return 0;
                }
                if (mIRSQLViewEntity == null) {
                    return -1;
                }
                if (mIRSQLViewEntity2 == null) {
                    return 1;
                }
                int n = mIRSQLViewEntity.getName().compareTo(mIRSQLViewEntity2.getName());
                if (n == 0 && (mIRDataPackage2 = mIRSQLViewEntity.getDataPackage()) != null && (mIRDataPackage = mIRSQLViewEntity2.getDataPackage()) != null) {
                    n = mIRDataPackage2.getName().compareTo(mIRDataPackage.getName());
                }
                return n;
            }
        };
        Collections.sort(list, comparator);
        for (MIRSQLViewEntity mIRSQLViewEntity : list) {
            Object object4;
            object3 = mIRSQLViewEntity.getClassifierMap();
            if (mIRSQLViewEntity.getDataPackage() == null || object3 != null && ((MIRClassifierMap)object3).getExpression() != null) continue;
            object2 = new SQLViewParser(mIRLogger, mIRStoreModel, mIRSQLViewEntity, sQLViewParserParams.getDefaultCatalog(mIRSQLViewEntity), sQLViewParserParams.getDefaultSchema(mIRSQLViewEntity), sQLViewParserParams.applyDataTypes(mIRSQLViewEntity), sQLViewParserParams.supportDoubleQuoteStrings(mIRSQLViewEntity), sQLViewParserParams.createSrc(mIRSQLViewEntity), sQLViewParserParams.createDst(mIRSQLViewEntity), n, n2);
            ((ParserBase)object2).setIsCatalogSupported(sQLViewParserParams.isCatalogSupported());
            object = SQLViewParser.getViewStatement(mIRSQLViewEntity);
            if (!((String)object).isEmpty()) {
                object3 = MIRBridgeLib.getDestinationOfClassifierMap(mIRSQLViewEntity, true);
                ((MIRClassifierMap)object3).setOperation((String)object);
                if (!((MIRExpressionAnalyzer)object2).parse((MIRClassifierMap)object3)) {
                    ((MIR_Object)object3).delete();
                    object3 = MIRBridgeLib.getDestinationOfClassifierMap(mIRSQLViewEntity, true);
                    ((MIRClassifierMap)object3).setOperation((String)object);
                    continue;
                }
                if (sQLViewParserParams.rebuildAssociations(mIRSQLViewEntity)) {
                    SQLViewParser.processSQLViewAttributes(mIRSQLViewEntity);
                }
                if (!((SQLViewParser)object2).redo && sQLViewParserParams.getSqlViewPostprocessor() != null) {
                    sQLViewParserParams.getSqlViewPostprocessor().postporcess(mIRSQLViewEntity);
                }
                SQLViewParser.cleanupExpressions((MIRClassifierMap)object3);
                arrayList.add(mIRSQLViewEntity);
                boolean bl2 = bl = bl || ((SQLViewParser)object2).redo;
                if (sQLViewParserParams.captureComments(mIRSQLViewEntity) && !((String)(object4 = ((MIRExpressionAnalyzer)object2).getComments())).isEmpty()) {
                    if (!mIRSQLViewEntity.getDescription().isEmpty() && mIRSQLViewEntity.getComment().isEmpty()) {
                        mIRSQLViewEntity.setComment(mIRSQLViewEntity.getDescription());
                    }
                    mIRSQLViewEntity.setDescription((String)object4);
                }
                if (!sQLViewParserParams.rebuildAssociations(mIRSQLViewEntity)) continue;
                SQLViewParser.processSQLViewAssociations(mIRSQLViewEntity);
                continue;
            }
            if (mIRSQLViewEntity.getDestinationOfSQLViewAssociationCount() > 0) {
                MIRModelObject mIRModelObject;
                Object object5;
                object = SQLViewParser.computeSqlViewSelectStatement(mIRSQLViewEntity);
                object3 = MIRBridgeLib.getDestinationOfClassifierMap(mIRSQLViewEntity, true);
                ((MIRClassifierMap)object3).setOperation((String)object);
                if (((MIRExpressionAnalyzer)object2).parse((MIRClassifierMap)object3)) {
                    SQLViewParser.processSQLViewAttributes(mIRSQLViewEntity);
                    SQLViewParser.cleanupExpressions((MIRClassifierMap)object3);
                    SQLViewParser.processSQLViewAssociations(mIRSQLViewEntity);
                    arrayList.add(mIRSQLViewEntity);
                    bl = bl || ((SQLViewParser)object2).redo;
                    continue;
                }
                ((MIRClassifierMap)object3).removeSourceClassifiers();
                ((MIRClassifierMap)object3).removeFeatureMaps();
                object4 = mIRSQLViewEntity.getDestinationOfSQLViewAssociations();
                Object object6 = object4.iterator();
                while (object6.hasNext()) {
                    object5 = (MIRSQLViewAssociation)object6.next();
                    mIRModelObject = ((MIRSQLViewAssociation)object5).getSourceClassifier();
                    if (((MIRClassifierMap)object3).containsSourceClassifier((MIRClassifier)mIRModelObject)) continue;
                    ((MIRClassifierMap)object3).addSourceClassifier((MIRClassifier)mIRModelObject);
                }
                object6 = mIRSQLViewEntity.getFeatures();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    MIRFeatureMap mIRFeatureMap;
                    mIRModelObject = (MIRFeature)object5.next();
                    if (((MIRFeature)mIRModelObject).getElementType() != 26) continue;
                    MIRSQLViewAttribute mIRSQLViewAttribute = (MIRSQLViewAttribute)mIRModelObject;
                    MIRFeature mIRFeature = mIRSQLViewAttribute.getSourceFeature();
                    if (mIRFeature != null) {
                        mIRFeatureMap = new MIRFeatureMap();
                        mIRFeatureMap.addSourceFeature(mIRFeature);
                        mIRFeatureMap.addDestinationFeature(mIRSQLViewAttribute);
                        ((MIRClassifierMap)object3).addFeatureMap(mIRFeatureMap);
                        continue;
                    }
                    if (mIRSQLViewAttribute.getExpression().isEmpty()) continue;
                    mIRFeatureMap = new MIRFeatureMap();
                    mIRFeatureMap.addDestinationFeature(mIRSQLViewAttribute);
                    mIRFeatureMap.setOperation(mIRSQLViewAttribute.getExpression());
                    ((MIRClassifierMap)object3).addFeatureMap(mIRFeatureMap);
                    if (((MIRExpressionAnalyzer)object2).parse(mIRFeatureMap)) continue;
                    mIRFeatureMap.delete();
                }
                continue;
            }
            BLIB.WRN_VIEW_WITHOUT_ASSOCIATION_OR_SQL.log(mIRLogger, SQLViewParser.buildQualifiedName(mIRSQLViewEntity, new String[0]));
        }
        if (bl) {
            for (MIRSQLViewEntity mIRSQLViewEntity : arrayList) {
                object3 = SQLViewParser.getViewStatement(mIRSQLViewEntity);
                if (((String)object3).isEmpty()) {
                    object3 = SQLViewParser.computeSqlViewSelectStatement(mIRSQLViewEntity);
                }
                if ((object2 = mIRSQLViewEntity.getDestinationOfClassifierMap()) != null) {
                    ((MIR_Object)object2).delete();
                }
                object2 = MIRBridgeLib.getDestinationOfClassifierMap(mIRSQLViewEntity, true);
                ((MIRClassifierMap)object2).setOperation((String)object3);
                object = new SQLViewParser(mIRLogger, mIRStoreModel, mIRSQLViewEntity, sQLViewParserParams.getDefaultCatalog(mIRSQLViewEntity), sQLViewParserParams.getDefaultSchema(mIRSQLViewEntity), sQLViewParserParams.applyDataTypes(mIRSQLViewEntity), sQLViewParserParams.supportDoubleQuoteStrings(mIRSQLViewEntity), sQLViewParserParams.createSrc(mIRSQLViewEntity), sQLViewParserParams.createDst(mIRSQLViewEntity), n, n2);
                if (!((MIRExpressionAnalyzer)object).parse((MIRClassifierMap)object2)) {
                    ((MIR_Object)object2).delete();
                    object2 = MIRBridgeLib.getDestinationOfClassifierMap(mIRSQLViewEntity, true);
                    ((MIRClassifierMap)object2).setOperation((String)object3);
                    continue;
                }
                if (sQLViewParserParams.getSqlViewPostprocessor() != null) {
                    sQLViewParserParams.getSqlViewPostprocessor().postporcess(mIRSQLViewEntity);
                }
                SQLViewParser.cleanupExpressions((MIRClassifierMap)object2);
            }
        }
    }

    private static String getViewStatement(MIRSQLViewEntity mIRSQLViewEntity) {
        MIRClassifierMap mIRClassifierMap = mIRSQLViewEntity.getClassifierMap();
        String string = mIRSQLViewEntity.getViewStatement();
        if (string.isEmpty() && mIRClassifierMap != null) {
            string = mIRClassifierMap.getOperation();
        }
        return string;
    }

    private static void processSQLViewAssociations(MIRSQLViewEntity mIRSQLViewEntity) {
        MIRClassifierMap mIRClassifierMap = MIRBridgeLib.getDestinationOfClassifierMap(mIRSQLViewEntity, true);
        SortedSet<MIRClassifier> sortedSet = mIRClassifierMap.getSourceClassifiers();
        for (MIRClassifier mIRClassifier : sortedSet) {
            MIRSQLViewAssociation mIRSQLViewAssociation = SQLViewParser.getSQLViewAssociation(mIRSQLViewEntity, mIRClassifier);
            if (mIRSQLViewAssociation != null) continue;
            mIRSQLViewAssociation = new MIRSQLViewAssociation();
            mIRSQLViewEntity.addDestinationOfSQLViewAssociation(mIRSQLViewAssociation);
            mIRSQLViewAssociation.addSourceClassifier(mIRClassifier);
            mIRSQLViewEntity.getNamespace().addNamespaceElement(mIRSQLViewAssociation);
        }
    }

    private static void processSQLViewAttributes(MIRSQLViewEntity mIRSQLViewEntity) {
        for (MIRFeature mIRFeature : mIRSQLViewEntity.getFeatures()) {
            MIRSQLViewAttribute mIRSQLViewAttribute;
            MIRFeatureMap mIRFeatureMap;
            if (!(mIRFeature instanceof MIRSQLViewAttribute) || !Util.isSimpleExpression(mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap(mIRSQLViewAttribute = (MIRSQLViewAttribute)mIRFeature, true))) continue;
            MIRFeature mIRFeature2 = mIRFeatureMap.getSourceFeatureIterator().next();
            if (mIRSQLViewAttribute.getSourceFeature() != null || mIRSQLViewAttribute == mIRFeature2) continue;
            mIRSQLViewAttribute.addSourceFeature(mIRFeature2);
        }
    }

    static MIRSQLViewAssociation getSQLViewAssociation(MIRSQLViewEntity mIRSQLViewEntity, MIRClassifier mIRClassifier) {
        SortedSet<MIRSQLViewAssociation> sortedSet = mIRSQLViewEntity.getDestinationOfSQLViewAssociations();
        for (MIRSQLViewAssociation mIRSQLViewAssociation : sortedSet) {
            MIRClassifier mIRClassifier2 = mIRSQLViewAssociation.getSourceClassifier();
            if (mIRClassifier2 == null || mIRClassifier2 != mIRClassifier || mIRClassifier2.getElementType() != 13 && mIRClassifier2.getElementType() != 25) continue;
            return mIRSQLViewAssociation;
        }
        return null;
    }

    static String computeSqlViewSelectStatement(MIRSQLViewEntity mIRSQLViewEntity) {
        MIRNamespaceElement mIRNamespaceElement;
        MIRSQLViewAssociation mIRSQLViewAssociation;
        Object object;
        Object object2;
        if (mIRSQLViewEntity.getDestinationOfSQLViewAssociationCount() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (mIRSQLViewEntity.getSelectType() == 1) {
            stringBuilder.append("ALL ");
        } else if (mIRSQLViewEntity.getSelectType() == 2) {
            stringBuilder.append("DISTINCT ");
        } else if (mIRSQLViewEntity.getSelectType() == 3) {
            stringBuilder.append("DISTINCTROW ");
        } else if (mIRSQLViewEntity.getSelectType() == 4) {
            stringBuilder.append("UNIQUE ");
        }
        boolean bl = true;
        List<MIRFeature> list = mIRSQLViewEntity.getFeatureByPosition();
        for (MIRFeature object32 : list) {
            if (!object32.isInstanceOf((short)26)) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            object2 = (MIRSQLViewAttribute)object32;
            MIRModelObject n = ((MIRSQLViewAttribute)object2).getSourceFeature();
            if (n != null) {
                object = n.getClassifier();
                mIRSQLViewAssociation = SQLViewParser.getSQLViewAssociation(mIRSQLViewEntity, (MIRClassifier)object);
                if (mIRSQLViewAssociation != null && !mIRSQLViewAssociation.getAliasName().isEmpty()) {
                    stringBuilder.append(MIRBridgeLib.getQuotedString(mIRSQLViewAssociation.getAliasName()) + ".");
                    stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(n));
                    continue;
                }
                mIRNamespaceElement = ((MIRNamespaceElement)object).getDataPackage();
                if (mIRNamespaceElement != null && ((MIRDataPackage)mIRNamespaceElement).getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRNamespaceElement).isEmpty()) {
                    stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(mIRNamespaceElement) + ".");
                }
                stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName((MIRModelObject)object) + ".");
                stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(n));
                continue;
            }
            stringBuilder.append(((MIRSQLViewAttribute)object2).getExpression());
        }
        stringBuilder.append(" FROM ");
        ArrayList arrayList = new ArrayList();
        SortedSet<MIRSQLViewAssociation> sortedSet = mIRSQLViewEntity.getDestinationOfSQLViewAssociations();
        for (MIRModelObject n : sortedSet) {
            arrayList.add(n);
        }
        object2 = new Comparator<MIRSQLViewAssociation>(){

            @Override
            public int compare(MIRSQLViewAssociation mIRSQLViewAssociation, MIRSQLViewAssociation mIRSQLViewAssociation2) {
                int n = mIRSQLViewAssociation.getSQLTableSequence() - mIRSQLViewAssociation2.getSQLTableSequence();
                if (n == 0) {
                    return mIRSQLViewAssociation.getSourceClassifier().getName().compareTo(mIRSQLViewAssociation2.getSourceClassifier().getName());
                }
                return n;
            }
        };
        Collections.sort(arrayList, object2);
        int n = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            mIRSQLViewAssociation = (MIRSQLViewAssociation)object.next();
            mIRNamespaceElement = mIRSQLViewAssociation.getSourceClassifier();
            MIRDataPackage mIRDataPackage = mIRNamespaceElement.getDataPackage();
            if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRDataPackage).isEmpty()) {
                stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".");
            }
            stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(mIRNamespaceElement));
            if (!mIRSQLViewAssociation.getAliasName().isEmpty()) {
                stringBuilder.append(" " + MIRBridgeLib.getQuotedString(mIRSQLViewAssociation.getAliasName()));
            }
            if (n < mIRSQLViewEntity.getDestinationOfSQLViewAssociationCount() - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        if (!mIRSQLViewEntity.getWhereClause().isEmpty()) {
            stringBuilder.append(" WHERE " + mIRSQLViewEntity.getWhereClause());
        }
        if (!mIRSQLViewEntity.getGroupByClause().isEmpty()) {
            stringBuilder.append(" GROUP BY " + mIRSQLViewEntity.getGroupByClause());
        }
        if (!mIRSQLViewEntity.getHavingClause().isEmpty()) {
            stringBuilder.append(" HAVING " + mIRSQLViewEntity.getHavingClause());
        }
        if (!mIRSQLViewEntity.getOrderByClause().isEmpty()) {
            stringBuilder.append(" ORDER BY " + mIRSQLViewEntity.getOrderByClause());
        }
        return stringBuilder.toString();
    }

    static String computeSqlViewCreateStatement(MIRSQLViewEntity mIRSQLViewEntity) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE ");
        if (mIRSQLViewEntity.getViewType() == 0) {
            stringBuilder.append("VIEW ");
        } else if (mIRSQLViewEntity.getViewType() == 1) {
            stringBuilder.append("SNAPSHOT ");
        } else if (mIRSQLViewEntity.getViewType() == 2) {
            stringBuilder.append("MATERIALIZED VIEW ");
        } else if (mIRSQLViewEntity.getViewType() == 3) {
            stringBuilder.append("TABLE ");
        }
        MIRDataPackage mIRDataPackage = mIRSQLViewEntity.getDataPackage();
        if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRDataPackage).isEmpty()) {
            stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".");
        }
        stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(mIRSQLViewEntity));
        if (mIRSQLViewEntity.getFeatureCount() > 0) {
            stringBuilder.append(" ( ");
            List<MIRFeature> list = mIRSQLViewEntity.getFeatureByPosition();
            for (int i = 0; i < mIRSQLViewEntity.getFeatureCount(); ++i) {
                MIRSQLViewAttribute mIRSQLViewAttribute = (MIRSQLViewAttribute)list.get(i);
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(MIRBridgeLib.getQuotedPhysicalName(mIRSQLViewAttribute));
            }
            stringBuilder.append(" ) ");
        }
        stringBuilder.append(" AS\n");
        if (!mIRSQLViewEntity.getViewStatement().isEmpty() && mIRSQLViewEntity.getViewStatementType() == 1) {
            stringBuilder.append(mIRSQLViewEntity.getViewStatement());
        } else {
            stringBuilder.append(SQLViewParser.computeSqlViewSelectStatement(mIRSQLViewEntity));
        }
        return stringBuilder.toString();
    }

    public static abstract class SQLViewParserParams {
        public boolean supportDoubleQuoteStrings(MIRSQLViewEntity mIRSQLViewEntity) {
            return false;
        }

        public boolean createSrc(MIRSQLViewEntity mIRSQLViewEntity) {
            return false;
        }

        public boolean createDst(MIRSQLViewEntity mIRSQLViewEntity) {
            return false;
        }

        public boolean rebuildAssociations(MIRSQLViewEntity mIRSQLViewEntity) {
            return false;
        }

        public boolean captureComments(MIRSQLViewEntity mIRSQLViewEntity) {
            return false;
        }

        public boolean applyDataTypes(MIRSQLViewEntity mIRSQLViewEntity) {
            return false;
        }

        public String getDefaultSchema(MIRSQLViewEntity mIRSQLViewEntity) {
            return null;
        }

        public MIRSystemPackage getDefaultCatalog(MIRSQLViewEntity mIRSQLViewEntity) {
            return null;
        }

        public SqlViewPostprocessor getSqlViewPostprocessor() {
            return null;
        }

        public boolean isCatalogSupported() {
            return false;
        }
    }

    public static interface SqlViewPostprocessor {
        public void postporcess(MIRSQLViewEntity var1);
    }
}

