/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.parsers.ParserBase;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRSystemPackage;
import MITI.util.log.MIRLogger;

public abstract class RelationalParser
extends ParserBase {
    public static final String TEMP_SCHEMA_NAME = "__temp__";
    protected MIRStoreModel model;
    protected String defaultSchemaName;

    public RelationalParser(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, MIRNamespaceElement mIRNamespaceElement, int n, int n2, String string) {
        super(mIRLogger, mIRNamespaceElement, n, n2);
        this.model = mIRStoreModel;
        this.defaultSchemaName = MIRBridgeLib.removeQuotes(string);
    }

    private String getDefaultCatalogName() {
        return this.defaultCatalog != null && !(this.defaultCatalog instanceof MIRStoreConnection) ? this.defaultCatalog.getName() : MIRBridgeLib.getPhysicalName(this.model);
    }

    @Override
    protected MIRDataPackage getDataPackage(String string, String string2, boolean bl, boolean bl2) {
        MIRModelObject mIRModelObject;
        if (this.model.getStoreType() == 0 && (string == null || string.isEmpty() || this.getDefaultCatalogName().equalsIgnoreCase(string))) {
            MIRModelObject mIRModelObject2 = mIRModelObject = string2 == null || string2.isEmpty() ? this.defaultSchema : this.getItem(string2, bl, this.model.getDataPackages());
            if (mIRModelObject instanceof MIRDatabaseSchema) {
                return mIRModelObject;
            }
        }
        if (this.model.getStoreType() != 0 || bl2) {
            Object object;
            if (string == null || string.isEmpty()) {
                string = !this.isCatalogSupported && this.isSchemaBasedDatabase(this.getDatabaseType()) ? string2 : string2 + "@" + this.model.getName();
            }
            if ((mIRModelObject = this.getItem(string = string.toUpperCase(), false, this.model.getStoreConnections())) != null && this.model.getStoreType() == 0) {
                int n = 0;
                object = string;
                while (mIRModelObject != null && ((MIRStoreConnection)mIRModelObject).getStoreType() != 0 && ((MIRStoreConnection)mIRModelObject).getStoreType() != 2) {
                    string = (String)object + "_" + ++n;
                    mIRModelObject = this.getItem(string, false, this.model.getStoreConnections());
                }
            }
            if (mIRModelObject == null && bl2) {
                mIRModelObject = new MIRStoreConnection();
                mIRModelObject.setName(string);
                this.model.addStoreConnection((MIRStoreConnection)mIRModelObject);
                RelationalParser.setSystemType(this.getDatabaseType(), (MIRSystemPackage)mIRModelObject);
            }
            if (mIRModelObject != null) {
                String[] stringArray;
                if ((string2 == null || string2.isEmpty()) && (stringArray = this.getAlternativeDataPackageNames()) != null && stringArray.length > 0) {
                    string2 = stringArray[0];
                }
                object = this.getItem(string2, bl, ((MIRStoreConnection)mIRModelObject).getConnectionPackages());
                if (bl2 && object == null) {
                    object = new MIRConnectionPackage();
                    ((MIRObject)object).setName(string2);
                    ((MIRStoreConnection)mIRModelObject).addConnectionPackage((MIRConnectionPackage)object);
                    this.setCollationLineageOption((MIRObject)object, bl);
                }
                return object;
            }
        }
        return null;
    }

    protected static String buildQualifiedName(MIRObject mIRObject, String ... stringArray) {
        if (mIRObject == null) {
            return "<null>";
        }
        String string = mIRObject.getPath(false);
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                stringBuilder.append("/" + string2);
            }
            string = string + stringBuilder.toString();
        }
        return string;
    }
}

