/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.expression.MIRExpressionLangType;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRType;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class ParserBase
extends MIRExpressionAnalyzer {
    protected MIRDataPackage defaultSchema;
    protected MIRSystemPackage defaultCatalog;
    protected boolean isCatalogSupported;
    private static final MIRDataPackage[] NO_PACKAGES = new MIRDataPackage[0];

    public ParserBase(MIRLogger mIRLogger, MIRNamespaceElement mIRNamespaceElement, int n, int n2) {
        super(mIRLogger, n, n2);
        MIRObject mIRObject;
        this.defaultSchema = ParserBase.getDataPackage(mIRNamespaceElement);
        if (this.defaultSchema != null && (mIRObject = this.defaultSchema.getParent()) != null && mIRObject.isInstanceOf((short)267)) {
            this.defaultCatalog = (MIRSystemPackage)mIRObject;
        }
        this.setDatabaseType(this.detectDbType(n2));
    }

    @Override
    public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(new LookupOptions(mIRElementNode, false), collection, collection2);
    }

    public void setIsCatalogSupported(boolean bl) {
        this.isCatalogSupported = bl;
    }

    protected int detectDbType(int n) {
        MIRDataStoreVersion mIRDataStoreVersion;
        if (this.defaultCatalog != null && (mIRDataStoreVersion = MIRDataTypeLib.getDataStore(this.defaultCatalog)).isValid()) {
            int n2 = MIRExpressionAnalyzer.getExpressionDatabaseType(mIRDataStoreVersion.getDataStoreType());
            if (n2 == 5 && mIRDataStoreVersion.getDataStoreType().toUpperCase().contains("NETEZZA")) {
                this.isCatalogSupported = true;
            }
            return n2 == 0 ? n : n2;
        }
        return n;
    }

    private List<MIRElementNamePart> getElementNameParts(MIRExpressionNode mIRExpressionNode) {
        List<MIRElementNamePart> list = null;
        if (mIRExpressionNode instanceof MIRElementNode && (((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 75 || ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 66 || ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 49 || ((MIRElementNode)mIRExpressionNode).getDestinationElementType() == 23)) {
            list = ((MIRElementNode)mIRExpressionNode).getElementNamePartByPosition();
        } else if (mIRExpressionNode instanceof MIROperationNode) {
            list = ((MIROperationNode)mIRExpressionNode).getElementNamePartByPosition();
        }
        return list;
    }

    private String[] getSchemaFullName(List<MIRElementNamePart> list) {
        String[] stringArray;
        boolean bl;
        String string = MIRConnectionManager.getServerName(this.defaultCatalog);
        String string2 = MIRConnectionManager.getDatabaseName(this.defaultCatalog);
        if ((string2 == null || string2.isEmpty()) && this.defaultCatalog instanceof MIRStoreConnection) {
            string2 = this.defaultCatalog.getName();
        }
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 2);
        String string3 = MIRBridgeLib.removeQuotes(mIRElementNamePart.getName());
        boolean bl2 = bl = !this.isCatalogSupported && this.isSchemaBasedDatabase(this.getDatabaseType());
        if (list.size() > 3) {
            stringArray = new StringBuilder();
            for (int i = 0; i < list.size() - 3; ++i) {
                if (i != 0) {
                    stringArray.append('.');
                }
                stringArray.append(MIRBridgeLib.removeQuotes(list.get(i).getName()));
            }
            string = stringArray.toString();
            string2 = list.get(list.size() - 3).getName();
        } else if (list.size() > 2) {
            if (!bl) {
                string2 = list.get(list.size() - 3).getName();
            } else {
                string = list.get(list.size() - 3).getName();
            }
        }
        if (bl && this.getDatabaseType() == 1 && string != null && string.startsWith("@")) {
            string = MIRBridgeLib.removeQuotes(string.substring(1));
        }
        stringArray = new String[]{string2, MIRBridgeLib.removeQuotes(string3)};
        return stringArray;
    }

    protected abstract MIRDataPackage getDataPackage(String var1, String var2, boolean var3, boolean var4);

    protected MIRDataPackage getDataPackage(MIRExpressionNode mIRExpressionNode, boolean bl) {
        MIRDataPackage mIRDataPackage = null;
        List<MIRElementNamePart> list = this.getElementNameParts(mIRExpressionNode);
        if (list != null) {
            if (list.size() == 1) {
                mIRDataPackage = this.defaultSchema;
            } else {
                String string;
                String string2;
                MIRElementNamePart mIRElementNamePart;
                String[] stringArray = this.getSchemaFullName(list);
                if (this.getPackageName(mIRExpressionNode) != null) {
                    mIRElementNamePart = list.get(list.size() - 3);
                    string2 = stringArray[0];
                    string = "";
                } else {
                    mIRElementNamePart = list.get(list.size() - 2);
                    string = stringArray[0];
                    string2 = stringArray[1];
                }
                boolean bl2 = mIRElementNamePart.getQuoted();
                mIRDataPackage = this.getDataPackage(string, string2, bl2, bl);
            }
        }
        return mIRDataPackage;
    }

    protected String getPackageName(MIRExpressionNode mIRExpressionNode) {
        MIROperationNode mIROperationNode;
        if (this.getOptions().supportPackages() && mIRExpressionNode instanceof MIROperationNode && (mIROperationNode = (MIROperationNode)mIRExpressionNode).getElementNamePartCount() > 2) {
            return mIROperationNode.getElementNamePartByPosition().get(mIROperationNode.getElementNamePartCount() - 2).getName();
        }
        return null;
    }

    MIRDataPackage[] getAlternativeDataPackages(MIROperationNode mIROperationNode) {
        List<MIRElementNamePart> list = mIROperationNode.getElementNamePartByPosition();
        if (!list.isEmpty() && (list.size() == 1 || list.get(list.size() - 2).getName().isEmpty())) {
            return this.getAlternativeDataPackagesInternal(mIROperationNode, false);
        }
        return NO_PACKAGES;
    }

    MIRDataPackage[] getAlternativeDataPackages(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        if (!list.isEmpty() && (list.size() == 1 || list.get(list.size() - 2).getName().isEmpty())) {
            return this.getAlternativeDataPackagesInternal(mIRElementNode, true);
        }
        return NO_PACKAGES;
    }

    protected MIRDataPackage[] getAlternativeDataPackagesInternal(MIRExpressionNode mIRExpressionNode, boolean bl) {
        Object object;
        Object object2;
        String string;
        if (mIRExpressionNode instanceof MIROperationNode || mIRExpressionNode instanceof MIRElementNode && ((MIRElementNode)mIRExpressionNode).getElementNamePartCount() == 1) {
            string = "";
        } else {
            object2 = this.getElementNameParts(mIRExpressionNode);
            object = this.getSchemaFullName((List<MIRElementNamePart>)object2);
            string = object[0];
        }
        object2 = this.getAlternativeDataPackageNames();
        if (object2 == null) {
            return NO_PACKAGES;
        }
        object = new LinkedList();
        for (String string2 : object2) {
            object.add(this.getDataPackage(string, string2, true, bl));
        }
        return object.toArray(new MIRDataPackage[object.size()]);
    }

    protected String[] getAlternativeDataPackageNames() {
        if (this.getDatabaseType() == 1) {
            return new String[]{"PUBLIC", "SYS"};
        }
        if (this.getDatabaseType() == 5) {
            return new String[]{"pg_catalog"};
        }
        if (this.getDatabaseType() == 2) {
            return new String[]{"dbo"};
        }
        return null;
    }

    protected MIRElement getClassifier(String string, boolean bl, MIRPackage mIRPackage) {
        if (mIRPackage == null) {
            return null;
        }
        MIRModelObject mIRModelObject = this.getItem(string, bl, mIRPackage.getNamespaceElements());
        if (mIRModelObject == null) {
            mIRModelObject = this.getItem(string, bl, mIRPackage.getImportedNamespaceElements());
        }
        if (mIRModelObject != null && (mIRModelObject.isInstanceOf((short)49) || mIRModelObject.isInstanceOf((short)75))) {
            return mIRModelObject;
        }
        return null;
    }

    protected List<MIRFeature> getFeatures(String string, boolean bl, Collection<MIRClassifier> collection) {
        return this.getFeatures(new String[]{string}, bl, collection);
    }

    protected List<MIRFeature> getFeatures(String[] stringArray, boolean bl, Collection<MIRClassifier> collection) {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ArrayList<MIRClassifier> arrayList2 = new ArrayList<MIRClassifier>();
            for (MIRClassifier mIRClassifier : collection) {
                MIRClassType mIRClassType;
                MIRFeature mIRFeature = this.getItem(string, bl, mIRClassifier.getFeatures());
                if (mIRFeature == null) continue;
                if (i == stringArray.length - 1 || (mIRClassType = ParserBase.getHierarchicalType(mIRFeature.getType())) == null) {
                    arrayList.add(mIRFeature);
                    continue;
                }
                if (mIRClassType == null) continue;
                arrayList2.add(mIRClassType.getAssociatedClass());
            }
            collection = arrayList2;
        }
        return arrayList;
    }

    private static MIRClassType getHierarchicalType(MIRType mIRType) {
        if (mIRType instanceof MIRDerivedType) {
            mIRType = ((MIRDerivedType)mIRType).getArrayOfType();
        }
        if (mIRType instanceof MIRClassType) {
            return (MIRClassType)mIRType;
        }
        return null;
    }

    protected List<MIRFeature> getFeaturesByPosition(int n, Collection<MIRClassifier> collection) {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        for (MIRClassifier mIRClassifier : collection) {
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                if (mIRFeature.getPosition() != n) continue;
                arrayList.add(mIRFeature);
            }
        }
        return arrayList;
    }

    protected List<MIRNamespaceElement> getOperations(String string, boolean bl, MIRDataPackage mIRDataPackage) {
        if (mIRDataPackage == null) {
            return null;
        }
        List<MIRNamespaceElement> list = this.getItems(string, bl, mIRDataPackage.getNamespaceElements());
        if (list == null) {
            list = this.getItems(string, bl, mIRDataPackage.getImportedNamespaceElements());
        }
        return list;
    }

    protected int getStatementType(MIRObject mIRObject) {
        while (mIRObject.getElementType() != 134) {
            if ((mIRObject = mIRObject.getParent()) != null && mIRObject instanceof MIRExpressionNode) continue;
            return -1;
        }
        return ((MIRStatementNode)mIRObject).getStatementType();
    }

    protected void setCollationLineageOption(MIRObject mIRObject, boolean bl) {
        MIRExpressionAnalyzerHelper.setCollationLineageOption(mIRObject, bl, this.getCollationMode(mIRObject));
    }

    static void cleanupExpressions(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap.getExpression() == null) {
            return;
        }
        mIRClassifierMap.getExpression().delete();
        for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps()) {
            if (mIRFeatureMap.getExpression() == null) continue;
            mIRFeatureMap.getExpression().delete();
        }
    }

    public static void setSystemType(int n, MIRSystemPackage mIRSystemPackage) {
        MIRModel mIRModel = mIRSystemPackage.getRootModel();
        if (mIRModel != null && ParserBase.getExpressionDatabaseType(mIRModel.getSystemType()) == n) {
            mIRSystemPackage.setSystemType(mIRModel.getSystemType());
        } else if (n == 1) {
            mIRSystemPackage.setSystemType("ORACLE");
        } else if (n == 4) {
            mIRSystemPackage.setSystemType("TERADATA");
        } else if (n == 11) {
            mIRSystemPackage.setSystemType("HIVE");
        } else if (n == 2) {
            mIRSystemPackage.setSystemType("MICROSOFT SQL SERVER");
        } else if (n == 5) {
            mIRSystemPackage.setSystemType("POSTGRESQL");
        } else if (n == 20) {
            mIRSystemPackage.setSystemType("SNOWFLAKE");
        } else if (n == 3) {
            mIRSystemPackage.setSystemType("DB2/UDB");
        } else if (n == 10) {
            mIRSystemPackage.setSystemType("MYSQL");
        } else if (n == 12) {
            mIRSystemPackage.setSystemType("ACCESS");
        } else if (n == 13) {
            mIRSystemPackage.setSystemType("TALEND.VECTORWISE");
        } else if (n == 14) {
            mIRSystemPackage.setSystemType("ORACLE BI SERVER");
        } else if (n == 15) {
            mIRSystemPackage.setSystemType("APACHE CASSANDRA");
        } else if (n == 16) {
            mIRSystemPackage.setSystemType("HP VERTICA");
        } else if (n == 17) {
            mIRSystemPackage.setSystemType("SALESFORCE");
        } else if (n == 18) {
            mIRSystemPackage.setSystemType("SAP HANA");
        } else if (n == 19) {
            mIRSystemPackage.setSystemType("PRESTO");
        } else if (n == 21) {
            mIRSystemPackage.setSystemType("REDSHIFT");
        } else if (n == 22) {
            mIRSystemPackage.setSystemType("DENODO");
        } else if (n == 23) {
            mIRSystemPackage.setSystemType("AMAZONAURORA");
        } else if (n == 24) {
            mIRSystemPackage.setSystemType("GOOGLE BIGQUERY");
        } else if (n == 25) {
            mIRSystemPackage.setSystemType("AMAZONATHENA");
        } else if (n == 26) {
            mIRSystemPackage.setSystemType("SYBASE AS ENTERPRISE");
        } else if (n == 9) {
            mIRSystemPackage.setSystemType("ODBC");
        } else {
            mIRSystemPackage.setSystemType(MIRExpressionLangType.getName(n));
        }
    }

    protected <T extends MIRObject> T getItem(String string, boolean bl, Collection<T> collection) {
        List<T> list = this.getItems(string, bl, collection);
        return (T)(list == null || list.isEmpty() ? null : (MIRObject)list.get(0));
    }

    protected <T extends MIRObject> List<T> getItems(String string, boolean bl, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        MIRObject mIRObject = (MIRObject)collection.iterator().next();
        return MIRExpressionAnalyzerHelper.getItems(string, bl, collection, this.getCollationMode(mIRObject));
    }

    private static MIRSystemPackage getCatalog(MIRObject mIRObject) {
        while (mIRObject != null && !(mIRObject instanceof MIRSystemPackage)) {
            if (mIRObject instanceof MIRNamespaceElement && !(mIRObject instanceof MIRDataPackage)) {
                mIRObject = ParserBase.getDataPackage((MIRNamespaceElement)mIRObject);
                continue;
            }
            mIRObject = mIRObject.getParent();
        }
        return (MIRSystemPackage)mIRObject;
    }

    private static MIRDataPackage getDataPackage(MIRNamespaceElement mIRNamespaceElement) {
        MIRConnectionDataPackage mIRConnectionDataPackage;
        if (mIRNamespaceElement instanceof MIRDataPackage) {
            return (MIRDataPackage)mIRNamespaceElement;
        }
        if (mIRNamespaceElement instanceof MIROperation && ((MIROperation)mIRNamespaceElement).getAssociatedClass() != null) {
            mIRNamespaceElement = ((MIROperation)mIRNamespaceElement).getAssociatedClass();
        }
        if (mIRNamespaceElement instanceof MIRClassifier && (mIRConnectionDataPackage = ((MIRClassifier)mIRNamespaceElement).getConnectionDataPackage()) != null) {
            return mIRConnectionDataPackage;
        }
        return mIRNamespaceElement != null ? mIRNamespaceElement.getDataPackage() : null;
    }

    private CollationMode getCollationMode(MIRObject mIRObject) {
        MIRSystemPackage mIRSystemPackage;
        Set<String> set;
        CollationMode collationMode = this.getCollationMode();
        if (this.getDatabaseType() == 10 && mIRObject instanceof MIRFeature) {
            collationMode = CollationMode.CaseInsensitive;
        }
        if (this.getDatabaseType() == 24 && mIRObject instanceof MIRClassifier) {
            collationMode = CollationMode.CaseSensitive;
        } else if (MIRParserOptions.isConfigurableCollation(this.getDatabaseType(), this.getParserType()) && !(set = MIRConnectionManager.getInstance().getCaseSensitiveConnections()).isEmpty() && (mIRSystemPackage = ParserBase.getCatalog(mIRObject)) != null && set.contains(mIRSystemPackage.getName())) {
            collationMode = CollationMode.CaseSensitive;
        }
        return collationMode;
    }
}

