/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.bridges.bridgelib.parsers.RelationalParser;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.messages.MIRExpressionLib.EXPLIB;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAliasFeature;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.util.ObjectCollector;
import MITI.util.StringDigest;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class OperationParser
extends RelationalParser {
    public static final String PROPERTY_TYPE__LANGUAGE = "Language";
    private static final String OUTPUT = "Output_";
    private final MIROperation op;
    private final boolean supportDoubleQuoteStrings;
    private boolean redo;
    private static Map<String, String> tmpTables = new HashMap<String, String>();
    private static Map<String, String> synonyms = new HashMap<String, String>();
    private final String ParametersSuffix = "_params";

    private OperationParser(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, MIROperation mIROperation, MIRSystemPackage mIRSystemPackage, String string, boolean bl, int n, int n2) {
        super(mIRLogger, mIRStoreModel, mIROperation, n, n2, string);
        if (mIRSystemPackage != null) {
            this.defaultCatalog = mIRSystemPackage;
        }
        this.op = mIROperation;
        this.supportDoubleQuoteStrings = bl;
    }

    @Override
    public boolean isMultiStatement() {
        return true;
    }

    @Override
    public boolean supportDoubleQuoteStrings() {
        return this.supportDoubleQuoteStrings;
    }

    @Override
    public boolean captureConstantExpressions() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        MIRElementNode mIRElementNode = lookupOptions.getNode();
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        String string = mIRElementNamePart.getName();
        boolean bl = mIRElementNamePart.getQuoted();
        if (mIRElementNode.getDestinationElementType() == 24) {
            MIRArgument mIRArgument;
            string = mIRElementNode.getOriginalText();
            MIRArgument mIRArgument2 = mIRArgument = string == null || string.isEmpty() ? this.op.getArgumentByPosition().get(mIRElementNode.getPosition()) : this.getItem(string, bl, this.op.getArguments());
            if (mIRArgument == null) {
                mIRArgument = new MIRArgument();
                mIRArgument.setName(string);
                mIRArgument.setKind(mIRElementNode.getKind());
                mIRArgument.setPosition((short)(this.op.getArgumentCount() + 1));
                mIRArgument.setDefaultValue(mIRElementNode.getDescription());
                mIRArgument.addType(this.getDataType(mIRElementNode));
                this.op.addArgument(mIRArgument);
            }
            if (this.op instanceof MIRStoredProcedure) {
                void bl2;
                MIRFeature mIRFeature;
                MIRDataSet mIRDataSet = ((MIRStoredProcedure)this.op).getParametersDataSet();
                MIRFeature mIRFeature2 = mIRFeature = string == null || string.isEmpty() ? this.getFeatureByPosition(mIRDataSet, lookupOptions.getPosition(), false) : this.getItem(string, bl, mIRDataSet.getFeatures());
                if (mIRFeature == null) {
                    MIRDataAttribute object = new MIRDataAttribute();
                    object.setName(string);
                    object.addType(mIRArgument.getType());
                    object.setNativeType(mIRElementNode.getKind() == 2 ? "out" : "in");
                    mIRDataSet.addFeature(object);
                    this.setCollationLineageOption(object, bl);
                }
                collection2.add((MIRElement)bl2);
            }
        } else if (mIRElementNode.getDestinationElementType() == 49) {
            String string2 = MIRExpressionAnalyzerHelper.getSynonymReferencedTable(mIRElementNode);
            synonyms.put(mIRElementNode.getName(), string2);
        } else if (mIRElementNode.getDestinationElementType() == 75) {
            String string4;
            if (MIRExpressionAnalyzerHelper.isCreateSynonym(mIRElementNode)) {
                return;
            }
            MIRDataPackage mIRDataPackage = this.getDataPackage(mIRElementNode, true);
            MIRElement mIRElement = this.getClassifier(string, bl, mIRDataPackage);
            if (mIRElement == null) {
                MIRDataPackage mIRDataPackage2;
                void var13_52;
                MIRDataPackage[] mIRClass = this.getAlternativeDataPackages(mIRElementNode);
                int n = mIRClass.length;
                boolean bl2 = false;
                while (var13_52 < n && (mIRElement = this.getClassifier(string, bl, mIRDataPackage2 = mIRClass[var13_52])) == null) {
                    ++var13_52;
                }
            }
            if (mIRElement == null && mIRElementNode.getElementNamePartCount() == 1 && this.defaultSchemaName != null && !this.defaultSchemaName.isEmpty()) {
                mIRDataPackage = this.getDataPackage(MIRBridgeLib.getPhysicalName(this.defaultCatalog), this.defaultSchemaName, true, true);
                mIRElement = this.getClassifier(string, bl, mIRDataPackage);
            }
            if (mIRElement == null || mIRElement instanceof MIRClassifier && ((MIRClassifier)mIRElement).hasLineageOption(1024)) {
                mIRElement = this.getOrCreateTemporaryTable(string, bl, mIRElementNode, mIRDataPackage);
            }
            if (mIRElement == null && (string4 = synonyms.get(string)) != null && tmpTables.containsKey(string4)) {
                mIRElement = this.getOrCreateTemporaryTable(string4, bl, mIRElementNode, mIRDataPackage);
            }
            if (mIRElement == null) {
                boolean mIRClass = this.getDatabaseType() == 2 || this.getStatementType(mIRElementNode) == 5;
                mIRElement = this.getOrCreateExternalTable(string, bl, mIRDataPackage, mIRClass);
            }
            if (mIRElement == null && mIRDataPackage != null && mIRDataPackage.getElementType() == 215) {
                MIRClass cloneable2 = new MIRClass();
                cloneable2.setLineageOption(2048);
                cloneable2.setName(string);
                BLIB.MSG_NEW_CLASSIFIER_CREATED_FROM_SQL.log(string, OperationParser.buildQualifiedName(this.op, new String[0]));
                mIRDataPackage.addNamespaceElement(cloneable2);
                this.setCollationLineageOption(cloneable2, bl);
            }
            if (mIRElement != null) {
                collection2.add(mIRElement);
            } else {
                EXPLIB.WRN_CANNOT_FIND_SRC_CLASSIFIER.log(this.getLog(), mIRElementNode.getName());
            }
        } else if (mIRElementNode.getDestinationElementType() == 209) {
            String string3 = lookupOptions.getName();
            if (this.getDatabaseType() == 20 && mIRElementNode != null && mIRElementNode.getName() != null && mIRElementNode.getName().startsWith("@")) {
                String[] stringArray = this.getStageNameParts(mIRElementNode);
                String string2 = stringArray[0];
                String string4 = stringArray[1];
                String string5 = stringArray[2];
                MIRDataPackage mIRDataPackage = this.getDataPackage(string2, string4, false, true);
                MIRElement mIRElement = this.getClassifier(string5, lookupOptions.isQuoted(), mIRDataPackage);
                if (mIRDataPackage != null && mIRElement == null) {
                    if (mIRDataPackage instanceof MIRConnectionPackage) {
                        MIRConnectionDataSet mIRConnectionDataSet = new MIRConnectionDataSet();
                        mIRConnectionDataSet.setName(string5);
                        mIRDataPackage.addNamespaceElement(mIRConnectionDataSet);
                        this.setCollationLineageOption(mIRConnectionDataSet, lookupOptions.isQuoted());
                        mIRElement = mIRConnectionDataSet;
                    } else if (mIRDataPackage instanceof MIRDatabaseSchema && (string5.startsWith("@%") || string5.startsWith("%") || string5.startsWith("@~"))) {
                        MIRClass mIRClass = new MIRClass();
                        mIRClass.setName(string5);
                        if (string5.startsWith("@%") || string5.startsWith("%")) {
                            mIRClass.setNativeType("TABLE STAGE");
                        } else if (string5.startsWith("@~")) {
                            mIRClass.setNativeType("USER STAGE");
                        }
                        mIRDataPackage.addNamespaceElement(mIRClass);
                        this.setCollationLineageOption(mIRClass, lookupOptions.isQuoted());
                        mIRElement = mIRClass;
                    }
                }
                if (mIRElement != null) {
                    collection2.add(mIRElement);
                } else {
                    EXPLIB.WRN_CANNOT_FIND_SRC_CLASSIFIER.log(this.getLog(), mIRElementNode.getName());
                }
            } else {
                void var13_56;
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                StringBuilder stringBuilder = new StringBuilder();
                MIRConnectionNamespace mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(this.model, string3, stringBuilder);
                string3 = stringBuilder.toString();
                MIRStoreConnection mIRStoreConnection = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace);
                mIRStoreConnection = this.getFileConnection(mIRStoreConnection.getName());
                MIRNamespaceElement mIRNamespaceElement = mIRConnectionNamespace.getNamespaceElement(string3);
                if (mIRNamespaceElement == null) {
                    MIRFlatTextFile mIRFlatTextFile = new MIRFlatTextFile();
                    mIRFlatTextFile.setName(string3);
                    mIRFlatTextFile.addFlatFileDescriptor(new MIRDelimitedFileDescriptor());
                    mIRConnectionNamespace.addNamespaceElement(mIRFlatTextFile);
                    MIRFlatTextFile mIRFlatTextFile2 = mIRFlatTextFile;
                }
                collection2.add((MIRElement)var13_56);
            }
        } else if (mIRElementNode.getDestinationElementType() == 66) {
            MIRDataPackage mIRDataPackage = this.getDataPackage(mIRElementNode, true);
            MIRNamespaceElement mIRNamespaceElement = this.getItem(string, bl, mIRDataPackage.getNamespaceElements());
            if (mIRNamespaceElement instanceof MIRClass) {
                collection2.add(mIRNamespaceElement);
            } else if (mIRNamespaceElement == null) {
                MIRClass mIRClass = new MIRClass();
                mIRClass.setNativeType("TYPE");
                mIRClass.setName(string);
                mIRClass.setLineageOption(1);
                mIRDataPackage.addNamespaceElement(mIRClass);
                MIRClassType mIRClassType = new MIRClassType();
                mIRClassType.setName(string);
                mIRClassType.addAssociatedClass(mIRClass);
                this.model.addType(mIRClassType);
                collection2.add(mIRClass);
            }
        } else if (mIRElementNode.getDestinationElementType() == 23) {
            if (this.op instanceof MIRStoredProcedure) {
                collection2.add(((MIRStoredProcedure)this.op).getParametersDataSet());
            }
        } else if (mIRElementNode.getDestinationElementType() == 77) {
            Object object;
            Object object2;
            List<Object> list2 = null;
            if (!lookupOptions.isPositionBased()) {
                list2 = this.getFeatures(string, bl, collection);
            } else {
                list2 = new ArrayList();
                for (MIRClassifier mIRClassifier : collection) {
                    object2 = this.getFeatureByPosition(mIRClassifier, lookupOptions.getPosition(), false);
                    if (object2 == null) continue;
                    list2.add(object2);
                }
            }
            if (string.isEmpty() && !lookupOptions.isPositionBased()) {
                BLIB.DBG_ATTRIBUTE_NO_NAME_OP.log(OperationParser.buildQualifiedName(this.op, new String[0]), this.op.getSemantics());
            } else if (list2.size() == 0) {
                object = null;
                if (collection.size() == 1) {
                    object = collection.iterator().next();
                }
                if (object != null && ((MIRClassifier)object).getElementType() == 101) {
                    MIRClassifier mIRClassifier;
                    MIRAliasFeature mIRAliasFeature = new MIRAliasFeature();
                    mIRAliasFeature.setName(string);
                    mIRAliasFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                    ((MIRClassifier)object).addFeature(mIRAliasFeature);
                    this.setCollationLineageOption(mIRAliasFeature, bl);
                    list2.add(mIRAliasFeature);
                    object2 = ((MIRClassifier)object).getDestinationOfClassifierMap();
                    if (object2 != null && (mIRClassifier = ((MIRClassifierMap)object2).getSourceClassifiers().first()) != null) {
                        MIRFeature mIRFeature = mIRClassifier.getFeature(string);
                        if (mIRFeature == null) {
                            mIRFeature = this.createFeature(mIRClassifier);
                            mIRFeature.setName(string);
                            mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                            mIRClassifier.addFeature(mIRFeature);
                            this.setCollationLineageOption(mIRFeature, bl);
                        }
                        MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                        mIRFeatureMap.addSourceFeature(mIRFeature);
                        mIRFeatureMap.addDestinationFeature(mIRAliasFeature);
                        ((MIRClassifierMap)object2).addFeatureMap(mIRFeatureMap);
                    }
                } else if (object != null && ((MIRClassifier)object).getElementType() == 209) {
                    MIRFeature mIRFeature;
                    if (lookupOptions.isPositionBased() && (mIRFeature = ((MIRClassifier)object).getFeature(string)) == null) {
                        MIRFeature mIRFeature3 = this.createFeature((MIRClassifier)object);
                        mIRFeature3.setName(":" + String.valueOf(lookupOptions.getPosition()));
                        mIRFeature3.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                        mIRFeature3.setLineageOption(512);
                        mIRFeature3.setPosition((short)lookupOptions.getPosition());
                        ((MIRClassifier)object).addFeature(mIRFeature3);
                        this.setCollationLineageOption(mIRFeature3, bl);
                        list2.add(mIRFeature3);
                    }
                } else {
                    ArrayList<MIRClassifier> arrayList = new ArrayList<MIRClassifier>();
                    for (MIRClassifier mIRClassifier : collection) {
                        if (!mIRClassifier.hasLineageOption(1024) && !mIRClassifier.hasLineageOption(2048) && mIRClassifier.getParent().getElementType() != 215 && (!mIRClassifier.getName().startsWith("@") || this.getDatabaseType() != 20)) continue;
                        arrayList.add(mIRClassifier);
                    }
                    for (MIRClassifier mIRClassifier : arrayList) {
                        MIRFeature mIRFeature = this.createFeature(mIRClassifier);
                        if (mIRClassifier instanceof MIRDataSet) {
                            mIRFeature.setNativeType("Parameter");
                        }
                        if (!lookupOptions.isPositionBased()) {
                            mIRFeature.setName(string);
                        } else {
                            mIRFeature.setPosition((short)lookupOptions.getPosition());
                            mIRFeature.setLineageOption(512);
                            mIRFeature.setName(":" + String.valueOf(lookupOptions.getPosition()));
                        }
                        mIRFeature.setNativeType(mIRClassifier.getNativeType());
                        if (arrayList.size() > 1) {
                            mIRFeature.setLineageOption(1);
                        }
                        mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                        if (!lookupOptions.isPositionBased()) {
                            mIRClassifier.addFeature(mIRFeature);
                            this.setCollationLineageOption(mIRFeature, bl);
                        } else {
                            mIRClassifier.addFeatureUniqueName(mIRFeature);
                        }
                        list2.add(mIRFeature);
                    }
                }
            }
            if (list2.size() == 0 && this.getOptions().supportPackages()) {
                object = null;
                if (list.size() == 1) {
                    object = this.op.getAssociatedClass();
                } else {
                    void var11_43;
                    Object var11_39 = null;
                    if (list.size() == 3) {
                        object2 = list.get(0);
                        MIRDataPackage mIRDataPackage = this.getItem(((MIRObject)object2).getName(), ((MIRElementNamePart)object2).getQuoted(), this.model.getDataPackages());
                    } else {
                        MIRDataPackage mIRDataPackage = this.op.getDataPackage();
                        if (mIRDataPackage == null && this.op.getAssociatedClass() != null) {
                            MIRDataPackage mIRDataPackage3 = this.op.getAssociatedClass().getDataPackage();
                        }
                    }
                    if (var11_43 != null) {
                        object2 = list.get(list.size() - 2);
                        object = this.getClassifier(((MIRObject)object2).getName(), ((MIRElementNamePart)object2).getQuoted(), (MIRPackage)var11_43);
                    }
                }
                if (object instanceof MIRClass) {
                    MIRClass mIRClass = (MIRClass)object;
                    object2 = list.get(list.size() - 1);
                    MIRFeature mIRFeature = this.getItem(((MIRObject)object2).getName(), bl, mIRClass.getFeatures());
                    if (mIRFeature != null && "MEMBER".equals(mIRFeature.getNativeType())) {
                        list2.add(mIRFeature);
                    }
                }
            }
            collection2.addAll(list2);
        }
    }

    private String removeAt(String string) {
        if (string.startsWith("@")) {
            return string.substring(1);
        }
        return string;
    }

    private String[] getStageNameParts(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (mIRElementNamePart.getName().startsWith("/")) {
            if (list.size() == 2) {
                string = this.defaultCatalog.getName();
                string2 = this.defaultSchema.getName();
                string3 = list.get(0).getName();
            } else if (list.size() == 3) {
                string = this.defaultCatalog.getName();
                string2 = this.removeAt(list.get(0).getName());
                string3 = "@" + list.get(1).getName();
            } else if (list.size() == 4) {
                string = this.removeAt(list.get(0).getName());
                string2 = list.get(1).getName();
                string3 = "@" + list.get(2).getName();
            }
            string4 = mIRElementNamePart.getName();
        } else if (list.size() == 1) {
            string = this.defaultCatalog.getName();
            string2 = this.defaultSchema.getName();
            string3 = list.get(0).getName();
        } else if (list.size() == 2) {
            string = this.defaultCatalog.getName();
            string2 = this.removeAt(list.get(0).getName());
            string3 = "@" + list.get(1).getName();
        } else if (list.size() == 3) {
            string = this.removeAt(list.get(0).getName());
            string2 = list.get(1).getName();
            string3 = "@" + list.get(2).getName();
        }
        String[] stringArray = new String[]{string, string2, string3, string4};
        return stringArray;
    }

    private MIRStoreConnection getFileConnection(String string) {
        MIRStoreConnection mIRStoreConnection = this.model.getStoreConnection(string);
        if (mIRStoreConnection == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName(string);
            this.model.addStoreConnection(mIRStoreConnection);
        }
        mIRStoreConnection.setStoreType((byte)2);
        mIRStoreConnection.setSystemType("Flat file");
        return mIRStoreConnection;
    }

    @Override
    public MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by) {
        if (by == 2) {
            Cloneable cloneable;
            MIRElement mIRElement = MIRDecorUtil.getReference(mIRElementNode, (short)75);
            if (mIRElement == null) {
                cloneable = new TreeSet<MIRElement>();
                this.getSrcElements(mIRElementNode, collection, (Collection<MIRElement>)((Object)cloneable));
                if (((TreeSet)cloneable).size() == 1) {
                    mIRElement = (MIRElement)((TreeSet)cloneable).first();
                }
            }
            if (mIRElementNode.getDestinationElementType() != 66) {
                cloneable = new MIRClassifierMap();
                ((MIRClassifierMap)cloneable).addDatabaseOperation(this.getClassifierMap().getDatabaseOperation());
                mIRElement = MIRExpressionAnalyzerHelper.getClassifier(mIRElement, (MIRClassifierMap)cloneable, false);
                if (mIRElement != null) {
                    ((MIRClassifierMap)cloneable).addDestinationClassifier((MIRClassifier)mIRElement);
                    return cloneable;
                }
                ((MIR_Object)cloneable).delete();
            }
        }
        return null;
    }

    private MIRElement getOrCreateExternalTable(String string, boolean bl, MIRDataPackage mIRDataPackage, boolean bl2) {
        if (mIRDataPackage == null) {
            return null;
        }
        MIRElement mIRElement = this.getClassifier(string, bl, mIRDataPackage);
        if (mIRElement == null && (bl2 || mIRDataPackage.getElementType() == 215)) {
            MIRClass mIRClass = new MIRClass();
            mIRClass.setName(string);
            mIRClass.setLineageOption(2048);
            mIRDataPackage.addNamespaceElement(mIRClass);
            this.setCollationLineageOption(mIRClass, bl);
            mIRElement = mIRClass;
        }
        return mIRElement;
    }

    private MIRElement getOrCreateTemporaryTable(String string, boolean bl, MIRElementNode mIRElementNode, MIRDataPackage mIRDataPackage) {
        Object object;
        Object object2;
        boolean bl2;
        MIRStoreConnection mIRStoreConnection;
        if (this.getDatabaseType() != 2 && this.getDatabaseType() != 5 && this.getDatabaseType() != 4 && this.getDatabaseType() != 1) {
            return null;
        }
        MIRStoreConnection mIRStoreConnection2 = mIRStoreConnection = this.defaultCatalog instanceof MIRStoreConnection ? (MIRStoreConnection)this.defaultCatalog : null;
        MIRDataPackage mIRDataPackage2 = mIRElementNode.getElementNamePartCount() == 1 ? (mIRStoreConnection != null ? mIRStoreConnection.getConnectionPackage("__temp__") : this.model.getDataPackage("__temp__")) : mIRDataPackage;
        boolean bl3 = MIRExpressionAnalyzerHelper.isCreateTmpTable(mIRElementNode, this.getDatabaseType());
        boolean bl4 = false;
        if (!bl3) {
            bl4 = MIRExpressionAnalyzerHelper.isDropTable(mIRElementNode);
        }
        boolean bl5 = bl2 = this.getDatabaseType() == 2 && string.startsWith("#") && !bl4;
        if (!(mIRDataPackage2 != null || bl3 || bl4 || bl2)) {
            return null;
        }
        if (mIRDataPackage2 == null) {
            if (mIRStoreConnection != null) {
                mIRDataPackage2 = new MIRConnectionPackage();
                mIRDataPackage2.setName("__temp__");
                mIRStoreConnection.addConnectionPackage((MIRConnectionPackage)mIRDataPackage2);
            } else {
                mIRDataPackage2 = new MIRDatabaseSchema();
                mIRDataPackage2.setName("__temp__");
                this.model.addDataPackage(mIRDataPackage2);
            }
        }
        if ((object2 = this.getClassifier(string, bl, mIRDataPackage2)) != null && bl3) {
            object = string;
            String string2 = tmpTables.get(string);
            int n = 1;
            StringDigest stringDigest = StringDigest.getMd5();
            while (tmpTables.containsKey(object = string + "_" + stringDigest.update(string2 + "/" + string + String.valueOf(n++)).toString())) {
            }
            ((MIRObject)object2).setName((String)object);
            tmpTables.put((String)object, this.op.getName());
            object2 = null;
        }
        if (object2 == null && (bl3 || bl4 || bl2)) {
            object = new MIRClass();
            ((MIRObject)object).setName(string);
            ((MIRClassifier)object).setLineageOption(1024);
            mIRDataPackage2.addNamespaceElement((MIRNamespaceElement)object);
            this.setCollationLineageOption((MIRObject)object, bl);
            object2 = object;
            tmpTables.put(string, this.op.getPath());
        }
        return object2;
    }

    @Override
    public MIRType getDataType(String string) {
        MIRType mIRType = this.model.getType(string);
        return mIRType;
    }

    private MIRType getDataType(MIRElementNode mIRElementNode) {
        MIRType mIRType = null;
        String string = "SQL_" + mIRElementNode.getDataType().toUpperCase();
        String string2 = "undefined";
        if (MIRBaseTypeList.isMIRNumeric(string)) {
            string2 = "number";
        } else if (MIRBaseTypeList.isMIRString(string)) {
            string2 = "text";
        }
        SortedSet<MIRType> sortedSet = this.model.getTypes();
        for (MIRType mIRType2 : sortedSet) {
            if (mIRType2.getElementType() != 4 || !mIRType2.getName().equals(string2)) continue;
            mIRType = mIRType2;
            break;
        }
        if (mIRType == null) {
            mIRType = MIRTypeLib.createBaseType(string2);
            this.model.addType(mIRType);
        }
        return mIRType;
    }

    @Override
    public void setBuiltinOperation(MIROperationNode mIROperationNode) {
        List<MIRElementNamePart> list = mIROperationNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        String string = mIRElementNamePart.getName();
        if (this.getDatabaseType() == 2 && "sp_rename".equalsIgnoreCase(string) && mIROperationNode.getExpressionNodeCount() > 1) {
            MIRClassifier mIRClassifier = this.getClassifier(mIROperationNode.getExpressionNodeByPosition().get(0).getName());
            MIRClassifier mIRClassifier2 = this.getClassifier(mIROperationNode.getExpressionNodeByPosition().get(1).getName());
            if (mIRClassifier != null && mIRClassifier2 != null) {
                MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
                mIRClassifierMap.addDestinationClassifier(mIRClassifier2);
                mIRClassifierMap.addSourceClassifier(mIRClassifier);
                this.op.addClassifierMap(mIRClassifierMap);
                for (MIRFeature mIRFeature : mIRClassifier2.getFeatures()) {
                    MIRFeature mIRFeature2 = mIRClassifier.getFeature(mIRFeature.getName());
                    if (mIRFeature2 == null) continue;
                    MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                    mIRFeatureMap.addDestinationFeature(mIRFeature);
                    mIRFeatureMap.addSourceFeature(mIRFeature2);
                    mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                }
            }
        }
    }

    @Override
    public void getSrcElements(MIROperationNode mIROperationNode, Collection<MIRElement> collection) {
        MIRElement mIRElement;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl;
        List<MIRElementNamePart> list = mIROperationNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        String string = mIRElementNamePart.getName();
        boolean bl2 = mIRElementNamePart.getQuoted();
        MIRDataPackage mIRDataPackage = this.getDataPackage(mIROperationNode, true);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        string = MIRExpressionAnalyzerHelper.getCanonicalName(string, bl2, this.getDatabaseType());
        boolean bl3 = bl = mIRDataPackage != null && mIRDataPackage.getElementType() == 215;
        if (!bl) {
            object4 = this.getOperations(string, bl2, mIRDataPackage);
            if (object4 != null && !object4.isEmpty()) {
                linkedList.addAll((Collection<Object>)object4);
            }
            if (linkedList.isEmpty() && (object3 = this.op.getAssociatedClass()) != null && (object2 = (MIRDataPackage[])this.getItem(string, bl2, ((MIRClass)object3).getOperations())) != null) {
                linkedList.add(object2);
            }
            object3 = this.getPackageName(mIROperationNode);
            if (linkedList.isEmpty() && mIRDataPackage != null && object3 != null && (object2 = this.getClassifier((String)object3, bl2, mIRDataPackage)) instanceof MIRClass && (object = this.getItems(string, bl2, ((MIRClass)(mIRElement = (MIRClass)object2)).getOperations())) != null && !object.isEmpty()) {
                linkedList.addAll((Collection<Object>)object);
            }
            if (linkedList.isEmpty()) {
                for (MIRDataPackage object5 : this.getAlternativeDataPackages(mIROperationNode)) {
                    object4 = this.getOperations(string, bl2, object5);
                    if (object4 == null || object4.isEmpty()) continue;
                    linkedList.addAll((Collection<Object>)object4);
                    break;
                }
            }
            if (linkedList.isEmpty() && mIROperationNode.getElementNamePartCount() == 1 && this.defaultSchemaName != null && !this.defaultSchemaName.isEmpty() && (object4 = this.getOperations(string, bl2, mIRDataPackage = this.getDataPackage(MIRBridgeLib.getPhysicalName(this.defaultCatalog), this.defaultSchemaName, true, true))) != null && !object4.isEmpty()) {
                linkedList.addAll((Collection<Object>)object4);
            }
        } else {
            object4 = this.getClassifier(string, bl2, mIRDataPackage);
            if (object4 != null) {
                linkedList.add(object4);
            }
            if (linkedList.isEmpty() && mIRDataPackage != null) {
                object3 = this.getPackageName(mIROperationNode);
                object2 = (object3 != null ? (String)object3 + "." : "") + string;
                mIRElement = mIRDataPackage.getNamespaceElement((String)object2);
                object = null;
                if (mIRElement != null) {
                    if (mIRElement instanceof MIRStoredProcedure) {
                        object = (MIRStoredProcedure)mIRElement;
                    }
                } else {
                    object = new MIRStoredProcedure();
                    ((MIRObject)object).setName((String)object2);
                    MIRDataSet mIRDataSet = new MIRDataSet();
                    mIRDataSet.setNativeType("parameters");
                    mIRDataSet.setName(string + "_params");
                    mIRDataSet.setLineageOption(2048);
                    ((MIRStoredProcedure)object).addParametersDataSet(mIRDataSet);
                    MIRDataSet mIRDataSet2 = new MIRDataSet();
                    mIRDataSet2.setName(string);
                    mIRDataSet2.setNativeType("result");
                    MIRDataAttribute mIRDataAttribute = new MIRDataAttribute();
                    mIRDataAttribute.setName(string);
                    mIRDataAttribute.setNativeType("Result");
                    mIRDataAttribute.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                    mIRDataSet2.addFeature(mIRDataAttribute);
                    ((MIRStoredProcedure)object).addResultDataSet(mIRDataSet2);
                    mIRDataPackage.addNamespaceElement((MIRNamespaceElement)object);
                }
                if (object != null) {
                    linkedList.add(object);
                }
            }
        }
        object4 = null;
        if (!linkedList.isEmpty()) {
            object4 = (MIRElement)linkedList.get(0);
        }
        if (object4 instanceof MIRStoredProcedure && !bl) {
            boolean bl4 = true;
            object2 = ((MIRStoredProcedure)object4).getClassifierMaps().iterator();
            while (object2.hasNext() && (bl4 = ((MIRClassifierMap)(mIRElement = (MIRClassifierMap)object2.next())).getExpression() == null && bl4)) {
            }
            if (!bl4) {
                collection.add((MIRElement)object4);
            }
            this.redo = bl4 || this.redo;
        } else if (object4 != null) {
            collection.add((MIRElement)object4);
        } else {
            EXPLIB.DBG_CANNOT_FIND_SRC_OPERATION.log(this.getLog(), mIROperationNode.getName());
        }
    }

    private MIRClassifier getClassifier(String string) {
        Object object;
        MIRClassifier mIRClassifier = null;
        if (string == null || string.isEmpty()) {
            return mIRClassifier;
        }
        String[] stringArray = string.split("\\.");
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            object = MIRBridgeLib.removeQuotes(stringArray[i]);
            blArray[i] = object != null && stringArray[i].length() != ((String)object).length();
            stringArray[i] = object;
        }
        if (stringArray.length > 0) {
            Object object2 = null;
            if (stringArray.length == 1) {
                object2 = this.defaultSchema;
            } else {
                object = this.getItem(stringArray[stringArray.length - 2], blArray[blArray.length - 2], this.model.getDataPackages());
                if (((MIRDataPackage)object).getElementType() == 72) {
                    object2 = object;
                }
            }
            if (object2 != null && (object = this.getClassifier(stringArray[stringArray.length - 1], blArray[blArray.length - 1], (MIRPackage)object2)) instanceof MIRClassifier) {
                mIRClassifier = (MIRClassifier)object;
            }
        }
        return mIRClassifier;
    }

    @Override
    public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        boolean bl;
        String string = lookupOptions.getName();
        int n = lookupOptions.getPosition();
        boolean bl2 = mIRClassifier instanceof MIRDataSet && ((MIRDataSet)mIRClassifier).getResultOfStoredProcedure() != null;
        boolean bl3 = mIRClassifier.hasLineageOption(2048) || mIRClassifier.hasLineageOption(1) || mIRClassifier.hasLineageOption(1024);
        boolean bl4 = mIRClassifier instanceof MIRFlatTextFile && lookupOptions.isPositionBased();
        boolean bl5 = bl = lookupOptions.isPositionBased() && (mIRClassifier.getNativeType().equals("EXTERNAL NAMED STAGE") || mIRClassifier.getNativeType().equals("INTERNAL NAMED STAGE"));
        MIRFeature mIRFeature = lookupOptions.isPositionBased() ? this.getFeatureByPosition(mIRClassifier, n, !bl2 && !bl3 && !bl4) : this.getItem(string.isEmpty() ? OUTPUT + n : string, lookupOptions.isQuoted(), mIRClassifier.getFeatures());
        if (mIRFeature == null) {
            if (bl2) {
                mIRFeature = new MIRDataAttribute();
                mIRFeature.setPosition((short)n);
                mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                mIRFeature.setName(string.isEmpty() ? OUTPUT + n : string);
                mIRFeature.setNativeType("Result");
                if (lookupOptions.isPositionBased()) {
                    mIRClassifier.addFeatureUniqueName(mIRFeature);
                } else {
                    mIRClassifier.addFeature(mIRFeature);
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                }
            } else if (bl3) {
                if (!string.isEmpty() || lookupOptions.isPositionBased()) {
                    mIRFeature = this.createFeature(mIRClassifier);
                    mIRFeature.setLineageOption(2048);
                    if (lookupOptions.hasStar()) {
                        mIRFeature.setLineageOption(256);
                    }
                    mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                    mIRFeature.setPosition((short)n);
                    if (lookupOptions.isPositionBased()) {
                        mIRFeature.setName(string.isEmpty() ? OUTPUT + n : string);
                        mIRFeature.setLineageOption(512);
                        mIRClassifier.addFeatureUniqueName(mIRFeature);
                    } else {
                        mIRFeature.setName(string);
                        mIRClassifier.addFeature(mIRFeature);
                        this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                    }
                } else {
                    BLIB.DBG_ATTRIBUTE_NO_NAME_OP.log(OperationParser.buildQualifiedName(this.op, new String[0]), this.op.getSemantics());
                }
            } else if (bl4 || bl) {
                List<MIRFeature> list = mIRClassifier.getFeatureByPosition();
                if (n < list.size()) {
                    mIRFeature = list.get(n);
                }
                if (mIRFeature == null) {
                    mIRFeature = this.createFeature(mIRClassifier);
                    mIRFeature.setName(":" + String.valueOf(lookupOptions.getPosition()));
                    mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
                    mIRFeature.setLineageOption(512);
                    mIRFeature.setPosition((short)lookupOptions.getPosition());
                    mIRClassifier.addFeature(mIRFeature);
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                }
            }
        }
        return mIRFeature;
    }

    @Override
    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        MIRDataSet mIRDataSet;
        if (this.op instanceof MIRStoredProcedure && (mIRDataSet = ((MIRStoredProcedure)this.op).getResultDataSet()) == mIRClassifier) {
            MIRFeature mIRFeature = mIRClassifier.getFeature("SQL CONDITION");
            if (mIRFeature == null || !mIRFeature.isInstanceOf((short)84)) {
                MIRCondition mIRCondition = new MIRCondition();
                mIRCondition.setName("SQL CONDITION");
                mIRClassifier.addFeatureUniqueName(mIRCondition, '_');
                mIRCondition.setPosition((short)Short.MAX_VALUE);
                mIRFeature = mIRCondition;
            }
            return mIRFeature;
        }
        return null;
    }

    @Override
    public void setDstClassifier(MIRElementNode mIRElementNode) {
    }

    @Override
    public boolean isStarCandidate(MIRFeature mIRFeature, boolean bl) {
        return mIRFeature.getElementType() != 84;
    }

    @Override
    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        if (mIRClassifier instanceof MIRDataSet && ((MIRDataSet)mIRClassifier).getResultOfStoredProcedure() != null) {
            for (MIRClassifierMap mIRClassifierMap : ((MIRDataSet)mIRClassifier).getResultOfStoredProcedure().getClassifierMaps()) {
                if (mIRClassifierMap.getExpression() == null) continue;
                return true;
            }
            return false;
        }
        if (mIRClassifier.getNamespace().getElementType() == 215 && !mIRClassifier.hasLineageOption(1)) {
            return false;
        }
        return !mIRClassifier.getName().startsWith("@") || this.getDatabaseType() != 20;
    }

    private MIRFeature createFeature(MIRClassifier mIRClassifier) {
        return mIRClassifier instanceof MIRDataSet ? new MIRDataAttribute() : new MIRAttribute();
    }

    private MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, int n, boolean bl) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (mIRFeature.getPosition() != n) continue;
            return mIRFeature;
        }
        if (bl) {
            BLIB.WRN_CANNOT_FIND_FEATURE_BY_POSITION.log(String.valueOf(n), OperationParser.buildQualifiedName(mIRClassifier, new String[0]), OperationParser.buildQualifiedName(this.op, new String[0]));
        }
        return null;
    }

    public static void processOperations(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel) throws MIRException {
        OperationParserParams operationParserParams = new OperationParserParams(){};
        OperationParser.processOperations(mIRLogger, mIRStoreModel, 0, 0, operationParserParams);
    }

    public static void processOperations(MIRLogger mIRLogger, MIRStoreModel mIRStoreModel, int n, int n2, OperationParserParams operationParserParams) throws MIRException {
        Object object;
        Object object2;
        Cloneable cloneable;
        MIRStoredProcedure mIRStoredProcedure;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{67});
        mIRStoreModel.depthTraversal(objectCollector);
        if (objectCollector.getObjects().size() > 0) {
            BLIB.STS_PARSING_PROCEDURES.log(mIRLogger, new Object[0]);
        }
        LinkedList linkedList = new LinkedList(objectCollector.getObjects());
        Collections.sort(linkedList, new Comparator<MIRStoredProcedure>(){

            @Override
            public int compare(MIRStoredProcedure mIRStoredProcedure, MIRStoredProcedure mIRStoredProcedure2) {
                if (mIRStoredProcedure == mIRStoredProcedure2) {
                    return 0;
                }
                if (mIRStoredProcedure2 == null) {
                    return 1;
                }
                if (mIRStoredProcedure == null) {
                    return -1;
                }
                return mIRStoredProcedure.getName().compareTo(mIRStoredProcedure2.getName());
            }
        });
        int n3 = linkedList.size();
        int n4 = 0;
        while (!linkedList.isEmpty()) {
            if (n3 == n4++) {
                if (linkedList.size() == n3) break;
                n4 = 1;
                n3 = linkedList.size();
            }
            mIRStoredProcedure = (MIRStoredProcedure)linkedList.remove(0);
            cloneable = MIRUdpLib.fetchPropertyType(mIRStoreModel, (short)67, PROPERTY_TYPE__LANGUAGE, (byte)0, "", "", "SQL_VARCHAR", false);
            object2 = MIRUdpLib.getPropertyValueValue(cloneable, mIRStoredProcedure);
            if (object2 != null && !((String)object2).isEmpty() && !"SQL".equalsIgnoreCase((String)object2)) continue;
            try {
                if (mIRStoredProcedure.getSemantics().isEmpty()) continue;
                BLIB.DBG_PARSING_PROCEDURE.log(OperationParser.buildQualifiedName(mIRStoredProcedure, new String[0]));
                object = new OperationParser(mIRLogger, mIRStoreModel, mIRStoredProcedure, operationParserParams.getDefaultCatalog(mIRStoredProcedure), operationParserParams.getDefaultSchema(mIRStoredProcedure), operationParserParams.supportDoubleQuoteStrings(mIRStoredProcedure), n, n2);
                ((MIRExpressionAnalyzer)object).parse(mIRStoredProcedure);
                if (!((OperationParser)object).redo) continue;
                LinkedList<MIRClassifierMap> linkedList2 = new LinkedList<MIRClassifierMap>(mIRStoredProcedure.getClassifierMaps());
                for (MIRClassifierMap mIRClassifierMap : linkedList2) {
                    mIRClassifierMap.delete();
                }
                if (mIRStoredProcedure.getResultDataSet() != null) {
                    mIRStoredProcedure.getResultDataSet().delete();
                }
                linkedList.add(mIRStoredProcedure);
            }
            catch (Throwable throwable) {
                BLIB.ERR_CANNOT_PARSE_EXPRESSION.log(throwable.getMessage() != null ? throwable.getMessage() : "");
                BLIB.DBG_DEBUG.log(throwable, throwable.getMessage() != null ? throwable.getMessage() : "");
            }
        }
        linkedList = new LinkedList(objectCollector.getObjects());
        while (!linkedList.isEmpty()) {
            mIRStoredProcedure = (MIRStoredProcedure)linkedList.remove(0);
            cloneable = new ArrayList();
            ((ArrayList)cloneable).addAll(mIRStoredProcedure.getClassifierMaps());
            object2 = ((ArrayList)cloneable).iterator();
            while (object2.hasNext()) {
                object = (MIRClassifierMap)object2.next();
                if (((MIRClassifierMap)object).getSourceClassifierCount() == 0 && ((MIRClassifierMap)object).getFeatureMapCount() == 0) {
                    ((MIR_Object)object).delete();
                    continue;
                }
                if (((MIRClassifierMap)object).getFeatureMapCount() == 0 && ((MIRClassifierMap)object).getDestinationClassifier() instanceof MIRDataSet && (((MIRDataSet)((MIRClassifierMap)object).getDestinationClassifier()).getParametersOfStoredProcedure() == mIRStoredProcedure || ((MIRDataSet)((MIRClassifierMap)object).getDestinationClassifier()).getResultOfStoredProcedure() == mIRStoredProcedure)) {
                    ((MIR_Object)object).delete();
                    continue;
                }
                if (((MIRClassifierMap)object).getExpression() == null) continue;
                OperationParser.cleanupExpressions((MIRClassifierMap)object);
            }
            if (mIRStoredProcedure.getResultDataSet() == null || mIRStoredProcedure.getResultDataSet().getDestinationOfClassifierMapCount() != 0 || mIRStoredProcedure.getResultDataSet().getFeatureCount() != 0) continue;
            mIRStoredProcedure.getResultDataSet().delete();
        }
    }

    public static abstract class OperationParserParams {
        public boolean supportDoubleQuoteStrings(MIROperation mIROperation) {
            return false;
        }

        public String getDefaultSchema(MIROperation mIROperation) {
            return null;
        }

        public MIRSystemPackage getDefaultCatalog(MIROperation mIROperation) {
            return null;
        }
    }
}

