/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.bridges.bridgelib.parsers.ParserBase;
import MITI.expression.MIRStatementNodeType;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIREmbeddedTransformation;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIRTransformationDataSet;
import MITI.util.log.MIRLogger;
import java.util.Collection;

public abstract class DiParser
extends ParserBase {
    protected MIRDiModel model;

    protected abstract MIRClassifier getDstClassifier(MIRElementNode var1);

    public DiParser(MIRLogger mIRLogger, MIRDiModel mIRDiModel, MIRNamespaceElement mIRNamespaceElement, int n, int n2) {
        super(mIRLogger, mIRNamespaceElement, n, n2);
        this.model = mIRDiModel;
        this.setDatabaseType(n2);
    }

    @Override
    public boolean isMultiStatement() {
        return true;
    }

    @Override
    protected MIRDataPackage getDataPackage(String string, String string2, boolean bl, boolean bl2) {
        if (string.isEmpty()) {
            string = !this.isCatalogSupported && this.isSchemaBasedDatabase(this.getDatabaseType()) ? string2.toUpperCase() : string2.toUpperCase() + "@" + this.model.getName().toUpperCase();
        }
        MIRStoreConnection mIRStoreConnection = this.getItem(string, false, this.model.getStoreConnections());
        if (bl2 && mIRStoreConnection == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName(string);
            DiParser.setSystemType(this.getDatabaseType(), mIRStoreConnection);
            this.model.addStoreConnection(mIRStoreConnection);
        }
        if (mIRStoreConnection != null) {
            string2 = MIRExpressionAnalyzerHelper.getCanonicalName(string2, bl, this.getDatabaseType());
            MIRConnectionPackage mIRConnectionPackage = this.getItem(string2, true, mIRStoreConnection.getConnectionPackages());
            if (bl2 && mIRConnectionPackage == null) {
                mIRConnectionPackage = new MIRConnectionPackage();
                mIRConnectionPackage.setName(string2);
                mIRStoreConnection.addConnectionPackage(mIRConnectionPackage);
                this.setCollationLineageOption(mIRConnectionPackage, bl);
            }
            return mIRConnectionPackage;
        }
        return null;
    }

    @Override
    public MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by) {
        return this.getOutput(mIRElementNode, collection, by, null);
    }

    protected MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by, MIREmbeddedTransformation mIREmbeddedTransformation) {
        MIRElement mIRElement = MIRDecorUtil.getReference(mIRElementNode, (short)75);
        if (by == 2 && !(mIRElement instanceof MIRQueryTable) && (mIRElement = this.getDstClassifier(mIRElementNode)) != null) {
            MIRElement mIRElement2;
            MIRClassifierMap mIRClassifierMap = null;
            if (mIREmbeddedTransformation == null) {
                mIREmbeddedTransformation = this.createTransformation(mIRElementNode, null);
            } else if (mIREmbeddedTransformation.getClassifierMapCount() == 1 && ((MIRClassifierMap)(mIRElement2 = mIREmbeddedTransformation.getClassifierMapIterator().next())).getDestinationClassifier() == null) {
                mIRClassifierMap = mIRElement2;
            }
            if (mIRClassifierMap == null) {
                mIRClassifierMap = new MIRClassifierMap();
                mIREmbeddedTransformation.addClassifierMap(mIRClassifierMap);
            }
            if (mIRElement instanceof MIRTransformationDataSet && ((MIRTransformationDataSet)(mIRElement2 = (MIRTransformationDataSet)mIRElement)).getOutputOfEmbeddedTransformation() == null) {
                mIREmbeddedTransformation.addOutputTransformationDataSet((MIRTransformationDataSet)mIRElement);
            }
            mIRClassifierMap.addDestinationClassifier((MIRClassifier)mIRElement);
            return mIRClassifierMap;
        }
        return null;
    }

    public MIRClassifierMap getOutput(MIROperationNode mIROperationNode, MIREmbeddedTransformation mIREmbeddedTransformation) {
        for (MIRElement mIRElement : mIROperationNode.getReferencedElements()) {
            MIRClassifierMap mIRClassifierMap;
            MIRDataSet mIRDataSet = null;
            if (mIRElement instanceof MIRStoredProcedure) {
                mIRDataSet = ((MIRStoredProcedure)mIRElement).getParametersDataSet();
            } else if (mIRElement instanceof MIRDataSet && (mIRDataSet = (MIRDataSet)mIRElement).getParametersOfStoredProcedure() == null) {
                mIRDataSet = null;
            }
            if (mIRDataSet == null) continue;
            MIRClassifierMap mIRClassifierMap2 = null;
            if (mIREmbeddedTransformation == null) {
                mIREmbeddedTransformation = this.createTransformation(mIROperationNode, null);
            } else if (mIREmbeddedTransformation.getClassifierMapCount() == 1 && (mIRClassifierMap = mIREmbeddedTransformation.getClassifierMapIterator().next()).getDestinationClassifier() == null) {
                mIRClassifierMap2 = mIRClassifierMap;
            }
            if (mIRClassifierMap2 == null) {
                mIRClassifierMap2 = new MIRClassifierMap();
                mIREmbeddedTransformation.addClassifierMap(mIRClassifierMap2);
            }
            mIRClassifierMap2.addDestinationClassifier(mIRDataSet);
            return mIRClassifierMap2;
        }
        return null;
    }

    public void init(MIRDiModel mIRDiModel, MIRDataPackage mIRDataPackage) {
        MIRObject mIRObject;
        this.model = mIRDiModel;
        this.defaultSchema = mIRDataPackage;
        if (mIRDataPackage != null && (mIRObject = mIRDataPackage.getParent()) instanceof MIRSystemPackage) {
            this.defaultCatalog = (MIRSystemPackage)mIRObject;
        }
    }

    protected MIRConnectionPackage getConnectionPackage(MIRExpressionNode mIRExpressionNode, boolean bl) {
        MIRConnectionPackage mIRConnectionPackage = (MIRConnectionPackage)this.getDataPackage(mIRExpressionNode, true);
        if (mIRConnectionPackage != null) {
            MIRStoreConnection mIRStoreConnection = mIRConnectionPackage.getStoreConnection();
            if (bl) {
                if (mIRStoreConnection.getSourceOfMappingModel() == null) {
                    this.model.addSourceStoreConnection(mIRStoreConnection);
                }
            } else if (mIRStoreConnection.getDestinationOfMappingModel() == null) {
                this.model.addDestinationStoreConnection(mIRStoreConnection);
            }
        }
        return mIRConnectionPackage;
    }

    protected MIRSqlQuery createTransformation(MIRExpressionNode mIRExpressionNode, String string) {
        MIRDiModel mIRDiModel = this.getClassifierMap().getDiModel();
        MIRSqlQuery mIRSqlQuery = new MIRSqlQuery();
        int n = mIRDiModel.getTransformationCount() + 1;
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRDiModel, mIRSqlQuery.getElementType(), "Query Position", (byte)0, "", "", "SQL_VARCHAR", true);
        MIRUdpLib.setPropertyValue(mIRPropertyType, String.valueOf(n), mIRSqlQuery);
        if (string != null && !string.isEmpty()) {
            mIRSqlQuery.setName(string);
        } else {
            int n2 = this.getStatementType(mIRExpressionNode);
            if (n2 != -1) {
                mIRSqlQuery.setName(MIRStatementNodeType.getName(n2));
            }
        }
        mIRDiModel.addTransformationUniqueName(mIRSqlQuery);
        return mIRSqlQuery;
    }
}

