/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib.parsers;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.parsers.DiParser;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.decoration.MIRDecorUtil;
import MITI.messages.MIRExpressionLib.EXPLIB;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryFilter;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRType;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiOperationParser
extends DiParser {
    private static final String SP_RETURNVALUE = "ReturnValue";
    private static final String SP_PARAMETERS_SUFFIX = "_params";
    private static final String TEMPORARY = "Temporary";
    protected MIRClassifier paramsDataSet;
    private Collection<MIRClassifier> predefinedClassifiers = new HashSet<MIRClassifier>();
    private List<MIRQueryTable> fullyDefinedTables = new LinkedList<MIRQueryTable>();
    List<MIRNamespaceElement> namespaceElementsToRename = new ArrayList<MIRNamespaceElement>();
    private Map<String, MIRClassType> tableTypes = new HashMap<String, MIRClassType>();
    private static Map<String, MIRQueryTable> synonyms = new HashMap<String, MIRQueryTable>();
    private static final String OUTPUT = "Output_";

    public DiOperationParser(MIRDiModel mIRDiModel, MIRNamespaceElement mIRNamespaceElement, int n, int n2, MIRClassifier mIRClassifier, Set<MIRClassifier> set) {
        super(MIRLogger.getLogger(), mIRDiModel, mIRNamespaceElement, n, n2);
        this.paramsDataSet = mIRClassifier;
        this.setRecoverFromSyntaxErrors(true);
        if (set != null) {
            this.predefinedClassifiers = set;
        }
    }

    @Override
    public boolean startStatement(MIRStatementNode mIRStatementNode) {
        if (mIRStatementNode.getStatementType() == 30 && this.getDatabaseType() == 11) {
            MIRDelimiterNode mIRDelimiterNode = (MIRDelimiterNode)mIRStatementNode.getExpressionNodeByPosition().get(0);
            MIRElementNode mIRElementNode = (MIRElementNode)mIRDelimiterNode.getExpressionNodeByPosition().get(0);
            MIRElementNamePart mIRElementNamePart = mIRElementNode.getElementNamePartByPosition().get(mIRElementNode.getElementNamePartCount() - 1);
            String string = mIRElementNamePart.getName();
            this.defaultSchema = this.getDataPackage(this.defaultCatalog != null ? this.defaultCatalog.getName() : "", string, mIRElementNamePart.getQuoted(), true);
        }
        return true;
    }

    @Override
    public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        this.getSrcElements(new LookupOptions(mIRElementNode, false), collection, collection2);
    }

    private void renameTables(String string) {
        for (MIRNamespaceElement mIRNamespaceElement : this.namespaceElementsToRename) {
            mIRNamespaceElement.setName(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getSrcElements(LookupOptions lookupOptions, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
        MIRElementNode mIRElementNode = lookupOptions.getNode();
        String string = MIRExpressionAnalyzerHelper.getCanonicalName(lookupOptions.getName(), lookupOptions.isQuoted(), this.getDatabaseType());
        if (mIRElementNode.getDestinationElementType() == 75) {
            MIRElement mIRElement;
            if (MIRExpressionAnalyzerHelper.isCreateSynonym(mIRElementNode)) {
                return;
            }
            MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, true);
            if (MIRExpressionAnalyzerHelper.isRenameTable(mIRElementNode)) {
                if (mIRElementNode.getPosition() == 0) {
                    this.namespaceElementsToRename.clear();
                    this.namespaceElementsToRename = this.getItems(string, lookupOptions.isQuoted(), mIRConnectionPackage.getNamespaceElements());
                    this.namespaceElementsToRename.addAll(this.getItems(string, lookupOptions.isQuoted(), mIRConnectionPackage.getImportedNamespaceElements()));
                    this.namespaceElementsToRename.addAll(this.getItems(string, lookupOptions.isQuoted(), mIRConnectionPackage.getClassifiers()));
                } else if (mIRElementNode.getPosition() == 1) {
                    MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
                    String string2 = mIRElementNamePart.getName();
                    this.renameTables(string2);
                }
                mIRElement = null;
            } else {
                MIRClassifier mIRClassifier;
                mIRElement = null;
                if (!synonyms.isEmpty()) {
                    mIRElement = synonyms.get(string);
                }
                if (mIRElement == null) {
                    mIRElement = this.getClassifier(string, lookupOptions.isQuoted(), mIRConnectionPackage);
                }
                if (mIRElement == null && "%ROWTYPE".equalsIgnoreCase(mIRElementNode.getDataType())) {
                    mIRElement = this.getItem(mIRConnectionPackage, string, lookupOptions.isQuoted());
                }
                if (mIRElement == null && (mIRClassifier = (MIRClassifier)this.getItem(string, lookupOptions.isQuoted(), this.fullyDefinedTables)) != null && (TEMPORARY.equals(mIRClassifier.getNativeType()) || mIRClassifier.getConnectionDataPackage() == mIRConnectionPackage)) {
                    mIRElement = mIRClassifier;
                }
                if (mIRConnectionPackage != null && mIRElement == null) {
                    MIRConnectionDataSet object2 = new MIRConnectionDataSet();
                    object2.setName(string);
                    MIRNamespaceElement mIRNamespaceElement = this.getItem(mIRConnectionPackage, string, lookupOptions.isQuoted());
                    if (mIRNamespaceElement instanceof MIRClassifier) {
                        object2.setLineageOptions(((MIRClassifier)mIRNamespaceElement).getLineageOptions());
                    }
                    if (this.getOptions().isReservedClassifierKeyword(string)) {
                        object2.setLineageOption(1);
                    }
                    mIRConnectionPackage.addNamespaceElement(object2);
                    this.setCollationLineageOption(object2, lookupOptions.isQuoted());
                    mIRElement = object2;
                }
            }
            if (mIRElement != null) {
                collection2.add(mIRElement);
            }
        } else if (mIRElementNode.getDestinationElementType() == 24) {
            MIRFeature mIRFeature;
            if (lookupOptions.isPositionBased()) {
                mIRFeature = this.getFeatureByPosition(this.paramsDataSet, lookupOptions.getPosition());
                if (mIRFeature == null) {
                    mIRFeature = this.createFeature(this.paramsDataSet);
                    mIRFeature.setPosition((short)lookupOptions.getPosition());
                    mIRFeature.setLineageOption(512);
                    mIRFeature.setName(":" + String.valueOf(lookupOptions.getPosition()));
                    this.paramsDataSet.addFeature(mIRFeature);
                }
            } else {
                mIRFeature = this.paramsDataSet.getFeature(string);
                if (mIRFeature == null) {
                    mIRFeature = this.createFeature(this.paramsDataSet);
                    if (string.isEmpty()) {
                        int n = lookupOptions.getPosition();
                        string = "$" + n;
                    }
                    mIRFeature.setName(string);
                    this.paramsDataSet.addFeature(mIRFeature);
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                }
            }
            collection2.add(mIRFeature);
        } else if (mIRElementNode.getDestinationElementType() == 77) {
            List<MIRElementNamePart> list;
            if (this.getOptions().supportPackages()) {
                list = mIRElementNode.getElementNamePartByPosition();
                Iterator<MIRClassifier> iterator = MIRDecorUtil.getClassifierPart(mIRElementNode);
                MIRElementNamePart string5 = MIRDecorUtil.getFeaturePart(mIRElementNode);
                if (list.size() >= 2 && iterator != null && string5 != null && !string5.getName().isEmpty() || list.size() == 1 && string5 != null && !string5.getName().isEmpty()) {
                    void var9_29;
                    Object object;
                    Object object2;
                    Object var9_26 = null;
                    boolean bl = false;
                    if (list.size() > 1) {
                        String string3 = ((MIRObject)((Object)iterator)).getName();
                        bl = ((MIRElementNamePart)((Object)iterator)).getQuoted();
                    } else {
                        object2 = this.model.getName();
                        object = ((String)object2).split("\\.");
                        if (((String[])object).length == 3) {
                            String string4 = object[1];
                            bl = false;
                        }
                    }
                    object2 = this.getItem((String)var9_29, bl, this.predefinedClassifiers);
                    object = null;
                    if (object2 instanceof MIRClass && "PACKAGE".equals(((MIRElement)object2).getNativeType())) {
                        object = (MIRClass)object2;
                    }
                    MIRFeature mIRFeature = null;
                    if (object != null) {
                        mIRFeature = this.getItem(string5.getName(), string5.getQuoted(), ((MIRClassifier)object).getFeatures());
                    }
                    if (object != null && mIRFeature != null) {
                        MIRObject mIRObject;
                        String string6 = null;
                        boolean bl2 = false;
                        if (list.size() == 3) {
                            mIRObject = list.get(0);
                            string6 = mIRObject.getName();
                            bl2 = ((MIRElementNamePart)mIRObject).getQuoted();
                        } else {
                            string6 = ((MIRNamespaceElement)object).getNamespace().getName();
                        }
                        mIRObject = (MIRConnectionPackage)this.getDataPackage(this.defaultCatalog.getName(), string6, bl2, true);
                        MIRStoreConnection mIRStoreConnection = ((MIRConnectionPackage)mIRObject).getStoreConnection();
                        if (mIRStoreConnection.getSourceOfMappingModel() == null) {
                            mIRStoreConnection.addSourceOfMappingModel(this.model);
                        }
                        MIRConnectionDataSet mIRConnectionDataSet = null;
                        MIRElement mIRElement = this.getItem((String)var9_29, bl, ((MIRNamespace)mIRObject).getNamespaceElements());
                        if (mIRElement instanceof MIRConnectionDataSet) {
                            mIRConnectionDataSet = (MIRConnectionDataSet)mIRElement;
                        } else {
                            mIRConnectionDataSet = new MIRConnectionDataSet();
                            mIRConnectionDataSet.setName((String)var9_29);
                            ((MIRNamespace)mIRObject).addNamespaceElement(mIRConnectionDataSet);
                        }
                        collection.clear();
                        collection.add(mIRConnectionDataSet);
                    }
                }
            }
            list = new LinkedList<MIRElementNamePart>();
            if (lookupOptions.hasStar()) {
                block0: for (MIRClassifier mIRClassifier : collection) {
                    for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                        if (!mIRFeature.hasLineageOption(256)) continue;
                        list.add((MIRElementNamePart)((Object)mIRFeature));
                        continue block0;
                    }
                }
            } else if (lookupOptions.isPositionBased()) {
                for (MIRClassifier mIRClassifier : collection) {
                    MIRFeature mIRFeature = this.getFeatureByPosition(mIRClassifier, lookupOptions.getPosition());
                    if (mIRFeature == null) continue;
                    list.add((MIRElementNamePart)((Object)mIRFeature));
                }
            } else {
                list.addAll(this.getFeatures(string, lookupOptions.isQuoted(), collection));
            }
            if (list.isEmpty()) {
                boolean bl = collection.size() > 1;
                for (MIRClassifier mIRClassifier : collection) {
                    MIRFeature mIRFeature;
                    if (mIRClassifier instanceof MIRFlatTextFile) {
                        mIRFeature = new MIRAttribute();
                        mIRFeature.setLineageOption(512);
                        mIRFeature.addType(this.getType(lookupOptions));
                        mIRFeature.setPosition(this.getPosition(mIRClassifier, lookupOptions));
                        if (!string.isEmpty()) {
                            mIRFeature.setName(string);
                        } else {
                            mIRFeature.setName(":" + String.valueOf(mIRFeature.getPosition()));
                        }
                        mIRClassifier.addFeatureUniqueName(mIRFeature);
                    } else {
                        mIRFeature = this.createFeature(mIRClassifier);
                        if (lookupOptions.isPositionBased()) {
                            mIRFeature.setPosition((short)lookupOptions.getPosition());
                            mIRFeature.setLineageOption(512);
                            mIRFeature.setName(":" + String.valueOf(lookupOptions.getPosition()));
                        } else {
                            mIRFeature.setName(string);
                        }
                        mIRClassifier.addFeature(mIRFeature);
                    }
                    this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
                    if (bl || this.getOptions().isReservedFeatureKeyword(mIRFeature.getName())) {
                        mIRFeature.setLineageOption(1);
                    }
                    if (mIRClassifier.hasLineageOption(1024)) {
                        mIRFeature.setLineageOption(1024);
                    }
                    list.add((MIRElementNamePart)((Object)mIRFeature));
                }
            }
            collection2.addAll(list);
        } else if (mIRElementNode.getDestinationElementType() == 209) {
            String string7 = lookupOptions.getName();
            if (this.getDatabaseType() == 20 && mIRElementNode != null && mIRElementNode.getName() != null && mIRElementNode.getName().startsWith("@")) {
                String[] stringArray = this.getStageNameParts(mIRElementNode);
                String string8 = stringArray[0];
                String string9 = stringArray[1];
                String string10 = stringArray[2];
                MIRDataPackage mIRDataPackage = this.getDataPackage(string8, string9, false, true);
                MIRElement mIRElement = this.getClassifier(string10, lookupOptions.isQuoted(), mIRDataPackage);
                if (mIRDataPackage != null && mIRElement == null) {
                    if (mIRDataPackage instanceof MIRConnectionPackage) {
                        MIRConnectionDataSet mIRConnectionDataSet = new MIRConnectionDataSet();
                        mIRConnectionDataSet.setName(string10);
                        mIRDataPackage.addNamespaceElement(mIRConnectionDataSet);
                        this.setCollationLineageOption(mIRConnectionDataSet, lookupOptions.isQuoted());
                        mIRElement = mIRConnectionDataSet;
                    } else if (mIRDataPackage instanceof MIRDatabaseSchema && (string10.startsWith("@%") || string10.startsWith("%") || string10.startsWith("@~"))) {
                        MIRClass mIRClass = new MIRClass();
                        mIRClass.setName(string10);
                        if (string10.startsWith("@%") || string10.startsWith("%")) {
                            mIRClass.setNativeType("TABLE STAGE");
                        } else if (string10.startsWith("@~")) {
                            mIRClass.setNativeType("USER STAGE");
                        }
                        mIRDataPackage.addNamespaceElement(mIRClass);
                        this.setCollationLineageOption(mIRClass, lookupOptions.isQuoted());
                        mIRElement = mIRClass;
                    }
                }
                if (mIRElement != null) {
                    collection2.add(mIRElement);
                }
            } else {
                if (string7.endsWith("/")) {
                    string7 = string7.substring(0, string7.length() - 1);
                }
                StringBuilder stringBuilder = new StringBuilder();
                MIRConnectionNamespace mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(this.model, string7, stringBuilder);
                string7 = stringBuilder.toString();
                MIRStoreConnection mIRStoreConnection2 = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace);
                mIRStoreConnection2 = this.getFileConnection(mIRStoreConnection2.getName());
                MIRNamespaceElement mIRNamespaceElement = mIRConnectionNamespace.getNamespaceElement(string7);
                if (mIRNamespaceElement == null) {
                    MIRFlatTextFile mIRFlatTextFile = new MIRFlatTextFile();
                    mIRFlatTextFile.setName(string7);
                    this.setFlatFileDescriptor(mIRFlatTextFile);
                    mIRConnectionNamespace.addNamespaceElement(mIRFlatTextFile);
                    mIRNamespaceElement = mIRFlatTextFile;
                }
                collection2.add(mIRNamespaceElement);
            }
        }
    }

    @Override
    protected MIRDataPackage getDataPackage(String string, String string2, boolean bl, boolean bl2) {
        return super.getDataPackage(string.toUpperCase(), string2, bl, bl2);
    }

    private MIRFeature createFeature(MIRClassifier mIRClassifier) {
        MIRStructuralFeature mIRStructuralFeature = null;
        if (mIRClassifier instanceof MIRDataSet) {
            mIRStructuralFeature = new MIRDataAttribute();
            mIRStructuralFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
        } else if (mIRClassifier instanceof MIRQueryTable) {
            mIRStructuralFeature = new MIRQueryColumn();
        } else if (mIRClassifier instanceof MIRFlatTextFile) {
            mIRStructuralFeature = new MIRAttribute();
            mIRStructuralFeature.addType(MIRTypeLib.getUndefinedBaseType(this.model));
        } else {
            mIRStructuralFeature = new MIRConnectionDataAttribute();
        }
        return mIRStructuralFeature;
    }

    @Override
    public void getSrcElements(MIROperationNode mIROperationNode, Collection<MIRElement> collection) {
        List<MIRElementNamePart> list = mIROperationNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        boolean bl = mIRElementNamePart.getQuoted();
        String string = MIRExpressionAnalyzerHelper.getCanonicalName(mIRElementNamePart.getName(), bl, this.getDatabaseType());
        MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIROperationNode, true);
        String string2 = this.getPackageName(mIROperationNode);
        String string3 = (string2 != null ? string2 + "." : "") + string;
        MIRNamespaceElement mIRNamespaceElement = mIRConnectionPackage.getNamespaceElement(string3);
        MIRStoredProcedure mIRStoredProcedure = null;
        if (mIRNamespaceElement != null) {
            if (mIRNamespaceElement instanceof MIRStoredProcedure) {
                mIRStoredProcedure = (MIRStoredProcedure)mIRNamespaceElement;
            }
        } else {
            mIRStoredProcedure = new MIRStoredProcedure();
            mIRStoredProcedure.setName(string3);
            MIRDataSet mIRDataSet = new MIRDataSet();
            mIRDataSet.setName(string + SP_PARAMETERS_SUFFIX);
            mIRStoredProcedure.addParametersDataSet(mIRDataSet);
            MIRDataSet mIRDataSet2 = new MIRDataSet();
            mIRDataSet2.setName(string);
            if (!MIRExpressionAnalyzerHelper.isInClassifierContext(mIROperationNode)) {
                MIRFeature mIRFeature = this.createFeature(mIRDataSet2);
                mIRFeature.setPosition((short)1);
                mIRFeature.setName(SP_RETURNVALUE);
                mIRFeature.setLineageOption(512);
                mIRDataSet2.addFeature(mIRFeature);
            }
            mIRStoredProcedure.addResultDataSet(mIRDataSet2);
            mIRConnectionPackage.addNamespaceElement(mIRStoredProcedure);
        }
        if (mIRStoredProcedure != null) {
            collection.add(mIRStoredProcedure);
        } else {
            EXPLIB.DBG_CANNOT_FIND_SRC_OPERATION.log(this.getLog(), mIROperationNode.getName());
        }
    }

    @Override
    public MIRClassifierMap getOutput(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, byte by) {
        MIRClassifierMap mIRClassifierMap = super.getOutput(mIRElementNode, collection, by);
        if (mIRElementNode.getDestinationElementType() == 66) {
            return null;
        }
        if (mIRElementNode.getDestinationElementType() == 49) {
            MIRElementNamePart mIRElementNamePart = MIRDecorUtil.getLastPart(mIRElementNode);
            String string = MIRExpressionAnalyzerHelper.getSynonymReferencedTable(mIRElementNode);
            List<MIRQueryTable> list = this.getItems(string, mIRElementNamePart.getQuoted(), this.fullyDefinedTables);
            MIRQueryTable mIRQueryTable = null;
            if (list != null) {
                Iterator<MIRQueryTable> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MIRQueryTable mIRQueryTable2;
                    mIRQueryTable = mIRQueryTable2 = iterator.next();
                }
            }
            if (mIRQueryTable != null) {
                synonyms.put(mIRElementNode.getName(), mIRQueryTable);
            }
        }
        return mIRClassifierMap;
    }

    @Override
    public MIRType getDataType(String string) {
        return this.tableTypes.get(string);
    }

    MIRType getType(LookupOptions lookupOptions) {
        return MIRTypeLib.getUndefinedBaseType(this.model);
    }

    void setFlatFileDescriptor(MIRFlatTextFile mIRFlatTextFile) {
        mIRFlatTextFile.addFlatFileDescriptor(new MIRDelimitedFileDescriptor());
    }

    void setFlatFileDescriptor(MIRQueryTable mIRQueryTable) {
        mIRQueryTable.addFlatFileDescriptor(new MIRDelimitedFileDescriptor());
    }

    short getPosition(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        return (short)lookupOptions.getPosition();
    }

    private MIRStoreConnection getFileConnection(String string) {
        MIRStoreConnection mIRStoreConnection = this.model.getStoreConnection(string);
        if (mIRStoreConnection == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName(string);
            this.model.addStoreConnection(mIRStoreConnection);
        }
        mIRStoreConnection.setStoreType((byte)2);
        mIRStoreConnection.setSystemType("Flat file");
        if (mIRStoreConnection.getSourceOfMappingModel() == null) {
            this.model.addSourceStoreConnection(mIRStoreConnection);
        }
        return mIRStoreConnection;
    }

    private MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, int n) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (mIRFeature.getPosition() != n) continue;
            return mIRFeature;
        }
        return null;
    }

    @Override
    public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
        String string;
        MIRFeature mIRFeature = null;
        short s = 0;
        if (lookupOptions.hasStar()) {
            string = lookupOptions.getName() != null && !lookupOptions.getName().isEmpty() ? lookupOptions.getName() : "*";
            for (MIRFeature mIRFeature2 : mIRClassifier.getFeatures()) {
                if (mIRFeature2.getPosition() != s || !mIRFeature2.hasLineageOption(256)) continue;
                mIRFeature = mIRFeature2;
                break;
            }
            if (mIRFeature == null) {
                mIRFeature = this.createFeature(mIRClassifier);
                mIRFeature.setName(string);
                mIRFeature.setLineageOption(256);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
            }
        } else if (lookupOptions.isPositionBased()) {
            s = (short)lookupOptions.getPosition();
            string = ":" + String.valueOf(s);
            mIRFeature = this.getFeatureByPosition(mIRClassifier, s);
        } else {
            string = MIRExpressionAnalyzerHelper.getCanonicalName(lookupOptions.getName(), lookupOptions.isQuoted(), this.getDatabaseType());
            mIRFeature = this.getItem(string, lookupOptions.isQuoted(), mIRClassifier.getFeatures());
        }
        if (mIRFeature == null) {
            mIRFeature = this.createFeature(mIRClassifier);
            if (lookupOptions.isPositionBased()) {
                mIRFeature.setPosition(s);
                mIRFeature.setLineageOption(512);
            }
            if (string.isEmpty()) {
                mIRFeature.setName(OUTPUT + s);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
            } else {
                mIRFeature.setName(string);
                mIRClassifier.addFeatureUniqueName(mIRFeature);
                this.setCollationLineageOption(mIRFeature, lookupOptions.isQuoted());
            }
            if (this.fullyDefinedTables.contains(mIRClassifier) || this.getClassifierMap().getDestinationClassifier() == mIRClassifier) {
                mIRFeature.setPosition((short)lookupOptions.getPosition());
            }
        }
        if (mIRClassifier.hasLineageOption(1024)) {
            mIRFeature.setLineageOption(1024);
        }
        return mIRFeature;
    }

    @Override
    public MIRFeature getDstCondition(MIRClassifier mIRClassifier) {
        MIRFeature mIRFeature = mIRClassifier.getFeature("SQL CONDITION");
        if (mIRFeature == null || !mIRFeature.isInstanceOf((short)333)) {
            MIRQueryFilter mIRQueryFilter = new MIRQueryFilter();
            mIRQueryFilter.setName("SQL CONDITION");
            mIRClassifier.addFeatureUniqueName(mIRQueryFilter, '_');
            mIRQueryFilter.setPosition((short)Short.MAX_VALUE);
            mIRQueryFilter.setLineageOption(128);
            mIRFeature = mIRQueryFilter;
        }
        return mIRFeature;
    }

    private String removeAt(String string) {
        if (string.startsWith("@")) {
            return string.substring(1);
        }
        return string;
    }

    private String[] getStageNameParts(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (mIRElementNamePart.getName().startsWith("/")) {
            if (list.size() == 2) {
                string = this.defaultCatalog.getName();
                string2 = this.defaultSchema.getName();
                string3 = list.get(0).getName();
            } else if (list.size() == 3) {
                string = this.defaultCatalog.getName();
                string2 = this.removeAt(list.get(0).getName());
                string3 = "@" + list.get(1).getName();
            } else if (list.size() == 4) {
                string = this.removeAt(list.get(0).getName());
                string2 = list.get(1).getName();
                string3 = "@" + list.get(2).getName();
            }
            string4 = mIRElementNamePart.getName();
        } else if (list.size() == 1) {
            string = this.defaultCatalog.getName();
            string2 = this.defaultSchema.getName();
            string3 = list.get(0).getName();
        } else if (list.size() == 2) {
            string = this.defaultCatalog.getName();
            string2 = this.removeAt(list.get(0).getName());
            string3 = "@" + list.get(1).getName();
        } else if (list.size() == 3) {
            string = this.removeAt(list.get(0).getName());
            string2 = list.get(1).getName();
            string3 = "@" + list.get(2).getName();
        }
        String[] stringArray = new String[]{string, string2, string3, string4};
        return stringArray;
    }

    @Override
    protected MIRClassifier getDstClassifier(MIRElementNode mIRElementNode) {
        MIRElement mIRElement = new MIRQueryTable();
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElementNamePart mIRElementNamePart = list.get(list.size() - 1);
        if (mIRElementNode.getDestinationElementType() == 209) {
            String string = mIRElementNode.getName();
            if (string.startsWith("@") && this.getDatabaseType() == 20) {
                String[] stringArray = this.getStageNameParts(mIRElementNode);
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                MIRDataPackage mIRDataPackage = this.getDataPackage(string2, string3, false, true);
                if (mIRDataPackage != null && mIRDataPackage instanceof MIRConnectionPackage) {
                    mIRElement.setName(string4);
                    this.setCollationLineageOption(mIRElement, mIRElementNamePart.getQuoted());
                    ((MIRConnectionPackage)mIRDataPackage).addClassifier((MIRClassifier)mIRElement);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                MIRConnectionNamespace mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(this.model, string, stringBuilder);
                MIRStoreConnection mIRStoreConnection = MIRBridgeLib.getStoreConnection(mIRConnectionNamespace);
                mIRStoreConnection = this.getFileConnection(mIRStoreConnection.getName());
                mIRElement.setName(stringBuilder.toString());
                this.setFlatFileDescriptor((MIRQueryTable)mIRElement);
                mIRConnectionNamespace.addClassifier((MIRClassifier)mIRElement);
            }
        } else if (mIRElementNode.getDestinationElementType() == 66) {
            MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, false);
            mIRElement.setNativeType("TYPE");
            String string = mIRElementNamePart.getName();
            mIRElement.setName(string);
            mIRConnectionPackage.addClassifier((MIRClassifier)mIRElement);
            MIRClass mIRClass = new MIRClass();
            mIRClass.setNativeType("TYPE");
            mIRClass.setName(string);
            MIRClassType mIRClassType = new MIRClassType();
            mIRClassType.setName(string);
            mIRClassType.addAssociatedClass(mIRClass);
            this.tableTypes.put(string, mIRClassType);
        } else {
            List<MIRClassifier> list2;
            MIRConnectionPackage mIRConnectionPackage = this.getConnectionPackage(mIRElementNode, false);
            mIRElement.setName(MIRExpressionAnalyzerHelper.getCanonicalName(mIRElementNamePart.getName(), mIRElementNamePart.getQuoted(), this.getDatabaseType()));
            List<MIRQueryTable> list3 = this.getItems(mIRElement.getName(), mIRElementNamePart.getQuoted(), this.fullyDefinedTables);
            MIRElement mIRElement2 = null;
            if (list3 != null) {
                list2 = list3.iterator();
                while (list2.hasNext()) {
                    MIRQueryTable mIRQueryTable = list2.next();
                    if (!TEMPORARY.equals(mIRQueryTable.getNativeType()) && mIRQueryTable.getConnectionDataPackage() != mIRConnectionPackage) continue;
                    mIRElement2 = mIRQueryTable;
                    break;
                }
            }
            if (mIRElement2 != null) {
                if (TEMPORARY.equals(mIRElement2.getNativeType())) {
                    mIRConnectionPackage = null;
                    mIRElement = mIRElement2;
                } else {
                    ((MIRClassifier)mIRElement).setLineageOptions(((MIRClassifier)mIRElement2).getLineageOptions());
                    this.copyFeatures((MIRClassifier)mIRElement2, (MIRClassifier)mIRElement);
                }
            }
            if (MIRExpressionAnalyzerHelper.isCreateTable(mIRElementNode)) {
                if (MIRExpressionAnalyzerHelper.isCreateTmpTable(mIRElementNode, this.getDatabaseType())) {
                    mIRConnectionPackage = null;
                    this.setTemporary((MIRClassifier)mIRElement);
                }
                this.fullyDefinedTables.add((MIRQueryTable)mIRElement);
            } else if (MIRExpressionAnalyzerHelper.isDropTable(mIRElementNode)) {
                if (mIRConnectionPackage != null) {
                    if (mIRElement2 != null) {
                        list2 = this.getItems(mIRElement.getName(), mIRElementNamePart.getQuoted(), mIRConnectionPackage.getClassifiers());
                        for (MIRClassifier mIRClassifier : list2) {
                            this.setTemporary(mIRClassifier);
                        }
                    }
                    if ((list2 = mIRConnectionPackage.getNamespaceElement(mIRElement.getName())) instanceof MIRConnectionDataSet) {
                        this.setTemporary((MIRConnectionDataSet)((Object)list2));
                    }
                }
                this.setTemporary((MIRClassifier)mIRElement);
            }
            if (mIRConnectionPackage != null) {
                mIRConnectionPackage.addClassifier((MIRClassifier)mIRElement);
            }
            this.setCollationLineageOption(mIRElement, mIRElementNamePart.getQuoted());
        }
        return mIRElement;
    }

    private void setTemporary(MIRClassifier mIRClassifier) {
        mIRClassifier.setLineageOption(1024);
        mIRClassifier.setNativeType(TEMPORARY);
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            mIRFeature.setLineageOption(1024);
        }
    }

    private MIRNamespaceElement getItem(MIRConnectionPackage mIRConnectionPackage, String string, boolean bl) {
        MIRNamespaceElement mIRNamespaceElement = this.getItem(string, bl, mIRConnectionPackage.getNamespaceElements());
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = this.getItem(string, bl, mIRConnectionPackage.getImportedNamespaceElements());
        }
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = this.getItem(string, bl, mIRConnectionPackage.getClassifiers());
        }
        return mIRNamespaceElement;
    }

    private void copyFeatures(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            MIRQueryColumn mIRQueryColumn = new MIRQueryColumn((MIRQueryColumn)mIRFeature);
            mIRQueryColumn.setLineageOption(512);
            mIRQueryColumn.setLineageOption(1024);
            mIRClassifier2.addFeatureUniqueName(mIRQueryColumn);
        }
    }

    @Override
    public boolean isClassifierDefined(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            return false;
        }
        if (this.fullyDefinedTables.contains(mIRClassifier)) {
            return true;
        }
        MIRClassifier mIRClassifier2 = this.getItem(MIRBridgeLib.getPhysicalName(mIRClassifier), mIRClassifier.hasLineageOption(4096), this.predefinedClassifiers);
        if (mIRClassifier2 != null) {
            for (MIRFeature mIRFeature : mIRClassifier2.getFeatureByPosition()) {
                String string = MIRBridgeLib.getPhysicalName(mIRFeature);
                MIRFeature mIRFeature2 = this.getItem(MIRBridgeLib.getPhysicalName(mIRFeature), mIRFeature.hasLineageOption(4096), mIRClassifier.getFeatures());
                if (mIRFeature2 == null && mIRFeature.getPosition() > 0) {
                    mIRFeature2 = this.getFeatureByPosition(mIRClassifier, mIRFeature.getPosition());
                }
                if (mIRFeature2 != null) continue;
                mIRFeature2 = this.createFeature(mIRClassifier);
                mIRFeature2.setPosition(mIRFeature.getPosition());
                mIRFeature2.setName(string);
                mIRClassifier.addFeature(mIRFeature2);
            }
            return true;
        }
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (!mIRFeature.hasLineageOption(512) && !mIRFeature.hasLineageOption(256)) continue;
            return true;
        }
        MIRFeature mIRFeature = this.createFeature(mIRClassifier);
        mIRFeature.setName("*");
        mIRFeature.setLineageOption(256);
        mIRClassifier.addFeature(mIRFeature);
        return true;
    }

    @Override
    public boolean isStarCandidate(MIRFeature mIRFeature, boolean bl) {
        return bl && (mIRFeature.getPosition() > 0 || mIRFeature.hasLineageOption(256));
    }

    @Override
    public boolean captureConstantExpressions() {
        return true;
    }

    @Override
    public boolean supportFunctionCalls() {
        return true;
    }

    @Override
    public void move(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
        List<Object> list;
        if (mIRClassifier2 != null && mIRClassifier2.getFeatureCount() == 0) {
            Object object;
            list = new LinkedList();
            MIRConnectionDataPackage mIRConnectionDataPackage = (MIRConnectionDataPackage)mIRClassifier.getNamespace();
            List<MIRClassifier> list2 = this.getItems(mIRClassifier.getName(), mIRClassifier.hasLineageOption(4096), mIRConnectionDataPackage.getClassifiers());
            for (MIRClassifier mIRModelObject : list2) {
                for (MIRFeature mIRFeature : mIRModelObject.getFeatures()) {
                    if (mIRFeature.getPosition() <= 0) continue;
                    list.add(mIRFeature);
                }
                if (list.isEmpty()) continue;
                break;
            }
            if (list.isEmpty()) {
                for (MIRFeature mIRFeature : mIRClassifier.getFeatureByPosition()) {
                    if (!mIRFeature.hasLineageOption(256)) continue;
                    list.add(mIRFeature);
                    break;
                }
                if (list.isEmpty()) {
                    MIRFeature mIRFeature = this.createFeature(mIRClassifier);
                    mIRFeature.setName("*");
                    mIRFeature.setLineageOption(256);
                    mIRClassifier.addFeature(mIRFeature);
                    list.add(mIRFeature);
                }
            } else {
                for (MIRFeature mIRFeature : list) {
                    object = null;
                    object = mIRFeature.getPosition() > 0 ? this.getFeatureByPosition(mIRClassifier, mIRFeature.getPosition()) : this.getItem(mIRFeature.getName(), mIRFeature.hasLineageOption(4096), mIRClassifier.getFeatures());
                    if (object != null) continue;
                    object = this.createFeature(mIRClassifier);
                    ((MIRObject)object).setName(mIRFeature.getName());
                    ((MIRFeature)object).setLineageOptions(mIRFeature.getLineageOptions());
                    ((MIRFeature)object).setPosition(mIRFeature.getPosition());
                    if (mIRFeature.getPosition() > 0) {
                        mIRClassifier.addFeatureUniqueName((MIRFeature)object);
                        continue;
                    }
                    mIRClassifier.addFeature((MIRFeature)object);
                }
            }
            for (MIRFeature mIRFeature : mIRClassifier.getFeatureByPosition()) {
                object = new MIRQueryColumn();
                ((MIRObject)object).setName(mIRFeature.getName());
                ((MIRFeature)object).setLineageOptions(mIRFeature.getLineageOptions());
                ((MIRFeature)object).setPosition(mIRFeature.getPosition());
                mIRClassifier2.addFeature((MIRFeature)object);
                MIRFeatureMap mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap((MIRFeature)object, true);
                if (mIRFeature.hasLineageOption(256)) {
                    mIRFeatureMap.setBulk(true);
                }
                MIRBridgeLib.addSourceFeature(mIRFeatureMap, mIRFeature);
            }
        }
        if ((list = this.getItems(mIRClassifier.getName(), mIRClassifier.hasLineageOption(4096), this.fullyDefinedTables)) != null && !list.isEmpty()) {
            this.setTemporary(mIRClassifier);
        }
    }
}

