/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRTransformationDataAttribute;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIR_Object;
import java.util.Iterator;

public class TransformTaskUtils {
    public static boolean isSqlNameChar(char c) {
        if (c >= 'A') {
            if (c >= 'a') {
                return c <= 'z';
            }
            if (c <= 'Z') {
                return true;
            }
            return c == '_';
        }
        if (c >= '0') {
            return c <= '9';
        }
        if (c < '\u0000') {
            return true;
        }
        return c == '#' || c == '$';
    }

    public static boolean isSqlNameChars(String string) {
        int n = string.length();
        while (n-- > 0) {
            char c = string.charAt(n);
            if (TransformTaskUtils.isSqlNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static String makeCharsSqlName(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        boolean bl = false;
        int n = cArray.length;
        while (n-- > 0) {
            if (TransformTaskUtils.isSqlNameChar(cArray[n])) continue;
            cArray[n] = 95;
            bl = true;
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static MIRClassifierMap newClassMap(MIRTransformationDataSet mIRTransformationDataSet, MIRTransformationDataSet mIRTransformationDataSet2, MIRTransformationDataSet mIRTransformationDataSet3) {
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet2);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet3);
        MIRTransformation mIRTransformation = (MIRTransformation)mIRTransformationDataSet.getParent();
        MIRTransformation mIRTransformation2 = (MIRTransformation)mIRTransformationDataSet3.getParent();
        if (mIRTransformation == mIRTransformation2) {
            mIRTransformation.addClassifierMap(mIRClassifierMap);
        } else {
            mIRTransformation.getDiModel().addClassifierMap(mIRClassifierMap);
        }
        return mIRClassifierMap;
    }

    public static MIRFeature getSingleSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            assert (false);
            return null;
        }
        MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
        if (mIRFeatureMap != null) {
            int n = mIRFeatureMap.getSourceFeatureCount();
            assert (n == 1);
            if (n > 0) {
                return mIRFeatureMap.getSourceFeatureIterator().next();
            }
        }
        return null;
    }

    public static MIRFeature getSingleDestFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            assert (false);
            return null;
        }
        int n = mIRFeature.getSourceOfFeatureMapCount();
        assert (n == 2);
        if (n > 0) {
            MIRFeatureMap mIRFeatureMap = mIRFeature.getSourceOfFeatureMapIterator().next();
            MIRFeature mIRFeature2 = mIRFeatureMap.getDestinationFeature();
            assert (mIRFeature2 != null);
            return mIRFeature2;
        }
        return null;
    }

    public static MIRClassifier getSingleDestClass(MIRClassifier mIRClassifier) {
        int n = mIRClassifier.getSourceOfClassifierMapCount();
        assert (n == 1);
        if (n > 0) {
            MIRClassifierMap mIRClassifierMap = mIRClassifier.getSourceOfClassifierMapIterator().next();
            MIRClassifier mIRClassifier2 = mIRClassifierMap.getDestinationClassifier();
            assert (mIRClassifier2 != null);
            return mIRClassifier2;
        }
        return null;
    }

    public static MIRClassifier getSingleSourceClass(MIRClassifier mIRClassifier) {
        MIRClassifierMap mIRClassifierMap = mIRClassifier.getDestinationOfClassifierMap();
        if (mIRClassifierMap != null) {
            Iterator<MIRClassifier> iterator = mIRClassifierMap.getSourceClassifierIterator();
            MIRClassifier mIRClassifier2 = iterator.next();
            assert (mIRClassifier2 != null);
            return mIRClassifier2;
        }
        return null;
    }

    public static MIRTransformationDataAttribute newDataAttribute(MIRFeature mIRFeature, MIRTransformationDataSet mIRTransformationDataSet) {
        if (!(mIRFeature instanceof MIRTransformationDataAttribute)) {
            return null;
        }
        MIRTransformationDataAttribute mIRTransformationDataAttribute = new MIRTransformationDataAttribute((MIRTransformationDataAttribute)mIRFeature);
        mIRTransformationDataAttribute.setName(mIRFeature.getName());
        mIRTransformationDataAttribute.addType(mIRFeature.getType());
        mIRTransformationDataSet.addFeatureUniqueName(mIRTransformationDataAttribute, '_');
        return mIRTransformationDataAttribute;
    }

    public static MIRFeatureMap linkFeatures(MIRFeature mIRFeature, MIRFeature mIRFeature2) {
        Object object;
        Iterator<MIRElement> iterator;
        MIRElement mIRElement;
        MIRElement mIRElement2;
        Iterator<MIRClassifierMap> iterator2;
        if (mIRFeature == mIRFeature2) {
            return null;
        }
        assert (mIRFeature instanceof MIRTransformationDataAttribute && mIRFeature2 instanceof MIRTransformationDataAttribute);
        MIRTransformationDataSet mIRTransformationDataSet = (MIRTransformationDataSet)mIRFeature.getClassifier();
        assert (mIRTransformationDataSet != null && mIRFeature instanceof MIRTransformationDataAttribute);
        MIRTransformationDataSet mIRTransformationDataSet2 = (MIRTransformationDataSet)mIRFeature2.getClassifier();
        assert (mIRTransformationDataSet2 != null && mIRFeature2 instanceof MIRTransformationDataAttribute);
        MIRTransformation mIRTransformation = (MIRTransformation)mIRTransformationDataSet.getParent();
        MIRTransformation mIRTransformation2 = (MIRTransformation)mIRTransformationDataSet2.getParent();
        assert (mIRTransformation != null && mIRTransformation2 != null);
        MIRDiModel mIRDiModel = mIRTransformation == mIRTransformation2 ? null : mIRTransformation.getDiModel();
        MIRElement mIRElement3 = null;
        MIRElement mIRElement4 = null;
        Iterator<MIRClassifierMap> iterator3 = iterator2 = mIRDiModel == null ? mIRTransformation2.getClassifierMapIterator() : mIRDiModel.getClassifierMapIterator();
        while (iterator2.hasNext()) {
            mIRElement2 = iterator2.next();
            mIRElement = (MIRTransformationDataSet)((MIRClassifierMap)mIRElement2).getDestinationClassifier();
            if (mIRElement == mIRTransformationDataSet2) {
                iterator = ((MIRClassifierMap)mIRElement2).getSourceClassifierIterator();
                while (iterator.hasNext()) {
                    object = (MIRClassifier)iterator.next();
                    if (object != mIRTransformationDataSet) continue;
                    mIRElement3 = mIRElement2;
                    break;
                }
                if (mIRDiModel == null) {
                    mIRElement4 = mIRElement2;
                }
            }
            if (mIRElement3 == null) continue;
            break;
        }
        if (mIRElement3 == null) {
            if (mIRElement4 != null) {
                mIRElement3 = mIRElement4;
                mIRElement3.addSourceClassifier(mIRTransformationDataSet);
            } else {
                mIRElement3 = TransformTaskUtils.newClassMap(mIRTransformationDataSet, null, mIRTransformationDataSet2);
            }
        }
        mIRElement2 = null;
        mIRElement = null;
        iterator = mIRElement3.getFeatureMapIterator();
        while (iterator.hasNext()) {
            mIRElement2 = iterator.next();
            if (((MIRFeatureMap)mIRElement2).getDestinationFeature() != mIRFeature2 || ((MIRFeatureMap)mIRElement2).getDestinationFeature() == null) continue;
            mIRElement = mIRElement2;
            object = ((MIRFeatureMap)mIRElement2).getSourceFeatureIterator();
            while (object.hasNext()) {
                MIRFeature mIRFeature3 = (MIRFeature)object.next();
                if (mIRFeature3 != mIRFeature) continue;
                return mIRElement2;
            }
        }
        if (mIRElement != null) {
            mIRElement2 = mIRElement;
        } else {
            mIRElement2 = new MIRFeatureMap();
            ((MIRFeatureMap)mIRElement2).addDestinationFeature(mIRFeature2);
            mIRElement3.addFeatureMap((MIRFeatureMap)mIRElement2);
        }
        ((MIRFeatureMap)mIRElement2).addSourceFeature(mIRFeature);
        return mIRElement2;
    }

    public static String getTransformationUdp(MIRTransformation mIRTransformation, String string) {
        MIRObject mIRObject = mIRTransformation;
        while (((MIR_Object)mIRObject).getParent() != null && !(mIRObject instanceof MIRMappingModel)) {
            mIRObject = ((MIR_Object)mIRObject).getParent();
        }
        assert (mIRObject instanceof MIRMappingModel);
        MIRPropertyType mIRPropertyType = null;
        mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRObject, (short)79, string, (byte)2, "Transformation Control", "", "varchar", false);
        if (mIRPropertyType == null) {
            return "";
        }
        MIRPropertyValue mIRPropertyValue = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRTransformation);
        if (mIRPropertyValue == null) {
            return "";
        }
        return mIRPropertyValue.getValue();
    }
}

