/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.sdk.MIRAliasType;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRBusinessRule;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRIdentity;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class MIRTypeLib {
    public static void factorizeTypes(MIRModel mIRModel) {
        MIRTypeLib.factorizeTypes(mIRModel, false, false);
    }

    public static void factorizeTypes(MIRModel mIRModel, boolean bl, boolean bl2) {
        TreeSet<MIRType> treeSet = new TreeSet<MIRType>();
        for (MIRType mIRType : mIRModel.getTypes()) {
            if (mIRType.getElementType() == 6 || mIRType.getElementType() == 66 || treeSet.contains(mIRType)) continue;
            MIRTypeLib.factorizeEquivalentTypes(treeSet, mIRType, mIRModel, bl, bl2 && mIRType.getElementType() == 4);
        }
        for (MIRType mIRType : treeSet) {
            mIRModel.removeType(mIRType);
            mIRType.delete();
        }
    }

    private static void factorizeEquivalentTypes(Collection<MIRType> collection, MIRType mIRType, MIRModel mIRModel, boolean bl, boolean bl2) {
        for (MIRType mIRType2 : mIRModel.getTypes()) {
            if (mIRType2.getElementType() == 66 || mIRType2 == mIRType || collection.contains(mIRType2) || !MIRTypeLib.canFactorizeTypes(mIRType, mIRType2, bl, bl2)) continue;
            MIRTypeLib.factorizeTypes(mIRType, mIRType2);
            collection.add(mIRType2);
        }
    }

    private static boolean canFactorizeTypes(MIRType mIRType, MIRType mIRType2, boolean bl, boolean bl2) {
        MIRDerivedType mIRDerivedType;
        MIRDerivedType mIRDerivedType2;
        if (!bl2 && mIRType2.getElementType() != 5) {
            return false;
        }
        if (!bl && mIRType2.getUserDefined()) {
            return false;
        }
        if (!MIRTypeLib.equivalentTypes(mIRType2, mIRType)) {
            return false;
        }
        return mIRType.getElementType() != 5 || mIRType2.getElementType() != 5 || (mIRDerivedType2 = (MIRDerivedType)mIRType).containsDerivedType(mIRDerivedType = (MIRDerivedType)mIRType2) || mIRDerivedType.getDerivedFromConcreteType() == mIRDerivedType2.getDerivedFromConcreteType();
    }

    private static void factorizeTypes(MIRType mIRType, MIRType mIRType2) {
        MIRModelObject mIRModelObject;
        while (mIRType2.getFeatureCount() > 0) {
            mIRModelObject = mIRType2.getFeature(null);
            ((MIRFeature)mIRModelObject).removeType();
            ((MIRFeature)mIRModelObject).addType(mIRType);
        }
        while (mIRType2.getArgumentCount() > 0) {
            mIRModelObject = mIRType2.getArgument(null);
            ((MIRArgument)mIRModelObject).removeType();
            ((MIRArgument)mIRModelObject).addType(mIRType);
        }
        while (mIRType2.getOperationCount() > 0) {
            mIRModelObject = mIRType2.getOperation(null);
            ((MIROperation)mIRModelObject).removeReturnType();
            ((MIROperation)mIRModelObject).addReturnType(mIRType);
        }
        if (mIRType2 instanceof MIRConcreteType && mIRType instanceof MIRConcreteType) {
            while (((MIRConcreteType)mIRType2).getDerivedTypeCount() > 0) {
                mIRModelObject = ((MIRConcreteType)mIRType2).getDerivedType(null);
                ((MIRConcreteType)mIRType2).removeDerivedType((MIRDerivedType)mIRModelObject);
                ((MIRConcreteType)mIRType).addDerivedType((MIRDerivedType)mIRModelObject);
            }
        }
        while (mIRType2.getAliasTypeCount() > 0) {
            mIRModelObject = mIRType2.getAliasType(null);
            mIRType2.removeAliasType((MIRAliasType)mIRModelObject);
            mIRType.addAliasType((MIRAliasType)mIRModelObject);
        }
        while (mIRType2.getArrayTypeOfDerivedTypeCount() > 0) {
            mIRModelObject = mIRType2.getArrayTypeOfDerivedType(null);
            mIRType2.removeArrayTypeOfDerivedType((MIRDerivedType)mIRModelObject);
            mIRType.addArrayTypeOfDerivedType((MIRDerivedType)mIRModelObject);
        }
    }

    private static boolean equivalentTypes(MIRType mIRType, MIRType mIRType2) {
        Object object;
        MIRType mIRType3 = mIRType.getActualType();
        Object object2 = mIRType2.getActualType();
        short s = mIRType.getElementType();
        short s2 = mIRType2.getElementType();
        if (mIRType3.getAssociatedBusinessRuleCount() != ((MIRModelObject)object2).getAssociatedBusinessRuleCount()) {
            return false;
        }
        for (MIRBusinessRule mIRModelObject : mIRType3.getAssociatedBusinessRules()) {
            if (((MIRModelObject)object2).containsAssociatedBusinessRule(mIRModelObject)) continue;
            return false;
        }
        if (s == s2) {
            if (s == 5) {
                MIRType mIRType4;
                object = (MIRDerivedType)mIRType3;
                MIRDerivedType mIRDerivedType = (MIRDerivedType)object2;
                MIRIdentity mIRIdentity = ((MIRDerivedType)object).getIdentity();
                MIRIdentity mIRIdentity2 = mIRDerivedType.getIdentity();
                if (mIRIdentity != null || mIRIdentity2 != null) {
                    return false;
                }
                MIRType mIRType5 = ((MIRDerivedType)object).getArrayOfType();
                if (mIRType5 != (mIRType4 = mIRDerivedType.getArrayOfType())) {
                    return false;
                }
                if (((MIRDerivedType)object).getTypeValueCount() > 0 || mIRDerivedType.getTypeValueCount() > 0) {
                    return false;
                }
                return ((MIR_Object)object).isSimilar(mIRDerivedType);
            }
            if (s == 4) {
                return mIRType3.isSimilar((MIR_Object)object2);
            }
        }
        if (s2 == 4) {
            object = mIRType3;
            mIRType3 = object2;
            object2 = object;
        }
        return ((MIRType)object2).getInitialValue().isEmpty() && ((MIRType)object2).getLowerBound().isEmpty() && ((MIRType)object2).getNativeLogicalDataType().isEmpty() && ((MIRType)object2).getTypeValueCount() == 0 && ((MIRType)object2).getUpperBound().isEmpty() && !((MIRType)object2).getUserDefined() && !((MIRType)object2).getUserDataType() && MIR_Object.isSimilar(mIRType3, (MIR_Object)object2, (short)50) && !((MIRDerivedType)object2).getLowerBoundExclusive() && !((MIRDerivedType)object2).getUpperBoundExclusive() && ((MIRDerivedType)object2).getPattern().isEmpty() && ((MIRDerivedType)object2).getIdentity() == null && ((MIRDerivedType)object2).getArrayOfType() == null;
    }

    public static MIRType getType(MIRModel mIRModel, String string, short s) {
        MIRType mIRType = mIRModel.getType(string);
        if (mIRType == null) {
            return null;
        }
        if (s == mIRType.getElementType()) {
            return mIRType;
        }
        Iterator<MIRType> iterator = mIRModel.getTypeIterator();
        while (iterator.hasNext()) {
            MIRType mIRType2 = iterator.next();
            if (mIRType2.getElementType() != s || !mIRType2.getName().equals(string)) continue;
            return mIRType2;
        }
        return null;
    }

    public static MIRBaseType createBaseType(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string2 = MIRBaseTypeList.getDataTypeName(string);
        MIRBaseType mIRBaseType = new MIRBaseType();
        mIRBaseType.setName(string);
        mIRBaseType.setDataType(string2);
        mIRBaseType.setPhysicalName(string2);
        return mIRBaseType;
    }

    public static MIRBaseType getBaseType(MIRModel mIRModel, String string) {
        MIRBaseType mIRBaseType = (MIRBaseType)MIRTypeLib.getType(mIRModel, string, (short)4);
        if (mIRBaseType == null) {
            mIRBaseType = MIRTypeLib.createBaseType(string);
            mIRModel.addType(mIRBaseType);
        }
        return mIRBaseType;
    }

    public static MIRBaseType getUndefinedBaseType(MIRModel mIRModel) {
        return MIRTypeLib.getBaseType(mIRModel, "undefined");
    }

    public static String buildTypePhysicalName(MIRDerivedType mIRDerivedType) {
        return MIRTypeLib.buildTypePhysicalName(mIRDerivedType.getDataType(), mIRDerivedType.getLength(), mIRDerivedType.getScale());
    }

    private static String buildTypePhysicalName(String string, int n, int n2) {
        String string2 = "";
        if (n != 0 || n2 != 0) {
            string2 = n == -1 ? "MAX" : Integer.toString(n);
            string = string + "_" + string2;
        }
        if (n2 != 0) {
            string2 = Integer.toString(n2);
            string = string + "_" + string2;
        }
        return string;
    }

    public static MIRClassType createClassType(MIRClass mIRClass, MIRModel mIRModel) {
        if (mIRClass == null || mIRModel == null) {
            return null;
        }
        MIRClassType mIRClassType = mIRClass.getClassType();
        if (mIRClassType == null) {
            mIRClassType = new MIRClassType();
            mIRClassType.setName(mIRClass.getName());
            mIRClassType.addAssociatedClass(mIRClass);
            mIRModel.addType(mIRClassType);
        }
        return mIRClassType;
    }

    public static MIRDerivedType createArrayType(int n, MIRType mIRType, MIRModel mIRModel, boolean bl) {
        MIRDerivedType mIRDerivedType = null;
        if (bl) {
            for (MIRDerivedType mIRDerivedType2 : mIRType.getArrayTypeOfDerivedTypes()) {
                if (mIRDerivedType2.getLength() != n) continue;
                mIRDerivedType = mIRDerivedType2;
                break;
            }
        }
        if (mIRDerivedType == null) {
            mIRDerivedType = new MIRDerivedType();
            mIRDerivedType.setDataType("SQL_ARRAY");
            mIRDerivedType.setName("array");
            mIRDerivedType.setLength(n);
            mIRDerivedType.addArrayOfType(mIRType);
            MIRBaseType mIRBaseType = MIRTypeLib.getBaseType(mIRModel, MIRBaseTypeList.getLogicalName("SQL_ARRAY"));
            mIRDerivedType.addDerivedFromConcreteType(mIRBaseType);
            mIRModel.addType(mIRDerivedType);
        }
        return mIRDerivedType;
    }
}

