/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.expression.analyzer.MIRExpressionAnalyzerHelper;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreType;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class MIRStoreConnectionSummarizer {
    public static boolean mergeStoreConnections(MIRStoreConnection mIRStoreConnection, MIRStoreConnection mIRStoreConnection2, CollationMode collationMode) {
        MIRConnectionDataPackage mIRConnectionDataPackage;
        if (mIRStoreConnection == null || mIRStoreConnection2 == null) {
            return false;
        }
        if (mIRStoreConnection2.getStoreType() != mIRStoreConnection.getStoreType()) {
            BLIB.ERR_MERGE_CONNECTION_STORE_TYPE.log(mIRStoreConnection.getName(), MIRStoreType.toString(mIRStoreConnection.getStoreType()), mIRStoreConnection2.getName(), MIRStoreType.toString(mIRStoreConnection2.getStoreType()));
            return false;
        }
        LinkedList<MIRConnectionNamespace> linkedList = new LinkedList<MIRConnectionNamespace>(mIRStoreConnection.getConnectionNamespaces());
        for (MIRConnectionNamespace object2 : linkedList) {
            mIRConnectionDataPackage = mIRStoreConnection2.getConnectionNamespace(MIRBridgeLib.getPhysicalName(object2));
            if (mIRConnectionDataPackage == null) {
                object2.removeStoreConnection();
                object2.addStoreConnection(mIRStoreConnection2);
                continue;
            }
            MIRStoreConnectionSummarizer.mergeConnectionDataPackage(object2, mIRConnectionDataPackage, collationMode);
        }
        LinkedList<MIRConnectionPackage> linkedList2 = new LinkedList<MIRConnectionPackage>(mIRStoreConnection.getConnectionPackages());
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            mIRConnectionDataPackage = (MIRConnectionPackage)iterator.next();
            MIRConnectionPackage mIRConnectionPackage = mIRStoreConnection2.getConnectionPackage(mIRConnectionDataPackage.getName());
            if (mIRConnectionPackage == null) {
                ((MIRConnectionPackage)mIRConnectionDataPackage).removeStoreConnection();
                ((MIRConnectionPackage)mIRConnectionDataPackage).addStoreConnection(mIRStoreConnection2);
                continue;
            }
            MIRStoreConnectionSummarizer.mergeConnectionDataPackage(mIRConnectionDataPackage, mIRConnectionPackage, collationMode);
        }
        return true;
    }

    public static void mergeConnectionDataPackage(MIRConnectionDataPackage mIRConnectionDataPackage, MIRConnectionDataPackage mIRConnectionDataPackage2, CollationMode collationMode) {
        Object object;
        LinkedList<MIRNamespaceElement> linkedList = new LinkedList<MIRNamespaceElement>(mIRConnectionDataPackage.getNamespaceElements());
        for (MIRNamespaceElement object22 : linkedList) {
            if (!(object22 instanceof MIRClassifier) && !(object22 instanceof MIRStoredProcedure)) continue;
            object = MIRExpressionAnalyzerHelper.getItem(MIRBridgeLib.getPhysicalName(object22), MIRStoreConnectionSummarizer.isCasesensitive(object22), mIRConnectionDataPackage2.getNamespaceElements(), collationMode);
            if (object == null) {
                object22.removeNamespace();
                object22.addNamespace(mIRConnectionDataPackage2);
                continue;
            }
            MIRStoreConnectionSummarizer.mergeNamespaceElement(object22, (MIRNamespaceElement)object, collationMode);
        }
        linkedList = new LinkedList<MIRNamespaceElement>(mIRConnectionDataPackage.getImportedNamespaceElements());
        for (MIRNamespaceElement mIRNamespaceElement : linkedList) {
            object = MIRExpressionAnalyzerHelper.getItems(mIRNamespaceElement.getName(), MIRStoreConnectionSummarizer.isCasesensitive(mIRNamespaceElement), mIRConnectionDataPackage2.getImportedNamespaceElements(), collationMode);
            if (object != null && object.contains(mIRNamespaceElement)) continue;
            mIRNamespaceElement.removeImportedByPackage(mIRConnectionDataPackage);
            mIRNamespaceElement.addImportedByPackage(mIRConnectionDataPackage2);
        }
        LinkedList<MIRClassifier> linkedList2 = new LinkedList<MIRClassifier>(mIRConnectionDataPackage.getClassifiers());
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            object = (MIRClassifier)iterator.next();
            List<MIRClassifier> list = MIRExpressionAnalyzerHelper.getItems(((MIRObject)object).getName(), MIRStoreConnectionSummarizer.isCasesensitive((MIRObject)object), mIRConnectionDataPackage2.getClassifiers(), collationMode);
            if (list != null && list.contains(object)) continue;
            ((MIRClassifier)object).removeConnectionDataPackage();
            ((MIRClassifier)object).addConnectionDataPackage(mIRConnectionDataPackage2);
        }
    }

    public static void mergeNamespaceElement(MIRNamespaceElement mIRNamespaceElement, MIRNamespaceElement mIRNamespaceElement2, CollationMode collationMode) {
        if (mIRNamespaceElement2.getElementType() != mIRNamespaceElement.getElementType()) {
            BLIB.WRN_MERGE_NMELEMENTS_TYPE_CONFLICT.log(mIRNamespaceElement.getName(), MIRElementType.getName(mIRNamespaceElement.getElementType()), mIRNamespaceElement2.getName(), MIRElementType.getName(mIRNamespaceElement2.getElementType()));
            return;
        }
        if (mIRNamespaceElement instanceof MIRClassifier) {
            MIRStoreConnectionSummarizer.mergeClassifier((MIRClassifier)mIRNamespaceElement, (MIRClassifier)mIRNamespaceElement2, collationMode);
        } else if (mIRNamespaceElement instanceof MIRConnectionDataPackage) {
            MIRStoreConnectionSummarizer.mergeConnectionDataPackage((MIRConnectionDataPackage)mIRNamespaceElement, (MIRConnectionDataPackage)mIRNamespaceElement2, collationMode);
        } else {
            BLIB.ERR_MERGE_CONNECTION_STORE_TYPE.log(mIRNamespaceElement.getName(), MIRElementType.getName(mIRNamespaceElement.getElementType()));
        }
    }

    public static void mergeClassifier(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2, CollationMode collationMode) {
        MIRClassifierMap mIRClassifierMap;
        Cloneable cloneable;
        MIRClassifierMap mIRClassifierMap2;
        if (mIRClassifier.hasLineageOption(4096) != mIRClassifier2.hasLineageOption(4096)) {
            mIRClassifier2.unsetLineageOption(4096);
        }
        if ((mIRClassifierMap2 = mIRClassifier.getClassifierMap()) != null) {
            cloneable = mIRClassifier2.getClassifierMap();
            if (cloneable == null) {
                mIRClassifierMap2.removeClassifier();
                mIRClassifierMap2.addClassifier(mIRClassifier2);
                if (mIRClassifierMap2.getDestinationClassifier() == mIRClassifier) {
                    mIRClassifierMap2.removeDestinationClassifier();
                    mIRClassifierMap2.addDestinationClassifier(mIRClassifier2);
                }
            } else {
                if (((MIRClassifierMap)cloneable).getOperation() == null || ((MIRClassifierMap)cloneable).getOperation().isEmpty()) {
                    ((MIRClassifierMap)cloneable).setOperation(mIRClassifierMap2.getOperation());
                } else if (mIRClassifierMap2.getOperation() != null && !mIRClassifierMap2.getOperation().isEmpty()) {
                    ((MIRClassifierMap)cloneable).setOperation(((MIRClassifierMap)cloneable).getOperation() + "; " + mIRClassifierMap2.getOperation());
                }
                if (mIRClassifierMap2.getDestinationClassifier() == mIRClassifier) {
                    mIRClassifierMap2.removeDestinationClassifier();
                    if (((MIRClassifierMap)cloneable).getDestinationClassifier() != mIRClassifier2) {
                        ((MIRClassifierMap)cloneable).addDestinationClassifier(mIRClassifier2);
                    }
                }
            }
        }
        cloneable = new LinkedList<MIRClassifierMap>(mIRClassifier.getSourceOfClassifierMaps());
        Object object = cloneable.iterator();
        while (object.hasNext()) {
            mIRClassifierMap = (MIRClassifierMap)object.next();
            mIRClassifierMap.removeSourceClassifier(mIRClassifier);
            if (mIRClassifierMap.containsSourceClassifier(mIRClassifier2)) continue;
            mIRClassifierMap.addSourceClassifier(mIRClassifier2);
        }
        cloneable = new LinkedList<MIRClassifierMap>(mIRClassifier.getControlOfClassifierMaps());
        object = cloneable.iterator();
        while (object.hasNext()) {
            mIRClassifierMap = (MIRClassifierMap)object.next();
            mIRClassifierMap.removeControlClassifier(mIRClassifier);
            if (mIRClassifierMap.containsSourceClassifier(mIRClassifier2)) continue;
            mIRClassifierMap.addControlClassifier(mIRClassifier2);
        }
        cloneable = new LinkedList<MIRClassifierMap>(mIRClassifier.getDestinationOfClassifierMaps());
        object = cloneable.iterator();
        while (object.hasNext()) {
            mIRClassifierMap = (MIRClassifierMap)object.next();
            mIRClassifierMap.removeDestinationClassifier();
            mIRClassifierMap.addDestinationClassifier(mIRClassifier2);
        }
        object = new LinkedList<MIRFeature>(mIRClassifier.getFeatureByPosition());
        boolean bl = MIRStoreConnectionSummarizer.getStoreType(mIRClassifier2) == 2;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            LinkedList<MIRFeatureMap> linkedList;
            MIRFeature mIRFeature;
            MIRFeature mIRFeature2 = (MIRFeature)iterator.next();
            if (mIRFeature2.hasLineageOption(512) || bl && !mIRFeature2.hasLineageOption(8192)) {
                mIRFeature = MIRStoreConnectionSummarizer.getFeatureByPosition(mIRClassifier2, mIRFeature2.getPosition());
                if (mIRFeature == null) {
                    linkedList = MIRBridgeLib.getPhysicalName(mIRFeature2);
                    int n = 1;
                    while (MIRExpressionAnalyzerHelper.getItem((String)((Object)linkedList), true, mIRClassifier2.getFeatures(), CollationMode.CaseSensitive) != null) {
                        linkedList = MIRBridgeLib.getPhysicalName(mIRFeature2) + "/" + n++;
                    }
                    if (!((String)((Object)linkedList)).equals(mIRFeature2.getName())) {
                        mIRFeature2.setPhysicalName((String)((Object)linkedList));
                    }
                }
            } else {
                mIRFeature = MIRExpressionAnalyzerHelper.getItem(MIRBridgeLib.getPhysicalName(mIRFeature2), mIRFeature2.hasLineageOption(4096), mIRClassifier2.getFeatures(), collationMode);
                if (mIRFeature == null || mIRFeature2.getPosition() > 0 && MIRStoreConnectionSummarizer.getFeatureByPosition(mIRClassifier2, mIRFeature2.getPosition()) != null) {
                    mIRFeature2.setPosition((short)0);
                }
            }
            if (mIRFeature == null) {
                mIRFeature2.removeClassifier();
                mIRFeature2.addClassifier(mIRClassifier2);
                mIRFeature = mIRFeature2;
            } else {
                linkedList = mIRFeature2.getType();
                MIRType mIRType = mIRFeature.getType();
                if (linkedList != null && linkedList != mIRType) {
                    mIRFeature2.removeType();
                    mIRFeature.removeType();
                    mIRFeature.addType((MIRType)((Object)linkedList));
                }
            }
            linkedList = new LinkedList<MIRFeatureMap>(mIRFeature2.getDestinationOfFeatureMaps());
            for (MIRFeatureMap mIRFeatureMap : linkedList) {
                if (mIRFeature2 != mIRFeature) {
                    mIRFeatureMap.removeDestinationFeature();
                    mIRFeatureMap.addDestinationFeature(mIRFeature);
                }
                if (mIRFeatureMap.getClassifierMap().getDestinationClassifier() == mIRClassifier2) continue;
                mIRFeatureMap.removeClassifierMap();
                mIRFeatureMap.addClassifierMap(mIRClassifier2.getDestinationOfClassifierMap());
            }
            if (mIRFeature2 == mIRFeature) continue;
            linkedList = new LinkedList<MIRFeatureMap>(mIRFeature2.getSourceOfFeatureMaps());
            for (MIRFeatureMap mIRFeatureMap : linkedList) {
                mIRFeatureMap.removeSourceFeature(mIRFeature2);
                MIRBridgeLib.addSourceFeature(mIRFeatureMap, mIRFeature);
            }
            linkedList = new LinkedList<MIRFeatureMap>(mIRFeature2.getControlOfFeatureMaps());
            for (MIRFeatureMap mIRFeatureMap : linkedList) {
                mIRFeatureMap.removeControlFeature(mIRFeature2);
                MIRBridgeLib.addControlFeature(mIRFeatureMap, mIRFeature);
            }
        }
    }

    private static MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, short s) {
        Optional<MIRFeature> optional = mIRClassifier.getFeatures().stream().filter(mIRFeature -> mIRFeature.getPosition() == s).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    private static byte getStoreType(MIRObject mIRObject) {
        while (mIRObject != null) {
            if (mIRObject instanceof MIRStoreConnection) {
                return ((MIRStoreConnection)mIRObject).getStoreType();
            }
            mIRObject = mIRObject.getParent();
        }
        return 0;
    }

    private static boolean isCasesensitive(MIRObject mIRObject) {
        if (mIRObject instanceof MIRClassifier) {
            return ((MIRClassifier)mIRObject).hasLineageOption(4096);
        }
        if (mIRObject instanceof MIRFeature) {
            return ((MIRFeature)mIRObject).hasLineageOption(4096);
        }
        return false;
    }
}

