/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRRelationalLib;
import MITI.expression.analyzer.LookupOptions;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.util.Util;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRCube;
import MITI.sdk.MIRCubeDimensionAssociation;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiagram;
import MITI.sdk.MIRDimension;
import MITI.sdk.MIRDimensionAttribute;
import MITI.sdk.MIRDimensionalRoleType;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRGeneralizationRole;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRMeasure;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROlapSchema;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRType;
import MITI.sdk.util.ObjectCollector;
import MITI.sdk.validation.MIRValidation;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.util.EscapedStringTokenizer;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class MIRRolapLib {
    private boolean hasMultipleSources(MIRClassifierMap mIRClassifierMap) {
        MIRClassifier mIRClassifier = mIRClassifierMap.getDestinationClassifier();
        int n = mIRClassifierMap.getSourceClassifierCount();
        if (mIRClassifierMap.containsSourceClassifier(mIRClassifier)) {
            --n;
        }
        return n > 1;
    }

    private void reverseEngineerROLAPProperties(GraphBuilder graphBuilder, MIRClass mIRClass) {
        Object object;
        ClassifierNode classifierNode = graphBuilder.buildClassifierNode(mIRClass);
        ArrayList arrayList = new ArrayList();
        graphBuilder.collectClassifierNodes(classifierNode, arrayList);
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            ClassifierNode classifierNode2 = (ClassifierNode)arrayList.get(i);
            if (classifierNode2.classifier.getDescription().isEmpty()) continue;
            if (!string.isEmpty()) {
                string = string + "\n";
            }
            string = string + MIRBridgeLib.getPhysicalName(classifierNode2.classifier);
            if (!classifierNode2.classifier.getNativeType().isEmpty()) {
                string = string + " (" + classifierNode2.classifier.getNativeType() + ")";
            }
            string = string + ":\n" + classifierNode2.classifier.getDescription() + "\n";
        }
        mIRClass.setDescription(string);
        graphBuilder.resetDistance(classifierNode);
        graphBuilder.calculateDistance(classifierNode);
        ClassifierNode classifierNode3 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (ClassifierNode)arrayList.get(i);
            if (classifierNode3 != null && (((ClassifierNode)object).distance <= classifierNode3.distance || ((ClassifierNode)object).classifier.getName() == mIRClass.getName())) continue;
            classifierNode3 = object;
        }
        if (classifierNode3 != null) {
            this.migrateOlapRole(classifierNode3.classifier, mIRClass);
            this.migrateName(classifierNode3.classifier, mIRClass);
        }
        ArrayList<MIRAttribute> arrayList2 = new ArrayList<MIRAttribute>();
        object = mIRClass.getFeatureIterator();
        while (object.hasNext()) {
            MIRAttribute mIRAttribute = (MIRAttribute)object.next();
            arrayList2.add(mIRAttribute);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            MIRAttribute mIRAttribute = (MIRAttribute)arrayList2.get(i);
            this.reverseEngineerROLAPProperties(graphBuilder, classifierNode, mIRAttribute);
            mIRAttribute.setDesignLevel((byte)0);
        }
    }

    private void reverseEngineerROLAPProperties(GraphBuilder graphBuilder, ClassifierNode classifierNode, MIRAttribute mIRAttribute) {
        FeatureNode featureNode = graphBuilder.buildFeatureNode(classifierNode, mIRAttribute);
        ArrayList arrayList = new ArrayList();
        graphBuilder.collectFeatureNodes(featureNode, arrayList);
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            FeatureNode featureNode2 = (FeatureNode)arrayList.get(i);
            if (featureNode2.feature.getDescription().isEmpty()) continue;
            if (!string.isEmpty()) {
                string = string + "\n";
            }
            string = string + MIRBridgeLib.getPhysicalName(featureNode2.feature);
            if (!featureNode2.feature.getNativeType().isEmpty()) {
                string = string + " (" + featureNode2.feature.getNativeType() + ")";
            }
            string = string + ":\n" + featureNode2.feature.getDescription() + "\n";
        }
        mIRAttribute.setDescription(string);
        graphBuilder.resetDistance(featureNode);
        graphBuilder.calculateDistance(featureNode);
        FeatureNode featureNode3 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            FeatureNode featureNode4 = (FeatureNode)arrayList.get(i);
            if (featureNode3 != null && featureNode4.distance <= featureNode3.distance || featureNode4.feature.getName().equals(mIRAttribute.getName())) continue;
            featureNode3 = featureNode4;
        }
        if (featureNode3 != null) {
            this.migrateName(featureNode3.feature, mIRAttribute);
        }
    }

    private void migrateOlapRole(MIRClassifier mIRClassifier, MIRClass mIRClass) {
        if (mIRClassifier.getElementType() == 87) {
            MIRDimension mIRDimension = (MIRDimension)mIRClassifier;
            if (mIRClass.getDimensionalRole() == 0) {
                if (mIRDimension.getType() == 0) {
                    mIRClass.setDimensionalRole((byte)1);
                } else {
                    mIRClass.setDimensionalRole((byte)2);
                }
            }
        } else if (mIRClassifier.getElementType() == 85) {
            mIRClass.setDimensionalRole((byte)1);
        }
    }

    private void migrateName(MIRObject mIRObject, MIRModelObject mIRModelObject) {
        String string = mIRObject.getName();
        if (!string.equals(mIRModelObject.getName())) {
            try {
                if (mIRModelObject.getPhysicalName().isEmpty()) {
                    mIRModelObject.setPhysicalName(mIRModelObject.getName());
                }
                mIRModelObject.setName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private MIRKey getMatchingKey(MIRClass mIRClass, ArrayList<MIRFeature> arrayList, short s) {
        Iterator<MIRKey> iterator = mIRClass.getKeyIterator();
        while (iterator.hasNext()) {
            MIRKey mIRKey = iterator.next();
            if (mIRKey.getElementType() != s || mIRKey.getAttributeCount() != arrayList.size()) continue;
            boolean bl = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                MIRAttribute mIRAttribute = (MIRAttribute)arrayList.get(i);
                if (mIRKey.containsAttribute(mIRAttribute)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return mIRKey;
        }
        return null;
    }

    private MIRAssociation reverseEngineerJoin(MIRJoinRole mIRJoinRole, MIRJoinRole mIRJoinRole2, MIRClass mIRClass, MIRClass mIRClass2, ArrayList<MIRFeature> arrayList, ArrayList<MIRFeature> arrayList2) {
        MIRModelObject mIRModelObject;
        MIRModelObject mIRModelObject2;
        int n;
        MIRCandidateKey mIRCandidateKey = (MIRCandidateKey)this.getMatchingKey(mIRClass, arrayList, (short)21);
        MIRForeignKey mIRForeignKey = (MIRForeignKey)this.getMatchingKey(mIRClass2, arrayList2, (short)22);
        if (mIRForeignKey != null && mIRCandidateKey != null && mIRForeignKey.getCandidateKey() == mIRCandidateKey) {
            return null;
        }
        if (mIRCandidateKey == null) {
            mIRCandidateKey = new MIRCandidateKey();
            mIRCandidateKey.setUniqueKey(true);
            mIRClass.addKey(mIRCandidateKey);
            for (n = 0; n < arrayList.size(); ++n) {
                mIRModelObject2 = (MIRAttribute)arrayList.get(n);
                mIRCandidateKey.addAttribute((MIRAttribute)mIRModelObject2);
            }
        }
        mIRForeignKey = new MIRForeignKey();
        mIRClass2.addKey(mIRForeignKey);
        mIRForeignKey.addCandidateKey(mIRCandidateKey);
        for (n = 0; n < arrayList2.size(); ++n) {
            mIRModelObject2 = (MIRAttribute)arrayList2.get(n);
            mIRModelObject = (MIRAttribute)arrayList.get(n);
            mIRForeignKey.addAttribute((MIRAttribute)mIRModelObject2);
            MIRRelationalLib.createARNM((MIRAttribute)mIRModelObject, (MIRAttribute)mIRModelObject2, mIRForeignKey, false);
        }
        MIRAssociation mIRAssociation = new MIRAssociation();
        mIRAssociation.setUserDefined(false);
        mIRAssociation.setDesignLevel(mIRClass2.getDesignLevel());
        mIRModelObject2 = new MIRAssociationRole();
        mIRModelObject = new MIRAssociationRole();
        ((MIRAssociationRole)mIRModelObject2).addAssociatedClass(mIRClass);
        ((MIRAssociationRole)mIRModelObject).addAssociatedClass(mIRClass2);
        mIRAssociation.addAssociationRole((MIRAssociationRole)mIRModelObject2);
        mIRAssociation.addAssociationRole((MIRAssociationRole)mIRModelObject);
        mIRForeignKey.addAssociationRole((MIRAssociationRole)mIRModelObject);
        ((MIRAssociationRole)mIRModelObject2).setMultiplicity(mIRJoinRole.getMultiplicity());
        ((MIRAssociationRole)mIRModelObject).setMultiplicity(mIRJoinRole2.getMultiplicity());
        mIRAssociation.setAggregation(false);
        ((MIRAssociationRole)mIRModelObject2).setSource(true);
        ((MIRAssociationRole)mIRModelObject).setSource(false);
        MIRBridgeLib.setAggregationProperty(mIRAssociation);
        return mIRAssociation;
    }

    private MIRAssociation reverseEngineerJoin(GraphBuilder graphBuilder, MIRJoin mIRJoin) {
        Object object;
        Object object2;
        MIRModelObject mIRModelObject;
        int n;
        Cloneable cloneable;
        Object object3;
        int n2 = mIRJoin.getJoinRoleCount();
        if (n2 != 2) {
            return null;
        }
        MIRJoinRole mIRJoinRole = MIRBridgeLib.getLeftJoinRole(mIRJoin);
        MIRJoinRole mIRJoinRole2 = MIRBridgeLib.getRightJoinRole(mIRJoin);
        if (mIRJoinRole == null || mIRJoinRole2 == null) {
            return null;
        }
        MIRClassifier mIRClassifier = mIRJoinRole.getClassifier();
        MIRClassifier mIRClassifier2 = mIRJoinRole2.getClassifier();
        if (mIRClassifier == null || mIRClassifier2 == null) {
            return null;
        }
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        ArrayList<MIRFeature> arrayList2 = new ArrayList<MIRFeature>();
        boolean bl = Util.isSimpleJoinExpression(mIRJoin, arrayList, arrayList2);
        if (!bl) {
            return null;
        }
        if (arrayList.size() == 0 || arrayList2.size() == 0 || arrayList.size() != arrayList2.size()) {
            return null;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = arrayList.get(i);
            cloneable = arrayList2.get(i);
            boolean bl2 = mIRClassifier.containsFeature((MIRFeature)object3);
            n = mIRClassifier2.containsFeature((MIRFeature)cloneable);
            if (bl2 && n != 0) continue;
            return null;
        }
        ClassifierNode classifierNode = graphBuilder.getClassifierNode(mIRClassifier);
        object3 = graphBuilder.getClassifierNode(mIRClassifier2);
        if (classifierNode == null || object3 == null) {
            return null;
        }
        mIRClassifier = graphBuilder.findSourceClassifier(classifierNode, false);
        mIRClassifier2 = graphBuilder.findSourceClassifier((ClassifierNode)object3, false);
        if (mIRClassifier == null || mIRClassifier.getElementType() != 13 || mIRClassifier2 == null || mIRClassifier2.getElementType() != 13) {
            return null;
        }
        cloneable = new ArrayList();
        ArrayList<MIRFeature> arrayList3 = new ArrayList<MIRFeature>();
        for (n = 0; n < arrayList.size(); ++n) {
            MIRFeature mIRFeature = arrayList.get(n);
            mIRModelObject = arrayList2.get(n);
            object2 = classifierNode.getFeatureNode(mIRFeature);
            object = ((ClassifierNode)object3).getFeatureNode((MIRFeature)mIRModelObject);
            if (object2 == null || object == null) {
                return null;
            }
            mIRFeature = graphBuilder.findSourceFeature((FeatureNode)object2);
            mIRModelObject = graphBuilder.findSourceFeature((FeatureNode)object);
            if (mIRFeature == null || mIRModelObject == null || mIRFeature.getElementType() != 14 || ((MIRFeature)mIRModelObject).getElementType() != 14) {
                return null;
            }
            boolean bl3 = mIRClassifier.containsFeature(mIRFeature);
            boolean bl4 = mIRClassifier2.containsFeature((MIRFeature)mIRModelObject);
            if (!bl3 || !bl4) {
                return null;
            }
            if (!((ArrayList)cloneable).contains(mIRFeature) && !arrayList3.contains(mIRModelObject) && ((ArrayList)cloneable).add(mIRFeature) && arrayList3.add((MIRFeature)mIRModelObject)) continue;
            return null;
        }
        n = this.isMultiplicityMany(mIRJoinRole) ? 1 : 0;
        boolean bl5 = this.isMultiplicityMany(mIRJoinRole2);
        mIRModelObject = null;
        if (n != 0 && !bl5) {
            mIRModelObject = this.reverseEngineerJoin(mIRJoinRole2, mIRJoinRole, (MIRClass)mIRClassifier2, (MIRClass)mIRClassifier, arrayList3, (ArrayList<MIRFeature>)cloneable);
        } else if (n == 0 && bl5) {
            mIRModelObject = this.reverseEngineerJoin(mIRJoinRole, mIRJoinRole2, (MIRClass)mIRClassifier, (MIRClass)mIRClassifier2, (ArrayList<MIRFeature>)cloneable, arrayList3);
        } else if (n == 0 && !bl5) {
            mIRModelObject = this.reverseEngineerJoin(mIRJoinRole, mIRJoinRole2, (MIRClass)mIRClassifier, (MIRClass)mIRClassifier2, (ArrayList<MIRFeature>)cloneable, arrayList3);
        } else if (n == 0 || bl5) {
            // empty if block
        }
        if (mIRModelObject != null) {
            object2 = mIRJoin.getDiagramIterator();
            while (object2.hasNext()) {
                object = (MIRDiagram)object2.next();
                if (!((MIRDiagram)object).containsModelElement((MIRModelElement)mIRModelObject)) {
                    ((MIRDiagram)object).addModelElement((MIRModelElement)mIRModelObject);
                }
                if (!((MIRDiagram)object).containsModelElement(mIRClassifier)) {
                    ((MIRDiagram)object).addModelElement(mIRClassifier);
                }
                if (((MIRDiagram)object).containsModelElement(mIRClassifier2)) continue;
                ((MIRDiagram)object).addModelElement(mIRClassifier2);
            }
        }
        return mIRModelObject;
    }

    private boolean isMultiplicityMany(MIRJoinRole mIRJoinRole) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        MIRBridgeLib.decodeMultiplicity(mIRJoinRole.getMultiplicity(), hashMap);
        return hashMap.get("max") > 1;
    }

    public void reverseEngineerROLAPModel(MIRModel mIRModel) throws MIRException {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{22});
        mIRModel.depthTraversal(objectCollector);
        Set set = objectCollector.getObjects();
        for (Object object62 : set) {
            object5 = ((MIRKey)object62).getAttributeIterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                object3 = MIRRelationalLib.getParentAttribute((MIRAttribute)object4, (MIRForeignKey)object62);
                if (object3 == null) continue;
                MIRRelationalLib.createARNM((MIRAttribute)object3, (MIRAttribute)object4, (MIRForeignKey)object62, true);
            }
        }
        ObjectCollector objectCollector2 = new ObjectCollector(new short[]{13});
        mIRModel.depthTraversal(objectCollector2);
        object62 = new GraphBuilder();
        object5 = objectCollector2.getObjects();
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = (MIRClass)object4.next();
            this.reverseEngineerROLAPProperties((GraphBuilder)object62, (MIRClass)object3);
            ((MIRModelObject)object3).setDesignLevel((byte)0);
        }
        object4 = new ObjectCollector(new short[]{92});
        mIRModel.depthTraversal(object4);
        for (Object object22 : ((ObjectCollector)object4).getObjects()) {
            object = this.reverseEngineerJoin((GraphBuilder)object62, (MIRJoin)object22);
            if (object == null) {
                BLIB.DBG_DEBUG.log("Could not reverse engineer Join: " + ((MIRObject)object22).getName());
                continue;
            }
            ((MIRNamespaceElement)object).addNamespace(((MIRNamespaceElement)object22).getNamespace());
        }
        object3 = new ObjectCollector(new short[]{9});
        mIRModel.depthTraversal(object3);
        object22 = ((ObjectCollector)object3).getObjects();
        object = object22.iterator();
        while (object.hasNext()) {
            MIRDesignPackage mIRDesignPackage = (MIRDesignPackage)object.next();
            mIRDesignPackage.setUserDefined(false);
        }
    }

    public MIRDesignPackage forwardEngineerROLAPObjects(MIRStoreModel mIRStoreModel, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, boolean bl5, boolean bl6, boolean bl7, MIRLogger mIRLogger) throws MIRException {
        ForwardEngineerROLAPObjects forwardEngineerROLAPObjects = new ForwardEngineerROLAPObjects(mIRStoreModel, bl, bl2, bl3, string, bl4, bl5, bl6, bl7, mIRLogger);
        return forwardEngineerROLAPObjects.run();
    }

    private class ForwardEngineerROLAPObjects {
        private MIRStoreModel theModel;
        private MIRDesignPackage olapPackage;
        private MIROlapSchema olapSchema;
        private boolean autodetectStarSchema;
        private boolean collapseOutriggerTables;
        private boolean collapseAllowJoinLoops;
        private String hintFactTables;
        private ArrayList<MIRClassifier> hintFactTablesArray;
        private boolean assumeTablesAreDimensions;
        private boolean doCreateCubes;
        private boolean snowflakeJoinsOnly;
        private boolean verbose;
        private MIRLogger log;
        private boolean hasOLAPmetadata;
        private Parser expressionParser;
        private ArrayList<MIRClassifier> tables;
        private ArrayList<MIRForeignKey> foreignKeys;
        private ArrayList<MIRFeature> columns;
        private ArrayList<MIRClassifier> factTables;
        private ArrayList<MIRClassifier> dimensionTables;
        private ArrayList<MIRFeature> attributes;
        private ArrayList<MIRFeature> measures;
        private ArrayList<JoinedTable> candidateJoinedTables;
        private TreeMap<MIRObject, ObjectUserData> objectUserDataTree;

        private ForwardEngineerROLAPObjects(MIRStoreModel mIRStoreModel, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, boolean bl5, boolean bl6, boolean bl7, MIRLogger mIRLogger) {
            this.theModel = mIRStoreModel;
            this.collapseOutriggerTables = bl;
            this.collapseAllowJoinLoops = bl2;
            this.autodetectStarSchema = bl3;
            this.hintFactTables = string;
            this.hintFactTablesArray = new ArrayList();
            this.assumeTablesAreDimensions = bl4;
            this.doCreateCubes = bl5;
            this.snowflakeJoinsOnly = bl6;
            this.verbose = bl7;
            this.log = mIRLogger;
            this.expressionParser = new Parser(mIRLogger);
            this.tables = new ArrayList();
            this.foreignKeys = new ArrayList();
            this.columns = new ArrayList();
            this.factTables = new ArrayList();
            this.dimensionTables = new ArrayList();
            this.attributes = new ArrayList();
            this.measures = new ArrayList();
            this.candidateJoinedTables = new ArrayList();
            this.objectUserDataTree = new TreeMap();
        }

        private MIRDesignPackage run() throws MIRException {
            this.hasOLAPmetadata = false;
            try {
                MIRDesignPackage mIRDesignPackage;
                Iterator<MIRDesignPackage> iterator = this.theModel.getDesignPackageIterator();
                while (iterator.hasNext()) {
                    mIRDesignPackage = iterator.next();
                    this.retrieveModelElements(mIRDesignPackage);
                }
                if (this.hasOLAPmetadata) {
                    mIRDesignPackage = null;
                    return mIRDesignPackage;
                }
                BLIB.MSG_START_ROLAP_FORWARD_ENGINEERING.log(new Object[0]);
                this.parseFactTables();
                this.olapPackage = new MIRDesignPackage();
                this.olapSchema = new MIROlapSchema();
                this.theModel.addDataPackage(this.olapSchema);
                this.theModel.addDesignPackage(this.olapPackage);
                this.preProcessTables();
                this.preProcessColumns();
                this.preProcessJoins();
                this.preProcessFactTables();
                this.createDimensions();
                this.createJoins();
                if (this.doCreateCubes) {
                    this.createCubes();
                }
                BLIB.MSG_FINISH_ROLAP_FORWARD_ENGINEERING.log(new Object[0]);
                if (this.log.getLevel() >= 6) {
                    if (this.olapPackage.getName().isEmpty()) {
                        this.olapPackage.setName("ROLAPEngineering");
                    }
                    assert (MIRValidation.validate(this.olapPackage, MIRValidationLevel.BASIC));
                }
            }
            finally {
                this.cleanup();
            }
            return this.olapPackage;
        }

        private void cleanup() {
            this.tables.clear();
            this.foreignKeys.clear();
            this.columns.clear();
            this.factTables.clear();
            this.dimensionTables.clear();
            this.attributes.clear();
            this.measures.clear();
            this.candidateJoinedTables.clear();
            this.objectUserDataTree.clear();
        }

        private ObjectUserData getObjectUserData(MIRObject mIRObject) {
            ObjectUserData objectUserData = this.objectUserDataTree.get(mIRObject);
            if (objectUserData == null) {
                objectUserData = new ObjectUserData();
                this.objectUserDataTree.put(mIRObject, objectUserData);
            }
            return objectUserData;
        }

        private boolean isExportableClass(MIRClass mIRClass) {
            ObjectUserData objectUserData = this.getObjectUserData(mIRClass);
            if (objectUserData.isExportable == -1) {
                if (mIRClass.getDesignLevel() == 1) {
                    objectUserData.isExportable = 0;
                } else {
                    objectUserData.isExportable = 1;
                }
            }
            return objectUserData.isExportable == 1;
        }

        private boolean isExportableSQLViewEntity(MIRSQLViewEntity mIRSQLViewEntity) {
            return true;
        }

        private boolean isExportableFeature(MIRFeature mIRFeature) {
            ObjectUserData objectUserData = this.getObjectUserData(mIRFeature);
            if (objectUserData.isExportable == -1) {
                if (mIRFeature.getElementType() == 14) {
                    if (mIRFeature.getDesignLevel() == 1) {
                        objectUserData.isExportable = 0;
                    } else {
                        objectUserData.isExportable = 1;
                    }
                } else if (mIRFeature.getElementType() == 26) {
                    MIRSQLViewAttribute mIRSQLViewAttribute = (MIRSQLViewAttribute)mIRFeature;
                    if (mIRSQLViewAttribute.getDesignLevel() == 1) {
                        objectUserData.isExportable = 0;
                    } else {
                        objectUserData.isExportable = 1;
                        if (mIRSQLViewAttribute.getSourceFeature() != null && !this.isExportableFeature(mIRSQLViewAttribute.getSourceFeature())) {
                            objectUserData.isExportable = 0;
                        }
                    }
                }
            }
            return objectUserData.isExportable == 1;
        }

        private boolean isExportableGeneralization(MIRGeneralization mIRGeneralization) {
            ObjectUserData objectUserData = this.getObjectUserData(mIRGeneralization);
            if (objectUserData.isExportable == -1) {
                boolean bl = true;
                if (mIRGeneralization.getDesignLevel() == 1) {
                    objectUserData.isExportable = 0;
                } else if (!this.isExportableClass(mIRGeneralization.getSupertypeGeneralizationRoleIterator().next().getAssociatedClass())) {
                    objectUserData.isExportable = 0;
                } else {
                    objectUserData.isExportable = 1;
                }
                Iterator<MIRGeneralizationRole> iterator = mIRGeneralization.getSubtypeGeneralizationRoleIterator();
                while (iterator.hasNext()) {
                    if (!this.isExportableClass(iterator.next().getAssociatedClass())) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    objectUserData.isExportable = 0;
                }
            }
            return objectUserData.isExportable == 1;
        }

        private boolean mtmAssociation(MIRAssociation mIRAssociation) {
            Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
            return MIRBridgeLib.isMultiplicityMany(iterator.next()) && MIRBridgeLib.isMultiplicityMany(iterator.next());
        }

        private boolean isExportableAssociation(MIRAssociation mIRAssociation) {
            Iterator<MIRAssociationRole> iterator = mIRAssociation.getAssociationRoleIterator();
            ObjectUserData objectUserData = this.getObjectUserData(mIRAssociation);
            if (objectUserData.isExportable == -1) {
                if (mIRAssociation.getAssociationRoleCount() != 2) {
                    objectUserData.isExportable = 0;
                } else if (mIRAssociation.getDesignLevel() == 1) {
                    objectUserData.isExportable = 0;
                } else if (this.mtmAssociation(mIRAssociation)) {
                    objectUserData.isExportable = 0;
                } else if (!this.isExportableClass(iterator.next().getAssociatedClass()) || !this.isExportableClass(iterator.next().getAssociatedClass())) {
                    objectUserData.isExportable = 0;
                } else {
                    objectUserData.isExportable = 1;
                }
            }
            return objectUserData.isExportable == 1;
        }

        private boolean isExportableKey(MIRKey mIRKey) {
            ObjectUserData objectUserData = this.getObjectUserData(mIRKey);
            if (objectUserData.isExportable == -1) {
                objectUserData.isExportable = 1;
                Iterator<MIRAttribute> iterator = mIRKey.getAttributeIterator();
                while (iterator.hasNext()) {
                    MIRAttribute mIRAttribute = iterator.next();
                    if (this.isExportableFeature(mIRAttribute)) continue;
                    objectUserData.isExportable = 0;
                    break;
                }
            }
            return objectUserData.isExportable == 1;
        }

        private MIRClassifier findTable(String string) {
            for (int i = 0; i < this.tables.size(); ++i) {
                MIRClassifier mIRClassifier = this.tables.get(i);
                MIRDataPackage mIRDataPackage = mIRClassifier.getDataPackage();
                String string2 = "";
                if (mIRDataPackage != null && !MIRBridgeLib.getPhysicalName(mIRDataPackage).isEmpty()) {
                    string2 = string2 + MIRBridgeLib.getPhysicalName(mIRDataPackage) + ".";
                }
                if ((string2 = string2 + MIRBridgeLib.getPhysicalName(mIRClassifier)).compareToIgnoreCase(string) != 0) continue;
                return mIRClassifier;
            }
            return null;
        }

        private void parseFactTables() {
            String string;
            if (this.hintFactTables.isEmpty()) {
                return;
            }
            EscapedStringTokenizer escapedStringTokenizer = new EscapedStringTokenizer(this.hintFactTables);
            while ((string = escapedStringTokenizer.getNextToken()) != null && string.length() != 0) {
                MIRClassifier mIRClassifier = this.findTable(string);
                if (mIRClassifier != null) {
                    this.hintFactTablesArray.add(mIRClassifier);
                    continue;
                }
                BLIB.MSG_FACT_TABLE_NOT_FOUND.log(string);
            }
        }

        private void retrieveModelElements(MIRDesignPackage mIRDesignPackage) {
            MIRNamespaceElement mIRNamespaceElement;
            Iterator<MIRNamespaceElement> iterator = mIRDesignPackage.getNamespaceElementIterator();
            while (iterator.hasNext()) {
                mIRNamespaceElement = iterator.next();
                if (mIRNamespaceElement.getElementType() != 9) continue;
                this.retrieveModelElements((MIRDesignPackage)mIRNamespaceElement);
            }
            iterator = mIRDesignPackage.getNamespaceElementIterator();
            while (iterator.hasNext()) {
                mIRNamespaceElement = iterator.next();
                if (mIRNamespaceElement.getElementType() == 13 && this.isExportableClass((MIRClass)mIRNamespaceElement)) {
                    this.tables.add((MIRClass)mIRNamespaceElement);
                    MIRClass mIRClass = (MIRClass)mIRNamespaceElement;
                    Iterator<MIRKey> iterator2 = mIRClass.getKeyIterator();
                    while (iterator2.hasNext()) {
                        MIRKey mIRKey = iterator2.next();
                        if (mIRKey.getElementType() != 22) continue;
                        this.foreignKeys.add((MIRForeignKey)mIRKey);
                    }
                    continue;
                }
                if (mIRNamespaceElement.getElementType() == 25 && this.isExportableSQLViewEntity((MIRSQLViewEntity)mIRNamespaceElement)) {
                    this.tables.add((MIRSQLViewEntity)mIRNamespaceElement);
                    continue;
                }
                if (mIRNamespaceElement.getElementType() != 89 && mIRNamespaceElement.getElementType() != 87 && mIRNamespaceElement.getElementType() != 85 && mIRNamespaceElement.getElementType() != 148 && mIRNamespaceElement.getElementType() != 119) continue;
                this.hasOLAPmetadata = true;
                break;
            }
        }

        private void preProcessTables() {
            Iterator<MIRKey> iterator;
            int n;
            MIRDataPackage mIRDataPackage;
            String string;
            ObjectUserData objectUserData;
            MIRClassifier mIRClassifier;
            int n2;
            for (n2 = 0; n2 < this.tables.size(); ++n2) {
                mIRClassifier = this.tables.get(n2);
                objectUserData = this.getObjectUserData(mIRClassifier);
                if (mIRClassifier.getElementType() == 13) {
                    objectUserData.DWRole = ((MIRClass)mIRClassifier).getDimensionalRole();
                } else if (mIRClassifier.getElementType() == 25) {
                    objectUserData.DWRole = ((MIRSQLViewEntity)mIRClassifier).getDimensionalRole();
                }
                string = "";
                mIRDataPackage = mIRClassifier.getDataPackage();
                if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRDataPackage).isEmpty()) {
                    string = string + MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".";
                }
                string = string + MIRBridgeLib.getQuotedPhysicalName(mIRClassifier);
                if (objectUserData.DWRole != 0 && this.verbose) {
                    BLIB.MSG_TABLE_HAS_DIMENSIONAL_ROLE.log(string, MIRDimensionalRoleType.toString(objectUserData.DWRole));
                }
                if (objectUserData.DWRole == 0 && this.hintFactTablesArray.size() > 0) {
                    for (int i = 0; i < this.hintFactTablesArray.size(); ++i) {
                        MIRClassifier mIRClassifier2 = this.hintFactTablesArray.get(i);
                        if (mIRClassifier2 != mIRClassifier) continue;
                        if (this.verbose) {
                            BLIB.MSG_ASSUMING_TABLE_FACT_USER_INPUT.log(string);
                        }
                        objectUserData.DWRole = (byte)1;
                        break;
                    }
                }
                if (objectUserData.DWRole != 0 || !this.autodetectStarSchema || mIRClassifier.getElementType() != 13) continue;
                MIRClass mIRClass = (MIRClass)mIRClassifier;
                int n3 = 0;
                n = 0;
                iterator = mIRClass.getKeyIterator();
                while (iterator.hasNext()) {
                    MIRKey mIRKey = iterator.next();
                    if (mIRKey.getElementType() == 21) {
                        n += ((MIRCandidateKey)mIRKey).getForeignKeyCount();
                        continue;
                    }
                    if (mIRKey.getElementType() != 22) continue;
                    ++n3;
                }
                if (n != 0 || n3 < 2) continue;
                if (this.verbose) {
                    BLIB.MSG_AUTODETECT_FACT_TABLE.log(string);
                }
                objectUserData.DWRole = (byte)1;
            }
            for (n2 = 0; n2 < this.tables.size(); ++n2) {
                mIRClassifier = this.tables.get(n2);
                objectUserData = this.getObjectUserData(mIRClassifier);
                string = "";
                mIRDataPackage = mIRClassifier.getDataPackage();
                if (mIRDataPackage != null && mIRDataPackage.getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRDataPackage).isEmpty()) {
                    string = string + MIRBridgeLib.getQuotedPhysicalName(mIRDataPackage) + ".";
                }
                string = string + MIRBridgeLib.getQuotedPhysicalName(mIRClassifier);
                if (objectUserData.DWRole == 0 && this.autodetectStarSchema) {
                    if (mIRClassifier.getElementType() == 13) {
                        MIRClass mIRClass = (MIRClass)mIRClassifier;
                        int n4 = 0;
                        n = 0;
                        iterator = mIRClass.getKeyIterator();
                        while (iterator.hasNext()) {
                            MIRKey mIRKey = iterator.next();
                            if (mIRKey.getElementType() == 21) {
                                n += ((MIRCandidateKey)mIRKey).getForeignKeyCount();
                                continue;
                            }
                            if (mIRKey.getElementType() != 22) continue;
                            ++n4;
                        }
                        if (n == 0 && n4 == 0) {
                            if (this.verbose) {
                                BLIB.MSG_AUTODETECT_DIMENSION_TABLE.log(string);
                            }
                            objectUserData.DWRole = (byte)2;
                        } else if (n == 0 && n4 == 1) {
                            objectUserData.DWRole = (byte)2;
                            if (this.verbose) {
                                BLIB.MSG_AUTODETECT_DIMENSION_TABLE.log(string);
                            }
                        } else if (n > 0) {
                            int n5 = this.computeFactTableDistance(mIRClass, 0);
                            if (n5 == 1) {
                                if (this.verbose) {
                                    BLIB.MSG_AUTODETECT_DIMENSION_TABLE.log(string);
                                }
                                objectUserData.DWRole = (byte)2;
                            } else if (n5 >= 2) {
                                if (this.verbose) {
                                    BLIB.MSG_AUTODETECT_OUTRIGGER_TABLE.log(string);
                                }
                                objectUserData.DWRole = (byte)3;
                            } else {
                                if (this.verbose) {
                                    BLIB.MSG_AUTODETECT_DIMENSION_TABLE.log(string);
                                }
                                objectUserData.DWRole = (byte)2;
                            }
                        }
                    } else if (mIRClassifier.getElementType() == 25) {
                        if (this.verbose) {
                            BLIB.MSG_AUTODETECT_DIMENSION_TABLE.log(string);
                        }
                        objectUserData.DWRole = (byte)2;
                    }
                }
                if (objectUserData.DWRole != 0 || !this.assumeTablesAreDimensions) continue;
                if (this.verbose) {
                    BLIB.MSG_ASSUMING_TABLE_DIMENSION_USER_INPUT.log(string);
                }
                objectUserData.DWRole = (byte)2;
            }
        }

        private int computeFactTableDistance(MIRClass mIRClass, int n) {
            int n2 = 2;
            Iterator<MIRKey> iterator = mIRClass.getKeyIterator();
            while (iterator.hasNext()) {
                MIRKey mIRKey = iterator.next();
                if (mIRKey.getElementType() != 21) continue;
                MIRCandidateKey mIRCandidateKey = (MIRCandidateKey)mIRKey;
                Iterator<MIRForeignKey> iterator2 = mIRCandidateKey.getForeignKeyIterator();
                while (iterator2.hasNext()) {
                    MIRForeignKey mIRForeignKey = iterator2.next();
                    MIRClass mIRClass2 = mIRForeignKey.getAssociatedClass();
                    if (mIRClass2 == mIRClass) continue;
                    int n3 = 0;
                    if (this.getObjectUserData(mIRClass2).DWRole == 0) {
                        n3 = n >= 2 ? 2 : 1 + this.computeFactTableDistance(mIRClass2, n + 1);
                    } else if (this.getObjectUserData(mIRClass2).DWRole == 1) {
                        n3 = 1;
                    }
                    if (n3 >= n2) continue;
                    n2 = n3;
                }
            }
            return n2;
        }

        private MIRType getType(MIRFeature mIRFeature) {
            MIRFeature mIRFeature2;
            MIRType mIRType = mIRFeature.getType();
            if (mIRType == null && mIRFeature.getElementType() == 26 && (mIRFeature2 = ((MIRSQLViewAttribute)mIRFeature).getSourceFeature()) != null) {
                mIRType = this.getType(mIRFeature2);
            }
            return mIRType;
        }

        private void preProcessColumns() {
            Object object;
            MIRModelObject mIRModelObject;
            int n;
            for (n = 0; n < this.tables.size(); ++n) {
                mIRModelObject = this.tables.get(n);
                for (MIRFeature object2 : ((MIRClassifier)mIRModelObject).getFeatureByPosition()) {
                    if (!this.isExportableFeature(object2)) continue;
                    this.columns.add(object2);
                }
            }
            for (n = 0; n < this.columns.size(); ++n) {
                MIRModelObject mIRModelObject2;
                Object object2;
                mIRModelObject = this.columns.get(n);
                object = ((MIRFeature)mIRModelObject).getClassifier();
                ObjectUserData objectUserData = this.getObjectUserData((MIRObject)object);
                MIRType mIRType = this.getType((MIRFeature)mIRModelObject);
                boolean bl = false;
                if (((MIRFeature)mIRModelObject).getElementType() == 14) {
                    object2 = ((MIRAttribute)mIRModelObject).getKeyIterator();
                    while (object2.hasNext()) {
                        mIRModelObject2 = object2.next();
                        if (22 != ((MIRKey)mIRModelObject2).getElementType() && (21 != ((MIRKey)mIRModelObject2).getElementType() || !((MIRCandidateKey)mIRModelObject2).getUniqueKey())) continue;
                        bl = true;
                        break;
                    }
                }
                if (mIRType != null && MIRBaseTypeList.isMIRNumeric(mIRType.getDataType()) && objectUserData.DWRole == 1 && (((MIRFeature)mIRModelObject).getElementType() == 26 || !bl)) {
                    if (this.verbose) {
                        object2 = "";
                        mIRModelObject2 = ((MIRFeature)mIRModelObject).getClassifier().getDataPackage();
                        if (mIRModelObject2 != null && ((MIRDataPackage)mIRModelObject2).getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRModelObject2).isEmpty()) {
                            object2 = (String)object2 + MIRBridgeLib.getQuotedPhysicalName(mIRModelObject2) + ".";
                        }
                        object2 = (String)object2 + MIRBridgeLib.getQuotedPhysicalName(((MIRFeature)mIRModelObject).getClassifier()) + ".";
                        object2 = (String)object2 + MIRBridgeLib.getQuotedPhysicalName(mIRModelObject);
                        BLIB.MSG_ASSUMING_COLUMN_MEASURE.log(this.log, object2);
                    }
                    this.measures.add((MIRFeature)mIRModelObject);
                    objectUserData.oudMeasures.add(mIRModelObject);
                    continue;
                }
                this.attributes.add((MIRFeature)mIRModelObject);
                objectUserData.oudAttributes.add(mIRModelObject);
            }
            for (n = 0; n < this.tables.size(); ++n) {
                mIRModelObject = this.tables.get(n);
                object = this.getObjectUserData(mIRModelObject);
                if (((ObjectUserData)object).DWRole == 1) {
                    this.factTables.add((MIRClassifier)mIRModelObject);
                    continue;
                }
                if (((ObjectUserData)object).DWRole != 2) continue;
                this.dimensionTables.add((MIRClassifier)mIRModelObject);
            }
        }

        private JoinedTable createCandidateJoin(MIRForeignKey mIRForeignKey) {
            MIRCandidateKey mIRCandidateKey = mIRForeignKey.getCandidateKey();
            MIRClass mIRClass = mIRCandidateKey != null ? mIRCandidateKey.getAssociatedClass() : null;
            MIRClass mIRClass2 = mIRForeignKey.getAssociatedClass();
            JoinedTable joinedTable = new JoinedTable();
            joinedTable.fk = mIRForeignKey;
            joinedTable.sourceTable = mIRClass;
            String string = mIRClass != null ? mIRClass.getName() : "";
            JoinedTable joinedTable2 = joinedTable;
            joinedTable2.name = joinedTable2.name + mIRClass2.getName() + "-" + string;
            joinedTable2 = joinedTable;
            joinedTable2.physicalName = joinedTable2.physicalName + MIRBridgeLib.getPhysicalName(mIRClass2) + "-" + MIRBridgeLib.getPhysicalName(mIRClass);
            return joinedTable;
        }

        private void preProcessJoins() {
            for (int i = 0; i < this.foreignKeys.size(); ++i) {
                JoinedTable joinedTable;
                MIRGeneralization mIRGeneralization;
                MIRForeignKey mIRForeignKey = this.foreignKeys.get(i);
                MIRClass mIRClass = mIRForeignKey.getAssociatedClass();
                MIRCandidateKey mIRCandidateKey = mIRForeignKey.getCandidateKey();
                MIRClass mIRClass2 = mIRCandidateKey != null ? mIRCandidateKey.getAssociatedClass() : null;
                MIRAssociationRole mIRAssociationRole = mIRForeignKey.getAssociationRole();
                MIRAssociation mIRAssociation = mIRAssociationRole != null ? mIRAssociationRole.getAssociation() : null;
                MIRGeneralizationRole mIRGeneralizationRole = mIRForeignKey.getGeneralizationRole();
                MIRGeneralization mIRGeneralization2 = mIRGeneralization = mIRGeneralizationRole != null ? mIRGeneralizationRole.getSubtypeOfGeneralization() : null;
                if (mIRAssociation != null) {
                    if (mIRCandidateKey == null || !this.isExportableKey(mIRForeignKey) || !this.isExportableKey(mIRCandidateKey) || !this.isExportableAssociation(mIRAssociation)) continue;
                    joinedTable = this.createCandidateJoin(mIRForeignKey);
                    this.candidateJoinedTables.add(joinedTable);
                    this.getObjectUserData(mIRClass).oudCandidateJoinedTables.add(joinedTable);
                    continue;
                }
                if (mIRGeneralization == null || mIRCandidateKey == null || !this.isExportableGeneralization(mIRGeneralization) || !this.isExportableKey(mIRForeignKey) || !this.isExportableKey(mIRCandidateKey) || !this.isExportableClass(mIRClass2)) continue;
                joinedTable = this.createCandidateJoin(mIRForeignKey);
                this.candidateJoinedTables.add(joinedTable);
                this.getObjectUserData(mIRClass).oudCandidateJoinedTables.add(joinedTable);
            }
        }

        private void preProcessFactTables() {
            JoinedTable joinedTable;
            int n;
            boolean bl;
            MIRClass mIRClass;
            JoinedTable joinedTable2;
            int n2;
            ObjectUserData objectUserData;
            MIRClass mIRClass2;
            MIRClassifier mIRClassifier;
            int n3;
            for (n3 = 0; n3 < this.factTables.size(); ++n3) {
                mIRClassifier = this.factTables.get(n3);
                if (mIRClassifier.getElementType() != 13) continue;
                mIRClass2 = (MIRClass)mIRClassifier;
                objectUserData = this.getObjectUserData(mIRClass2);
                for (n2 = 0; n2 < objectUserData.oudCandidateJoinedTables.size(); ++n2) {
                    joinedTable2 = (JoinedTable)objectUserData.oudCandidateJoinedTables.get(n2);
                    mIRClass = joinedTable2.sourceTable;
                    if (this.getObjectUserData(mIRClass).DWRole != 2) continue;
                    bl = false;
                    for (n = 0; n < objectUserData.oudJoinedTables.size(); ++n) {
                        joinedTable = (JoinedTable)objectUserData.oudJoinedTables.get(n);
                        if (joinedTable.sourceTable != mIRClass) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    objectUserData.oudJoinedTables.add(joinedTable2);
                }
            }
            if (!this.collapseOutriggerTables) {
                return;
            }
            for (n3 = 0; n3 < this.dimensionTables.size(); ++n3) {
                mIRClassifier = this.dimensionTables.get(n3);
                if (mIRClassifier.getElementType() != 13) continue;
                mIRClass2 = (MIRClass)mIRClassifier;
                objectUserData = this.getObjectUserData(mIRClass2);
                for (n2 = 0; n2 < objectUserData.oudCandidateJoinedTables.size(); ++n2) {
                    joinedTable2 = (JoinedTable)objectUserData.oudCandidateJoinedTables.get(n2);
                    mIRClass = joinedTable2.sourceTable;
                    if (this.getObjectUserData(mIRClass).DWRole != 3) continue;
                    bl = false;
                    for (n = 0; n < objectUserData.oudJoinedTables.size(); ++n) {
                        joinedTable = (JoinedTable)objectUserData.oudJoinedTables.get(n);
                        if (joinedTable.sourceTable != mIRClass) continue;
                        bl = true;
                        break;
                    }
                    if (bl && !this.collapseAllowJoinLoops) continue;
                    this.migrateOutriggerAttributesToDimension(joinedTable2, mIRClass2);
                }
            }
        }

        private void migrateOutriggerAttributesToDimension(JoinedTable joinedTable, MIRClass mIRClass) {
            int n;
            Object object;
            Object object2;
            if (this.verbose) {
                object2 = "";
                object = mIRClass.getDataPackage();
                if (object != null && ((MIRDataPackage)object).getElementType() == 72 && !MIRBridgeLib.getPhysicalName((MIRObject)object).isEmpty()) {
                    object2 = (String)object2 + MIRBridgeLib.getQuotedPhysicalName((MIRModelObject)object) + ".";
                }
                object2 = (String)object2 + MIRBridgeLib.getQuotedPhysicalName(mIRClass);
                String string = "";
                object = joinedTable.sourceTable.getDataPackage();
                if (object != null && ((MIRDataPackage)object).getElementType() == 72 && !MIRBridgeLib.getPhysicalName((MIRObject)object).isEmpty()) {
                    string = string + MIRBridgeLib.getQuotedPhysicalName((MIRModelObject)object) + ".";
                }
                string = string + MIRBridgeLib.getQuotedPhysicalName(joinedTable.sourceTable);
                BLIB.MSG_MIGRATING_OUTRIGGER_TO_DIMENSION.log(this.log, string, object2);
            }
            object2 = this.getObjectUserData(joinedTable.sourceTable);
            object = this.getObjectUserData(mIRClass);
            for (n = 0; n < ((ObjectUserData)object2).oudAttributes.size(); ++n) {
                ((ObjectUserData)object).oudAttributes.add(((ObjectUserData)object2).oudAttributes.get(n));
            }
            ((ObjectUserData)object).oudJoinedTables.add(joinedTable);
            for (n = 0; n < ((ObjectUserData)object2).oudCandidateJoinedTables.size(); ++n) {
                JoinedTable joinedTable2 = (JoinedTable)((ObjectUserData)object2).oudCandidateJoinedTables.get(n);
                MIRClass mIRClass2 = joinedTable2.sourceTable;
                if (this.getObjectUserData(mIRClass2).DWRole != 3) continue;
                boolean bl = false;
                for (int i = 0; i < ((ObjectUserData)object).oudJoinedTables.size(); ++i) {
                    JoinedTable joinedTable3 = (JoinedTable)((ObjectUserData)object).oudJoinedTables.get(i);
                    if (joinedTable3.sourceTable != mIRClass2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.migrateOutriggerAttributesToDimension(joinedTable2, mIRClass);
            }
        }

        private MIRDimension createDimension(MIRClassifier mIRClassifier, boolean bl) {
            MIRElement mIRElement;
            Object object;
            if (this.verbose) {
                object = "";
                mIRElement = mIRClassifier.getDataPackage();
                if (mIRElement != null && ((MIRDataPackage)mIRElement).getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRElement).isEmpty()) {
                    object = (String)object + MIRBridgeLib.getQuotedPhysicalName((MIRModelObject)mIRElement) + ".";
                }
                object = (String)object + MIRBridgeLib.getQuotedPhysicalName(mIRClassifier);
                if (bl) {
                    BLIB.MSG_CREATING_FACT_DIMENSION.log(this.log, mIRClassifier.getName(), object);
                } else {
                    BLIB.MSG_CREATING_DIMENSION.log(this.log, mIRClassifier.getName(), object);
                }
            }
            object = new MIRDimension();
            ((MIRDimension)object).setFrom(mIRClassifier);
            ((MIRElement)object).setNativeId("");
            if (bl) {
                ((MIRDimension)object).setType((byte)0);
            } else {
                ((MIRDimension)object).setType((byte)2);
            }
            this.olapPackage.addNamespaceElementUniqueName((MIRNamespaceElement)object, '/');
            this.olapSchema.addImportedNamespaceElement((MIRNamespaceElement)object);
            mIRElement = new MIRClassifierMap();
            ((MIRClassifier)object).addClassifierMap((MIRClassifierMap)mIRElement);
            ((MIRClassifierMap)mIRElement).addDestinationClassifier((MIRClassifier)object);
            ((MIRClassifierMap)mIRElement).addSourceClassifier(mIRClassifier);
            return object;
        }

        private void createDimensions() throws MIRException {
            MIRDimension mIRDimension;
            ObjectUserData objectUserData;
            MIRClassifier mIRClassifier;
            int n;
            for (n = 0; n < this.factTables.size(); ++n) {
                mIRClassifier = this.factTables.get(n);
                objectUserData = this.getObjectUserData(mIRClassifier);
                mIRDimension = this.createDimension(mIRClassifier, true);
                objectUserData.dim = mIRDimension;
                this.createMeasures(mIRClassifier, mIRDimension);
                this.createDimensionAttributes(mIRClassifier, mIRDimension);
            }
            for (n = 0; n < this.dimensionTables.size(); ++n) {
                mIRClassifier = this.dimensionTables.get(n);
                objectUserData = this.getObjectUserData(mIRClassifier);
                mIRDimension = this.createDimension(mIRClassifier, false);
                objectUserData.dim = mIRDimension;
                this.createDimensionAttributes(mIRClassifier, mIRDimension);
            }
        }

        private void createMeasures(MIRClassifier mIRClassifier, MIRDimension mIRDimension) throws MIRException {
            ObjectUserData objectUserData = this.getObjectUserData(mIRClassifier);
            MIRClassifierMap mIRClassifierMap = mIRDimension.getDestinationOfClassifierMap();
            for (int i = 0; i < objectUserData.oudMeasures.size(); ++i) {
                MIRFeature mIRFeature = (MIRFeature)objectUserData.oudMeasures.get(i);
                MIRMeasure mIRMeasure = new MIRMeasure();
                mIRMeasure.setFrom(mIRFeature);
                mIRMeasure.setNativeId("");
                mIRDimension.addFeatureUniqueName(mIRMeasure, '/');
                mIRMeasure.setPosition((short)mIRDimension.getFeatureCount());
                MIRType mIRType = this.getType(mIRFeature);
                if (mIRType != null) {
                    mIRMeasure.addType(mIRType);
                }
                MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                mIRFeatureMap.addDestinationFeature(mIRMeasure);
                mIRFeatureMap.addSourceFeature(mIRFeature);
                String string = "";
                string = string + "\"" + MIRBridgeLib.getPhysicalName(mIRFeature) + "\"";
                mIRFeatureMap.setOperation(string);
                this.expressionParser.partVector.clear();
                this.expressionParser.partVector.add(mIRFeature);
                this.expressionParser.partCounter = 0;
                this.expressionParser.parse(mIRFeatureMap);
                this.expressionParser.partVector.clear();
                this.expressionParser.partCounter = 0;
                if (mIRClassifierMap.containsSourceClassifier(mIRFeature.getClassifier())) continue;
                mIRClassifierMap.addSourceClassifier(mIRFeature.getClassifier());
            }
        }

        private void createDimensionAttributes(MIRClassifier mIRClassifier, MIRDimension mIRDimension) throws MIRException {
            ObjectUserData objectUserData = this.getObjectUserData(mIRClassifier);
            MIRClassifierMap mIRClassifierMap = mIRDimension.getDestinationOfClassifierMap();
            for (int i = 0; i < objectUserData.oudAttributes.size(); ++i) {
                MIRFeature mIRFeature = (MIRFeature)objectUserData.oudAttributes.get(i);
                String string = "";
                string = string + mIRFeature.getName() + " (" + mIRFeature.getClassifier().getName() + ")";
                MIRDimensionAttribute mIRDimensionAttribute = new MIRDimensionAttribute();
                mIRDimensionAttribute.setFrom(mIRFeature);
                mIRDimensionAttribute.setNativeId("");
                if (mIRDimension.getFeature(mIRDimensionAttribute.getName()) != null) {
                    mIRDimensionAttribute.setName(string);
                }
                mIRDimension.addFeatureUniqueName(mIRDimensionAttribute, '/');
                mIRDimensionAttribute.setPosition((short)mIRDimension.getFeatureCount());
                MIRType mIRType = this.getType(mIRFeature);
                if (mIRType != null) {
                    mIRDimensionAttribute.addType(mIRType);
                }
                MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                mIRFeatureMap.addDestinationFeature(mIRDimensionAttribute);
                mIRFeatureMap.addSourceFeature(mIRFeature);
                String string2 = "";
                string2 = string2 + "\"" + MIRBridgeLib.getPhysicalName(mIRFeature) + "\"";
                mIRFeatureMap.setOperation(string2);
                this.expressionParser.partVector.clear();
                this.expressionParser.partVector.add(mIRFeature);
                this.expressionParser.partCounter = 0;
                this.expressionParser.parse(mIRFeatureMap);
                this.expressionParser.partVector.clear();
                this.expressionParser.partCounter = 0;
                if (mIRClassifierMap.containsSourceClassifier(mIRFeature.getClassifier())) continue;
                mIRClassifierMap.addSourceClassifier(mIRFeature.getClassifier());
            }
        }

        private MIRJoin createJoin(JoinedTable joinedTable, MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) throws MIRException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            MIRElement mIRElement;
            Object object5;
            MIRModelObject mIRModelObject;
            Object object6;
            if (this.verbose) {
                object6 = "";
                mIRModelObject = mIRClassifier.getDataPackage();
                if (mIRModelObject != null && ((MIRDataPackage)mIRModelObject).getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRModelObject).isEmpty()) {
                    object6 = (String)object6 + MIRBridgeLib.getQuotedPhysicalName(mIRModelObject) + ".";
                }
                object6 = (String)object6 + MIRBridgeLib.getQuotedPhysicalName(mIRClassifier);
                object5 = "";
                mIRModelObject = mIRClassifier2.getDataPackage();
                if (mIRModelObject != null && ((MIRDataPackage)mIRModelObject).getElementType() == 72 && !MIRBridgeLib.getPhysicalName(mIRModelObject).isEmpty()) {
                    object5 = (String)object5 + MIRBridgeLib.getQuotedPhysicalName(mIRModelObject) + ".";
                }
                object5 = (String)object5 + MIRBridgeLib.getQuotedPhysicalName(mIRClassifier2);
                BLIB.MSG_CREATING_JOIN.log(object6, object5);
            }
            object6 = joinedTable.fk;
            mIRModelObject = ((MIRForeignKey)object6).getAssociationRole();
            object5 = ((MIRForeignKey)object6).getGeneralizationRole();
            MIRJoin mIRJoin = new MIRJoin();
            mIRJoin.setName(joinedTable.name);
            mIRJoin.setPhysicalName(joinedTable.physicalName);
            MIRJoinRole mIRJoinRole = new MIRJoinRole();
            MIRJoinRole mIRJoinRole2 = new MIRJoinRole();
            mIRJoin.addJoinRole(mIRJoinRole);
            mIRJoin.addJoinRole(mIRJoinRole2);
            mIRJoinRole.setLeft(true);
            mIRJoinRole.addClassifier(mIRClassifier);
            mIRJoinRole2.setLeft(false);
            mIRJoinRole2.addClassifier(mIRClassifier2);
            if (mIRModelObject != null) {
                mIRElement = MIRBridgeLib.findReverseRole((MIRAssociationRole)mIRModelObject);
                object4 = ((MIRAssociationRole)mIRModelObject).getMultiplicity();
                object3 = ((MIRAssociationRole)mIRElement).getMultiplicity();
                object2 = new HashMap<String, Integer>();
                MIRBridgeLib.decodeMultiplicity((String)object4, object2);
                object = new HashMap<String, Integer>();
                MIRBridgeLib.decodeMultiplicity((String)object3, object);
                int n = ((HashMap)object2).get("min");
                int n2 = ((HashMap)object).get("min");
                mIRJoinRole.setMultiplicity((String)object4);
                mIRJoinRole2.setMultiplicity((String)object3);
                if (n == 0 && n2 == 0) {
                    mIRJoin.setType((byte)1);
                } else if (n == 0 && n2 > 0) {
                    mIRJoin.setType((byte)2);
                } else if (n > 0 && n2 == 0) {
                    mIRJoin.setType((byte)3);
                } else {
                    mIRJoin.setType((byte)0);
                }
            } else if (object5 != null) {
                mIRJoinRole.setMultiplicity(MIRBridgeLib.buildMultiplicity(0, MIRBridgeLib.CARD_N));
                mIRJoinRole2.setMultiplicity(MIRBridgeLib.buildMultiplicity(1, 1));
                mIRJoin.setType((byte)2);
            } else {
                mIRJoinRole.setMultiplicity(MIRBridgeLib.buildMultiplicity(0, MIRBridgeLib.CARD_N));
                mIRJoinRole2.setMultiplicity(MIRBridgeLib.buildMultiplicity(1, 1));
                mIRJoin.setType((byte)2);
            }
            mIRElement = new MIRClassifierMap();
            mIRJoin.addClassifierMap((MIRClassifierMap)mIRElement);
            ((MIRClassifierMap)mIRElement).addDestinationClassifier(mIRJoin);
            MIRBridgeLib.addSourceClassifier((MIRClassifierMap)mIRElement, mIRClassifier);
            MIRBridgeLib.addSourceClassifier((MIRClassifierMap)mIRElement, mIRClassifier2);
            object4 = new MIRCondition();
            ((MIRObject)object4).setName(mIRJoin.getName());
            mIRJoin.addFeature((MIRFeature)object4);
            object3 = new MIRFeatureMap();
            ((MIRClassifierMap)mIRElement).addFeatureMap((MIRFeatureMap)object3);
            ((MIRFeatureMap)object3).addDestinationFeature((MIRFeature)object4);
            this.expressionParser.partVector.clear();
            this.expressionParser.partCounter = 0;
            object2 = "";
            object = joinedTable.fk.getAttributeIterator();
            while (object.hasNext()) {
                MIRAttribute mIRAttribute = (MIRAttribute)object.next();
                MIRAttribute mIRAttribute2 = MIRRelationalLib.getParentAttribute(mIRAttribute, joinedTable.fk);
                if (!((String)object2).isEmpty()) {
                    object2 = (String)object2 + " AND ";
                }
                if (mIRClassifier.getElementType() == 87 && mIRClassifier2.getElementType() == 87) {
                    MIRDimensionAttribute mIRDimensionAttribute = this.searchDimensionAttributeImplementingColumn(mIRAttribute, (MIRDimension)mIRClassifier);
                    MIRDimensionAttribute mIRDimensionAttribute2 = this.searchDimensionAttributeImplementingColumn(mIRAttribute2, (MIRDimension)mIRClassifier2);
                    object2 = (String)object2 + "\"" + MIRBridgeLib.getPhysicalName(mIRClassifier) + "\".\"" + MIRBridgeLib.getPhysicalName(mIRDimensionAttribute) + "\"";
                    object2 = (String)object2 + " = ";
                    object2 = (String)object2 + "\"" + MIRBridgeLib.getPhysicalName(mIRClassifier2) + "\".\"" + MIRBridgeLib.getPhysicalName(mIRDimensionAttribute2) + "\"";
                    this.expressionParser.partVector.add(mIRDimensionAttribute);
                    this.expressionParser.partVector.add(mIRDimensionAttribute2);
                    continue;
                }
                if (mIRClassifier.getElementType() != 13 || mIRClassifier2.getElementType() != 13) continue;
                object2 = (String)object2 + "\"" + MIRBridgeLib.getPhysicalName(mIRClassifier) + "\".\"" + MIRBridgeLib.getPhysicalName(mIRAttribute) + "\"";
                object2 = (String)object2 + " = ";
                object2 = (String)object2 + "\"" + MIRBridgeLib.getPhysicalName(mIRClassifier2) + "\".\"" + MIRBridgeLib.getPhysicalName(mIRAttribute2) + "\"";
                this.expressionParser.partVector.add(mIRAttribute);
                this.expressionParser.partVector.add(mIRAttribute2);
            }
            ((MIRFeatureMap)object3).setOperation((String)object2);
            this.expressionParser.parse((MIRFeatureMap)object3);
            this.expressionParser.partVector.clear();
            this.expressionParser.partCounter = 0;
            return mIRJoin;
        }

        private void createJoins() throws MIRException {
            if (this.snowflakeJoinsOnly) {
                MIRJoin mIRJoin;
                MIRClassifier mIRClassifier;
                MIRClass mIRClass;
                MIRCandidateKey mIRCandidateKey;
                MIRForeignKey mIRForeignKey;
                JoinedTable joinedTable;
                int n;
                MIRDimension mIRDimension;
                ObjectUserData objectUserData;
                MIRClassifier mIRClassifier2;
                int n2;
                for (n2 = 0; n2 < this.factTables.size(); ++n2) {
                    mIRClassifier2 = this.factTables.get(n2);
                    objectUserData = this.getObjectUserData(mIRClassifier2);
                    mIRDimension = objectUserData.dim;
                    for (n = 0; n < objectUserData.oudJoinedTables.size(); ++n) {
                        joinedTable = (JoinedTable)objectUserData.oudJoinedTables.get(n);
                        mIRForeignKey = joinedTable.fk;
                        mIRCandidateKey = mIRForeignKey.getCandidateKey();
                        mIRClass = mIRCandidateKey.getAssociatedClass();
                        mIRClassifier = this.getObjectUserData(mIRClass).dim;
                        mIRJoin = this.createJoin(joinedTable, mIRDimension, mIRClassifier);
                        this.olapPackage.addNamespaceElementUniqueName(mIRJoin, '/');
                    }
                }
                for (n2 = 0; n2 < this.dimensionTables.size(); ++n2) {
                    mIRClassifier2 = this.dimensionTables.get(n2);
                    objectUserData = this.getObjectUserData(mIRClassifier2);
                    mIRDimension = objectUserData.dim;
                    for (n = 0; n < objectUserData.oudJoinedTables.size(); ++n) {
                        joinedTable = (JoinedTable)objectUserData.oudJoinedTables.get(n);
                        mIRForeignKey = joinedTable.fk;
                        mIRCandidateKey = mIRForeignKey.getCandidateKey();
                        mIRClass = mIRForeignKey.getAssociatedClass();
                        mIRClassifier = mIRCandidateKey.getAssociatedClass();
                        mIRJoin = this.createJoin(joinedTable, mIRClass, mIRClassifier);
                        this.olapPackage.addNamespaceElementUniqueName(mIRJoin, '/');
                        mIRDimension.addJoin(mIRJoin);
                    }
                }
            } else {
                for (int i = 0; i < this.tables.size(); ++i) {
                    MIRClassifier mIRClassifier = this.tables.get(i);
                    ObjectUserData objectUserData = this.getObjectUserData(mIRClassifier);
                    for (int j = 0; j < objectUserData.oudCandidateJoinedTables.size(); ++j) {
                        JoinedTable joinedTable = (JoinedTable)objectUserData.oudCandidateJoinedTables.get(j);
                        MIRClass mIRClass = joinedTable.fk.getAssociatedClass();
                        MIRClass mIRClass2 = joinedTable.sourceTable;
                        MIRJoin mIRJoin = this.createJoin(joinedTable, mIRClass, mIRClass2);
                        this.olapPackage.addNamespaceElementUniqueName(mIRJoin, '/');
                    }
                }
            }
        }

        private MIRDimensionAttribute searchDimensionAttributeImplementingColumn(MIRAttribute mIRAttribute, MIRDimension mIRDimension) {
            Iterator<MIRFeature> iterator = mIRDimension.getFeatureIterator();
            while (iterator.hasNext()) {
                MIRFeatureMap mIRFeatureMap;
                MIRFeature mIRFeature;
                MIRFeature mIRFeature2 = iterator.next();
                if (mIRFeature2.getElementType() != 88 || mIRFeature2.getDestinationOfFeatureMap() == null || (mIRFeature = (mIRFeatureMap = mIRFeature2.getDestinationOfFeatureMap()).getSourceFeatureIterator().next()) == null || mIRFeature != mIRAttribute || !Util.isSimpleExpression(mIRFeatureMap)) continue;
                return (MIRDimensionAttribute)mIRFeature2;
            }
            return null;
        }

        private void createCubes() throws MIRException {
            MIRClassifier mIRClassifier;
            ArrayList<MIRCube> arrayList = new ArrayList<MIRCube>();
            Iterator<MIRNamespaceElement> iterator = this.olapPackage.getNamespaceElementIterator();
            while (iterator.hasNext()) {
                Object object;
                MIRElement mIRElement;
                MIRModelObject mIRModelObject;
                MIRModelObject mIRModelObject2;
                Object object2;
                MIRNamespaceElement mIRNamespaceElement = iterator.next();
                if (mIRNamespaceElement.getElementType() != 87 || 0 != ((MIRDimension)(mIRClassifier = (MIRDimension)mIRNamespaceElement)).getType()) continue;
                if (this.verbose) {
                    BLIB.MSG_CREATING_CUBE.log(this.log, mIRClassifier.getName());
                }
                MIRCube mIRCube = new MIRCube();
                mIRCube.setFrom(mIRClassifier);
                mIRCube.setDesignLevel((byte)1);
                arrayList.add(mIRCube);
                MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
                mIRCube.addClassifierMap(mIRClassifierMap);
                mIRClassifierMap.addDestinationClassifier(mIRCube);
                mIRClassifierMap.addSourceClassifier(mIRClassifier);
                Iterator<MIRFeature> iterator2 = mIRClassifier.getFeatureIterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    if (((MIRFeature)object2).getElementType() != 97) continue;
                    mIRModelObject2 = (MIRMeasure)object2;
                    mIRModelObject = new MIRMeasure((MIRMeasure)mIRModelObject2);
                    ((MIRFeature)mIRModelObject).addType(((MIRFeature)mIRModelObject2).getType());
                    mIRCube.addFeature((MIRFeature)mIRModelObject);
                    mIRElement = new MIRFeatureMap();
                    ((MIRFeatureMap)mIRElement).addSourceFeature((MIRFeature)mIRModelObject2);
                    ((MIRFeatureMap)mIRElement).addDestinationFeature((MIRFeature)mIRModelObject);
                    mIRClassifierMap.addFeatureMap((MIRFeatureMap)mIRElement);
                    object = "\"" + MIRBridgeLib.getPhysicalName(mIRModelObject2) + "\"";
                    ((MIRFeatureMap)mIRElement).setOperation((String)object);
                    this.expressionParser.partVector.clear();
                    this.expressionParser.partVector.add(mIRModelObject2);
                    this.expressionParser.partCounter = 0;
                    this.expressionParser.parse((MIRFeatureMap)mIRElement);
                    this.expressionParser.partVector.clear();
                    this.expressionParser.partCounter = 0;
                }
                object2 = mIRClassifier.getAssociatedJoinRoleIterator();
                while (object2.hasNext()) {
                    mIRModelObject2 = (MIRJoinRole)object2.next();
                    mIRModelObject = ((MIRJoinRole)mIRModelObject2).getJoin();
                    mIRElement = null;
                    object = ((MIRJoin)mIRModelObject).getJoinRoleIterator().next();
                    MIRJoinRole mIRJoinRole = ((MIRJoin)mIRModelObject).getJoinRoleIterator().next();
                    mIRElement = object == mIRModelObject2 ? (MIRDimension)mIRJoinRole.getClassifier() : (MIRDimension)((MIRJoinRole)object).getClassifier();
                    MIRCubeDimensionAssociation mIRCubeDimensionAssociation = new MIRCubeDimensionAssociation();
                    mIRCubeDimensionAssociation.setName(mIRElement.getName());
                    mIRCubeDimensionAssociation.addCube(mIRCube);
                    mIRCubeDimensionAssociation.addDimension((MIRDimension)mIRElement);
                    mIRCube.addJoin((MIRJoin)mIRModelObject);
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                mIRClassifier = (MIRCube)arrayList.get(i);
                this.olapPackage.addNamespaceElementUniqueName(mIRClassifier, '/');
                this.olapSchema.addImportedNamespaceElement(mIRClassifier);
            }
        }

        private class Parser
        extends MIRExpressionAnalyzer {
            private int partCounter;
            private ArrayList<MIRFeature> partVector;

            private Parser(MIRLogger mIRLogger) {
                super(mIRLogger, 0, 0);
                this.partCounter = 0;
                this.partVector = new ArrayList();
            }

            @Override
            public MIRFeature getDstFeature(MIRClassifier mIRClassifier, LookupOptions lookupOptions) {
                return null;
            }

            @Override
            public void getSrcElements(MIRElementNode mIRElementNode, Collection<MIRClassifier> collection, Collection<MIRElement> collection2) {
                MIRFeature mIRFeature = this.partVector.get(this.partCounter++);
                collection2.add(mIRFeature);
            }
        }

        private class JoinedTable {
            private MIRForeignKey fk = null;
            private MIRClass sourceTable = null;
            private String name = "";
            private String physicalName = "";

            private JoinedTable() {
            }
        }

        private class ObjectUserData {
            private int isExportable = -1;
            private byte DWRole = 0;
            private ArrayList<MIRFeature> oudAttributes = new ArrayList();
            private ArrayList<MIRFeature> oudMeasures = new ArrayList();
            private ArrayList<JoinedTable> oudCandidateJoinedTables = new ArrayList();
            private ArrayList<JoinedTable> oudJoinedTables = new ArrayList();
            private MIRDimension dim = null;

            private ObjectUserData() {
            }
        }
    }

    private class GraphBuilder {
        private ArrayList<ClassifierNode> classifierNodes = new ArrayList();

        private GraphBuilder() {
        }

        private ClassifierNode buildClassifierNode(MIRClassifier mIRClassifier) {
            ClassifierNode classifierNode = this.getClassifierNode(mIRClassifier);
            if (classifierNode == null) {
                MIRModelObject mIRModelObject;
                Object object;
                classifierNode = new ClassifierNode(mIRClassifier);
                this.classifierNodes.add(classifierNode);
                Iterator<MIRClassifierMap> iterator = mIRClassifier.getSourceOfClassifierMapIterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    mIRModelObject = ((MIRClassifierMap)object).getDestinationClassifier();
                    if (!this.isSupportedOlapClassifier((MIRClassifier)mIRModelObject) || !Util.isSimpleExpression((MIRClassifierMap)object)) continue;
                    ClassifierNode classifierNode2 = this.buildClassifierNode((MIRClassifier)mIRModelObject);
                    classifierNode2.hasMultipleSources = MIRRolapLib.this.hasMultipleSources((MIRClassifierMap)object);
                    if (classifierNode2 == classifierNode) continue;
                    classifierNode.destinationNodes.add(classifierNode2);
                    classifierNode2.sourceNode = classifierNode;
                }
                object = mIRClassifier.getFeatureIterator();
                while (object.hasNext()) {
                    mIRModelObject = (MIRFeature)object.next();
                    this.buildFeatureNode(classifierNode, (MIRFeature)mIRModelObject);
                }
            }
            return classifierNode;
        }

        private FeatureNode buildFeatureNode(ClassifierNode classifierNode, MIRFeature mIRFeature) {
            FeatureNode featureNode = classifierNode.getFeatureNode(mIRFeature);
            if (featureNode == null) {
                featureNode = new FeatureNode(mIRFeature);
                classifierNode.featureNodes.add(featureNode);
                Iterator<MIRFeatureMap> iterator = mIRFeature.getSourceOfFeatureMapIterator();
                while (iterator.hasNext()) {
                    FeatureNode featureNode2;
                    MIRClassifier mIRClassifier;
                    ClassifierNode classifierNode2;
                    MIRFeatureMap mIRFeatureMap = iterator.next();
                    MIRFeature mIRFeature2 = mIRFeatureMap.getDestinationFeature();
                    if (!this.isSupportedOlapFeature(mIRFeature2) || !Util.isSimpleExpression(mIRFeatureMap) || !classifierNode.destinationNodes.contains(classifierNode2 = this.getClassifierNode(mIRClassifier = mIRFeature2.getClassifier())) || (featureNode2 = this.buildFeatureNode(classifierNode2, mIRFeature2)) == featureNode) continue;
                    featureNode.destinationNodes.add(featureNode2);
                    featureNode2.sourceNode = featureNode;
                }
            }
            return featureNode;
        }

        private void collectClassifierNodes(ClassifierNode classifierNode, ArrayList<ClassifierNode> arrayList) {
            if (classifierNode.hasMultipleSources) {
                return;
            }
            if (this.isSupportedOlapClassifier(classifierNode.classifier)) {
                arrayList.add(classifierNode);
            }
            for (ClassifierNode classifierNode2 : classifierNode.destinationNodes) {
                this.collectClassifierNodes(classifierNode2, arrayList);
            }
        }

        private void collectFeatureNodes(FeatureNode featureNode, ArrayList<FeatureNode> arrayList) {
            if (this.isSupportedOlapFeature(featureNode.feature)) {
                arrayList.add(featureNode);
            }
            for (FeatureNode featureNode2 : featureNode.destinationNodes) {
                this.collectFeatureNodes(featureNode2, arrayList);
            }
        }

        private void resetDistance(Node node) {
            HashSet<Node> hashSet = new HashSet<Node>();
            this.resetDistance(node, hashSet);
        }

        private void resetDistance(Node node, Set<Node> set) {
            node.distance = 0;
            set.add(node);
            for (Node node2 : node.destinationNodes) {
                if (set.contains(node2)) continue;
                this.resetDistance(node2, set);
            }
        }

        private void calculateDistance(Node node) {
            HashSet<Node> hashSet = new HashSet<Node>();
            this.calculateDistance(node, 1, hashSet);
        }

        private void calculateDistance(Node node, int n, Set<Node> set) {
            node.distance = Math.max(node.distance, n);
            set.add(node);
            for (Node node2 : node.destinationNodes) {
                if (set.contains(node2)) continue;
                this.calculateDistance(node2, n + 1, set);
            }
        }

        private MIRClassifier findSourceClassifier(ClassifierNode classifierNode, boolean bl) {
            ClassifierNode classifierNode2 = classifierNode;
            if (bl) {
                while (classifierNode2.sourceNode != null) {
                    classifierNode2 = classifierNode2.sourceNode;
                }
            } else {
                while (!classifierNode2.hasMultipleSources && classifierNode2.sourceNode != null) {
                    classifierNode2 = classifierNode2.sourceNode;
                }
                if (classifierNode2.hasMultipleSources) {
                    return null;
                }
            }
            return classifierNode2.classifier;
        }

        private MIRFeature findSourceFeature(FeatureNode featureNode) {
            FeatureNode featureNode2 = featureNode;
            while (featureNode2.sourceNode != null) {
                featureNode2 = featureNode2.sourceNode;
            }
            return featureNode2.feature;
        }

        private ClassifierNode getClassifierNode(MIRClassifier mIRClassifier) {
            for (ClassifierNode classifierNode : this.classifierNodes) {
                if (classifierNode.classifier != mIRClassifier) continue;
                return classifierNode;
            }
            return null;
        }

        private boolean isSupportedOlapClassifier(MIRClassifier mIRClassifier) {
            return mIRClassifier.getElementType() == 87 || mIRClassifier.getElementType() == 85 || mIRClassifier.getElementType() == 101 || mIRClassifier.getElementType() == 106;
        }

        private boolean isSupportedOlapFeature(MIRFeature mIRFeature) {
            return mIRFeature.getElementType() == 88 || mIRFeature.getElementType() == 97 || mIRFeature.getElementType() == 102 || mIRFeature.getElementType() == 105;
        }
    }

    private class FeatureNode
    extends Node {
        private MIRFeature feature;
        private FeatureNode sourceNode;

        private FeatureNode(MIRFeature mIRFeature) {
            this.sourceNode = null;
            this.feature = mIRFeature;
        }
    }

    private class ClassifierNode
    extends Node {
        private MIRClassifier classifier;
        private ClassifierNode sourceNode;
        private ArrayList<FeatureNode> featureNodes;
        private boolean hasMultipleSources;

        private ClassifierNode(MIRClassifier mIRClassifier) {
            this.sourceNode = null;
            this.featureNodes = new ArrayList();
            this.hasMultipleSources = false;
            this.classifier = mIRClassifier;
        }

        private FeatureNode getFeatureNode(MIRFeature mIRFeature) {
            if (this.classifier != mIRFeature.getClassifier()) {
                return null;
            }
            for (FeatureNode featureNode : this.featureNodes) {
                if (featureNode.feature != mIRFeature) continue;
                return featureNode;
            }
            return null;
        }
    }

    private class Node {
        protected ArrayList<Node> destinationNodes = new ArrayList();
        protected int distance = 0;

        private Node() {
        }
    }
}

