/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRNamedParameterContext;
import MITI.sdk.MIRParameterContext;
import MITI.sdk.MIRParameterDefinition;
import MITI.util.log.MIRLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MIRParameterFileLoader {
    private MIRDiModel model = null;
    private MIRElement currentContext = null;

    protected void processLine(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.isCommentLine(string)) {
            return;
        }
        if (this.isContextLine(string)) {
            this.currentContext = this.getContext(string);
            return;
        }
        if (this.currentContext == null) {
            return;
        }
        int n = string.indexOf("=");
        if (n != -1 && n != string.length()) {
            String string2 = string.substring(0, n);
            string2 = string2.trim();
            String string3 = string.substring(n + 1);
            this.setParameterValue(this.currentContext, string2, string3);
        }
    }

    protected boolean isCommentLine(String string) {
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        String string2 = string.substring(0, 1);
        return string2.equals("#") || string2.equals(";");
    }

    protected boolean isContextLine(String string) {
        return false;
    }

    protected MIRElement getContext(String string) {
        return this.currentContext;
    }

    protected void setParameterValue(MIRElement mIRElement, String string, String string2) {
        MIRParameterDefinition mIRParameterDefinition = null;
        if (mIRElement.isInstanceOf((short)258)) {
            mIRParameterDefinition = ((MIRDiModel)mIRElement).getParameterDefinition(string);
        } else if (mIRElement.isInstanceOf((short)303)) {
            mIRParameterDefinition = ((MIRParameterContext)mIRElement).getParameterDefinition(string);
        }
        if (mIRParameterDefinition == null) {
            mIRParameterDefinition = new MIRParameterDefinition();
            mIRParameterDefinition.setName(string);
            if (mIRElement.isInstanceOf((short)258)) {
                ((MIRDiModel)mIRElement).addParameterDefinition(mIRParameterDefinition);
            } else if (mIRElement.isInstanceOf((short)303)) {
                ((MIRParameterContext)mIRElement).addParameterDefinition(mIRParameterDefinition);
            }
        }
        mIRParameterDefinition.setValue(string2);
    }

    protected MIRElement getCurentContext() {
        return this.currentContext;
    }

    protected MIRDiModel getParameterModel() {
        return this.model;
    }

    public MIRParameterFileLoader(MIRDiModel mIRDiModel, MIRFolderContent mIRFolderContent) {
        this.model = mIRDiModel;
        if (mIRFolderContent != null) {
            MIRNamedParameterContext mIRNamedParameterContext = null;
            while (mIRFolderContent != null) {
                MIRNamedParameterContext mIRNamedParameterContext2 = new MIRNamedParameterContext();
                mIRNamedParameterContext2.setName(mIRFolderContent.getName());
                mIRNamedParameterContext2.setContextElementType(mIRFolderContent.getElementType());
                if (mIRNamedParameterContext != null) {
                    mIRNamedParameterContext2.addChildParameterContext(mIRNamedParameterContext);
                }
                mIRNamedParameterContext = mIRNamedParameterContext2;
                mIRFolderContent = mIRFolderContent.getFolder();
            }
            this.model.addParameterContext(mIRNamedParameterContext);
            this.currentContext = mIRNamedParameterContext;
        } else {
            this.currentContext = this.model;
        }
        assert (this.currentContext != null);
    }

    public void loadFile(MIRLogger mIRLogger, File file) throws MIRException {
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            throw new MIRException(BLIB.ERR_CANT_OPEN_PARAMETERS_FILE.getMessage(file.getName()));
        }
        BLIB.MSG_LOADING_VARS.log(mIRLogger, file.getPath());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                this.processLine(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new MIRException(iOException);
        }
    }
}

