/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.validation.MIRValidation;
import MITI.sdk.validation.MIRValidationLevel;
import MITI.server.services.common.LogEvent;
import MITI.util.log.BufferedLogger;
import MITI.util.log.MIRLogger;
import java.util.ArrayList;

public class MIRModelFix
implements MIR_Object.MIRTraversalOperation {
    private MIRLogger log;
    private ArrayList<MIRObject> candidateKeys = new ArrayList();
    private ArrayList<MIRObject> foreignKeys = new ArrayList();
    private ArrayList<MIRObject> indexes = new ArrayList();
    private ArrayList<MIRObject> generalizations = new ArrayList();
    private ArrayList<MIRObject> presentationElements = new ArrayList();
    private ArrayList<MIRObject> associations = new ArrayList();

    public MIRModelFix(MIRLogger mIRLogger) {
        this.log = mIRLogger;
    }

    private void deleteInvalidObjects(ArrayList<MIRObject> arrayList) {
        BufferedLogger bufferedLogger = new BufferedLogger();
        for (MIRObject mIRObject : arrayList) {
            if (MIRValidation.validate(mIRObject, MIRValidationLevel.BASIC)) continue;
            BLIB.WRN_REMOVING_INVALID_OBJECT.log(this.log, MIRValidation.buildValidationName(mIRObject));
            if (this.log.getLevel() == 6) {
                String string = Thread.currentThread().getName();
                for (LogEvent logEvent : bufferedLogger.getEvents()) {
                    logEvent.setThreadId(string);
                    this.log.log(logEvent);
                }
                bufferedLogger.clearEvents();
            }
            mIRObject.delete();
        }
    }

    public void deleteInvalidObjects(MIRModel mIRModel) throws MIRException {
        mIRModel.depthTraversal(this);
        this.deleteInvalidObjects(this.candidateKeys);
        this.deleteInvalidObjects(this.generalizations);
        this.deleteInvalidObjects(this.associations);
        this.deleteInvalidObjects(this.foreignKeys);
        this.deleteInvalidObjects(this.indexes);
        this.deleteInvalidObjects(this.presentationElements);
    }

    @Override
    public boolean traverse(MIRObject mIRObject) throws MIRException {
        return true;
    }

    @Override
    public void pre_process(MIRObject mIRObject, boolean bl) throws MIRException {
        if (mIRObject.isInstanceOf((short)22)) {
            this.foreignKeys.add(mIRObject);
        } else if (mIRObject.isInstanceOf((short)51)) {
            this.indexes.add(mIRObject);
        } else if (mIRObject.isInstanceOf((short)16)) {
            this.generalizations.add(mIRObject);
        } else if (mIRObject.isInstanceOf((short)61)) {
            this.presentationElements.add(mIRObject);
        } else if (mIRObject.isInstanceOf((short)21)) {
            this.candidateKeys.add(mIRObject);
        } else if (mIRObject.isInstanceOf((short)17)) {
            this.associations.add(mIRObject);
        }
    }

    @Override
    public void post_process(MIRObject mIRObject) {
    }
}

