/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRConnectionManager;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.datatypelib.MIRDataStoreVersion;
import MITI.bridges.datatypelib.MIRDataTypeConverter;
import MITI.bridges.datatypelib.MIRDataTypeLib;
import MITI.bridges.profiles.ProfileIds;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRAllClasses;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassType;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRConnectedTransformation;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFileDirectory;
import MITI.sdk.MIRFixedWidthFileDescriptor;
import MITI.sdk.MIRFlatFileDescriptor;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROlapSchema;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRType;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.validation.MIRValidation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.function.Supplier;

public class MIRConnectionSummarizer {
    public static final String VSAM_STORE = "VSAM";
    public static final String NATIVE_TYPE_STORED_PROCEDURE = "Stored Procedure";

    public static void summarizeConnections(MIRModel mIRModel) throws MIRException {
        for (MIRConnection mIRConnection : mIRModel.getContent().getClientOfConnections()) {
            MIRStoreConnection mIRStoreConnection = mIRModel.getStoreConnection(MIRBridgeLib.getPhysicalName(mIRConnection));
            if (mIRStoreConnection == null) continue;
            MIRStoreModel mIRStoreModel = null;
            MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
            if (mIRStoreContent == null || mIRStoreContent.getConnectionOfDirectoryStructureModel() == null || (mIRStoreModel = (MIRStoreModel)mIRStoreContent.getModel()) == null) continue;
            MIRConnectionSummarizer.updateConnectedStore(mIRStoreConnection, mIRStoreModel);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveConnectionModels(MIRDirectoryStructureModel mIRDirectoryStructureModel, MIRMixManager mIRMixManager) throws MIRException {
        ArrayList<MIRStoreContent> arrayList = new ArrayList<MIRStoreContent>();
        for (MIRStoreContent mIRStoreContent : mIRDirectoryStructureModel.getConnectionStoreContents()) {
            if (mIRStoreContent.getSupplierOfConnectionCount() != 0) {
                MIRConnection[] mIRConnectionArray = (MIRConnection[])mIRMixManager.loadModel(mIRStoreContent);
                MIRConnectionSummarizer.cleanStoreModel((MIRStoreModel)mIRConnectionArray);
                if (mIRConnectionArray.getDataPackageCount() != 0 || mIRConnectionArray.getDesignPackageCount() != 0) {
                    MIRTypeLib.factorizeTypes((MIRModel)mIRConnectionArray);
                    MIRMetadataOrigin mIRMetadataOrigin = mIRConnectionArray.getMetadataOrigin();
                    if (mIRMetadataOrigin != null && mIRMetadataOrigin.getProfileId() <= 0) {
                        mIRMetadataOrigin.setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__DATA_STORE);
                    }
                    if (mIRConnectionArray.getStoreType() == 2 && MIRObjectCollections.__getSdkCaseSensitive()) {
                        mIRConnectionArray.setSystemCase((byte)1);
                    }
                    if (mIRConnectionArray.getSystemType().isEmpty()) {
                        BLIB.WRN_SYSTEM_TYPE.log(MIRValidation.buildValidationName((MIRObject)mIRConnectionArray), "ODBC");
                        mIRConnectionArray.setSystemType("ODBC");
                    }
                    try {
                        mIRMixManager.saveModel(mIRStoreContent);
                    }
                    catch (Exception exception) {
                        BLIB.ERR_OPERATION_FAILED.log(exception, "while saving store content " + mIRStoreContent.getPath());
                    }
                    if (!MIRConnectionManager.getInstance().isMergeQuestion()) {
                        // empty if block
                    }
                } else {
                    arrayList.add(mIRStoreContent);
                }
                mIRConnectionArray.delete();
                continue;
            }
            if (mIRStoreContent.getFolder() != null) continue;
            arrayList.add(mIRStoreContent);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            MIRStoreContent mIRStoreContent;
            mIRStoreContent = (MIRStoreContent)iterator.next();
            for (MIRConnection mIRConnection : mIRStoreContent.getSupplierOfConnections().toArray(new MIRConnection[mIRStoreContent.getSupplierOfConnectionCount()])) {
                mIRConnection.delete();
            }
            mIRStoreContent.delete();
        }
        return;
    }

    private static void cleanStoreModel(MIRStoreModel mIRStoreModel) throws MIRException {
        ArrayList<MIRDataPackage> arrayList = new ArrayList<MIRDataPackage>();
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            for (Object object : mIRDataPackage.getNamespaceElements().toArray()) {
                if (!MIRConnectionSummarizer.isNamespaceElementEmpty((MIRNamespaceElement)object)) continue;
                mIRDataPackage.removeNamespaceElement((MIRNamespaceElement)object);
            }
            for (Object object : mIRDataPackage.getNamespaceElements().toArray()) {
                if (!MIRConnectionSummarizer.isNamespaceElementEmpty((MIRNamespaceElement)object)) continue;
                mIRDataPackage.removeImportedNamespaceElement((MIRNamespaceElement)object);
            }
        }
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            if (mIRDataPackage.getNamespaceElementCount() != 0 || mIRDataPackage.getImportedNamespaceElementCount() != 0) continue;
            arrayList.add(mIRDataPackage);
        }
        for (MIRDataPackage mIRDataPackage : arrayList) {
            mIRStoreModel.removeDataPackage(mIRDataPackage);
            mIRDataPackage.delete();
        }
    }

    private static boolean isNamespaceElementEmpty(MIRNamespaceElement mIRNamespaceElement) {
        boolean bl = true;
        if (mIRNamespaceElement.isInstanceOf((short)207)) {
            MIRNamespaceElement mIRNamespaceElement2;
            Iterator iterator = ((MIRFileDirectory)mIRNamespaceElement).getNamespaceElements().iterator();
            while (iterator.hasNext() && (bl = MIRConnectionSummarizer.isNamespaceElementEmpty(mIRNamespaceElement2 = (MIRNamespaceElement)iterator.next()))) {
            }
        } else {
            bl = mIRNamespaceElement.isInstanceOf((short)75) ? ((MIRClassifier)mIRNamespaceElement).getFeatureCount() == 0 : !mIRNamespaceElement.isInstanceOf((short)67);
        }
        return bl;
    }

    public static void updateConnectedStore(MIRStoreConnection mIRStoreConnection, MIRStoreModel mIRStoreModel) throws MIRException {
        Object object;
        Object object2;
        Comparable<MIRDataStoreVersion> comparable;
        if (mIRStoreModel.getStoreType() != mIRStoreConnection.getStoreType()) {
            if (mIRStoreModel.getDataPackageCount() == 0) {
                mIRStoreModel.setStoreType(mIRStoreConnection.getStoreType());
                BLIB.WRN_STORE_TYPE.log(MIRValidation.buildValidationName(mIRStoreConnection), MIRValidation.buildValidationName(mIRStoreModel));
            } else {
                BLIB.ERR_STORE_TYPE.log(MIRValidation.buildValidationName(mIRStoreConnection), MIRValidation.buildValidationName(mIRStoreModel));
                return;
            }
        }
        if (mIRStoreModel.getSystemType().isEmpty()) {
            mIRStoreModel.setSystemType(mIRStoreConnection.getSystemType());
            mIRStoreModel.setSystemMajorVersion(mIRStoreConnection.getSystemMajorVersion());
            mIRStoreModel.setSystemMinorVersion(mIRStoreConnection.getSystemMinorVersion());
            mIRStoreModel.setSystemReleaseVersion(mIRStoreConnection.getSystemReleaseVersion());
        }
        MIRContent mIRContent = mIRStoreConnection.getRootModel().getContent();
        MIRStoreContent mIRStoreContent = (MIRStoreContent)mIRStoreModel.getContent();
        String string = MIRBridgeLib.getPhysicalName(mIRStoreConnection);
        if (mIRContent.getClientOfConnection(string) == null) {
            comparable = new MIRConnection();
            ((MIRObject)comparable).setName(string);
            ((MIRConnection)comparable).addClientContent(mIRContent);
            ((MIRConnection)comparable).addSupplierStoreContent(mIRStoreContent);
        }
        comparable = MIRDataTypeLib.getDataStore(mIRStoreModel);
        MIRDataTypeConverter mIRDataTypeConverter = MIRConnectionSummarizer.getDataTypeConverter((MIRDataStoreVersion)comparable);
        boolean bl = mIRStoreConnection.getStoreType() == 2;
        boolean bl2 = mIRStoreConnection.getStoreType() == 5;
        for (MIRConnectionNamespace mIRConnectionDataPackage : mIRStoreConnection.getConnectionNamespaces()) {
            object2 = MIRBridgeLib.getPhysicalName(mIRConnectionDataPackage);
            if (bl2) {
                object = mIRStoreModel.getDesignPackage((String)object2);
                if (object == null) {
                    object = new MIRDesignPackage();
                    ((MIRObject)object).setName((String)object2);
                    ((MIRElement)object).setNativeId(mIRConnectionDataPackage.getNativeId());
                    mIRStoreModel.addDesignPackage((MIRDesignPackage)object);
                }
                MIRConnectionSummarizer.updateConnectedNamespace(mIRConnectionDataPackage, (MIRPackage)object, mIRStoreModel, MIRDesignPackage::new, mIRDataTypeConverter);
                continue;
            }
            object = mIRStoreModel.getDataPackage((String)object2);
            if (object == null) {
                object = new MIRFileDirectory();
                ((MIRObject)object).setName((String)object2);
                if (bl && ((MIRObject)object).getName().equals("Fake Root") && mIRConnectionDataPackage.getNativeType().equals("Fake Root")) {
                    ((MIRElement)object).setNativeType("Fake Root");
                }
                mIRStoreModel.addDataPackage((MIRDataPackage)object);
            }
            MIRConnectionSummarizer.updateConnectedNamespace(mIRConnectionDataPackage, (MIRPackage)object, mIRStoreModel, MIRFileDirectory::new, mIRDataTypeConverter);
        }
        for (MIRConnectionPackage mIRConnectionPackage : mIRStoreConnection.getConnectionPackages()) {
            object2 = MIRConnectionSummarizer.getDataPackage(mIRStoreModel, mIRConnectionPackage.getNamespaceName(mIRConnectionPackage));
            for (MIRClassifier mIRClassifier : mIRConnectionPackage.getClassifiers()) {
                MIRConnectionSummarizer.updateConnectedClass((MIRPackage)object2, mIRDataTypeConverter, mIRClassifier, bl);
            }
            object = mIRConnectionPackage.getAllNamespaceElementIterator();
            while (object.hasNext()) {
                MIRNamespaceElement mIRNamespaceElement = object.next();
                if (mIRNamespaceElement.isInstanceOf((short)75)) {
                    MIRConnectionSummarizer.updateConnectedClass((MIRPackage)object2, mIRDataTypeConverter, (MIRClassifier)mIRNamespaceElement, bl);
                    continue;
                }
                if (!mIRNamespaceElement.isInstanceOf((short)67)) continue;
                MIRConnectionSummarizer.updateStoredProcedure(mIRStoreModel, (MIRDataPackage)object2, mIRDataTypeConverter, (MIRStoredProcedure)mIRNamespaceElement);
            }
        }
    }

    public static MIRDataTypeConverter getDataTypeConverter(MIRDataStoreVersion mIRDataStoreVersion) throws MIRException {
        MIRDataTypeConverter mIRDataTypeConverter = null;
        try {
            mIRDataTypeConverter = new MIRDataTypeConverter(mIRDataStoreVersion, "");
        }
        catch (MIRException mIRException) {
            BLIB.WRN_UNSUPPORTED_DB_TYPE_DEFAULT_APPLY.log(mIRDataStoreVersion.getDataStoreType());
            mIRDataTypeConverter = new MIRDataTypeConverter(new MIRDataStoreVersion("ODBC", 1, 0, 0), "");
        }
        return mIRDataTypeConverter;
    }

    public static void updateConnectedNamespace(MIRConnectionNamespace mIRConnectionNamespace, MIRPackage mIRPackage, MIRStoreModel mIRStoreModel, Supplier<MIRPackage> supplier, MIRDataTypeConverter mIRDataTypeConverter) throws MIRException {
        ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>();
        arrayList.addAll(mIRConnectionNamespace.getNamespaceElements());
        arrayList.addAll(mIRConnectionNamespace.getImportedNamespaceElements());
        boolean bl = mIRPackage instanceof MIRFileDirectory;
        for (MIRObject mIRObject : arrayList) {
            MIRNamespaceElement mIRNamespaceElement;
            if (mIRObject.isInstanceOf((short)75)) {
                MIRConnectionSummarizer.updateConnectedClass(mIRPackage, mIRDataTypeConverter, (MIRClassifier)mIRObject, bl);
                continue;
            }
            if (!mIRObject.isInstanceOf((short)321)) continue;
            String string = MIRBridgeLib.getPhysicalName(mIRObject);
            MIRNamespaceElement mIRNamespaceElement2 = mIRNamespaceElement = mIRPackage != null ? mIRPackage.getNamespaceElement(string) : mIRStoreModel.getDataPackage(string);
            if (mIRNamespaceElement == null) {
                mIRNamespaceElement = supplier.get();
                mIRNamespaceElement.setName(string);
                if (mIRPackage != null) {
                    mIRPackage.addNamespaceElement(mIRNamespaceElement);
                } else {
                    mIRStoreModel.addDataPackage((MIRDataPackage)mIRNamespaceElement);
                }
            } else {
                if (mIRNamespaceElement.isInstanceOf((short)75)) {
                    MIRConnectionSummarizer.mergeConnectedClassifiers((MIRClassifier)mIRNamespaceElement, (MIRConnectionNamespace)mIRObject, mIRDataTypeConverter);
                    continue;
                }
                if (!mIRNamespaceElement.isInstanceOf((short)144)) {
                    BLIB.ERR_FILE_DIRECTORY_COLLISION.log(mIRPackage.getPath(), MIRElementType.getName(mIRNamespaceElement.getElementType()), mIRObject.getPath());
                    continue;
                }
            }
            MIRConnectionSummarizer.updateConnectedNamespace((MIRConnectionNamespace)mIRObject, (MIRPackage)mIRNamespaceElement, mIRStoreModel, supplier, mIRDataTypeConverter);
        }
        for (MIRClassifier mIRClassifier : mIRConnectionNamespace.getClassifiers()) {
            MIRConnectionSummarizer.updateConnectedClass(mIRPackage, mIRDataTypeConverter, mIRClassifier, bl);
        }
    }

    public static void mergeConnectedClass(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2, MIRDataTypeConverter mIRDataTypeConverter) {
        MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRClassifier2.getRootModel();
        mIRClassifier2.setLineageOption(mIRClassifier.getLineageOptions());
        MIRFlatFileDescriptor mIRFlatFileDescriptor = null;
        MIRFlatFileDescriptor mIRFlatFileDescriptor2 = null;
        if (mIRClassifier2.isInstanceOf((short)209)) {
            if (!(mIRClassifier2.getNativeType().contains(mIRClassifier.getNativeType()) || mIRClassifier2.getNativeType().isEmpty() || mIRClassifier.getNativeType().isEmpty())) {
                if (mIRClassifier.getNativeType().compareTo(mIRClassifier2.getNativeType()) < 0) {
                    mIRClassifier2.setNativeType(mIRClassifier.getNativeType() + " " + mIRClassifier2.getNativeType());
                } else {
                    mIRClassifier2.setNativeType(mIRClassifier2.getNativeType() + " " + mIRClassifier.getNativeType());
                }
            }
            mIRFlatFileDescriptor = ((MIRFlatTextFile)mIRClassifier2).getFlatFileDescriptor();
            if (mIRClassifier.isInstanceOf((short)254)) {
                MIRConnectedTransformation mIRConnectedTransformation = ((MIRConnectionDataSet)mIRClassifier).getConnectedTransformation();
                if (mIRConnectedTransformation != null) {
                    mIRFlatFileDescriptor2 = mIRConnectedTransformation.getFlatFileDescriptor();
                }
            } else if (mIRClassifier.isInstanceOf((short)209)) {
                mIRFlatFileDescriptor2 = ((MIRFlatTextFile)mIRClassifier).getFlatFileDescriptor();
            } else if (mIRClassifier.isInstanceOf((short)243)) {
                mIRFlatFileDescriptor2 = ((MIRQueryTable)mIRClassifier).getFlatFileDescriptor();
            }
            if (mIRFlatFileDescriptor == null) {
                if (mIRFlatFileDescriptor2 != null) {
                    mIRFlatFileDescriptor = mIRFlatFileDescriptor2.isInstanceOf((short)325) ? new MIRDelimitedFileDescriptor() : new MIRFixedWidthFileDescriptor();
                    mIRFlatFileDescriptor.setFrom(mIRFlatFileDescriptor2);
                    ((MIRFlatTextFile)mIRClassifier2).addFlatFileDescriptor(mIRFlatFileDescriptor);
                }
            } else if (mIRFlatFileDescriptor2 != null && mIRFlatFileDescriptor.isInstanceOf((short)325) && mIRFlatFileDescriptor2.isInstanceOf((short)326)) {
                ((MIRFlatTextFile)mIRClassifier2).removeFlatFileDescriptor();
                mIRFlatFileDescriptor = new MIRFixedWidthFileDescriptor();
                mIRFlatFileDescriptor.setFrom(mIRFlatFileDescriptor2);
                ((MIRFlatTextFile)mIRClassifier2).addFlatFileDescriptor(mIRFlatFileDescriptor);
            }
        }
        boolean bl = false;
        if (mIRFlatFileDescriptor != null && mIRFlatFileDescriptor2 != null) {
            bl = mIRClassifier.getFeatureCount() == 1 && mIRClassifier2.getFeatureCount() == 1 && mIRFlatFileDescriptor.getElementType() != mIRFlatFileDescriptor2.getElementType();
        } else {
            boolean bl2;
            boolean bl3 = bl2 = mIRFlatFileDescriptor != null && mIRStoreModel.getSystemType().equals(VSAM_STORE);
            if (bl2) {
                return;
            }
        }
        block7: for (MIRFeature mIRFeature2 : mIRClassifier.getFeatures()) {
            MIRModelObject mIRModelObject;
            MIRType mIRType;
            if (MIRConnectionSummarizer.isCondition(mIRFeature2)) continue;
            String string = MIRBridgeLib.getPhysicalName(mIRFeature2);
            MIRFeature mIRFeature3 = null;
            if (mIRFlatFileDescriptor != null) {
                if (mIRFlatFileDescriptor.getNativeType().equals(VSAM_STORE)) {
                    mIRFeature3 = MIRBridgeLib.getFeatureByPosition(mIRClassifier2, mIRFeature2.getPosition());
                } else {
                    if (mIRFeature2.hasLineageOption(512) && mIRFeature2.getPosition() < 0) {
                        BLIB.WRN_NO_POSITION.log(mIRFeature2.getPath());
                    }
                    if (mIRFeature2.hasLineageOption(512) && mIRFeature2.hasLineageOption(8192)) {
                        BLIB.WRN_BY_NAME_AND_POSITION.log(mIRFeature2.getPath());
                    }
                    HowToStitch howToStitch = HowToStitch.Unknown;
                    howToStitch = mIRFeature2.getPosition() < 0 ? (mIRFeature2.hasLineageOption(512) ? HowToStitch.stitchSkip : HowToStitch.stitchByName) : (mIRFeature2.hasLineageOption(8192) && !mIRFeature2.hasLineageOption(512) ? HowToStitch.stitchByName : HowToStitch.stitchByPos);
                    switch (howToStitch) {
                        case stitchSkip: 
                        case Unknown: {
                            continue block7;
                        }
                        case stitchByName: {
                            mIRFeature3 = mIRClassifier2.getFeatures().stream().filter(mIRFeature -> MIRBridgeLib.getPhysicalName(mIRFeature).equals(string)).findFirst().orElse(null);
                            if (mIRFeature3 == null) break;
                            mIRFeature3.setLineageOption(mIRFeature2.getLineageOptions());
                            mIRFeature3.setPosition((short)0);
                            break;
                        }
                        case stitchByPos: {
                            mIRFeature3 = MIRBridgeLib.getFeatureByPosition(mIRClassifier2, mIRFeature2.getPosition());
                            if (mIRFeature3 == null || mIRFeature3.getName().compareTo(mIRFeature2.getName()) >= 0) break;
                            mIRFeature3.setUniqueName(mIRFeature2.getName(), '_');
                        }
                    }
                }
            } else {
                mIRFeature3 = mIRClassifier2.getFeatures().stream().filter(mIRFeature -> MIRBridgeLib.getPhysicalName(mIRFeature).equals(string)).findFirst().orElse(null);
                if (mIRFeature3 != null) {
                    MIRFeature mIRFeature4;
                    if (!mIRFeature2.hasLineageOption(1) && mIRFeature3.hasLineageOption(1)) {
                        mIRFeature3.unsetLineageOption(1);
                    }
                    mIRFeature3.setLineageOption(mIRFeature2.getLineageOptions());
                    if (mIRFeature3.getPosition() == 0) {
                        mIRFeature3.setPosition(mIRFeature2.getPosition());
                    }
                    if (mIRFeature2.getType() == null && (mIRFeature4 = MIRConnectionSummarizer.getPropgatedTypeFeature(mIRFeature2)) != null && mIRFeature4.getType() != null) {
                        mIRFeature2.addType(mIRFeature4.getType());
                    }
                }
            }
            if (mIRFeature3 != null || bl) continue;
            mIRFeature3 = mIRClassifier2.isInstanceOf((short)106) ? new MIRDataAttribute() : new MIRAttribute();
            mIRFeature3.setFrom(mIRFeature2);
            if (mIRFeature2.hasLineageOption(8192)) {
                mIRFeature3.setPosition((short)0);
            }
            mIRClassifier2.addFeatureUniqueName(mIRFeature3);
            if (mIRFlatFileDescriptor == null) {
                if (!mIRFeature3.getName().equals(mIRFeature2.getName())) {
                    mIRFeature3.setPhysicalName(MIRBridgeLib.getPhysicalName(mIRFeature2));
                }
            } else if (!mIRFeature2.hasLineageOption(8192)) {
                mIRFeature3.setPhysicalName("");
            }
            boolean bl4 = true;
            if (mIRFeature2.isInstanceOf((short)99)) {
                bl4 = ((MIRStructuralFeature)mIRFeature2).getOptional();
            }
            if ((mIRType = mIRFeature2.getType()) == null && (mIRModelObject = MIRConnectionSummarizer.getPropgatedTypeFeature(mIRFeature2)) != null) {
                mIRType = ((MIRFeature)mIRModelObject).getType();
                if (mIRModelObject.isInstanceOf((short)99)) {
                    bl4 = ((MIRStructuralFeature)mIRModelObject).getOptional();
                }
            }
            if (mIRFeature3.isInstanceOf((short)14)) {
                ((MIRAttribute)mIRFeature3).setOptional(bl4);
            }
            mIRModelObject = null;
            if (mIRType != null) {
                if (mIRType.isInstanceOf((short)66)) {
                    MIRType mIRType2 = MIRConnectionSummarizer.getType(mIRFeature3, mIRType);
                    MIRClass mIRClass = ((MIRClassType)mIRType).getAssociatedClass();
                    if (mIRClass == null) continue;
                    MIRPackage mIRPackage = MIRConnectionSummarizer.getPackage(mIRClass, mIRStoreModel);
                    MIRClass mIRClass2 = (MIRClass)MIRConnectionSummarizer.getClassifier(mIRPackage, mIRDataTypeConverter, mIRClass, false);
                    MIRConnectionSummarizer.mergeConnectedClass(mIRClass, mIRClass2, mIRDataTypeConverter);
                    ((MIRClassType)mIRType2).addAssociatedClass(mIRClass2);
                    continue;
                }
                mIRModelObject = new MIRDerivedType();
                try {
                    mIRModelObject.setName(mIRDataTypeConverter.getExportTypeName(mIRType.getDataType()));
                }
                catch (MIRException mIRException) {
                    mIRModelObject.setName(mIRType.getDataType());
                }
                ((MIRConcreteType)mIRModelObject).setDataType(mIRType.getDataType());
                ((MIRConcreteType)mIRModelObject).setLength(mIRType.getLength());
                ((MIRConcreteType)mIRModelObject).setScale(mIRType.getScale());
                ((MIRConcreteType)mIRModelObject).setNativeDataType(mIRType.getNativeDataType());
                if (mIRFeature2.getType() == null) {
                    mIRFeature2.addType(mIRType);
                }
                ((MIRDerivedType)mIRModelObject).addDerivedFromConcreteType(MIRTypeLib.getBaseType(mIRStoreModel, MIRBaseTypeList.getLogicalName(((MIRConcreteType)mIRModelObject).getDataType())));
            }
            mIRFeature3.addType((MIRType)(mIRModelObject == null ? MIRTypeLib.getUndefinedBaseType(mIRStoreModel) : mIRModelObject));
            if (mIRModelObject == null) continue;
            mIRStoreModel.addType((MIRType)mIRModelObject);
        }
    }

    public static MIRClassifier getClassifier(MIRPackage mIRPackage, MIRDataTypeConverter mIRDataTypeConverter, MIRClassifier mIRClassifier, boolean bl) {
        MIRModelObject mIRModelObject;
        MIRClassifier mIRClassifier2 = null;
        boolean bl2 = mIRClassifier.isInstanceOf((short)243);
        String string = bl2 ? mIRClassifier.getName() : MIRBridgeLib.getPhysicalName(mIRClassifier);
        String string2 = MIRBridgeLib.getPhysicalName(mIRClassifier);
        MIRNamespaceElement mIRNamespaceElement = mIRPackage.getNamespaceElement(string);
        if (mIRNamespaceElement == null && !string2.isEmpty()) {
            mIRNamespaceElement = mIRPackage.getNamespaceElement(string2);
        }
        if (mIRNamespaceElement == null) {
            mIRNamespaceElement = mIRPackage.getImportedNamespaceElement(string2);
        }
        if (mIRNamespaceElement != null) {
            if (mIRNamespaceElement.isInstanceOf((short)75)) {
                mIRClassifier2 = (MIRClassifier)mIRNamespaceElement;
            } else if (mIRNamespaceElement.isInstanceOf((short)67)) {
                mIRModelObject = (MIRStoredProcedure)mIRNamespaceElement;
                mIRClassifier2 = ((MIRStoredProcedure)mIRModelObject).getResultDataSet();
            } else if (bl) {
                if (mIRNamespaceElement.isInstanceOf((short)207)) {
                    mIRClassifier2 = MIRConnectionSummarizer.convertToPartionFolderClassifier((MIRDataPackage)mIRPackage, (MIRFileDirectory)mIRNamespaceElement, mIRDataTypeConverter, mIRClassifier);
                    return mIRClassifier2;
                }
                BLIB.ERR_FILE_DIRECTORY_COLLISION.log(mIRPackage.getPath(), MIRElementType.getName(mIRNamespaceElement.getElementType()), mIRClassifier.getPath());
                return null;
            }
        }
        if (!bl && mIRClassifier.getFeatureCount() == 0 && mIRClassifier.isInstanceOf((short)254) && mIRClassifier.getDestinationOfClassifierMap() != null) {
            mIRModelObject = new MIRConnectionDataAttribute();
            mIRModelObject.setName("*");
            ((MIRFeature)mIRModelObject).setLineageOption(256);
            mIRClassifier.addFeature((MIRFeature)mIRModelObject);
        }
        if (mIRClassifier2 == null) {
            if (bl) {
                mIRClassifier2 = new MIRFlatTextFile();
                mIRClassifier2.setFrom(mIRClassifier);
                mIRPackage.addNamespaceElement(mIRClassifier2);
            } else if (mIRClassifier.getNativeType().contains(NATIVE_TYPE_STORED_PROCEDURE)) {
                mIRModelObject = new MIRStoredProcedure();
                mIRModelObject.setName(mIRClassifier.getName());
                MIRDataSet mIRDataSet = new MIRDataSet();
                ((MIRStoredProcedure)mIRModelObject).addResultDataSet(mIRDataSet);
                mIRPackage.addNamespaceElementUniqueName((MIRNamespaceElement)mIRModelObject);
                mIRClassifier2 = mIRDataSet;
                mIRClassifier2.setFrom(mIRClassifier);
            } else {
                mIRClassifier2 = new MIRClass();
                mIRClassifier2.setFrom(mIRClassifier);
                mIRPackage.addNamespaceElement(mIRClassifier2);
            }
            if (bl2) {
                mIRClassifier2.setName(string2);
                mIRClassifier2.setPhysicalName(mIRClassifier.getPhysicalName());
            }
        }
        return mIRClassifier2;
    }

    public static MIRClassifier updateConnectedClass(MIRPackage mIRPackage, MIRDataTypeConverter mIRDataTypeConverter, MIRClassifier mIRClassifier, boolean bl) {
        MIRClassifier mIRClassifier2 = MIRConnectionSummarizer.getClassifier(mIRPackage, mIRDataTypeConverter, mIRClassifier, bl);
        MIRConnectionSummarizer.mergeConnectedClass(mIRClassifier, mIRClassifier2, mIRDataTypeConverter);
        return mIRClassifier2;
    }

    private static MIRFeature getPropgatedTypeFeature(MIRFeature mIRFeature) {
        MIRFeature mIRFeature2;
        MIRFeature mIRFeature3 = null;
        if (mIRFeature3 == null && mIRFeature.getDestinationOfFeatureMap() != null && mIRFeature.getDestinationOfFeatureMap().getSourceFeatureCount() != 0) {
            mIRFeature3 = mIRFeature.getDestinationOfFeatureMap().getSourceFeatures().first();
        }
        if ((mIRFeature3 == null || mIRFeature3.getType() == null) && mIRFeature.getSourceOfFeatureMapCount() != 0 && (mIRFeature2 = mIRFeature.getSourceOfFeatureMaps().first().getDestinationFeature()) != null) {
            mIRFeature3 = mIRFeature2;
        }
        return mIRFeature3;
    }

    private static void updateStoredProcedure(MIRStoreModel mIRStoreModel, MIRDataPackage mIRDataPackage, MIRDataTypeConverter mIRDataTypeConverter, MIRStoredProcedure mIRStoredProcedure) {
        MIRStoredProcedure mIRStoredProcedure2 = null;
        MIRNamespaceElement mIRNamespaceElement = mIRDataPackage.getNamespaceElement(MIRBridgeLib.getPhysicalName(mIRStoredProcedure));
        if (mIRNamespaceElement == null) {
            mIRStoredProcedure2 = new MIRStoredProcedure(mIRStoredProcedure);
            mIRDataPackage.addNamespaceElement(mIRStoredProcedure2);
        } else if (mIRNamespaceElement.isInstanceOf((short)67)) {
            mIRStoredProcedure2 = (MIRStoredProcedure)mIRNamespaceElement;
        }
        if (mIRStoredProcedure2 != null) {
            MIRDataSet mIRDataSet;
            MIRDataSet mIRDataSet2 = mIRStoredProcedure.getResultDataSet();
            if (mIRDataSet2 != null) {
                mIRDataSet = mIRStoredProcedure2.getResultDataSet();
                if (mIRDataSet == null) {
                    mIRDataSet = new MIRDataSet(mIRDataSet2);
                    mIRStoredProcedure2.addResultDataSet(mIRDataSet);
                }
                MIRConnectionSummarizer.merge(mIRDataSet2, mIRDataSet);
            }
            if ((mIRDataSet = mIRStoredProcedure.getParametersDataSet()) != null) {
                MIRDataSet mIRDataSet3 = mIRStoredProcedure2.getParametersDataSet();
                if (mIRDataSet3 == null) {
                    mIRDataSet3 = new MIRDataSet(mIRDataSet);
                    mIRStoredProcedure2.addParametersDataSet(mIRDataSet3);
                }
                MIRConnectionSummarizer.merge(mIRDataSet, mIRDataSet3);
            }
        }
    }

    private static void merge(MIRDataSet mIRDataSet, MIRDataSet mIRDataSet2) {
        MIRModel mIRModel = mIRDataSet2.getRootModel();
        for (MIRFeature mIRFeature : mIRDataSet.getFeatures()) {
            MIRType mIRType;
            MIRFeature mIRFeature2;
            if (MIRConnectionSummarizer.isCondition(mIRFeature) || (mIRFeature2 = mIRDataSet2.getFeature(MIRBridgeLib.getPhysicalName(mIRFeature))) != null) continue;
            mIRFeature2 = new MIRDataAttribute();
            mIRFeature2.setName(mIRFeature.getName());
            mIRFeature2.setPhysicalName(mIRFeature.getPhysicalName());
            MIRType mIRType2 = mIRFeature.getType();
            mIRDataSet2.addFeature(mIRFeature2);
            if (mIRType2 == null || (mIRType = MIRConnectionSummarizer.getType(mIRFeature2, mIRType2)).isInstanceOf((short)4)) continue;
            ((MIRDerivedType)mIRType).addDerivedFromConcreteType(MIRTypeLib.getBaseType(mIRModel, MIRBaseTypeList.getLogicalName(mIRType.getDataType())));
        }
    }

    private static MIRClassifier convertToPartionFolderClassifier(MIRDataPackage mIRDataPackage, MIRDataPackage mIRDataPackage2, MIRDataTypeConverter mIRDataTypeConverter, MIRClassifier mIRClassifier) {
        BLIB.WRN_PARTITIONCREATED.log(MIRBridgeLib.getFilePath(mIRDataPackage2));
        mIRDataPackage.removeImportedNamespaceElement(mIRDataPackage2);
        mIRDataPackage.removeNamespaceElement(mIRDataPackage2);
        MIRClassifier mIRClassifier2 = MIRConnectionSummarizer.updateConnectedClass(mIRDataPackage, mIRDataTypeConverter, mIRClassifier, true);
        MIRConnectionSummarizer.mergeConnectedClassifiers(mIRClassifier2, mIRDataPackage2, mIRDataTypeConverter);
        mIRDataPackage2.delete();
        return mIRClassifier2;
    }

    public static void mergeConnectedClassifiers(MIRClassifier mIRClassifier, MIRDataPackage mIRDataPackage, MIRDataTypeConverter mIRDataTypeConverter) {
        mIRClassifier.setLineageOption(16384);
        ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>();
        arrayList.addAll(mIRDataPackage.getNamespaceElements());
        arrayList.addAll(mIRDataPackage.getImportedNamespaceElements());
        if (mIRDataPackage.isInstanceOf((short)356)) {
            arrayList.addAll(((MIRConnectionDataPackage)mIRDataPackage).getClassifiers());
        }
        for (MIRNamespaceElement mIRNamespaceElement : arrayList) {
            if (mIRNamespaceElement.isInstanceOf((short)75)) {
                BLIB.WRN_FILEMERGED.log(MIRBridgeLib.getFilePath(mIRNamespaceElement), MIRBridgeLib.getFilePath(mIRClassifier));
                MIRConnectionSummarizer.mergeConnectedClass((MIRClassifier)mIRNamespaceElement, mIRClassifier, mIRDataTypeConverter);
                continue;
            }
            if (!mIRNamespaceElement.isInstanceOf((short)141)) continue;
            MIRConnectionSummarizer.mergeConnectedClassifiers(mIRClassifier, (MIRDataPackage)mIRNamespaceElement, mIRDataTypeConverter);
        }
    }

    public static MIRPackage getPackage(MIRClassifier mIRClassifier, MIRStoreModel mIRStoreModel) {
        MIRPackage mIRPackage = null;
        Stack<MIRPackage> stack = new Stack<MIRPackage>();
        for (MIRObject mIRObject = mIRClassifier.getParent(); mIRObject != null; mIRObject = mIRObject.getParent()) {
            if (!mIRObject.isInstanceOf((short)144)) {
                if (mIRObject.isInstanceOf((short)218) || mIRObject.isInstanceOf((short)216)) break;
                stack.clear();
                break;
            }
            stack.push((MIRPackage)mIRObject);
        }
        while (!stack.isEmpty()) {
            MIRPackage mIRPackage2 = (MIRPackage)stack.pop();
            if (mIRPackage == null) {
                mIRPackage = MIRConnectionSummarizer.getPackage(mIRStoreModel, mIRPackage2);
                continue;
            }
            mIRPackage = MIRConnectionSummarizer.getPackage(mIRPackage, mIRPackage2);
        }
        return mIRPackage;
    }

    private static MIRDataPackage getDataPackage(MIRStoreModel mIRStoreModel, String string) {
        MIRDataPackage mIRDataPackage = mIRStoreModel.getDataPackage(string);
        if (mIRDataPackage == null) {
            switch (mIRStoreModel.getStoreType()) {
                case 2: {
                    mIRDataPackage = new MIRFileDirectory();
                    break;
                }
                case 1: {
                    mIRDataPackage = new MIROlapSchema();
                    break;
                }
                default: {
                    mIRDataPackage = new MIRDatabaseSchema();
                }
            }
            mIRDataPackage.setName(string);
            mIRStoreModel.addDataPackage(mIRDataPackage);
        }
        return mIRDataPackage;
    }

    private static MIRDesignPackage getDesignPackage(MIRStoreModel mIRStoreModel, String string) {
        MIRDesignPackage mIRDesignPackage = mIRStoreModel.getDesignPackage(string);
        if (mIRDesignPackage == null) {
            mIRDesignPackage = new MIRDesignPackage();
            mIRDesignPackage.setName(string);
            mIRStoreModel.addDesignPackage(mIRDesignPackage);
        }
        return mIRDesignPackage;
    }

    private static MIRPackage getPackage(MIRStoreModel mIRStoreModel, MIRPackage mIRPackage) {
        String string = mIRPackage.getNamespaceName(mIRPackage);
        MIRPackage mIRPackage2 = null;
        switch (mIRPackage.getElementType()) {
            case 9: {
                mIRPackage2 = MIRConnectionSummarizer.getDesignPackage(mIRStoreModel, string);
                break;
            }
            case 141: {
                mIRPackage2 = MIRConnectionSummarizer.getDataPackage(mIRStoreModel, string);
            }
        }
        return mIRPackage2;
    }

    private static MIRPackage getPackage(MIRPackage mIRPackage, MIRPackage mIRPackage2) {
        String string = mIRPackage2.getNamespaceName(mIRPackage2);
        MIRPackage mIRPackage3 = (MIRPackage)mIRPackage.getNamespaceElement(string);
        if (mIRPackage3 == null) {
            mIRPackage3 = (MIRPackage)MIRAllClasses.createMIRObject(mIRPackage.getElementType());
            mIRPackage3.setName(string);
            mIRPackage.addNamespaceElement(mIRPackage3);
        }
        return mIRPackage3;
    }

    public static MIRNamespaceElement getNamespaceElement(MIRElement mIRElement, MIRNamespaceElement mIRNamespaceElement) {
        MIRNamespaceElement mIRNamespaceElement2 = null;
        short s = mIRNamespaceElement.getElementType();
        switch (mIRElement.getElementType()) {
            case 2: {
                if (s == 9) {
                    mIRNamespaceElement2 = ((MIRStoreModel)mIRElement).getDesignPackage(mIRNamespaceElement.getName());
                    break;
                }
                if (s != 141) break;
                mIRNamespaceElement2 = ((MIRStoreModel)mIRElement).getDataPackage(mIRNamespaceElement.getName());
                break;
            }
            case 144: {
                if (s != 144) break;
                mIRNamespaceElement2 = ((MIRPackage)mIRElement).getNamespaceElement(mIRNamespaceElement.getName());
            }
        }
        return mIRNamespaceElement2;
    }

    private static MIRType getType(MIRFeature mIRFeature, MIRType mIRType) {
        MIRType mIRType2 = mIRFeature.getType();
        if (mIRType2 == null) {
            if (mIRType.isInstanceOf((short)4)) {
                mIRType2 = MIRTypeLib.getBaseType(mIRFeature.getRootModel(), MIRBaseTypeList.getLogicalName(mIRType.getDataType()));
            } else {
                mIRType2 = (MIRType)MIRAllClasses.createMIRObject(mIRType.getElementType());
                mIRType2.setFrom(mIRType);
                mIRFeature.getRootModel().addType(mIRType2);
            }
            mIRFeature.addType(mIRType2);
        }
        return mIRType2;
    }

    private static boolean isCondition(MIRFeature mIRFeature) {
        return mIRFeature.isInstanceOf((short)84) | mIRFeature.isInstanceOf((short)333) | mIRFeature.isInstanceOf((short)334) | mIRFeature.isInstanceOf((short)335);
    }

    static enum HowToStitch {
        Unknown,
        stitchByPos,
        stitchByName,
        stitchSkip;

    }
}

