/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRStoreConnectionSummarizer;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.expression.analyzer.MIRExpressionAnalyzer;
import MITI.expression.analyzer.engine.CollationMode;
import MITI.expression.analyzer.engine.MIRParserOptions;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRSystemPackage;
import MITI.util.MiscParams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MIRConnectionManager {
    private GuiderConnectionMerge guiderConnectionMerge;
    private GuiderConnectionSplit guiderConnectionSplit;
    private GuiderFileConnectionSplit guiderFileConnectionSplit;
    private GuiderConnectionCast guiderConnectionCast;
    private GuiderConnectionCollation guiderConnectionCollation;
    protected String miscString;

    private MIRConnectionManager() {
        this._init("");
    }

    public static MIRConnectionManager getInstance() {
        return MIRConnectionManagerHolder.SINGLE_INSTANCE;
    }

    public static void init(String string) {
        MIRConnectionManager mIRConnectionManager = MIRConnectionManagerHolder.SINGLE_INSTANCE;
        mIRConnectionManager._init(string);
    }

    public void setServerName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string == null || string.isEmpty()) {
            string = this.guiderConnectionMerge.imvDefaultServer;
        }
        if (string != null && !string.isEmpty()) {
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Server", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        }
    }

    public static String getServerName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Server", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        return string;
    }

    public void setDatabaseName(MIRSystemPackage mIRSystemPackage, String string) {
        if (string == null || string.isEmpty()) {
            string = this.guiderConnectionMerge.imvDefaultDatabase;
        }
        if (string != null && !string.isEmpty()) {
            MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Database", (byte)0, "Connection", "", "SQL_VARCHAR", true, "");
            MIRUdpLib.setPropertyValue(mIRPropertyType, string, mIRSystemPackage);
        }
    }

    public static String getDatabaseName(MIRSystemPackage mIRSystemPackage) {
        String string = null;
        if (mIRSystemPackage == null) {
            return string;
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRSystemPackage.getRootModel(), mIRSystemPackage.getElementType(), "Database", (byte)0, "Connection", "", "SQL_VARCHAR", false, "");
        if (mIRPropertyType != null) {
            string = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRSystemPackage);
        }
        return string;
    }

    private void _init(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.miscString) && this.guiderConnectionCast != null) {
            return;
        }
        MiscParams miscParams = MiscParams.parse(string);
        this.guiderConnectionCast = new GuiderConnectionCast(miscParams);
        this.guiderConnectionMerge = new GuiderConnectionMerge(miscParams);
        this.guiderConnectionSplit = new GuiderConnectionSplit(miscParams);
        this.guiderFileConnectionSplit = new GuiderFileConnectionSplit(miscParams);
        this.guiderConnectionCollation = new GuiderConnectionCollation(miscParams);
        this.miscString = string;
    }

    public String mapPath(String string, boolean bl) {
        return this.guiderFileConnectionSplit.mapPath(string, bl);
    }

    public String getMergeName(String string) {
        return this.guiderConnectionMerge.getMrgName(string);
    }

    public boolean isMergeQuestion() {
        return this.guiderConnectionMerge.imvIsQuestion;
    }

    public String getFormattedConnectionName(String string, String string2) {
        return this.guiderConnectionMerge.getConnectionName(string, string2);
    }

    public String getConnectionName(String string, String string2) {
        return this.guiderConnectionSplit.getGrnConnectionName(string, string2, false);
    }

    public String getType(String string, String string2) {
        return this.guiderConnectionCast.getType(string, string2);
    }

    public Set<String> getCaseSensitiveConnections() {
        return Collections.unmodifiableSet(this.guiderConnectionCollation.caseSensitiveConnections);
    }

    public void processConnections(MIRModel mIRModel) {
        BLIB.DBG_START_PROCESSING_CONNECTIONS.log(new Object[0]);
        LinkedList<MIRStoreConnection> linkedList = new LinkedList<MIRStoreConnection>(mIRModel.getStoreConnections());
        for (MIRStoreConnection mIRStoreConnection : linkedList) {
            this.splitConnection(mIRStoreConnection, false);
        }
        linkedList = new LinkedList<MIRStoreConnection>(mIRModel.getStoreConnections());
        for (MIRStoreConnection mIRStoreConnection : linkedList) {
            String string = this.guiderConnectionMerge.getConnectionName(MIRConnectionManager.getServerName(mIRStoreConnection), mIRStoreConnection.getName());
            string = this.getMergeName(string);
            if (mIRStoreConnection.getName().equals(string)) continue;
            CollationMode collationMode = MIRParserOptions.getCollationMode(MIRExpressionAnalyzer.getExpressionDatabaseType(mIRStoreConnection.getSystemType()), 0);
            MIRStoreConnection mIRStoreConnection2 = mIRModel.getStoreConnection(string);
            if (mIRStoreConnection2 == null) {
                mIRStoreConnection.setName(string);
                continue;
            }
            boolean bl = MIRStoreConnectionSummarizer.mergeStoreConnections(mIRStoreConnection, mIRStoreConnection2, collationMode);
            if (!bl || !(mIRModel instanceof MIRMappingModel)) continue;
            MIRMappingModel mIRMappingModel = (MIRMappingModel)mIRModel;
            if (mIRStoreConnection.getSourceOfMappingModel() != null && mIRStoreConnection2.getSourceOfMappingModel() == null) {
                mIRStoreConnection2.addSourceOfMappingModel(mIRMappingModel);
            }
            if (mIRStoreConnection.getDestinationOfMappingModel() == null || mIRStoreConnection2.getDestinationOfMappingModel() != null) continue;
            mIRStoreConnection2.addDestinationOfMappingModel(mIRMappingModel);
        }
        BLIB.DBG_STOP_PROCESSING_CONNECTIONS.log(new Object[0]);
    }

    public static void splitConnection(MIRStoreConnection mIRStoreConnection) {
        MIRConnectionManager.getInstance().splitConnection(mIRStoreConnection, true);
    }

    private void splitConnection(MIRStoreConnection mIRStoreConnection, boolean bl) {
        MIRModel mIRModel = mIRStoreConnection.getRootModel();
        if (mIRStoreConnection.getStoreType() == 2 || mIRStoreConnection.getStoreType() == 5) {
            Collection<MIRClassifier> collection = this.getClassifiers(mIRStoreConnection);
            for (MIRClassifier mIRClassifier : collection) {
                MIRConnectionNamespace mIRConnectionNamespace;
                String string;
                String string2 = MIRBridgeLib.getFilePath(mIRClassifier);
                if (string2.equals(string = this.guiderFileConnectionSplit.mapPath(string2, true)) || (mIRConnectionNamespace = MIRBridgeLib.getConnectionNamespace(mIRModel, string, null)) == null) continue;
                MIRConnectionDataPackage mIRConnectionDataPackage = mIRClassifier.getConnectionDataPackage();
                mIRClassifier.removeConnectionDataPackage();
                mIRConnectionNamespace.addClassifier(mIRClassifier);
                while (mIRConnectionNamespace.getParent() instanceof MIRConnectionNamespace) {
                    mIRConnectionNamespace = (MIRConnectionNamespace)mIRConnectionNamespace.getParent();
                }
                MIRStoreConnection mIRStoreConnection2 = mIRConnectionNamespace.getParent() instanceof MIRStoreConnection ? (MIRStoreConnection)mIRConnectionNamespace.getParent() : null;
                mIRStoreConnection2.setNativeType(mIRStoreConnection.getNativeType());
                if (mIRModel instanceof MIRMappingModel) {
                    if (mIRClassifier.getSourceOfClassifierMapCount() > 0 && mIRStoreConnection2.getSourceOfMappingModel() == null) {
                        ((MIRMappingModel)mIRModel).addSourceStoreConnection(mIRStoreConnection2);
                    }
                    if (mIRClassifier.getDestinationOfClassifierMapCount() > 0 && mIRStoreConnection2.getDestinationOfMappingModel() == null) {
                        ((MIRMappingModel)mIRModel).addDestinationStoreConnection(mIRStoreConnection2);
                    }
                }
                for (MIRPropertyValue mIRPropertyValue : mIRStoreConnection.getPropertyValues()) {
                    MIRPropertyType mIRPropertyType = mIRPropertyValue.getPropertyType();
                    if (mIRPropertyValue.getValue() == null || mIRPropertyValue.getValue().isEmpty() || !"Connection".equals(mIRPropertyType.getUsage())) continue;
                    MIRPropertyType mIRPropertyType2 = MIRUdpLib.fetchPropertyType(mIRStoreConnection2.getRootModel(), mIRStoreConnection2.getElementType(), mIRPropertyType.getName(), mIRPropertyType.getDesignLevel(), mIRPropertyType.getUsage(), mIRPropertyType.getGroup(), mIRPropertyType.getDataType(), true, mIRPropertyType.getInitialValue());
                    MIRUdpLib.setPropertyValue(mIRPropertyType2, mIRPropertyValue.getValue(), mIRStoreConnection2);
                }
                this.cleanup(mIRConnectionDataPackage);
            }
        } else {
            LinkedList<MIRConnectionPackage> linkedList = new LinkedList<MIRConnectionPackage>(mIRStoreConnection.getConnectionPackages());
            for (MIRConnectionPackage mIRConnectionPackage : linkedList) {
                String string = this.guiderConnectionSplit.getGrnConnectionName(mIRStoreConnection.getName(), mIRConnectionPackage.getName(), bl);
                if (mIRStoreConnection.getName().equals(string)) continue;
                MIRStoreConnection mIRStoreConnection3 = mIRModel.getStoreConnection(string);
                if (mIRStoreConnection3 == null) {
                    mIRStoreConnection3 = new MIRStoreConnection(mIRStoreConnection);
                    mIRStoreConnection3.setName(string);
                    mIRStoreConnection3.setNativeType(mIRStoreConnection.getNativeType());
                    mIRModel.addStoreConnection(mIRStoreConnection3);
                    if (mIRModel instanceof MIRMappingModel) {
                        MIRMappingModel mIRMappingModel = (MIRMappingModel)mIRModel;
                        if (mIRStoreConnection.getSourceOfMappingModel() != null) {
                            mIRStoreConnection3.addSourceOfMappingModel(mIRMappingModel);
                        }
                        if (mIRStoreConnection.getDestinationOfMappingModel() != null) {
                            mIRStoreConnection3.addDestinationOfMappingModel(mIRMappingModel);
                        }
                    }
                    for (MIRPropertyValue mIRPropertyValue : mIRStoreConnection.getPropertyValues()) {
                        MIRPropertyType mIRPropertyType = mIRPropertyValue.getPropertyType();
                        if (mIRPropertyValue.getValue() == null || mIRPropertyValue.getValue().isEmpty() || !"Connection".equals(mIRPropertyType.getUsage())) continue;
                        MIRPropertyType mIRPropertyType3 = MIRUdpLib.fetchPropertyType(mIRStoreConnection3.getRootModel(), mIRStoreConnection3.getElementType(), mIRPropertyType.getName(), mIRPropertyType.getDesignLevel(), mIRPropertyType.getUsage(), mIRPropertyType.getGroup(), mIRPropertyType.getDataType(), true, mIRPropertyType.getInitialValue());
                        MIRUdpLib.setPropertyValue(mIRPropertyType3, mIRPropertyValue.getValue(), mIRStoreConnection3);
                    }
                }
                mIRConnectionPackage.removeStoreConnection();
                mIRStoreConnection3.addConnectionPackage(mIRConnectionPackage);
            }
            if (mIRStoreConnection.getConnectionPackageCount() == 0 && mIRStoreConnection.getConnectionClassifierCount() == 0) {
                mIRStoreConnection.delete();
            }
        }
    }

    private Collection<MIRClassifier> getClassifiers(MIRStoreConnection mIRStoreConnection) {
        LinkedHashSet<MIRClassifier> linkedHashSet = new LinkedHashSet<MIRClassifier>();
        LinkedList<MIRConnectionNamespace> linkedList = new LinkedList<MIRConnectionNamespace>(mIRStoreConnection.getConnectionNamespaces());
        while (!linkedList.isEmpty()) {
            MIRConnectionNamespace mIRConnectionNamespace = (MIRConnectionNamespace)linkedList.remove(0);
            for (MIRClassifier mIRClassifier : mIRConnectionNamespace.getClassifiers()) {
                linkedHashSet.add(mIRClassifier);
            }
            for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionNamespace.getNamespaceElements()) {
                if (!(mIRNamespaceElement instanceof MIRConnectionNamespace)) continue;
                linkedList.add((MIRConnectionNamespace)mIRNamespaceElement);
            }
        }
        return linkedHashSet;
    }

    private void cleanup(MIRConnectionDataPackage mIRConnectionDataPackage) {
        MIRConnectionDataPackage mIRConnectionDataPackage2 = mIRConnectionDataPackage;
        while (mIRConnectionDataPackage2 != null && mIRConnectionDataPackage2.getClassifierCount() == 0 && mIRConnectionDataPackage2.getNamespaceElementCount() == 0 && mIRConnectionDataPackage2.getImportedNamespaceElementCount() == 0) {
            MIRObject mIRObject = mIRConnectionDataPackage2.getParent();
            mIRConnectionDataPackage2.delete();
            if (mIRObject instanceof MIRConnectionDataPackage) {
                mIRConnectionDataPackage2 = (MIRConnectionDataPackage)mIRObject;
                continue;
            }
            mIRConnectionDataPackage2 = null;
            if (!(mIRObject instanceof MIRStoreConnection) || ((MIRStoreConnection)mIRObject).getConnectionNamespaceCount() != 0) continue;
            mIRObject.delete();
        }
    }

    private static class GuiderConnectionCollation {
        private Set<String> caseSensitiveConnections = new HashSet<String>();

        GuiderConnectionCollation(MiscParams miscParams) {
            Map<String, String> map = miscParams.getMappedValues("-connection.casesensitive");
            if (map != null) {
                this.caseSensitiveConnections.addAll(map.keySet());
            }
        }
    }

    private static class GuiderFileConnectionSplit {
        protected ArrayList<Map.Entry<String, String>> imvCdParamVals = new ArrayList();

        public GuiderFileConnectionSplit(MiscParams miscParams) {
            if (miscParams != null) {
                Map<String, String> map = miscParams.getMappedValues("-connection.map");
                if (map == null) {
                    map = miscParams.getMappedValues("-cd");
                }
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        if (null == entry.getValue()) continue;
                        this.imvCdParamVals.add(new AbstractMap.SimpleEntry<String, String>(entry.getKey(), entry.getValue()));
                    }
                    if (this.imvCdParamVals.size() > 0) {
                        BLIB.DBG_DEBUG.log("Split file connections entries:");
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            BLIB.DBG_DEBUG.log(String.format("%s => %s", entry.getKey(), entry.getValue()));
                        }
                    }
                }
            }
        }

        protected int splitPathElement(String string, int n, String string2, ArrayList<cPathElement> arrayList) {
            int n2 = string.indexOf(string2, n);
            if (n2 != -1) {
                if (n < n2) {
                    arrayList.add(new cPathElementSeparator(string.substring(n, n2)));
                }
                arrayList.add(new cPathElementName(string2));
                n2 += string2.length();
            }
            return n2;
        }

        public ArrayList<cPathElement> splitPath(String string) {
            String[] stringArray;
            ArrayList<cPathElement> arrayList = new ArrayList<cPathElement>();
            MIRBridgeLib.FileConnectionOptions fileConnectionOptions = new MIRBridgeLib.FileConnectionOptions();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = MIRBridgeLib.getFileConnectionName(string, stringBuilder, stringBuilder2, fileConnectionOptions);
            String string3 = stringBuilder.toString();
            String string4 = stringBuilder2.toString();
            int n = 0;
            if (n >= 0 && string2 != null && !string2.isEmpty()) {
                if (string2.length() == 3 && string2.endsWith("\\") && string2.charAt(1) == ':') {
                    string2 = string2.substring(0, 2);
                }
                n = this.splitPathElement(string, n, string2, arrayList);
            }
            for (String string5 : stringArray = string3.toString().split("[/\\\\]")) {
                if (n < 0 || string5.isEmpty()) continue;
                n = this.splitPathElement(string, n, string5, arrayList);
            }
            if (n >= 0 && !string4.isEmpty()) {
                n = this.splitPathElement(string, n, string4, arrayList);
            }
            if (n >= 0 && n < string.length()) {
                arrayList.add(new cPathElementSeparator(string.substring(n, string.length())));
                n = string.length();
            }
            return n == string.length() ? arrayList : null;
        }

        private String mapPath(String string, String string2, String string3, boolean bl) {
            String string4 = string;
            ArrayList<cPathElement> arrayList = this.splitPath(string);
            ArrayList<cPathElement> arrayList2 = this.splitPath(string2);
            ArrayList<cPathElement> arrayList3 = this.splitPath(string3);
            if (arrayList != null && arrayList2 != null && arrayList3 != null) {
                int n;
                boolean bl2 = true;
                for (n = 0; n < arrayList2.size(); ++n) {
                    if (n < arrayList.size()) {
                        cPathElement cPathElement2 = arrayList.get(n);
                        cPathElement cPathElement3 = arrayList2.get(n);
                        if (!(cPathElement2 instanceof cPathElementName) || !(cPathElement3 instanceof cPathElementName)) continue;
                        if (bl) {
                            if (cPathElement2.imvValue.equals(cPathElement3.imvValue)) continue;
                            bl2 = false;
                            break;
                        }
                        if (cPathElement2.imvValue.equalsIgnoreCase(cPathElement3.imvValue)) continue;
                        bl2 = false;
                        break;
                    }
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    int n2;
                    n = arrayList2.size();
                    if (arrayList2.size() < arrayList.size() && arrayList.get(arrayList2.size()) instanceof cPathElementSeparator && arrayList3.get(arrayList3.size() - 1) instanceof cPathElementSeparator) {
                        ++n;
                    }
                    string4 = "";
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        string4 = string4 + arrayList3.get((int)n2).imvValue;
                    }
                    for (n2 = n; n2 < arrayList.size(); ++n2) {
                        string4 = string4 + arrayList.get((int)n2).imvValue;
                    }
                    BLIB.DBG_DEBUG.log("Mapped connection path: '" + string + "' to:'" + string4);
                }
            } else {
                BLIB.DBG_DEBUG.log("Can not map the connection path: '" + string + "'");
            }
            return string4;
        }

        public String mapPath(String string, boolean bl) {
            if (this.imvCdParamVals.size() > 0) {
                for (Map.Entry<String, String> entry : this.imvCdParamVals) {
                    string = this.mapPath(string, entry.getKey(), entry.getValue(), bl);
                }
            }
            return string;
        }

        protected class cPathElementSeparator
        extends cPathElement {
            public cPathElementSeparator(String string) {
                super(string);
            }
        }

        protected class cPathElementName
        extends cPathElement {
            public cPathElementName(String string) {
                super(string);
            }
        }

        protected abstract class cPathElement {
            public String imvValue;

            public cPathElement(String string) {
                this.imvValue = string;
            }
        }
    }

    private static class GuiderConnectionSplit {
        protected TreeMap<String, TreeMap<String, String>> splitMap = new TreeMap();

        public GuiderConnectionSplit(MiscParams miscParams) {
            TreeMap<String, String> treeMap;
            Map<String, String> map = miscParams.getMappedValues("-connection.split");
            if (map == null) {
                map = miscParams.getMappedValues("-cs");
            }
            if (map != null) {
                if (map.size() == 1 && map.containsKey("*")) {
                    if (this.splitMap.get("*") == null) {
                        this.splitMap.put("*", null);
                    }
                } else {
                    for (Map.Entry<String, String> object : map.entrySet()) {
                        TreeMap<String, String> treeMap2;
                        treeMap = object.getValue();
                        Object object2 = object.getKey();
                        if (object2 == null || ((String)object2).isEmpty()) continue;
                        if (null == treeMap) {
                            this.splitMap.put((String)object2, null);
                            continue;
                        }
                        String string2 = "";
                        int n = ((String)object2).lastIndexOf(".");
                        if (n > 0) {
                            string2 = ((String)object2).substring(n + 1);
                            object2 = ((String)object2).substring(0, n);
                        }
                        if ((treeMap2 = this.splitMap.get(object2)) == null) {
                            treeMap2 = new TreeMap();
                            this.splitMap.put((String)object2, treeMap2);
                        }
                        treeMap2.put(string2, (String)((Object)treeMap));
                    }
                }
            }
            if (this.splitMap.size() > 0) {
                BLIB.DBG_DEBUG.log("Split connections entries:");
                for (String string : this.splitMap.keySet()) {
                    treeMap = this.splitMap.get(string);
                    if (treeMap == null) {
                        BLIB.DBG_DEBUG.log("''='" + string + "'.''");
                        continue;
                    }
                    for (String string2 : treeMap.keySet()) {
                        BLIB.DBG_DEBUG.log("'" + (String)treeMap.get(string2) + "'='" + string + "'.'" + string2 + "'");
                    }
                }
            }
        }

        public String getGrnConnectionName(String string, String string2, boolean bl) {
            if (bl || this.splitMap.keySet().contains("*")) {
                return string2 + "." + string;
            }
            if (this.splitMap.containsKey(string)) {
                TreeMap<String, String> treeMap = this.splitMap.get(string);
                if (treeMap == null) {
                    return string + "." + string2;
                }
                String string3 = treeMap.get(string2);
                if (string3 != null) {
                    return !string3.isEmpty() ? string3 : string + (string2.isEmpty() ? "" : "." + string2);
                }
            }
            return string;
        }
    }

    private static class GuiderConnectionCast {
        protected TreeMap<String, String> imvMap = new TreeMap();

        public GuiderConnectionCast(MiscParams miscParams) {
            Map<String, String> map;
            if (miscParams != null && (map = miscParams.getMappedValues("-connection.cast")) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.imvMap.put(entry.getKey(), entry.getValue());
                }
            }
        }

        public String getType(String string, String string2) {
            String string3 = this.imvMap.get(string);
            return string3 == null || string3.isEmpty() ? string2 : string3;
        }
    }

    private static class GuiderConnectionMerge {
        protected TreeMap<String, String> imvMrgCnnct = new TreeMap();
        protected boolean imvIsQuestion = false;
        protected String imvDefaultServer;
        protected String imvDefaultDatabase;

        public GuiderConnectionMerge(MiscParams miscParams) {
            Object object;
            Map<String, String> map = miscParams.getMappedValues("-connection.merge");
            if (miscParams.contains("-connection.rename")) {
                if (map != null) {
                    map.putAll(miscParams.getMappedValues("-connection.rename"));
                } else {
                    map = miscParams.getMappedValues("-connection.rename");
                }
            }
            this.imvDefaultServer = miscParams.getValue("-default.server");
            this.imvDefaultDatabase = miscParams.getValue("-default.database");
            if (map == null) {
                map = miscParams.getMappedValues("-cm");
            }
            if (map != null) {
                for (Map.Entry<String, String> object2 : map.entrySet()) {
                    this.imvIsQuestion = object2.getKey().trim().equals("?");
                    if (object2.getValue() == null) continue;
                    for (String string : object = object2.getValue().split(",")) {
                        this.imvMrgCnnct.put(object2.getKey(), string);
                    }
                }
            }
            if (this.imvMrgCnnct.size() > 0) {
                BLIB.DBG_DEBUG.log("Merge connections entries. Question mark = " + this.imvIsQuestion + ":");
                for (String string : this.imvMrgCnnct.keySet()) {
                    object = this.imvMrgCnnct.get(string);
                    BLIB.DBG_DEBUG.log(string + " = " + (String)object);
                }
            }
        }

        private String getConnectionName(String string, String string2) {
            if (string != null && !string.isEmpty() && string2.indexOf(64) == -1) {
                return string2 + "@" + string;
            }
            return string2;
        }

        public String getMrgName(String string) {
            string = this.getConnectionName(this.imvDefaultServer, string);
            String string2 = this.imvMrgCnnct.get(string);
            return this.imvIsQuestion ? string : (string2 == null ? string : string2);
        }
    }

    private static class MIRConnectionManagerHolder {
        static final MIRConnectionManager SINGLE_INSTANCE = new MIRConnectionManager();

        private MIRConnectionManagerHolder() {
        }
    }
}

