/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.javabridgeinterface.BridgeEnvironment;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class LibraryDownloader {
    private File driversStorageFolder;
    private String[] driversUrls;
    private ArrayList<String> driversStoragePaths = new ArrayList();

    public LibraryDownloader(BridgeEnvironment bridgeEnvironment) {
        this(bridgeEnvironment.getSetup().getDownloadDirectory());
    }

    public LibraryDownloader(File file) {
        this.driversStorageFolder = file;
    }

    public void setDriversURLs(String[] stringArray) {
        this.driversUrls = stringArray;
    }

    public String[] getDriversURLs() {
        return this.driversUrls;
    }

    public ArrayList<String> getDriversStoragePaths() {
        return this.driversStoragePaths;
    }

    public void download() throws MIRException {
        if (this.driversUrls == null) {
            BLIB.DBG_DEBUG.log("Drivers urls weren't set.");
            return;
        }
        if (!this.driversStorageFolder.exists()) {
            this.driversStorageFolder.mkdirs();
            BLIB.DBG_DEBUG.log("Created bridge drivers folder " + this.driversStorageFolder.getPath());
        }
        MIRLogger mIRLogger = MIRLogger.getLogger();
        BLIB.DBG_DEBUG.log("Updating drivers ...");
        for (int i = 0; i < this.driversUrls.length; ++i) {
            try {
                this.driversStoragePaths.addAll(this.downloadDriver(this.driversUrls[i], mIRLogger));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new MIRException(malformedURLException);
            }
        }
    }

    private String extractDriverPath(String string) {
        String string2 = string.substring(string.indexOf("://") + 3);
        return string2.substring(string2.indexOf("/") + 1);
    }

    private ArrayList<String> downloadDriver(String string, MIRLogger mIRLogger) throws MalformedURLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.driversStorageFolder, this.extractDriverPath(string));
        if (file.exists()) {
            arrayList.addAll(this.onFileDownloaded(file));
            return arrayList;
        }
        file.getParentFile().mkdirs();
        BLIB.DBG_DEBUG.log("Downloading " + string);
        MIRBridgeLib.downloadWebPageToFile(new URL(string), file, "mimb", mIRLogger);
        arrayList.addAll(this.onFileDownloaded(file));
        return arrayList;
    }

    protected ArrayList<String> onFileDownloaded(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getPath());
        return arrayList;
    }
}

