/*
 * Decompiled with CFR 0.152.
 */
package MITI.bridges.bridgelib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.util.log.MIRLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class BackupStorage {
    private static final String localStorageIndexName = "index.properties";
    private File directory;
    private boolean readOnly;
    private Properties index;
    private MIRLogger logger;

    public BackupStorage(File file, boolean bl, MIRLogger mIRLogger) {
        this.readOnly = bl;
        this.index = new Properties();
        this.logger = mIRLogger;
        if (file != null && file.isDirectory()) {
            this.directory = file;
            this.readIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile(String string, String string2, String string3) throws MIRException {
        String string4;
        Object object;
        File file = null;
        if (this.directory != null && this.readOnly) {
            if (this.index.containsKey(string)) {
                object = this.index.getProperty(string);
                file = new File(this.directory, (String)object);
            } else {
                BLIB.DBG_DEBUG.log("The offline metadata directory is missing a file for: " + string);
            }
        } else if (this.directory != null && !this.readOnly) {
            object = this.index;
            synchronized (object) {
                if (this.index.containsKey(string)) {
                    string4 = this.index.getProperty(string);
                    file = new File(this.directory, string4);
                } else {
                    String string5;
                    file = MIRBridgeLib.makeTempFile(this.directory, string2, string3);
                    string4 = file.getAbsolutePath();
                    if (string4.startsWith(string5 = this.directory.getAbsolutePath())) {
                        String string6 = string4.substring(string5.length() + 1);
                        this.index.setProperty(string, string6);
                    }
                }
            }
        }
        if (file == null) {
            object = this.index;
            synchronized (object) {
                if (this.index.containsKey(string)) {
                    string4 = this.index.getProperty(string);
                    file = new File(this.directory, string4);
                } else {
                    file = MIRBridgeLib.makeTempFile(string2, string3);
                    file.deleteOnExit();
                    this.index.setProperty(string, file.getAbsolutePath());
                }
            }
        }
        return file;
    }

    public boolean containsFile(String string) {
        return this.index.containsKey(string);
    }

    public void readIndex() {
        File file;
        if (this.directory != null && (file = new File(this.directory, localStorageIndexName)).exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.index.load(fileInputStream);
            }
            catch (IOException iOException) {
                BLIB.DBG_DEBUG.log(this.logger, "Error reading local storage index", iOException);
            }
        }
    }

    public void writeIndex() {
        if (!(this.directory != null && this.readOnly || this.directory == null || this.readOnly)) {
            File file = new File(this.directory, localStorageIndexName);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                Properties properties = new Properties(){

                    @Override
                    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
                        return Collections.synchronizedSet(super.entrySet().stream().sorted(Comparator.comparing(entry -> entry.getKey().toString())).collect(Collectors.toCollection(LinkedHashSet::new)));
                    }
                };
                properties.putAll((Map<?, ?>)this.index);
                properties.store(fileOutputStream, null);
            }
            catch (IOException iOException) {
                BLIB.DBG_DEBUG.log(this.logger, "Error writing local storage index", iOException);
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWritable() {
        return !this.readOnly;
    }
}

