/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.cli;

import com.platform.LSFJobFlow.api.JFException;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.build.ImportFlowFromCSV;
import com.sas.scheduler.api.build.ImportFlowFromSAS;
import com.sas.scheduler.api.build.ImportFlowFromXML;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.oma.BatchJob;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.oma.SubmitFlow;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.oma.TriggerEvent;
import com.sas.scheduler.api.report.ReportFlowToCSV;
import com.sas.scheduler.api.report.ReportFlowToSAS;
import com.sas.scheduler.api.report.ReportFlowToXML;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.security.ConnectionProfile;
import com.sas.services.user.UserContextInterface;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.security.auth.login.LoginException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.CurrentPackage.NoContext;

public class AppMethods {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(AppMethods.class);
    protected boolean m_verbose = false;
    protected boolean m_silent = false;
    protected ConnectionProfile m_connectionProfile;
    protected String m_metaMachine;
    protected String m_metaPort;
    protected String m_metaRepositoryName;
    protected String m_metaUser;
    protected String m_metaPassword;
    protected String m_serverUser;
    protected String m_serverPassword;
    protected String m_schedMachine;
    protected int m_schedPort;
    protected String m_workMachine;
    protected int m_workPort;
    protected String m_flowName;
    protected boolean m_delete = false;
    protected int m_reportFormat = -1;
    protected boolean m_write = true;
    protected String m_outputDir = ".";
    protected String m_infile;
    protected int m_maxPredecessors = 50;
    protected static final int REPORT_XML = 0;
    protected static final int REPORT_SAS = 1;
    protected static final int REPORT_CSV = 2;
    protected String m_command;
    protected String m_jobArgs = null;
    protected String m_schedName;
    protected int m_time = -1;
    protected String m_timeEventXML;
    protected static final int NOW = 0;
    protected static final int EVENT = 1;
    protected static final int MANUAL = 2;
    protected String m_jobID = null;
    protected List<String> m_fileName = null;
    protected List<String> m_fileId = null;
    protected String m_name = null;
    protected String m_dirName = null;
    protected String m_folder = null;
    protected String m_batchName = null;
    protected String m_flowID = null;
    protected boolean m_validatePlatformComputing = false;
    public static final int OKAY = 0;
    public static final int ERROR_CIRCULAR_DEPENDENCIES = 1;
    public static final int ERROR_NO_WORKSPACESERVER = 2;
    public static final int ERROR_UNABLE_TO_SUBMIT_JOB = 3;
    public static final int ERROR_UNABLE_TO_WRITE_REPORT = 4;
    public static final int ERROR_UNABLE_TO_BUILD_FLOW = 5;
    public static final int ERROR_UNABLE_TO_WRITE_FILE = 6;
    public static final int ERROR_UNABLE_TO_CREATE_JOB = 7;
    public static final int ERROR_UNABLE_TO_DETERMINE_DIR = 8;
    public static final int ERROR_DUPLICATE_JOB = 9;
    public static final int ERROR_UNABLE_TO_SUBMIT_FLOW = 10;
    public static final int ERROR_FLOW_NOT_SCHEDULED = 11;
    public static final int ERROR_UNABLE_TO_PARSE_FILE = 12;
    public static final int ERROR_UNABLE_TO_UPDATE_FLOW = 13;
    public static final int ERROR_NO_BATCHSERVER = 14;
    public static final int ERROR_UNEXPECTED_EXCEPTION = 99;

    public AppMethods(String[] saArgs) {
        this.processCommandLineArguments(saArgs);
    }

    public int deployDataStepBatchProgram(boolean schedule) {
        int returncode;
        block83: {
            returncode = 0;
            try {
                IFileService rio;
                IWorkspace workspace;
                MdObjectStore store;
                String folderRepos;
                String repos;
                MdFactoryImpl factory;
                block79: {
                    factory = new MdFactoryImpl();
                    factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
                    folderRepos = repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
                    store = factory.createObjectStore();
                    workspace = null;
                    rio = null;
                    try {
                        IWorkspaceServer iworkserver = new IWorkspaceServer((ServerContext)null, "440196D4-90F0-11D0-9F41-00A024BB830C", this.m_workMachine, this.m_workPort);
                        if (iworkserver.makeConnection(this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null)) {
                            workspace = iworkserver.getWorkspace();
                            rio = workspace.FileService();
                        }
                    }
                    catch (InvalidCredentialsException e) {
                        if (MetaUtilities.isDebug()) {
                            e.printStackTrace();
                        }
                    }
                    catch (FatalConnectionFactoryException e) {
                        if (!MetaUtilities.isDebug()) break block79;
                        e.printStackTrace();
                    }
                }
                ServerComponent batchserver = null;
                for (ServerComponent sc : MetaUtilities.getBatchServers((int)1, (MdStore)store, (String)repos)) {
                    if (sc.getName().compareToIgnoreCase(this.m_batchName) != 0) continue;
                    batchserver = sc;
                    break;
                }
                if (batchserver != null) {
                    Tree folder;
                    int targetOS;
                    block81: {
                        block80: {
                            targetOS = CommandUtilities.getTargetOSForBatchServer(batchserver);
                            folder = null;
                            if (this.m_folder != null) {
                                try {
                                    folder = this.m_metaRepositoryName != null ? AppMethods.getFolder(this.m_folder, this.m_metaRepositoryName, store, repos) : MetaUtilities.getFolder((String)this.m_folder, (MdObjectStore)store, (String)repos);
                                }
                                catch (Exception e) {
                                    if (!MetaUtilities.isDebug()) break block80;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (folder == null) {
                            try {
                                folder = MetaUtilities.getDefaultFolder((MdObjectStore)store, (String)repos);
                            }
                            catch (NotFound e1) {
                                if (MetaUtilities.isDebug()) {
                                    e1.printStackTrace();
                                }
                            }
                            catch (NoContext e1) {
                                if (!MetaUtilities.isDebug()) break block81;
                                e1.printStackTrace();
                            }
                        }
                    }
                    if (folder != null) {
                        folderRepos = "A0000001." + folder.getId().substring(0, 8);
                    }
                    Directory dir = null;
                    if (this.m_dirName != null) {
                        if (MetaUtilities.isDebug()) {
                            System.out.println("m_dirName: " + this.m_dirName);
                        }
                        dir = AppMethods.getDirectory(batchserver, targetOS, this.m_dirName, (MdStore)store, repos);
                    }
                    int numSrcfiles = this.m_fileName.size();
                    for (int x = 0; x < numSrcfiles; ++x) {
                        int rc = 0;
                        String filename = this.m_fileName.get(x);
                        String file = CommandUtilities.normalizeFullPath((String)filename, (int)CommandUtilities.getTargetOSForBatchServer((ServerComponent)batchserver));
                        if (file.startsWith("\"") || file.startsWith("'")) {
                            filename = file.substring(1, file.length() - 1);
                        }
                        char pathseparator = CommandUtilities.getPathSeparator((int)targetOS);
                        String basename = CommandUtilities.getFilenameForBatchServer((String)filename, (ServerComponent)batchserver);
                        String srcpath = "";
                        int lastindex = filename.lastIndexOf(pathseparator);
                        if (lastindex > 0) {
                            int firstindex = filename.indexOf(pathseparator);
                            srcpath = firstindex == lastindex ? filename.substring(0, lastindex + 1) : filename.substring(0, lastindex);
                        }
                        if (!MetaUtilities.isValidFilename((String)basename)) {
                            basename = MetaUtilities.replaceInvalidCharactersInFileName((String)basename);
                        }
                        if (this.m_name == null || numSrcfiles > 1) {
                            this.m_name = basename.indexOf(".") >= 0 ? basename.substring(0, basename.lastIndexOf(46)) : basename;
                        }
                        String normsrcpath = CommandUtilities.normalizePath((String)srcpath, (int)targetOS);
                        if (dir == null && batchserver != null) {
                            List dirs = MetaUtilities.getDirectoriesFromBatchServer((ServerComponent)batchserver);
                            try {
                                int numDirs = dirs != null ? dirs.size() : 0;
                                for (int i = 0; i < numDirs; ++i) {
                                    Directory tempdir = (Directory)dirs.get(i);
                                    String tempName = CommandUtilities.normalizePath((String)tempdir.getDirectoryName(), (int)targetOS);
                                    if (tempName.compareTo(normsrcpath) != 0) continue;
                                    dir = tempdir;
                                    break;
                                }
                            }
                            catch (StringIndexOutOfBoundsException ex) {
                                dir = null;
                            }
                        }
                        if (dir == null) {
                            rc = 8;
                        } else if (CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)targetOS).compareTo(normsrcpath) == 0) {
                            if (this.m_verbose || MetaUtilities.isDebug()) {
                                String dir1 = CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)targetOS);
                                Object[] parms = new Object[]{dir1};
                                String msg = MessageFormat.format(m_bundle.getString("AppMethods.Note.NoCopy.fmt"), parms);
                                System.out.println(msg);
                            }
                        } else {
                            try {
                                if (rio != null) {
                                    StringBuffer contents;
                                    String targetname = CommandUtilities.createFullPath((String)dir.getDirectoryName(), (String)basename, (int)targetOS);
                                    if (!CommandUtilities.saveToRemoteFile((IWorkspace)workspace, (String)targetname, (int)targetOS, (String)(contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)filename, (int)targetOS)).toString())) {
                                        rc = 6;
                                    }
                                } else {
                                    rc = 6;
                                }
                            }
                            catch (GenericError ge) {
                                if (MetaUtilities.isDebug()) {
                                    ge.printStackTrace();
                                }
                                rc = 6;
                            }
                        }
                        if (rc == 0) {
                            if (schedule) {
                                ServerComponent scheduler = null;
                                for (ServerComponent sc : MetaUtilities.getSchedulerServers((int)100, (MdStore)store, (String)repos)) {
                                    if (sc.getName().compareToIgnoreCase(this.m_schedName) != 0) continue;
                                    scheduler = sc;
                                    break;
                                }
                                if (filename != null && batchserver != null) {
                                    BatchJob job = new BatchJob(filename, (MdFactory)factory, folderRepos, batchserver, scheduler, this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null);
                                    if (this.m_name != null) {
                                        job.getDeployedJob().setName(this.m_name);
                                    }
                                    if (folder != null) {
                                        job.setFolder(folder);
                                    }
                                    if (this.m_time == 0) {
                                        job.runNow();
                                    } else if (this.m_time == 2) {
                                        if (job.runManually() != 0) {
                                            rc = 3;
                                        }
                                    } else if (this.m_time == 1) {
                                        job.setTimeEventFromXML(this.m_timeEventXML);
                                        if (job.runRecurring() != 0) {
                                            rc = 3;
                                        }
                                    }
                                } else {
                                    rc = 3;
                                }
                            } else if (MetaUtilities.doesJobExist((String)this.m_name, (Tree)folder, (MdStore)store, (String)repos)) {
                                rc = 9;
                            } else {
                                File targetfile = MetaUtilities.createSourceCodeObject((String)basename, (Directory)dir, (MdObjectStore)store, (String)folderRepos);
                                String bname = null;
                                String ext = null;
                                if (basename.indexOf(".") >= 0) {
                                    bname = basename.substring(0, basename.lastIndexOf(46));
                                    ext = basename.substring(basename.lastIndexOf(46) + 1);
                                    targetfile.setFileName(bname);
                                    targetfile.setFileExtension(ext);
                                }
                                Job job = null;
                                if (this.m_jobID != null) {
                                    job = MetaUtilities.getAssociatedJob((String)this.m_jobID, (MdStore)store, (String)folderRepos);
                                } else {
                                    Directory srcdir = MetaUtilities.getDirectoryFromPath((String)srcpath, (MdStore)store, (String)repos);
                                    File sourcefile = MetaUtilities.createFileObject((String)basename, (Directory)srcdir, (MdObjectStore)store, (String)folderRepos);
                                    if (bname != null) {
                                        sourcefile.setFileName(bname);
                                        sourcefile.setFileExtension(ext);
                                    }
                                    ServerComponent server = CommandUtilities.getWorkspaceServerComponentFromBatchServer((ServerComponent)batchserver);
                                    job = MetaUtilities.createUserWrittenJobObject((String)this.m_name, (File)sourcefile, (ServerComponent)server, (MdObjectStore)store, (String)folderRepos);
                                    if (folder != null && job != null) {
                                        AssociationList list = job.getTrees();
                                        list.clear();
                                        list.add(folder);
                                    }
                                }
                                if (job != null) {
                                    if (MetaUtilities.isDebug()) {
                                        System.out.println("DEPLOYING: " + MetaUtilities.replaceInvalidCharactersInJobName((String)job.getName()));
                                    }
                                    DeployedJob djob = new DeployedJob(job, batchserver, null, targetfile, folderRepos);
                                    if (this.m_name != null && job.getName().compareTo(this.m_name) != 0) {
                                        if (this.m_jobID != null) {
                                            djob.setName(this.m_name);
                                        } else {
                                            djob.getMetadataObject().setName(this.m_name);
                                        }
                                    }
                                    djob.setDeploymentDirectory(dir.getDirectoryName());
                                    this.checkJCLGeneration(djob, rio);
                                    if (folder != null) {
                                        if (MetaUtilities.isDebug()) {
                                            System.out.println("FOLDER: " + folder);
                                        }
                                        djob.setFolder(folder);
                                    }
                                    if (!djob.commitChanges()) {
                                        if (this.m_verbose || MetaUtilities.isDebug()) {
                                            System.out.println(m_bundle.getString("AppMethods.ErrorMsg.UnableToPersist.txt"));
                                        }
                                        rc = 7;
                                    }
                                } else {
                                    rc = 7;
                                }
                            }
                        }
                        if (rc == 0) continue;
                        returncode = rc;
                        if (this.m_silent) continue;
                        Object[] parms = new Object[]{filename, rc};
                        String msg = MessageFormat.format(m_bundle.getString("AppMethods.ErrorMsg.FailedToDeploy.fmt"), parms);
                        System.err.println(msg);
                    }
                    break block83;
                }
                returncode = 14;
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                returncode = 99;
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                returncode = 99;
            }
            catch (InvalidParameterException ipe) {
                returncode = 99;
            }
            catch (SchedulerException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                returncode = 99;
            }
        }
        if (MetaUtilities.isDebug()) {
            System.out.println("DEPLOY RETURN CODE = " + returncode);
        }
        return returncode;
    }

    public int deployGenericBatchProgram(boolean schedule) {
        int rc;
        block44: {
            rc = 0;
            try {
                String repos;
                MdFactoryImpl factory = new MdFactoryImpl();
                factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
                String folderRepos = repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
                MdObjectStore store = factory.createObjectStore();
                ServerComponent batchserver = null;
                for (ServerComponent sc : MetaUtilities.getBatchServers((int)0, (MdStore)store, (String)repos)) {
                    if (sc.getName().compareToIgnoreCase(this.m_batchName) != 0) continue;
                    batchserver = sc;
                    break;
                }
                if (batchserver != null) {
                    if (this.m_name != null) {
                        Tree folder;
                        block43: {
                            block42: {
                                folder = null;
                                if (this.m_folder != null) {
                                    try {
                                        folder = this.m_metaRepositoryName != null ? AppMethods.getFolder(this.m_folder, this.m_metaRepositoryName, store, repos) : MetaUtilities.getFolder((String)this.m_folder, (MdObjectStore)store, (String)repos);
                                    }
                                    catch (Exception e) {
                                        if (!MetaUtilities.isDebug()) break block42;
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (folder == null) {
                                try {
                                    folder = MetaUtilities.getDefaultFolder((MdObjectStore)store, (String)repos);
                                }
                                catch (NotFound e1) {
                                    if (MetaUtilities.isDebug()) {
                                        e1.printStackTrace();
                                    }
                                }
                                catch (NoContext e1) {
                                    if (!MetaUtilities.isDebug()) break block43;
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (folder != null) {
                            folderRepos = "A0000001." + folder.getId().substring(0, 8);
                        }
                        if (schedule) {
                            ServerComponent scheduler = null;
                            for (ServerComponent sc : MetaUtilities.getSchedulerServers((int)100, (MdStore)store, (String)repos)) {
                                if (sc.getName().compareToIgnoreCase(this.m_schedName) != 0) continue;
                                scheduler = sc;
                                break;
                            }
                            if (this.m_jobArgs != null && batchserver != null) {
                                BatchJob job = new BatchJob();
                                job.createJob(null, batchserver, this.m_name, this.m_jobArgs, null, (UserContextInterface)null);
                                job.setSchedulerInfo(scheduler, this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null);
                                if (folder != null) {
                                    job.setFolder(folder);
                                }
                                if (this.m_time == 0) {
                                    job.runNow();
                                } else if (this.m_time == 2) {
                                    if (job.runManually() != 0) {
                                        rc = 3;
                                    }
                                } else if (this.m_time == 1) {
                                    job.setTimeEventFromXML(this.m_timeEventXML);
                                    if (job.runRecurring() != 0) {
                                        rc = 3;
                                    }
                                }
                            } else {
                                rc = 3;
                            }
                        } else if (MetaUtilities.doesJobExist((String)this.m_name, (Tree)folder, (MdStore)store, (String)repos)) {
                            rc = 9;
                        } else {
                            Job job = null;
                            if (this.m_jobID != null) {
                                job = MetaUtilities.getAssociatedJob((String)this.m_jobID, (MdStore)store, (String)repos);
                            } else {
                                job = MetaUtilities.createJobObject((String)this.m_name, (MdObjectStore)store, (String)folderRepos);
                                job.setTransformRole("SCHEDULER_BRIDGE_JOB");
                                if (folder != null && job != null) {
                                    AssociationList list = job.getTrees();
                                    list.clear();
                                    list.add(folder);
                                }
                            }
                            if (job != null) {
                                DeployedJob djob = new DeployedJob(job, batchserver, null, this.m_jobArgs);
                                if (folder != null) {
                                    djob.setFolder(folder);
                                }
                                djob.commitChanges();
                            } else {
                                rc = 7;
                            }
                        }
                        break block44;
                    }
                    rc = 7;
                    break block44;
                }
                rc = 14;
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (InvalidParameterException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (SchedulerException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
        }
        return rc;
    }

    public int redeployDataStepBatchProgram() {
        int returncode = 0;
        try {
            IFileService rio;
            IWorkspace workspace;
            MdObjectStore store;
            String repos;
            MdFactoryImpl factory;
            block71: {
                factory = new MdFactoryImpl();
                factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
                repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
                store = factory.createObjectStore();
                workspace = null;
                rio = null;
                try {
                    IWorkspaceServer iworkserver = new IWorkspaceServer((ServerContext)null, "440196D4-90F0-11D0-9F41-00A024BB830C", this.m_workMachine, this.m_workPort);
                    if (iworkserver.makeConnection(this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null)) {
                        workspace = iworkserver.getWorkspace();
                        rio = workspace.FileService();
                    }
                }
                catch (InvalidCredentialsException e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                }
                catch (FatalConnectionFactoryException e) {
                    if (!MetaUtilities.isDebug()) break block71;
                    e.printStackTrace();
                }
            }
            int numSrcfiles = this.m_fileId.size();
            for (int x = 0; x < numSrcfiles; ++x) {
                AssociationList directories;
                File jclsource;
                File source;
                int rc = 0;
                String id = this.m_fileId.get(x);
                String filename = this.m_fileName != null ? this.m_fileName.get(x) : null;
                JFJob jfjob = MetaUtilities.getJFJob((String)id, (MdStore)store, (String)repos);
                DeployedJob djob = new DeployedJob(jfjob);
                Job jobObject = djob.getJobObject();
                File destfile = null;
                String jclDirPath = null;
                File jclFile = null;
                ServerComponent batchserver = null;
                BatchServerInfo bsinfo = null;
                int targetOS = -1;
                Directory dir = null;
                Tree folder = null;
                String normsrcpath = filename;
                String srcName = null;
                if (filename != null) {
                    if (filename.startsWith("\"") || filename.startsWith("'")) {
                        filename = filename.substring(1, filename.length() - 1);
                    }
                    String file = CommandUtilities.normalizeFullPath((String)filename, (int)targetOS);
                    char pathseparator = CommandUtilities.getPathSeparator((int)targetOS);
                    String basename = CommandUtilities.getFilenameForBatchServer((String)file, batchserver);
                    String srcpath = "";
                    int lastindex = file.lastIndexOf(pathseparator);
                    if (lastindex > 0) {
                        int firstindex = file.indexOf(pathseparator);
                        srcpath = firstindex == lastindex ? file.substring(0, lastindex + 1) : file.substring(0, lastindex);
                    }
                    if (!MetaUtilities.isValidFilename((String)basename)) {
                        basename = MetaUtilities.replaceInvalidCharactersInFileName((String)basename);
                    }
                    srcName = this.m_name == null || numSrcfiles > 1 ? (basename.indexOf(".") >= 0 ? basename.substring(0, basename.lastIndexOf(46)) : basename) : this.m_name;
                    normsrcpath = CommandUtilities.normalizePath((String)srcpath, (int)targetOS);
                } else {
                    source = djob.getSourceCode();
                    if (source == null) {
                        return 8;
                    }
                    srcName = source.getFileName();
                    String srcExt = source.getFileExtension();
                    if (srcExt != null && srcExt.length() > 0) {
                        srcName = srcExt.startsWith(".") ? srcName + srcExt : srcName + "." + srcExt;
                    }
                }
                if (this.m_batchName == null) {
                    batchserver = djob.getBatchServer();
                    targetOS = CommandUtilities.getTargetOSForBatchServer((ServerComponent)batchserver);
                    bsinfo = new BatchServerInfo(batchserver.getName(), batchserver.getClassIdentifier(), targetOS);
                    bsinfo.setId(batchserver.getId());
                } else {
                    for (ServerComponent sc : MetaUtilities.getBatchServers((int)1, (MdStore)store, (String)repos)) {
                        if (sc.getName().compareToIgnoreCase(this.m_batchName) != 0) continue;
                        batchserver = sc;
                        targetOS = CommandUtilities.getTargetOSForBatchServer((ServerComponent)batchserver);
                        bsinfo = new BatchServerInfo(batchserver.getName(), batchserver.getClassIdentifier(), targetOS);
                        bsinfo.setId(batchserver.getId());
                        break;
                    }
                }
                if (this.m_dirName != null) {
                    dir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (String)this.m_dirName, (MdStore)store, (String)repos);
                } else if (this.m_batchName == null) {
                    source = djob.getSourceCode();
                    AssociationList directories2 = source.getDirectories();
                    if (directories2 != null && !directories2.isEmpty()) {
                        dir = (Directory)directories2.get(0);
                    }
                } else {
                    source = djob.getSourceCode();
                    AssociationList directories3 = source.getDirectories();
                    Directory temp = null;
                    if (directories3 != null && !directories3.isEmpty()) {
                        temp = (Directory)directories3.get(0);
                    }
                    dir = MetaUtilities.getDirectory((BatchServerInfo)bsinfo, (String)temp.getDirectoryName(), (MdStore)store, (String)repos);
                }
                if (targetOS == 2 && (jclsource = djob.getJCL()) != null && (directories = jclsource.getDirectories()) != null && !directories.isEmpty()) {
                    jclDirPath = ((Directory)directories.get(0)).getDirectoryName();
                }
                if (normsrcpath == null) {
                    filename = dir != null ? CommandUtilities.createFullPath((String)dir.getDirectoryName(), (String)srcName, (int)targetOS) : srcName;
                }
                if (this.m_folder != null) {
                    block72: {
                        try {
                            folder = this.m_metaRepositoryName != null ? AppMethods.getFolder(this.m_folder, this.m_metaRepositoryName, store, repos) : MetaUtilities.getFolder((String)this.m_folder, (MdObjectStore)store, (String)repos);
                        }
                        catch (Exception e) {
                            if (!MetaUtilities.isDebug()) break block72;
                            e.printStackTrace();
                        }
                    }
                    if (folder != null) {
                        if (MetaUtilities.isDebug()) {
                            System.out.println("FOLDER: " + folder);
                        }
                        djob.setFolder(folder);
                    }
                }
                if (batchserver != null) {
                    if (dir != null) {
                        File jclObj;
                        String msg;
                        Object[] parms;
                        DirectoryInfo dinfo = new DirectoryInfo(dir.getName(), dir.getDirectoryName());
                        dinfo.setId(dir.getId());
                        String name = this.m_name;
                        if (this.m_name == null || numSrcfiles > 1) {
                            name = djob.getName();
                        }
                        List<String> values = this.setFilePaths(name, filename, bsinfo, dinfo);
                        String basename = values.get(1);
                        String targetname = values.get(2);
                        String srcname = values.get(3);
                        String srcpath = values.get(4);
                        boolean copyfile = true;
                        if (CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)targetOS).compareTo(srcpath) == 0) {
                            copyfile = false;
                            if (this.m_verbose || MetaUtilities.isDebug()) {
                                String dir1 = CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)targetOS);
                                parms = new Object[]{srcname, dir1};
                                msg = MessageFormat.format(m_bundle.getString("AppMethods.Note.NoCopy.fmt"), parms);
                                System.out.println(msg);
                            }
                        }
                        if (copyfile) {
                            try {
                                if (rio != null) {
                                    StringBuffer contents = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)filename, (int)targetOS);
                                    String target = CommandUtilities.createFullPath((String)dir.getDirectoryName(), (String)targetname, (int)targetOS);
                                    if (!CommandUtilities.saveToRemoteFile((IWorkspace)workspace, (String)target, (int)targetOS, (String)contents.toString())) {
                                        rc = 6;
                                    } else if (MetaUtilities.isDebug()) {
                                        String s1 = "Copying the source file from filename to target";
                                        String s2 = "filename is: " + filename;
                                        String s3 = "target is: " + target;
                                        System.out.println(s1);
                                        System.out.println(s2);
                                        System.out.println(s3);
                                    }
                                } else {
                                    rc = 6;
                                }
                            }
                            catch (GenericError ge) {
                                if (MetaUtilities.isDebug()) {
                                    ge.printStackTrace();
                                }
                                rc = 6;
                            }
                        }
                        if ((jclObj = djob.getJCL()) != null) {
                            try {
                                String jclName = basename + ".jcl";
                                String strFullName = CommandUtilities.createFullPath((String)jclDirPath, (String)jclName, (int)2);
                                String runas = djob.getRunAs();
                                if (rio != null) {
                                    String jcl;
                                    String cmd = CommandUtilities.getCommandLineFromBatchServer((ServerComponent)batchserver);
                                    String commonArgs = MetaUtilities.getProperty((Root)jfjob, (String)"CommonArgs");
                                    if (commonArgs == null || commonArgs.trim().length() <= 0) {
                                        commonArgs = MetaUtilities.getProperty((Root)batchserver, (String)"CommonArgs");
                                    }
                                    String jobcmdargs = MetaUtilities.getProperty((Root)jfjob, (String)"CmdArgs");
                                    if (MetaUtilities.isDebug()) {
                                        String s1 = "command is: " + cmd;
                                        String s2 = "common arguments are: " + commonArgs;
                                        String s3 = "job arguments are: " + jobcmdargs;
                                        System.out.println(s1);
                                        System.out.println(s2);
                                        System.out.println(s3);
                                    }
                                    if ((jcl = DeployedJob.generateJCLFromTemplate((IFileService)rio, (String)cmd, (String)commonArgs, (String)jobcmdargs, (String)runas, (String)strFullName)) != null) {
                                        if (!CommandUtilities.saveToRemoteFile((IFileService)rio, (String)strFullName, (int)2, (String)jcl)) {
                                            if (MetaUtilities.isDebug()) {
                                                System.out.println("Unable to save the JCL file to server.");
                                            }
                                            rc = 6;
                                        }
                                    } else {
                                        if (MetaUtilities.isDebug()) {
                                            System.out.println("Failed to generate the JCL file from the template.");
                                        }
                                        rc = 6;
                                    }
                                } else {
                                    if (MetaUtilities.isDebug()) {
                                        System.out.println("Unable to obtain the FileService.");
                                    }
                                    rc = 6;
                                }
                            }
                            catch (GenericError ge) {
                                if (MetaUtilities.isDebug()) {
                                    ge.printStackTrace();
                                }
                                rc = 6;
                            }
                        }
                        if (rc == 0) {
                            for (Object obj : jfjob.getSourceCodes()) {
                                if (!(obj instanceof File)) continue;
                                destfile = (File)obj;
                                String bname = targetname.substring(0, targetname.lastIndexOf(46));
                                String ext = targetname.substring(targetname.lastIndexOf(46) + 1);
                                destfile.setFileName(bname);
                                destfile.setFileExtension(ext);
                                destfile.setName(basename);
                                destfile.getDirectories().clear();
                                destfile.getDirectories().add((Object)dir);
                                break;
                            }
                            if (MetaUtilities.isDebug()) {
                                System.out.println("REDEPLOYING: " + MetaUtilities.replaceInvalidCharactersInJobName((String)djob.getName()));
                            }
                            djob = DataStepProgramDeployer.UpdateMetaObjects((Job)jobObject, (JFJob)jfjob, (File)destfile, jclFile, (Directory)dir, (ServerComponent)batchserver, null, (MdFactory)factory, (MdObjectStore)store, (String)repos);
                            djob.getDeployedJobObject().setName(name);
                            if (!djob.commitChanges()) {
                                if (this.m_verbose || MetaUtilities.isDebug()) {
                                    System.out.println(m_bundle.getString("AppMethods.ErrorMsg.UnableToPersist.txt"));
                                }
                                rc = 7;
                            }
                        }
                        if (rc == 0) continue;
                        returncode = rc;
                        if (this.m_silent) continue;
                        parms = new Object[]{filename, rc};
                        msg = MessageFormat.format(m_bundle.getString("AppMethods.ErrorMsg.FailedToReDeploy.fmt"), parms);
                        System.err.println(msg);
                        continue;
                    }
                    returncode = 8;
                    continue;
                }
                returncode = 14;
            }
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            returncode = 99;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            returncode = 99;
        }
        catch (InvalidParameterException ipe) {
            returncode = 99;
        }
        catch (SchedulerException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            returncode = 99;
        }
        if (MetaUtilities.isDebug()) {
            System.out.println("REDEPLOY RETURN CODE = " + returncode);
        }
        return returncode;
    }

    public int submitRunnableBatchJob() {
        int rc = 0;
        try {
            long id = LSFScheduler.submitRerunableBatchJobNow((String)this.m_flowName, (String)this.m_command, (String)this.m_schedMachine, (String)String.valueOf(this.m_schedPort), (String)this.m_serverUser, (SealedString)(this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null));
            if (MetaUtilities.isDebug()) {
                System.out.println("submitJob: " + id);
            }
            if (id < 0L) {
                rc = 3;
            }
        }
        catch (LoginException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (SchedulerException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (JFException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (IOException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        return rc;
    }

    public int reportFlow() {
        int rc;
        block42: {
            rc = 0;
            try {
                MdFactoryImpl factory = new MdFactoryImpl();
                factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
                String repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
                MdObjectStore store = factory.createObjectStore();
                IWorkspaceServer iworkserver = new IWorkspaceServer((ServerContext)null, "440196D4-90F0-11D0-9F41-00A024BB830C", this.m_workMachine, this.m_workPort);
                IWorkspace workspace = null;
                if (iworkserver.makeConnection(this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null)) {
                    workspace = iworkserver.getWorkspace();
                    if (this.m_write) {
                        DeployedFlow flow = AppMethods.getFlow(this.m_flowName, (MdFactory)factory, store, repos);
                        ReportFlowToXML reporter = null;
                        switch (this.m_reportFormat) {
                            case 0: {
                                reporter = new ReportFlowToXML(flow, this.m_flowName, this.m_outputDir, workspace);
                                break;
                            }
                            case 1: {
                                reporter = new ReportFlowToSAS(flow, this.m_flowName, this.m_outputDir, workspace);
                                break;
                            }
                            case 2: {
                                reporter = new ReportFlowToCSV(flow, this.m_flowName, this.m_outputDir, workspace);
                            }
                        }
                        if (!reporter.writeFlow()) {
                            rc = 4;
                        }
                        break block42;
                    }
                    ImportFlowFromSAS builder = null;
                    switch (this.m_reportFormat) {
                        case 0: {
                            if (this.m_infile == null) {
                                this.m_infile = this.m_outputDir + "/" + this.m_flowName + ".xml";
                            }
                            builder = new ImportFlowFromXML(this.m_infile, workspace, store, repos, this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null);
                            break;
                        }
                        case 1: {
                            if (this.m_infile == null) {
                                this.m_infile = this.m_outputDir + "/" + this.m_flowName;
                            }
                            builder = new ImportFlowFromSAS(this.m_infile, workspace, store, repos);
                            break;
                        }
                        case 2: {
                            if (this.m_infile == null) {
                                this.m_infile = this.m_outputDir + "/" + this.m_flowName + ".csv";
                            }
                            builder = new ImportFlowFromCSV(this.m_infile, workspace, store, repos);
                        }
                    }
                    if (builder.parse(this.m_maxPredecessors)) {
                        DeployedFlow flow;
                        block44: {
                            FlowInfo info = builder.getFlowInfo();
                            String reposID = repos.length() > 8 ? repos.substring(9) : repos;
                            Scheduler scheduler = MetaUtilities.getSchedulingServer((SchedulerServerInfo)info.getScheduler(), (MdObjectStore)store);
                            flow = new DeployedFlow(info, scheduler, store, reposID);
                            if (this.m_folder != null) {
                                try {
                                    Tree folder;
                                    block43: {
                                        folder = null;
                                        folder = this.m_metaRepositoryName != null ? AppMethods.getFolder(this.m_folder, this.m_metaRepositoryName, store, repos) : MetaUtilities.getFolder((String)this.m_folder, (MdObjectStore)store, (String)repos);
                                        if (folder == null && info.getLocation() == null) {
                                            try {
                                                folder = MetaUtilities.getDefaultFolder((MdObjectStore)store, (String)repos);
                                            }
                                            catch (NotFound e1) {
                                                if (MetaUtilities.isDebug()) {
                                                    e1.printStackTrace();
                                                }
                                            }
                                            catch (NoContext e1) {
                                                if (!MetaUtilities.isDebug()) break block43;
                                                e1.printStackTrace();
                                            }
                                        }
                                    }
                                    if (folder != null) {
                                        flow.setFolder(folder);
                                    }
                                }
                                catch (Exception e) {
                                    if (!MetaUtilities.isDebug()) break block44;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (!flow.commitChanges()) {
                            rc = 5;
                        }
                        break block42;
                    }
                    rc = 12;
                    break block42;
                }
                rc = 2;
            }
            catch (InvalidParameterException ipe) {
                if (MetaUtilities.isDebug()) {
                    ipe.printStackTrace();
                }
                rc = 1;
            }
            catch (InvalidCredentialsException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (FatalConnectionFactoryException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (IOException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
            catch (SchedulerException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                rc = 99;
            }
        }
        return rc;
    }

    public int rescheduleFlow() {
        int rc = 0;
        try {
            MdFactoryImpl factory = new MdFactoryImpl();
            factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
            String repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
            MdObjectStore store = factory.createObjectStore();
            DeployedFlow flow = null;
            if (this.m_flowID != null) {
                JFJob jfjob = MetaUtilities.getJFJob((String)this.m_flowID, (MdStore)store, (String)repos);
                flow = new DeployedFlow(jfjob, store);
            } else {
                flow = AppMethods.getFlow(this.m_flowName, (MdFactory)factory, store, repos);
            }
            SubmitFlow submitter = new SubmitFlow(flow);
            if (!submitter.batchSubmit(this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null)) {
                rc = 10;
            }
            if (!flow.commitChangesWithNoValidation()) {
                rc = 13;
            }
        }
        catch (UnsupportedOperationException uoe) {
            if (MetaUtilities.isDebug()) {
                uoe.printStackTrace();
            }
            rc = 11;
        }
        catch (InvalidParameterException ipe) {
            if (MetaUtilities.isDebug()) {
                ipe.printStackTrace();
            }
            rc = 1;
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (SchedulerException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        return rc;
    }

    public int scheduleFlow() {
        int rc = 0;
        try {
            MdFactoryImpl factory = new MdFactoryImpl();
            factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
            String repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
            MdObjectStore store = factory.createObjectStore();
            DeployedFlow flow = null;
            if (this.m_flowID != null) {
                JFJob jfjob = MetaUtilities.getJFJob((String)this.m_flowID, (MdStore)store, (String)repos);
                flow = new DeployedFlow(jfjob, store);
            } else {
                flow = AppMethods.getFlow(this.m_flowName, (MdFactory)factory, store, repos);
            }
            Scheduler scheduler = null;
            if (this.m_schedName != null) {
                ServerComponent scomponent = null;
                for (ServerComponent sc : MetaUtilities.getSchedulerServers((int)100, (MdStore)store, (String)repos)) {
                    if (sc.getName().compareToIgnoreCase(this.m_schedName) != 0) continue;
                    scomponent = sc;
                    break;
                }
                if (scomponent != null) {
                    scheduler = MetaUtilities.getSchedulingServer(scomponent);
                }
            } else {
                scheduler = flow.getSchedulingServer();
            }
            if (this.m_time == 0) {
                TriggerEvent runNow = new TriggerEvent(scheduler, m_bundle.getString("DeployedFlow.RunOnce.txt"), "RunNow");
                flow.setTriggerEvent(runNow);
            } else if (this.m_time == 2) {
                TriggerEvent manual = new TriggerEvent(scheduler, m_bundle.getString("DeployedFlow.Manual.txt"), "Manual");
                flow.setTriggerEvent(manual);
            } else if (this.m_time == 1) {
                TimeEvent te = new TimeEvent();
                te.initFromXML(this.m_timeEventXML, scheduler);
                IRecurrenceInfo recurrence = te.getInfo().getRecurrence();
                if (recurrence != null) {
                    String hours = te.getHours();
                    String minutes = te.getMinutes();
                    int duration = te.getDuration();
                    Calendar cal = scheduler.getCalendar(recurrence);
                    if (cal == null) {
                        cal = scheduler.createCalendar(recurrence);
                    }
                    TimeEvent event = new TimeEvent(scheduler);
                    event.setHours(hours);
                    event.setMinutes(minutes);
                    event.setCalendar(cal);
                    event.setUser(cal.getOwner());
                    event.setDuration(duration);
                    TriggerEventInfo trigger = new TriggerEventInfo(event.getInfo(), scheduler.getServerComponent());
                    flow.setTriggerEvent(trigger);
                } else {
                    rc = 11;
                }
            } else {
                rc = 11;
            }
            SubmitFlow submitter = new SubmitFlow(flow);
            if (!submitter.batchSubmit(this.m_serverUser, this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null)) {
                rc = 10;
            }
            if (!flow.commitChangesWithNoValidation()) {
                rc = 13;
            }
        }
        catch (UnsupportedOperationException uoe) {
            if (MetaUtilities.isDebug()) {
                uoe.printStackTrace();
            }
            rc = 11;
        }
        catch (InvalidParameterException ipe) {
            if (MetaUtilities.isDebug()) {
                ipe.printStackTrace();
            }
            rc = 1;
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (SchedulerException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        return rc;
    }

    public int deleteFlowFromMetadataOnly() {
        int rc = 0;
        try {
            MdFactoryImpl factory = new MdFactoryImpl();
            factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
            String repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
            MdObjectStore store = factory.createObjectStore();
            DeployedFlow flow = null;
            if (this.m_flowID != null) {
                JFJob jfjob = MetaUtilities.getJFJob((String)this.m_flowID, (MdStore)store, (String)repos);
                flow = new DeployedFlow(jfjob, store);
            } else {
                flow = AppMethods.getFlow(this.m_flowName, (MdFactory)factory, store, repos);
            }
            flow.delete();
        }
        catch (UnsupportedOperationException uoe) {
            if (MetaUtilities.isDebug()) {
                uoe.printStackTrace();
            }
            rc = 99;
        }
        catch (InvalidParameterException ipe) {
            if (MetaUtilities.isDebug()) {
                ipe.printStackTrace();
            }
            rc = 1;
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (SchedulerException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        return rc;
    }

    public int validatePlatformComputingSchedulingServer() {
        int rc = 0;
        try {
            MdFactoryImpl factory = new MdFactoryImpl();
            factory.makeOMRConnection(this.m_metaMachine, this.m_metaPort, this.m_metaUser, this.m_metaPassword);
            String repos = factory.getRepositoryUtil().getRepositoryIDFromName(this.m_metaRepositoryName);
            MdObjectStore store = factory.createObjectStore();
            List servers = MetaUtilities.getSchedulerServers((int)101, (MdStore)store, (String)repos);
            for (ServerComponent sc : servers) {
                if (!LSFScheduler.validateVersion((ServerComponent)sc, (String)this.m_serverUser, (SealedString)(this.m_serverPassword != null ? new SealedString(this.m_serverPassword) : null))) continue;
                rc = 99;
            }
        }
        catch (SchedulerException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (RemoteException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        catch (MdException e) {
            if (!this.m_silent) {
                System.err.println(e.toString());
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            rc = 99;
        }
        return rc;
    }

    private boolean processCommandLineArguments(String[] saArgs) {
        int nArgs = saArgs.length;
        if (MetaUtilities.isDebug()) {
            System.out.println("**COMMANDLINE_START**");
        }
        for (int iArg = 0; iArg < nArgs; ++iArg) {
            String fname;
            int i;
            String[] lines;
            int charsRead;
            StringBuffer buffer;
            char[] dataBuffer;
            InputStreamReader in;
            FileInputStream is;
            String infile;
            if (MetaUtilities.isDebug()) {
                String nextarg;
                String string = nextarg = iArg + 1 < nArgs ? saArgs[iArg + 1] : null;
                if (nextarg != null && !nextarg.startsWith("-")) {
                    System.out.println(saArgs[iArg] + " " + nextarg);
                } else {
                    System.out.println(saArgs[iArg]);
                }
            }
            if (saArgs[iArg].equalsIgnoreCase("-profile")) {
                String profile = saArgs[++iArg];
                this.setConnectionProfile(profile);
                this.m_metaMachine = this.m_connectionProfile.getProperty("host");
                this.m_metaPort = this.m_connectionProfile.getProperty("port");
                this.m_metaUser = this.m_connectionProfile.getProperty("userid");
                this.m_metaPassword = this.m_connectionProfile.getProperty("password");
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-metaserver")) {
                this.m_metaMachine = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-metaport")) {
                this.m_metaPort = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-metauser")) {
                this.m_metaUser = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-metapass")) {
                this.m_metaPassword = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-metarepository")) {
                this.m_metaRepositoryName = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-scheduler")) {
                this.m_schedName = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-batchserver")) {
                this.m_batchName = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-schedmachine")) {
                this.m_schedMachine = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-schedport")) {
                this.m_schedPort = Integer.parseInt(saArgs[++iArg]);
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-servermachine")) {
                this.m_workMachine = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-serverport")) {
                this.m_workPort = Integer.parseInt(saArgs[++iArg]);
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-username")) {
                this.m_serverUser = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-password")) {
                this.m_serverPassword = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-outputDir")) {
                this.m_outputDir = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-flow")) {
                this.m_flowName = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-delete")) {
                this.m_delete = true;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-xml")) {
                this.m_reportFormat = 0;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-sas")) {
                this.m_reportFormat = 1;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-csv")) {
                this.m_reportFormat = 2;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-import")) {
                this.m_infile = saArgs[++iArg];
                this.m_write = false;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-executeCmd")) {
                this.m_command = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-sysin")) {
                this.m_fileName = new ArrayList<String>();
                this.m_fileName.add(saArgs[++iArg]);
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-infile")) {
                infile = saArgs[++iArg];
                this.m_fileName = new ArrayList<String>();
                this.m_name = null;
                try {
                    is = new FileInputStream(infile);
                    in = new InputStreamReader(is);
                    dataBuffer = new char[1024];
                    buffer = new StringBuffer();
                    charsRead = in.read(dataBuffer);
                    while (charsRead > 0) {
                        buffer.append(dataBuffer, 0, charsRead);
                        charsRead = in.read(dataBuffer);
                    }
                    lines = buffer.toString().split("\n");
                    for (i = 0; i < lines.length; ++i) {
                        fname = lines[i];
                        if (fname.indexOf(13) > -1) {
                            int index = fname.indexOf(13);
                            fname = fname.substring(0, index);
                        }
                        this.m_fileName.add(fname);
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    this.m_fileName = null;
                    if (!MetaUtilities.isDebug()) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    this.m_fileName = null;
                    if (!MetaUtilities.isDebug()) continue;
                    e.printStackTrace();
                    continue;
                }
            }
            if (saArgs[iArg].equalsIgnoreCase("-redeployedjobid")) {
                this.m_fileId = new ArrayList<String>();
                this.m_fileId.add(saArgs[++iArg]);
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-redeploy")) {
                infile = saArgs[++iArg];
                this.m_fileId = new ArrayList<String>();
                this.m_fileName = new ArrayList<String>();
                this.m_name = null;
                try {
                    is = new FileInputStream(infile);
                    in = new InputStreamReader(is);
                    dataBuffer = new char[1024];
                    buffer = new StringBuffer();
                    charsRead = in.read(dataBuffer);
                    while (charsRead > 0) {
                        buffer.append(dataBuffer, 0, charsRead);
                        charsRead = in.read(dataBuffer);
                    }
                    lines = buffer.toString().split("\n");
                    for (i = 0; i < lines.length; ++i) {
                        fname = lines[i];
                        if (fname.indexOf(13) > -1) {
                            int index = fname.indexOf(13);
                            fname = fname.substring(0, index);
                        }
                        String[] tokens = fname.split(";");
                        this.m_fileId.add(tokens[0]);
                        String filename = tokens.length > 1 ? tokens[1] : null;
                        this.m_fileName.add(filename);
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    this.m_fileId = null;
                    if (!MetaUtilities.isDebug()) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    this.m_fileId = null;
                    if (!MetaUtilities.isDebug()) continue;
                    e.printStackTrace();
                    continue;
                }
            }
            if (saArgs[iArg].equalsIgnoreCase("-jobargs")) {
                this.m_jobArgs = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-trigger")) {
                String arg;
                this.m_time = (arg = saArgs[++iArg]).compareToIgnoreCase("NOW") == 0 ? 0 : (arg.compareToIgnoreCase("MANUAL") == 0 ? 2 : 1);
                this.m_timeEventXML = "<Event Type=\"Time\" Description=\"\">" + arg + "</Event>";
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-folder")) {
                this.m_folder = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-deploymentdir")) {
                this.m_dirName = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jobid")) {
                this.m_jobID = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-name")) {
                if (this.m_fileName != null && this.m_fileName.size() >= 2) continue;
                this.m_name = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-flowid")) {
                this.m_flowID = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-validatePlatformComputing")) {
                this.m_validatePlatformComputing = true;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-usage")) {
                System.err.println(m_bundle.getString("AppMain.Usage0.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage1.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage2.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage3.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage4.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage5.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage6.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage7.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage8.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.MetaServer.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.AppServer.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.SchServer.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.ReportFlow.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.DeployJob.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.RedeployJob.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.BuildFlow.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.FailOverCmd.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.SchedJob.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.SchedFlow.txt"));
                System.err.println(m_bundle.getString("AppMain.Usage.ReschedFlow.txt"));
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-verbose")) {
                this.m_verbose = true;
                this.m_silent = false;
                continue;
            }
            if (!saArgs[iArg].equalsIgnoreCase("-silent")) continue;
            this.m_verbose = false;
            this.m_silent = true;
        }
        if (MetaUtilities.isDebug()) {
            System.out.println("**COMMANDLINE_END**");
        }
        return true;
    }

    private static DeployedFlow getFlow(String name, MdFactory factory, MdObjectStore store, String repos) throws RemoteException, MdException {
        JFJob flow = null;
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\"/>";
        List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8584, selectXML);
        for (JFJob jfjob : list) {
            String role = jfjob.getTransformRole();
            if (role.compareTo("SCHEDULER_FLOW") != 0) continue;
            flow = jfjob;
            break;
        }
        return new DeployedFlow(flow, store);
    }

    private static Directory getDirectory(ServerComponent batchserver, int targetOS, String dirpath, MdStore store, String repos) throws MdException, RemoteException {
        if (batchserver == null) {
            return null;
        }
        LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
        if (ls == null) {
            return null;
        }
        ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
        if (sc == null) {
            return null;
        }
        AssociationList temp = sc.getDataPackages();
        String normDirpath = CommandUtilities.normalizePath((String)dirpath, (int)targetOS);
        if (MetaUtilities.isDebug()) {
            System.out.println("SEARCHING METADATA FOR DIRECTORY (" + normDirpath + ")");
        }
        if (normDirpath.indexOf("/") >= 0 || targetOS == 2 && normDirpath.indexOf(")") > 0 || targetOS == 3 && normDirpath.indexOf("]") > 0) {
            if (MetaUtilities.isDebug()) {
                System.out.println("SEARCHING METADATA FOR DIRECTORY BY PATH(" + normDirpath + ")");
            }
            int listsize = temp.size();
            for (int i = 0; i < listsize; ++i) {
                if (!(temp.get(i) instanceof Directory)) continue;
                Directory dir = (Directory)temp.get(i);
                String dirname = CommandUtilities.normalizePath((String)dir.getDirectoryName(), (int)targetOS);
                if (MetaUtilities.isDebug()) {
                    System.out.println("FOUND DIRECTORY BY PATH(" + dirname + ")");
                }
                if (dirname.compareTo(normDirpath) != 0) continue;
                return dir;
            }
        } else {
            if (MetaUtilities.isDebug()) {
                System.out.println("SEARCHING METADATA FOR DIRECTORY BY NAME (" + dirpath + ")");
            }
            int listsize = temp.size();
            for (int i = 0; i < listsize; ++i) {
                if (!(temp.get(i) instanceof Directory)) continue;
                Directory dir = (Directory)temp.get(i);
                String dirname = dir.getName();
                if (MetaUtilities.isDebug()) {
                    System.out.println("FOUND DIRECTORY BY NAME(" + dirname + ")");
                }
                if (dirname.compareTo(dirpath) != 0) continue;
                return dir;
            }
        }
        if (MetaUtilities.isDebug()) {
            System.err.println("CANNOT FIND DIRECTORY IN METADATA");
        }
        return null;
    }

    private static Tree getFolder(String name, String repository, MdObjectStore store, String repos) throws MdException, RemoteException, NotFound, NoContext {
        int flags = 392;
        MdFactory factory = store.getFactory();
        String folder = name.substring(name.lastIndexOf("/") + 1);
        String xmlSelect = "<XMLSELECT search=\"@Name = '" + folder + "'\"/>";
        ArrayList trees = new ArrayList();
        trees.addAll(factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Tree", flags, xmlSelect, false));
        int count = trees.size();
        if (count == 1) {
            return (Tree)trees.get(0);
        }
        if (count == 0) {
            NameComponent[] nameComponent = new NameComponent[]{new NameComponent(name, "Tree")};
            throw new NotFound(NotFoundReason.missing_node, nameComponent);
        }
        for (int i = 0; i < trees.size(); ++i) {
            Tree tree = (Tree)trees.get(i);
            String folderLocation = MetaUtilities.getFolderLocation((Tree)tree);
            if (folderLocation == null || folderLocation.compareTo(name) != 0) continue;
            return tree;
        }
        Object[] parms = new Object[]{repository, name};
        String msg = MessageFormat.format(m_bundle.getString("AppMethods.ErrorMsg.MultipleFoldersOfSameName.fmt"), parms);
        throw new NoContext(msg);
    }

    private Boolean checkJCLGeneration(DeployedJob djob, IFileService rio) throws SchedulerException {
        block15: {
            try {
                String dirname;
                ServerComponent batchserver = djob.getBatchServer();
                if (CommandUtilities.getTargetOSForBatchServer((ServerComponent)batchserver) != 2 || djob.getJCL() != null) break block15;
                String basename = djob.getName();
                String jclext = ".jcl".substring(1);
                String repos = "A0000001." + djob.getId().substring(0, 8);
                Directory dir = MetaUtilities.getDirectoryFromPath((String)djob.getDeploymentDirectory(), (MdStore)djob.getStore(), (String)repos);
                if (dir == null && (dir = MetaUtilities.createDirectoryObject((String)(dirname = batchserver.getName()), (MdObjectStore)((MdObjectStore)djob.getStore()), (String)repos)) != null) {
                    dir.setDirectoryName(djob.getDeploymentDirectory());
                }
                File jclObj = MetaUtilities.createSourceCodeObject((String)basename, (Directory)dir, (MdObjectStore)((MdObjectStore)djob.getStore()), (String)djob.getId().substring(0, 8));
                jclObj.setFileName(basename);
                jclObj.setFileExtension(jclext);
                djob.setJCL(jclObj);
                try {
                    String jclName = basename + ".jcl";
                    String strFullName = CommandUtilities.createFullPath((String)djob.getDeploymentDirectory(), (String)jclName, (int)2);
                    String runas = djob.getRunAs();
                    if (rio != null) {
                        String jcl;
                        String cmd = CommandUtilities.getCommandLineFromBatchServer((ServerComponent)batchserver);
                        JFJob jfjob = djob.getDeployedJobObject();
                        String commonArgs = MetaUtilities.getProperty((Root)jfjob, (String)"CommonArgs");
                        if (commonArgs == null || commonArgs.trim().length() <= 0) {
                            commonArgs = MetaUtilities.getProperty((Root)batchserver, (String)"CommonArgs");
                        }
                        String jobcmdargs = MetaUtilities.getProperty((Root)jfjob, (String)"CmdArgs");
                        if (MetaUtilities.isDebug()) {
                            String s1 = "command is: " + cmd;
                            String s2 = "common arguments are: " + commonArgs;
                            String s3 = "job arguments are: " + jobcmdargs;
                            System.out.println(s1);
                            System.out.println(s2);
                            System.out.println(s3);
                        }
                        if ((jcl = DeployedJob.generateJCLFromTemplate((IFileService)rio, (String)cmd, (String)commonArgs, (String)jobcmdargs, (String)runas, (String)strFullName)) != null) {
                            if (!CommandUtilities.saveToRemoteFile((IFileService)rio, (String)strFullName, (int)2, (String)jcl)) {
                                if (MetaUtilities.isDebug()) {
                                    System.out.println("Unable to save the JCL file to server.");
                                }
                                return false;
                            }
                            break block15;
                        }
                        if (MetaUtilities.isDebug()) {
                            System.out.println("Failed to generate the JCL file from the template.");
                        }
                        return false;
                    }
                    if (MetaUtilities.isDebug()) {
                        System.out.println("Unable to obtain the FileService.");
                    }
                    return false;
                }
                catch (GenericError ge) {
                    if (MetaUtilities.isDebug()) {
                        ge.printStackTrace();
                    }
                    return false;
                }
            }
            catch (Exception ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public void setConnectionProfile(String profile) {
        try {
            this.m_connectionProfile = ConnectionProfile.loadProfile((String)profile);
        }
        catch (IOException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            this.m_connectionProfile = null;
        }
    }

    protected List<String> setFilePaths(String name, String infile, BatchServerInfo bsinfo, DirectoryInfo dir) {
        ArrayList<String> returnValues = new ArrayList<String>();
        String file = CommandUtilities.normalizeFullPath((String)infile, (int)bsinfo.getOperatingSystem());
        if (file.startsWith("\"") || file.startsWith("'")) {
            file = file.substring(1, file.length() - 1);
        }
        String basename = MetaUtilities.replaceInvalidCharactersInFileName((String)name);
        String targetname = "";
        if (basename != null && basename.length() > 0) {
            targetname = bsinfo.getType() == 1 ? basename + ".sas" : basename;
        }
        char pathseparator = CommandUtilities.getPathSeparator((int)bsinfo.getOperatingSystem());
        String srcname = file.substring(file.lastIndexOf(pathseparator) + 1);
        String srcpath = null;
        int lastindex = file.lastIndexOf(pathseparator);
        if (lastindex > 0) {
            int firstindex = file.indexOf(pathseparator);
            srcpath = firstindex == lastindex ? file.substring(0, lastindex + 1) : file.substring(0, lastindex);
        }
        boolean rc = false;
        String fullname = CommandUtilities.createFullPath((String)dir.getPath(), (String)targetname, (int)bsinfo.getOperatingSystem());
        if (targetname.compareTo(srcname) != 0) {
            rc = true;
        }
        returnValues.add(String.valueOf(rc));
        returnValues.add(basename);
        returnValues.add(targetname);
        returnValues.add(srcname);
        returnValues.add(srcpath);
        returnValues.add(fullname);
        return returnValues;
    }
}

