/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.cli;

import com.sas.scheduler.cli.AppMethods;

public class AppMain {
    public static void main(String[] args) {
        int rc = 0;
        AppMethods handle = new AppMethods(args);
        if (handle.m_verbose) {
            System.out.println("metaMachine: " + handle.m_metaMachine);
            System.out.println("metaPort: " + handle.m_metaPort);
            System.out.println("metaRepository: " + handle.m_metaRepositoryName);
            System.out.println("metaUser: " + handle.m_metaUser);
            System.out.println("username: " + handle.m_serverUser);
            System.out.println("scheduler: " + handle.m_schedMachine);
            System.out.println("schedport: " + handle.m_schedPort);
            System.out.println("workspace: " + handle.m_workMachine);
            System.out.println("workport: " + handle.m_workPort);
            System.out.println("flow: " + handle.m_flowName);
            System.out.println("write: " + handle.m_write);
            System.out.println("outdir: " + handle.m_outputDir);
            System.out.println("infile: " + handle.m_infile);
            switch (handle.m_reportFormat) {
                case 0: {
                    System.out.println("fileFormat: xml");
                    break;
                }
                case 1: {
                    System.out.println("fileFormat: sas");
                    break;
                }
                case 2: {
                    System.out.println("fileFormat: csv");
                }
            }
            System.out.println("command: " + handle.m_command);
            System.out.println("filename: " + handle.m_fileName);
            System.out.println("fileid: " + handle.m_fileId);
            System.out.println("folder: " + handle.m_folder);
            System.out.println("batch server: " + handle.m_batchName);
            System.out.println("scheduler: " + handle.m_schedName);
            switch (handle.m_time) {
                case 0: {
                    System.out.println("trigger: Run Now");
                    break;
                }
                case 2: {
                    System.out.println("trigger: Manual");
                    break;
                }
                case 1: {
                    System.out.println("trigger: " + handle.m_timeEventXML);
                }
            }
            System.out.println("deployment dir: " + handle.m_dirName);
            System.out.println("deployed job name: " + handle.m_name);
            System.out.println("job id: " + handle.m_jobID);
        }
        if (handle.m_reportFormat != -1) {
            rc = handle.reportFlow();
        } else if (handle.m_command != null && handle.m_command.length() > 0) {
            rc = handle.submitRunnableBatchJob();
        } else if (handle.m_fileName != null && !handle.m_fileName.isEmpty()) {
            rc = handle.deployDataStepBatchProgram(handle.m_schedName != null);
        } else if (handle.m_fileId != null && !handle.m_fileId.isEmpty()) {
            rc = handle.redeployDataStepBatchProgram();
        } else if (handle.m_jobArgs != null) {
            rc = handle.deployGenericBatchProgram(handle.m_schedName != null);
        } else if (handle.m_validatePlatformComputing) {
            rc = handle.validatePlatformComputingSchedulingServer();
        } else if (handle.m_flowName != null || handle.m_flowID != null) {
            rc = handle.m_delete ? handle.deleteFlowFromMetadataOnly() : (handle.m_time == 0 || handle.m_time == 2 || handle.m_time == 1 ? handle.scheduleFlow() : handle.rescheduleFlow());
        }
        if (handle.m_verbose) {
            System.out.println("Exit with: " + rc);
        }
        System.exit(rc);
    }
}

