/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.mail.client;

import com.sas.svcs.mail.client.InlineData;
import com.sas.svcs.mail.client.MailAddress;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Mail
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(Mail.class);
    @Deprecated
    private String[] to;
    @Deprecated
    private String[] cc;
    @Deprecated
    private String[] bcc;
    @Deprecated
    private String replyTo;
    @Deprecated
    private String from;
    private String subject;
    private String textMessage;
    private String htmlMessage;
    private String charset;
    private MailAddress[] toAddresses;
    private MailAddress[] ccAddresses;
    private MailAddress[] bccAddresses;
    private MailAddress fromAddress;
    private MailAddress replyToAddress;
    private final Map<String, byte[]> attachments;
    private final Map<String, InlineData> inline;
    private boolean multipart = true;

    public Mail() {
        this.setSubject("");
        this.setTextMessage("");
        this.attachments = new HashMap<String, byte[]>();
        this.inline = new HashMap<String, InlineData>();
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean flag) {
        this.multipart = flag;
    }

    public void addAttachment(String name, byte[] attachment) {
        this.attachments.put(name, attachment);
    }

    public Map<String, byte[]> getAttachments() {
        return this.attachments;
    }

    public void addInline(InlineData data) {
        this.inline.put(data.getName(), data);
    }

    public Map<String, InlineData> getInline() {
        return this.inline;
    }

    public MailAddress[] getToAddresses() {
        return this.getAddressArray(this.toAddresses, this.to);
    }

    public void setToAddresses(MailAddress[] toAddresses) {
        this.toAddresses = toAddresses;
    }

    public MailAddress[] getCcAddresses() {
        return this.getAddressArray(this.ccAddresses, this.cc);
    }

    public void setCcAddresses(MailAddress[] ccAddresses) {
        this.ccAddresses = ccAddresses;
    }

    public MailAddress[] getBccAddresses() {
        return this.getAddressArray(this.bccAddresses, this.bcc);
    }

    public void setBccAddresses(MailAddress[] bccAddresses) {
        this.bccAddresses = bccAddresses;
    }

    public MailAddress getFromAddress() {
        return this.getAddress(this.fromAddress, this.from);
    }

    public void setFromAddress(MailAddress fromAddress) {
        this.fromAddress = fromAddress;
    }

    public MailAddress getReplyToAddress() {
        return this.getAddress(this.replyToAddress, this.replyTo);
    }

    public void setReplyToAddress(MailAddress replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    private MailAddress getAddress(MailAddress address, String string) {
        if (null == address && null != string) {
            address = new MailAddress();
            address.setAddress(string);
        }
        return address;
    }

    private MailAddress[] getAddressArray(MailAddress[] addresses, String[] strings) {
        if (null == addresses) {
            if (null == strings) {
                return null;
            }
            addresses = new MailAddress[strings.length];
            for (int i = 0; i < addresses.length; ++i) {
                addresses[i] = new MailAddress();
                addresses[i].setAddress(strings[i]);
            }
        }
        return addresses;
    }

    @Deprecated
    public void setTo(List to) {
        this.setTo(to.toArray(new String[0]));
    }

    @Deprecated
    public void setTo(String to) {
        this.setTo(Mail.stringArray(to));
    }

    @Deprecated
    public void setTo(String[] to) {
        this.to = to;
    }

    @Deprecated
    public String[] getTo() {
        return this.to;
    }

    @Deprecated
    public void setCC(String cc) {
        this.setCC(Mail.stringArray(cc));
    }

    @Deprecated
    public void setCC(String[] cc) {
        this.cc = cc;
    }

    @Deprecated
    public String[] getCC() {
        return this.cc;
    }

    @Deprecated
    public void setBCC(String bcc) {
        this.setBCC(Mail.stringArray(bcc));
    }

    @Deprecated
    public void setBCC(String[] bcc) {
        this.bcc = bcc;
    }

    @Deprecated
    public String[] getBCC() {
        return this.bcc;
    }

    @Deprecated
    public void setFrom(String from) {
        this.from = from;
    }

    @Deprecated
    public String getFrom() {
        if (null == this.getReplyTo()) {
            return Mail.validateAddress(this.from);
        }
        return this.from;
    }

    public final void setSubject(String subj) {
        this.subject = subj;
    }

    public final void setSubjectSanitize(String subj) {
        this.subject = subj.replaceAll("\r\n|\r|\n", " ");
        this.subject = StringEscapeUtils.escapeHtml4((String)this.subject);
    }

    public String getSubject() {
        return this.subject;
    }

    public final void setTextMessage(String msg) {
        this.textMessage = msg;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public void setHtmlMessage(String htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public void setHtmlMessageSanitize(String htmlMessage) {
        this.htmlMessage = StringEscapeUtils.escapeHtml4((String)htmlMessage);
    }

    public String getReplyTo() {
        return Mail.validateAddress(this.replyTo);
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    protected static String[] stringArray(String s) {
        if (s == null) {
            return null;
        }
        return s.split(",");
    }

    public static String validateAddress(String address) {
        if (address == null) {
            return null;
        }
        try {
            new InternetAddress(address);
        }
        catch (AddressException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Provided FROM address, '" + address + "', is invalid. Attempting to create valid address using localhost information.");
            }
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                String hostname = localHost.getHostName();
                int atIndex = address.indexOf(64);
                String tempFrom = atIndex == -1 ? address : address.substring(0, atIndex);
                address = tempFrom + "@" + hostname;
                address = address.replaceAll(" ", "_");
            }
            catch (UnknownHostException ue) {
                LOGGER.error("Unable to validate the from address due to exception." + ue);
            }
        }
        return address;
    }

    public String toString() {
        int stringLength = 256;
        StringBuilder sb = new StringBuilder(256).append("Mail: ");
        String fromAddr = null == this.getFromAddress() ? "null" : this.getFromAddress().toString();
        String reply = null == this.getReplyToAddress() ? "null" : this.getReplyToAddress().toString();
        sb.append("from=").append(fromAddr).append("; ").append("replyTo=").append(reply).append("; ").append("to=").append(this.arrayToCommaDelimitedString(this.getToAddresses())).append("; ").append("cc=").append(this.arrayToCommaDelimitedString(this.getCcAddresses())).append("; ").append("bcc=").append(this.arrayToCommaDelimitedString(this.getBccAddresses())).append("; ").append("subject=").append(this.subject).append("; ").append("text=").append(this.textMessage).append("; ").append("html=").append(this.htmlMessage);
        return sb.toString();
    }

    private String arrayToCommaDelimitedString(MailAddress[] addresses) {
        if (null == addresses) {
            return "null";
        }
        int numAddresses = addresses.length;
        int numChars = 32 * numAddresses;
        StringBuilder b = new StringBuilder(numChars);
        for (int i = 0; i < numAddresses; ++i) {
            b.append(addresses[i].toString());
            if (i >= numAddresses - 1) continue;
            b.append(",");
        }
        return b.toString();
    }
}

