/*
 * Decompiled with CFR 0.152.
 */
package com.sas.appserver.utils;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class FileCheckSum
implements GroovyObject {
    private static Logger logger;
    private byte[] checksum;
    private String fileName;
    private String algorithm;
    public static final String DIGEST_MD5 = "MD5";
    public static final String DIGEST_SHA1 = "SHA-1";
    public static final String DIGEST_SHA256 = "SHA-256";
    public final Map digestAlgorithm;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileCheckSum() {
        MetaClass metaClass;
        Map map;
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        Object var2_2 = null;
        this.checksum = (byte[])ScriptBytecodeAdapter.castToType(var2_2, byte[].class);
        Object var3_3 = null;
        this.fileName = ShortTypeHandling.castToString(var3_3);
        Object var4_4 = null;
        this.algorithm = ShortTypeHandling.castToString(var4_4);
        this.digestAlgorithm = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DIGEST_MD5, "size", 16}), 1, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DIGEST_SHA1, "size", 20}), 2, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", DIGEST_SHA256, "size", 32})});
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String getFileName() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        String storedName = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.fileName, null)) {
            Object object = callSiteArray[0].callConstructor(String.class, (Object)this.fileName);
            storedName = ShortTypeHandling.castToString((Object)object);
        }
        return storedName;
    }

    public String getAlgorithm() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        return this.algorithm;
    }

    public byte[] getChecksum() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        return this.checksum;
    }

    public String getHexChecksum() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        String hexValue = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.checksum, null)) {
            Object object = callSiteArray[1].call(Hex.class, (Object)this.checksum);
            hexValue = ShortTypeHandling.castToString((Object)object);
        }
        return hexValue;
    }

    public String getSerializedChecksum() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        StringBuilder serialized = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.fileName, null) || ScriptBytecodeAdapter.compareEqual((Object)this.algorithm, null) || ScriptBytecodeAdapter.compareEqual((Object)this.checksum, null)) {
                callSiteArray[2].call((Object)logger, (Object)"Checksum object properties are insufficient for serialization.");
            } else {
                Object object = callSiteArray[3].callConstructor(StringBuilder.class);
                serialized = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)object, StringBuilder.class);
                callSiteArray[4].call((Object)serialized, (Object)this.fileName);
                callSiteArray[5].call((Object)serialized, (Object)"::");
                callSiteArray[6].call((Object)serialized, (Object)this.algorithm);
                callSiteArray[7].call((Object)serialized, (Object)"::");
                callSiteArray[8].call((Object)serialized, callSiteArray[9].call(Hex.class, (Object)this.checksum));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.fileName, null) || ScriptBytecodeAdapter.compareEqual((Object)this.algorithm, null) || ScriptBytecodeAdapter.compareEqual((Object)this.checksum, null)) {
            callSiteArray[10].call((Object)logger, (Object)"Checksum object properties are insufficient for serialization.");
        } else {
            Object object = callSiteArray[11].callConstructor(StringBuilder.class);
            serialized = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)object, StringBuilder.class);
            callSiteArray[12].call((Object)serialized, (Object)this.fileName);
            callSiteArray[13].call((Object)serialized, (Object)"::");
            callSiteArray[14].call((Object)serialized, (Object)this.algorithm);
            callSiteArray[15].call((Object)serialized, (Object)"::");
            callSiteArray[16].call((Object)serialized, callSiteArray[17].call(Hex.class, (Object)this.checksum));
        }
        return ShortTypeHandling.castToString(serialized);
    }

    public boolean deserializeChecksum(String serializedChecksum) {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        boolean status = true;
        if (ScriptBytecodeAdapter.compareEqual((Object)serializedChecksum, null)) {
            boolean bl;
            callSiteArray[18].call((Object)logger, (Object)"Invalid checksum deserialization argument.");
            status = bl = false;
        } else {
            Object[] part = null;
            Object object = callSiteArray[19].call((Object)serializedChecksum, (Object)"::", (Object)-1);
            part = (String[])ScriptBytecodeAdapter.castToType((Object)object, String[].class);
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[20].call((Object)part), (Object)3)) {
                    boolean bl;
                    callSiteArray[21].call((Object)logger, (Object)"Invalid checksum deserialization argument.");
                    status = bl = false;
                } else {
                    Object object2 = callSiteArray[22].call((Object)part, (Object)0);
                    this.fileName = ShortTypeHandling.castToString((Object)object2);
                    Object object3 = callSiteArray[23].call((Object)part, (Object)1);
                    this.algorithm = ShortTypeHandling.castToString((Object)object3);
                    Object object4 = callSiteArray[24].call(Hex.class, callSiteArray[25].call((Object)part, (Object)2));
                    this.checksum = (byte[])ScriptBytecodeAdapter.castToType((Object)object4, byte[].class);
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[26].call((Object)part), (Object)3)) {
                boolean bl;
                callSiteArray[27].call((Object)logger, (Object)"Invalid checksum deserialization argument.");
                status = bl = false;
            } else {
                Object object5 = BytecodeInterface8.objectArrayGet((Object[])part, (int)0);
                this.fileName = ShortTypeHandling.castToString((Object)object5);
                Object object6 = BytecodeInterface8.objectArrayGet((Object[])part, (int)1);
                this.algorithm = ShortTypeHandling.castToString((Object)object6);
                Object object7 = callSiteArray[28].call(Hex.class, BytecodeInterface8.objectArrayGet((Object[])part, (int)2));
                this.checksum = (byte[])ScriptBytecodeAdapter.castToType((Object)object7, byte[].class);
            }
        }
        return status;
    }

    public String getHexChecksum(byte ... value) {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        String hexValue = null;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, null)) {
            Object object = callSiteArray[29].call(Hex.class, (Object)value);
            hexValue = ShortTypeHandling.castToString((Object)object);
        }
        return hexValue;
    }

    public boolean equals(byte ... value) {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)value, (Object)this.checksum);
    }

    public List getAlgorithmNames() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        public final class _getAlgorithmNames_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAlgorithmNames_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getAlgorithmNames_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                CallSite[] callSiteArray = _getAlgorithmNames_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(entry));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAlgorithmNames_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getAlgorithmNames_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getAlgorithmNames_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAlgorithmNames_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call((Object)this.digestAlgorithm, (Object)new _getAlgorithmNames_closure1(this, this)), List.class);
    }

    public List getChecksumSizes() {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        public final class _getChecksumSizes_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getChecksumSizes_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getChecksumSizes_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                CallSite[] callSiteArray = _getChecksumSizes_closure2.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(entry));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getChecksumSizes_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getChecksumSizes_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getChecksumSizes_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getChecksumSizes_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call((Object)this.digestAlgorithm, (Object)new _getChecksumSizes_closure2(this, this)), List.class);
    }

    private byte[] generateFileChecksum(String hashName, File inputFile, boolean storeIt) {
        CallSite[] callSiteArray = FileCheckSum.$getCallSiteArray();
        byte[] digestValue = null;
        String algorithm = ShortTypeHandling.castToString((Object)callSiteArray[32].call((Object)hashName));
        public final class _generateFileChecksum_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _generateFileChecksum_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _generateFileChecksum_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object entry) {
                CallSite[] callSiteArray = _generateFileChecksum_closure3.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(callSiteArray[1].callGetProperty(entry));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateFileChecksum_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _generateFileChecksum_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generateFileChecksum_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generateFileChecksum_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (!ScriptBytecodeAdapter.isCase((Object)algorithm, (Object)callSiteArray[33].call((Object)this.digestAlgorithm, (Object)new _generateFileChecksum_closure3(this, this)))) {
            callSiteArray[34].call((Object)logger, (Object)new GStringImpl(new Object[]{this.digestAlgorithm}, new String[]{"Invalid digest algorithm: ", ""}));
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call((Object)inputFile))) {
            callSiteArray[36].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[37].call((Object)inputFile)}, new String[]{"File ", " not found."}));
        } else {
            InputStream inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call((Object)inputFile), InputStream.class);
            MessageDigest checksumCalc = (MessageDigest)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(MessageDigest.class, (Object)algorithm), MessageDigest.class);
            DigestInputStream digestStream = (DigestInputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callConstructor(DigestInputStream.class, (Object)inputStream, (Object)checksumCalc), DigestInputStream.class);
            OutputStream outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].callConstructor(NullOutputStream.class), OutputStream.class);
            callSiteArray[42].call(IOUtils.class, (Object)digestStream, (Object)outputStream);
            callSiteArray[43].call((Object)inputStream);
            callSiteArray[44].call((Object)digestStream);
            callSiteArray[45].call((Object)outputStream);
            Object object = callSiteArray[46].call((Object)checksumCalc);
            digestValue = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
            if (ScriptBytecodeAdapter.compareEqual((Object)storeIt, (Object)true)) {
                String string;
                Object object2 = callSiteArray[47].call((Object)inputFile);
                this.fileName = ShortTypeHandling.castToString((Object)object2);
                byte[] byArray = digestValue;
                this.checksum = byArray;
                this.algorithm = string = hashName;
            }
        }
        return digestValue;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileCheckSum.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = FileCheckSum.$getCallSiteArray()[48].call(LogManager.class, FileCheckSum.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "encodeHexString";
        stringArray[2] = "error";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "append";
        stringArray[5] = "append";
        stringArray[6] = "append";
        stringArray[7] = "append";
        stringArray[8] = "append";
        stringArray[9] = "encodeHexString";
        stringArray[10] = "error";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "append";
        stringArray[13] = "append";
        stringArray[14] = "append";
        stringArray[15] = "append";
        stringArray[16] = "append";
        stringArray[17] = "encodeHexString";
        stringArray[18] = "error";
        stringArray[19] = "split";
        stringArray[20] = "size";
        stringArray[21] = "error";
        stringArray[22] = "getAt";
        stringArray[23] = "getAt";
        stringArray[24] = "decodeHex";
        stringArray[25] = "getAt";
        stringArray[26] = "size";
        stringArray[27] = "error";
        stringArray[28] = "decodeHex";
        stringArray[29] = "encodeHexString";
        stringArray[30] = "collect";
        stringArray[31] = "collect";
        stringArray[32] = "toUpperCase";
        stringArray[33] = "collect";
        stringArray[34] = "error";
        stringArray[35] = "exists";
        stringArray[36] = "error";
        stringArray[37] = "getPath";
        stringArray[38] = "newInputStream";
        stringArray[39] = "getInstance";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "copy";
        stringArray[43] = "close";
        stringArray[44] = "close";
        stringArray[45] = "close";
        stringArray[46] = "digest";
        stringArray[47] = "getPath";
        stringArray[48] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[49];
        FileCheckSum.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileCheckSum.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileCheckSum.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

