/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.option.jdom.DocumentWrapper;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.NamespaceIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Object node, NodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper) {
        return this.makeWrapper(node, docWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper, NodeWrapper parent, int index) {
        NodeWrapper wrapper;
        if (node instanceof Document) {
            return docWrapper;
        }
        if (node instanceof Element) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = 1;
        } else if (node instanceof Attribute) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)2;
        } else if (node instanceof String || node instanceof Text) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)3;
        } else if (node instanceof Comment) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)8;
        } else if (node instanceof ProcessingInstruction) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)7;
        } else {
            if (node instanceof Namespace) {
                throw new IllegalArgumentException("Cannot wrap JDOM namespace objects");
            }
            throw new IllegalArgumentException("Bad node type in JDOM! " + node.getClass() + " instance " + node.toString());
        }
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    public Object getUnderlyingNode() {
        if (this.node instanceof List) {
            return ((List)this.node).get(0);
        }
        return this.node;
    }

    public Object getRealNode() {
        return this.getUnderlyingNode();
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((AtomicValue)this.atomize());
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper ow = (NodeWrapper)other;
        return this.node.equals(ow.node);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String uri) {
        this.docWrapper.baseURI = uri;
    }

    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeInfo n = this;
        if (this.getNodeKind() != 1) {
            n = this.getParent();
        }
        while (n != null) {
            String xmlbase = n.getAttributeValue(385);
            if (xmlbase != null) {
                return xmlbase;
            }
            n = n.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof SiblingCountingNode) {
            return Navigator.compareOrder(this, (SiblingCountingNode)other);
        }
        return -other.compareOrder(this);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        if (this.node instanceof List) {
            List nodes = (List)this.node;
            FastStringBuffer fsb = new FastStringBuffer(64);
            for (int i = 0; i < nodes.size(); ++i) {
                Text o = (Text)nodes.get(i);
                fsb.append(NodeWrapper.getStringValue(o));
            }
            return fsb;
        }
        return NodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Object node) {
        if (node instanceof Document) {
            List children1 = ((Document)node).getContent();
            FastStringBuffer sb1 = new FastStringBuffer(256);
            NodeWrapper.expandStringValue(children1, sb1);
            return sb1.toString();
        }
        if (node instanceof Element) {
            return ((Element)node).getValue();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getValue();
        }
        if (node instanceof Text) {
            return ((Text)node).getText();
        }
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof Comment) {
            return ((Comment)node).getText();
        }
        if (node instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)node).getData();
        }
        if (node instanceof Namespace) {
            return ((Namespace)node).getURI();
        }
        return "";
    }

    private static void expandStringValue(List list, FastStringBuffer sb) {
        for (Object obj : list) {
            if (obj instanceof Element) {
                sb.append(((Element)obj).getValue());
                continue;
            }
            if (obj instanceof Text) {
                sb.append(((Text)obj).getText());
                continue;
            }
            if (obj instanceof EntityRef) {
                throw new IllegalStateException("Unexpanded entity in JDOM tree");
            }
            if (!(obj instanceof DocType)) {
                throw new AssertionError((Object)"Unknown JDOM node type");
            }
        }
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? this.makeWrapper(((Element)this.node).getDocument(), this.docWrapper) : this.makeWrapper(((Element)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Text) {
                this.parent = this.makeWrapper(((Text)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Comment) {
                this.parent = this.makeWrapper(((Comment)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = this.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Attribute) {
                this.parent = this.makeWrapper(((Attribute)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of JDOM namespace node");
                }
                throw new IllegalStateException("Unknown JDOM node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo n;
            AxisIterator iter;
            int ix = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    iter = this.parent.iterateAxis((byte)3);
                    break;
                }
                case 2: {
                    iter = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    iter = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((n = (NodeInfo)iter.next()) != null) {
                if (n.isSameNodeInfo(this)) {
                    this.index = ix;
                    return this.index;
                }
                if (((NodeWrapper)n).node instanceof List) {
                    ix += ((List)((NodeWrapper)n).node).size();
                    continue;
                }
                ++ix;
            }
            throw new IllegalStateException("JDOM node not linked to parent node");
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter(new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter(new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter(new Navigator.DescendantEnumeration(this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.AxisFilter(new Navigator.DescendantEnumeration(this, true, true), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter(new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return NamespaceIterator.makeIterator(this, nodeTest);
            }
            case 9: {
                this.getParent();
                return Navigator.filteredSingleton(this.parent, nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter(new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(int fingerprint) {
        if (this.nodeKind == 1) {
            NamePool pool = this.docWrapper.getNamePool();
            String uri = pool.getURI(fingerprint);
            String local = pool.getLocalName(fingerprint);
            return ((Element)this.node).getAttributeValue(local, uri.equals("http://www.w3.org/XML/1998/namespace") ? Namespace.XML_NAMESPACE : Namespace.getNamespace((String)uri));
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                return !((Element)this.node).getContent().isEmpty();
            }
        }
        return false;
    }

    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    public long getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        Navigator.copy(this, out, this.docWrapper.getNamePool(), copyOptions, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            List addl = elem.getAdditionalNamespaces();
            int size = addl.size() + 1;
            int[] result = buffer == null || size > buffer.length ? new int[size] : buffer;
            NamePool pool = this.getNamePool();
            Namespace ns2 = elem.getNamespace();
            String prefix = ns2.getPrefix();
            String uri = ns2.getURI();
            result[0] = pool.allocateNamespaceCode(prefix, uri);
            int i = 1;
            if (!addl.isEmpty()) {
                for (Namespace ns2 : addl) {
                    result[i++] = pool.allocateNamespaceCode(ns2.getPrefix(), ns2.getURI());
                }
            }
            if (size < result.length) {
                result[size] = -1;
            }
            return result;
        }
        return null;
    }

    public boolean isId() {
        return this.node instanceof Attribute && ((Attribute)this.node).getAttributeType() == 2;
    }

    public boolean isIdref() {
        if (this.node instanceof Attribute) {
            int type = ((Attribute)this.node).getAttributeType();
            return type == 3 || type == 4;
        }
        return false;
    }

    public boolean isNilled() {
        return false;
    }

    private final class ChildEnumeration
    extends Navigator.BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper start, boolean downwards, boolean forwards) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            this.commonParent = downwards ? start : (NodeWrapper)start.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).getContent().listIterator() : ((Element)this.commonParent.node).getContent().listIterator();
            if (downwards) {
                if (!forwards) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = start.getSiblingPosition();
                Object n = null;
                if (forwards) {
                    for (int i = 0; i <= this.ix; ++i) {
                        n = this.children.next();
                    }
                    if (n instanceof Text) {
                        boolean atEnd = false;
                        while (n instanceof Text) {
                            if (this.children.hasNext()) {
                                n = this.children.next();
                                ++this.ix;
                                continue;
                            }
                            atEnd = true;
                            break;
                        }
                        if (!atEnd) {
                            this.children.previous();
                        }
                    } else {
                        ++this.ix;
                    }
                } else {
                    for (int i = 0; i < this.ix; ++i) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object nextChild = this.children.next();
                    if (nextChild instanceof DocType) {
                        this.advance();
                        return;
                    }
                    if (nextChild instanceof EntityRef) {
                        throw new IllegalStateException("Unexpanded entity in JDOM tree");
                    }
                    if (nextChild instanceof Text) {
                        this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                        ArrayList<Object> list = null;
                        while (this.children.hasNext()) {
                            Object n = this.children.next();
                            if (n instanceof Text) {
                                if (list == null) {
                                    list = new ArrayList<Object>(4);
                                    list.add(((NodeWrapper)this.current).node);
                                }
                                list.add(n);
                                ++this.ix;
                                continue;
                            }
                            this.children.previous();
                            break;
                        }
                        if (list != null) {
                            ((NodeWrapper)this.current).node = list;
                        }
                    } else {
                        this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                    }
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object nextChild = this.children.previous();
                if (nextChild instanceof DocType) {
                    this.advance();
                    return;
                }
                if (nextChild instanceof EntityRef) {
                    throw new IllegalStateException("Unexpanded entity in JDOM tree");
                }
                if (nextChild instanceof Text) {
                    this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
                    ArrayList<Object> list = null;
                    while (this.children.hasPrevious()) {
                        Object n = this.children.previous();
                        if (n instanceof Text) {
                            if (list == null) {
                                list = new ArrayList<Object>(4);
                                list.add(((NodeWrapper)this.current).node);
                            }
                            list.add(0, n);
                            --this.ix;
                            continue;
                        }
                        this.children.next();
                        break;
                    }
                    if (list != null) {
                        ((NodeWrapper)this.current).node = list;
                    }
                } else {
                    this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper start) {
            this.start = start;
            this.atts = ((Element)start.node).getAttributes().iterator();
        }

        public void advance() {
            this.current = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), NodeWrapper.this.docWrapper, this.start, this.ix++) : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }
}

