/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.jdom.NodeWrapper;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AxisIterator;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected long documentNumber;
    private HashMap<String, Element> idIndex;
    private HashMap<String, Object> userData;

    public DocumentWrapper(Document doc, String baseURI, Configuration config) {
        super(doc, null, 0);
        this.node = doc;
        this.nodeKind = (short)9;
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.setConfiguration(config);
    }

    public NodeWrapper wrap(Object node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        Element element;
        if (this.idIndex == null) {
            NodeInfo node;
            this.idIndex = new HashMap(100);
            AxisIterator iter = this.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            while ((node = (NodeInfo)iter.next()) != null) {
                Element element2 = (Element)((NodeWrapper)node).node;
                List attributes = element2.getAttributes();
                for (int a = 0; a < attributes.size(); ++a) {
                    Attribute att = (Attribute)attributes.get(a);
                    if (att.getAttributeType() != 2) continue;
                    this.idIndex.put(att.getValue(), element2);
                }
            }
        }
        return (element = this.idIndex.get(id)) == null ? null : this.wrap(element);
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return null;
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

