/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.dom4j.DocumentWrapper;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.dom4j.tree.DefaultText;

public class DOM4JWriter
extends Builder {
    private Document document;
    private Stack ancestors = new Stack();
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(256);

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public void open() {
    }

    public void close() {
    }

    public void startDocument(int properties) throws XPathException {
        this.document = new DefaultDocument();
        this.ancestors.push(this.document);
        this.textBuffer.setLength(0);
    }

    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        DefaultElement element;
        this.flush();
        String local = this.namePool.getLocalName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        String prefix = this.namePool.getPrefix(nameCode);
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        QName name = new QName(local, new Namespace(prefix, uri));
        if (this.ancestors.size() == 1) {
            element = new DefaultElement(name);
            this.document.setRootElement((Element)element);
        } else {
            element = ((Element)this.ancestors.peek()).addElement(name);
        }
        this.ancestors.push(element);
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        String prefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
        String uri = this.namePool.getURIFromNamespaceCode(namespaceCode);
        ((Element)this.ancestors.peek()).addNamespace(prefix, uri);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String local = this.namePool.getLocalName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        String prefix = this.namePool.getPrefix(nameCode);
        Namespace ns = new Namespace(prefix, uri);
        DefaultAttribute att = new DefaultAttribute(local, ((Object)value).toString(), ns);
        ((Element)this.ancestors.peek()).add((Attribute)att);
    }

    public void startContent() throws XPathException {
        this.flush();
    }

    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        Object parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            DefaultText text = new DefaultText(this.textBuffer.toString());
            ((Element)this.ancestors.peek()).add((Text)text);
            this.textBuffer.setLength(0);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.flush();
        DefaultProcessingInstruction pi = new DefaultProcessingInstruction(target, ((Object)data).toString());
        ((Element)this.ancestors.peek()).add((ProcessingInstruction)pi);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.flush();
        DefaultComment comment = new DefaultComment(((Object)chars).toString());
        ((Element)this.ancestors.peek()).add((Comment)comment);
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    public NodeInfo getCurrentRoot() {
        return new DocumentWrapper(this.document, this.systemId, this.config);
    }
}

